/*
 * Decompiled with CFR 0.152.
 */
package assets.darwin;

import assets.darwin.GenomeUtils;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;

public class EntityDarwinCreature
extends rp
implements IEntityAdditionalSpawnData {
    public static final int MAX_TEXTURE_INDEX = 12;
    private boolean previousIsChild = false;

    public EntityDarwinCreature(abw world) {
        super(world);
        this.initialize();
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            this.a(0.9f, this.computeHeight());
        } else {
            this.a(1.0f, 1.0f);
        }
    }

    protected void a() {
        super.a();
        this.ah.a(20, (Object)new Integer(0));
        this.ah.a(21, (Object)new Integer(0));
        this.ah.a(22, (Object)new Integer(0));
        this.ah.a(23, (Object)new Integer(0));
        this.ah.a(24, (Object)new Integer(0));
        this.ah.a(25, (Object)new Integer(0));
    }

    public void initialize() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            int randomNb = this.ab.nextInt(7);
            switch (randomNb) {
                case 0: {
                    GenomeUtils.genomeCow(this);
                    break;
                }
                case 1: {
                    GenomeUtils.genomeEnderman(this);
                    break;
                }
                case 2: {
                    GenomeUtils.genomePig(this);
                    break;
                }
                case 3: {
                    GenomeUtils.genomeSlime(this);
                    break;
                }
                case 4: {
                    GenomeUtils.genomeZombie(this);
                    break;
                }
                case 5: {
                    GenomeUtils.genomeSquirtle(this);
                    break;
                }
                case 6: {
                    GenomeUtils.genomePikachu(this);
                    break;
                }
            }
            this.a(tp.a).a((double)this.computeMaxHealth());
            this.g(this.aT());
            this.a(tp.d).a((double)this.computeMoveSpeed());
            this.addTasks();
        }
    }

    protected float computeHeight() {
        float height = 0.8f;
        if (this.getLegLength() == 1) {
            height += 0.3f;
        }
        if (this.getLegLength() == 2) {
            height += 0.6f;
        }
        if (this.getLegLength() == 3) {
            height += 1.7f;
        }
        return height += this.getBodyRotation() / 255.0f;
    }

    protected float computeMoveSpeed() {
        float bonusSpeed = 3 - this.getBody();
        if (this.getBodyRotation() < 10.0f && this.getLegLength() == this.getArmLength()) {
            bonusSpeed += 3.0f;
        } else if (this.getBodyRotation() > 200.0f & this.getLegLength() > 0) {
            bonusSpeed += (float)(3 - this.getArmLength());
        }
        float moveSpeed = 0.07f * (1.0f + (float)this.getLegLength() + (float)this.getArmLength() / 2.0f + bonusSpeed);
        return moveSpeed;
    }

    double getMoveSpeed() {
        return this.a(tp.d).e();
    }

    protected void az() {
        super.az();
    }

    protected void addTasks() {
        int i = 0;
        int j = 0;
        if (this.getGeneStrongestAllele(3, 0, 1, true) > 0) {
            this.k().a(true);
        }
        if (this.getGeneStrongestAllele(3, 1, 1, true) > 0) {
            this.k().d(true);
        }
        if (this.getGeneStrongestAllele(3, 2, 1, true) > 0) {
            this.k().e(true);
            this.c.a(i++, (ps)new pp((og)this));
        }
        if (this.getGeneStrongestAllele(3, 3, 1, true) > 0) {
            this.k().b(true);
            this.c.a(i++, (ps)new pj((og)this));
        }
        if (this.getGeneStrongestAllele(3, 4, 1, true) > 0) {
            this.c.a(i++, (ps)new qj((on)this, this.getMoveSpeed()));
        }
        this.c.a(i++, (ps)new pk((rp)this, this.getMoveSpeed() * 0.5));
        this.c.a(i++, (ps)new qu((on)this, this.getMoveSpeed(), yc.V.cv, false));
        this.c.a(i++, (ps)new pr((rp)this, this.getMoveSpeed() * 0.5));
        if (this.getGeneStrongestAllele(3, 5, 1, true) > 0) {
            this.c.a(i++, (ps)new qd((on)this, this.getMoveSpeed()));
        }
        if (this.getGeneStrongestAllele(3, 6, 1, true) > 0) {
            this.c.a(i++, (ps)new qc((on)this, this.getMoveSpeed(), false));
        }
        if (this.getGeneStrongestAllele(3, 7, 1, true) > 0) {
            this.d.a(j++, (ps)new qx((on)this, false));
        }
        if (this.getGeneStrongestAllele(3, 9, 1, true) > 0) {
            this.c.a(i++, (ps)new qa((on)this, ub.class, this.getMoveSpeed(), true));
            this.d.a(j, (ps)new qy((on)this, ub.class, 0, false));
        }
        if (this.getGeneStrongestAllele(3, 10, 1, true) > 0) {
            this.c.a(i++, (ps)new qa((on)this, tm.class, this.getMoveSpeed(), true));
            this.d.a(j, (ps)new qy((on)this, tm.class, 0, false, true));
        }
        if (this.getGeneStrongestAllele(3, 11, 1, true) > 0) {
            this.c.a(i++, (ps)new qa((on)this, oq.class, this.getMoveSpeed(), true));
            this.d.a(j, (ps)new qy((on)this, oq.class, 0, false, true));
        }
        if (this.getGeneStrongestAllele(3, 12, 1, true) > 0) {
            this.c.a(i++, (ps)new qa((on)this, rz.class, this.getMoveSpeed(), true));
            this.d.a(j, (ps)new qy((on)this, rz.class, 0, false, true));
        }
        if (this.getGeneStrongestAllele(3, 13, 1, true) > 0) {
            this.c.a(i++, (ps)new qa((on)this, rr.class, this.getMoveSpeed(), true));
            this.d.a(j, (ps)new qy((on)this, rr.class, 0, false, true));
        }
        if (this.getGeneStrongestAllele(3, 14, 1, true) > 0) {
            this.c.a(i++, (ps)new qa((on)this, ry.class, this.getMoveSpeed(), true));
            this.d.a(j, (ps)new qy((on)this, ry.class, 0, false, true));
        }
        if (this.getGeneStrongestAllele(3, 15, 1, true) > 0) {
            this.c.a(i++, (ps)new qa((on)this, rq.class, this.getMoveSpeed(), true));
            this.d.a(j, (ps)new qy((on)this, rq.class, 0, false, true));
        }
        this.c.a(i++, (ps)new qm((on)this, this.getMoveSpeed()));
        this.c.a(i++, (ps)new px((og)this, uf.class, 6.0f));
        this.c.a(i, (ps)new ql((og)this));
        this.ag = this.getGeneStrongestAllele(3, 16, 1, true) > 0;
    }

    public boolean bf() {
        return true;
    }

    public void c() {
        float var1;
        if (this.O == 1.0f || this.g_() != this.previousIsChild) {
            this.a(0.9f, this.computeHeight());
        }
        this.previousIsChild = this.g_();
        if (this.getGeneStrongestAllele(3, 17, 1, true) > 0 && this.q.v() && !this.q.I && (var1 = this.d(1.0f)) > 0.5f && this.q.l(ls.c((double)this.u), ls.c((double)this.v), ls.c((double)this.w)) && this.ab.nextFloat() * 30.0f < (var1 - 0.4f) * 2.0f) {
            this.d(8);
        }
        if (this.getGeneStrongestAllele(3, 18, 1, true) > 0 && this.G()) {
            this.a(nb.e, 1.0f);
        }
        super.c();
    }

    public boolean aA() {
        return this.getGeneStrongestAllele(3, 19, 1, true) > 0;
    }

    public float a(int par1, int par2, int par3) {
        if (this.getGeneStrongestAllele(3, 1, 1, true) > 0) {
            return 0.5f - this.q.q(par1, par2, par3);
        }
        return super.a(par1, par2, par3);
    }

    public rp spawnBabyAnimal(rp var1) {
        EntityDarwinCreature parent = (EntityDarwinCreature)var1;
        EntityDarwinCreature baby = new EntityDarwinCreature(this.q);
        baby.setChromosome11(this.crossOverAndMutate(1));
        baby.setChromosome12(parent.crossOverAndMutate(1));
        baby.setChromosome21(this.crossOverAndMutate(2));
        baby.setChromosome22(parent.crossOverAndMutate(2));
        return baby;
    }

    public nk a(nk var1) {
        return this.spawnBabyAnimal((rp)var1);
    }

    public float computeMaxHealth() {
        try {
            return 9 * (this.getBody() + 1);
        }
        catch (Exception e) {
            return 10.0f;
        }
    }

    public int computeAttackStrength() {
        return this.getGeneFromBoth(3, 20, 3) + 1;
    }

    protected void a(nn par1Entity, float par2) {
        if (par1Entity instanceof EntityDarwinCreature) {
            super.a(par1Entity, par2);
        } else if (this.aC <= 0 && par2 < 2.0f && par1Entity.E.e > this.E.b && par1Entity.E.b < this.E.e) {
            this.aC = 20;
            this.m(par1Entity);
        }
    }

    public boolean m(nn par1Entity) {
        int attackStrength = this.computeAttackStrength();
        if (this.a(ni.g)) {
            attackStrength += 3 << this.b(ni.g).c();
        }
        if (this.a(ni.t)) {
            attackStrength -= 2 << this.b(ni.t).c();
        }
        return par1Entity.a(nb.a((of)this), (float)attackStrength);
    }

    protected int getGeneFromBoth(int chromosome, int pos, int maxValue) {
        switch (chromosome) {
            case 1: {
                return ((this.getChromosome11() >> pos & maxValue) + (this.getChromosome12() >> pos & maxValue)) / 2;
            }
            case 2: {
                return ((this.getChromosome21() >> pos & maxValue) + (this.getChromosome22() >> pos & maxValue)) / 2;
            }
            case 3: {
                return ((this.getChromosome31() >> pos & maxValue) + (this.getChromosome32() >> pos & maxValue)) / 2;
            }
        }
        return 0;
    }

    protected int getGeneFromOne(int chromosome, int pos, int maxValue, boolean random) {
        switch (chromosome) {
            case 1: {
                if (this.ab.nextBoolean() & random) {
                    return this.getChromosome11() >> pos & maxValue;
                }
                return this.getChromosome12() >> pos & maxValue;
            }
            case 2: {
                if (this.ab.nextBoolean() & random) {
                    return this.getChromosome21() >> pos & maxValue;
                }
                return this.getChromosome22() >> pos & maxValue;
            }
            case 3: {
                if (this.ab.nextBoolean() & random) {
                    return this.getChromosome31() >> pos & maxValue;
                }
                return this.getChromosome32() >> pos & maxValue;
            }
        }
        return 0;
    }

    protected int getGeneStrongestAllele(int chromosome, int pos, int maxValue, boolean biggest) {
        int allele1 = 0;
        int allele2 = 0;
        switch (chromosome) {
            case 1: {
                allele1 = this.getChromosome11() >> pos & maxValue;
                allele2 = this.getChromosome12() >> pos & maxValue;
                break;
            }
            case 2: {
                allele1 = this.getChromosome21() >> pos & maxValue;
                allele2 = this.getChromosome22() >> pos & maxValue;
                break;
            }
            case 3: {
                allele1 = this.getChromosome31() >> pos & maxValue;
                allele2 = this.getChromosome32() >> pos & maxValue;
                break;
            }
            default: {
                return 0;
            }
        }
        if (biggest) {
            return Math.max(allele1, allele2);
        }
        return Math.min(allele1, allele2);
    }

    public int getHead() {
        if (this.g_()) {
            return 0;
        }
        return this.getGeneFromBoth(2, 0, 3);
    }

    public int getLegLength() {
        if (this.g_()) {
            return 0;
        }
        return this.getGeneFromBoth(2, 2, 3);
    }

    public int getArmLength() {
        if (this.g_()) {
            return 0;
        }
        return this.getGeneFromBoth(2, 4, 3);
    }

    public int getTail() {
        if (this.g_()) {
            return 0;
        }
        return this.getGeneFromBoth(2, 6, 3);
    }

    public int getSnout() {
        return this.getGeneFromBoth(2, 8, 3);
    }

    public int getEars() {
        return this.getGeneFromBoth(2, 10, 3);
    }

    public int getBody() {
        if (this.g_()) {
            return 1;
        }
        return this.getGeneFromBoth(2, 12, 3);
    }

    public float getBodyRotation() {
        if (this.g_()) {
            return 0.0f;
        }
        return this.getGeneFromBoth(2, 16, 255);
    }

    protected int s() {
        int drop = this.getGeneFromOne(2, 24, 255, true) % 126;
        return drop + 256;
    }

    public int getTextureIndex() {
        int index = this.getGeneFromOne(1, 0, 15, false) % 12;
        return index;
    }

    public float red() {
        return (float)this.getGeneFromBoth(1, 8, 255) / 255.0f;
    }

    public float green() {
        return (float)this.getGeneFromBoth(1, 16, 255) / 255.0f;
    }

    public float blue() {
        return (float)this.getGeneFromBoth(1, 24, 255) / 255.0f;
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
    }

    public void readSpawnData(ByteArrayDataInput data) {
    }

    public void a(by par1nbtTagCompound) {
        super.a(par1nbtTagCompound);
        this.setChromosome11(par1nbtTagCompound.e("Chrom11"));
        this.setChromosome12(par1nbtTagCompound.e("Chrom12"));
        this.setChromosome21(par1nbtTagCompound.e("Chrom21"));
        this.setChromosome22(par1nbtTagCompound.e("Chrom22"));
        this.setChromosome31(par1nbtTagCompound.e("Chrom31"));
        this.setChromosome32(par1nbtTagCompound.e("Chrom32"));
        this.computeMoveSpeed();
    }

    public void b(by par1nbtTagCompound) {
        super.b(par1nbtTagCompound);
        par1nbtTagCompound.a("Chrom11", this.getChromosome11());
        par1nbtTagCompound.a("Chrom12", this.getChromosome12());
        par1nbtTagCompound.a("Chrom21", this.getChromosome21());
        par1nbtTagCompound.a("Chrom22", this.getChromosome22());
        par1nbtTagCompound.a("Chrom31", this.getChromosome31());
        par1nbtTagCompound.a("Chrom32", this.getChromosome32());
    }

    protected void setChromosome11(int chromosome) {
        this.ah.b(20, (Object)chromosome);
    }

    public int getChromosome11() {
        return this.ah.c(20);
    }

    protected void setChromosome12(int chromosome) {
        this.ah.b(21, (Object)chromosome);
    }

    public int getChromosome12() {
        return this.ah.c(21);
    }

    protected void setChromosome21(int chromosome) {
        this.ah.b(22, (Object)chromosome);
    }

    public int getChromosome21() {
        return this.ah.c(22);
    }

    protected void setChromosome22(int chromosome) {
        this.ah.b(23, (Object)chromosome);
    }

    public int getChromosome22() {
        return this.ah.c(23);
    }

    protected void setChromosome31(int chromosome) {
        this.ah.b(24, (Object)chromosome);
    }

    public int getChromosome31() {
        return this.ah.c(24);
    }

    protected void setChromosome32(int chromosome) {
        this.ah.b(25, (Object)chromosome);
    }

    public int getChromosome32() {
        return this.ah.c(25);
    }

    public int crossOverAndMutate(int chromosome) {
        int chrom1 = 0;
        int chrom2 = 0;
        switch (chromosome) {
            case 1: {
                chrom1 = this.getChromosome11();
                chrom2 = this.getChromosome12();
                break;
            }
            case 2: {
                chrom1 = this.getChromosome21();
                chrom2 = this.getChromosome22();
                break;
            }
        }
        int chromRet = 0;
        for (int i = 0; i < 32; ++i) {
            int random = this.ab.nextInt(100);
            if (random > 1) {
                chromRet += (chrom1 >> i & 1) << i;
                continue;
            }
            if (random > 51) {
                chromRet += (chrom2 >> i & 1) << i;
                continue;
            }
            chromRet += random << i;
        }
        return chromRet;
    }

    public void c(int par1) {
        if (par1 == 6000) {
            super.c(800);
        } else if (par1 == -24000) {
            super.c(-1000);
        } else {
            super.c(par1);
        }
    }
}

