/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.BlockMultipart$;
import codechicken.multipart.MultiPartRegistry$;
import codechicken.multipart.MultipartGenerator$;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import codechicken.multipart.handler.MultipartCompatiblity$;
import codechicken.multipart.handler.MultipartProxy$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.VolatileByteRef;

public final class TileMultipart$ {
    public static final TileMultipart$ MODULE$;
    private int renderID;
    private final Map<BlockCoord, TileMultipart> codechicken$multipart$TileMultipart$$clientFlushMap;

    static {
        new TileMultipart$();
    }

    public int renderID() {
        return this.renderID;
    }

    public void renderID_$eq(int x$1) {
        this.renderID = x$1;
    }

    public Map<BlockCoord, TileMultipart> codechicken$multipart$TileMultipart$$clientFlushMap() {
        return this.codechicken$multipart$TileMultipart$$clientFlushMap;
    }

    public void flushClientCache() {
        this.codechicken$multipart$TileMultipart$$clientFlushMap().clear();
    }

    public Option<TileMultipart> putClientCache(TileMultipart t) {
        return this.codechicken$multipart$TileMultipart$$clientFlushMap().put((Object)new BlockCoord((asp)t), (Object)t);
    }

    public TileMultipart getOrConvertTile(abw world, BlockCoord pos) {
        return (TileMultipart)((Object)this.getOrConvertTile2(world, pos)._1());
    }

    public Tuple2<TileMultipart, Object> getOrConvertTile2(abw world, BlockCoord pos) {
        asp t = world.r(pos.x, pos.y, pos.z);
        if (t instanceof TileMultipart) {
            return new Tuple2((Object)((TileMultipart)t), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        int id = world.a(pos.x, pos.y, pos.z);
        TMultiPart p = MultiPartRegistry$.MODULE$.convertBlock(world, pos, id);
        if (p == null) {
            return new Tuple2(null, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        TileMultipart t2 = MultipartGenerator$.MODULE$.generateCompositeTile(null, (Seq<TMultiPart>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TMultiPart[]{p}))), world.I);
        t2.l = pos.x;
        t2.m = pos.y;
        t2.n = pos.z;
        t2.b(world);
        t2.addPart_do(p);
        return new Tuple2((Object)t2, (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public TileMultipart getTile(abw world, BlockCoord pos) {
        TileMultipart tileMultipart;
        asp asp2 = world.r(pos.x, pos.y, pos.z);
        TileMultipart tileMultipart2 = asp2 instanceof TileMultipart ? (tileMultipart = (TileMultipart)asp2) : null;
        return tileMultipart2;
    }

    public boolean checkNoEntityCollision(abw world, BlockCoord pos, TMultiPart part) {
        return JavaConversions$.MODULE$.iterableAsScalaIterable(part.getCollisionBoxes()).forall((Function1)new Serializable(world, pos){
            public static final long serialVersionUID = 0L;
            private final abw world$1;
            private final BlockCoord pos$1;

            public final boolean apply(Cuboid6 b) {
                return this.world$1.b(b.toAABB().d((double)this.pos$1.x, (double)this.pos$1.y, (double)this.pos$1.z));
            }
            {
                this.world$1 = world$1;
                this.pos$1 = pos$1;
            }
        });
    }

    public boolean canPlacePart(abw world, BlockCoord pos, TMultiPart part) {
        if (this.checkNoEntityCollision(world, pos, part)) {
            TileMultipart t = this.getOrConvertTile(world, pos);
            if (t == null) {
                if (BoxesRunTime.unboxToBoolean((Object)MultipartCompatiblity$.MODULE$.canAddPart().apply((Object)world, (Object)BoxesRunTime.boxToInteger((int)pos.x), (Object)BoxesRunTime.boxToInteger((int)pos.y), (Object)BoxesRunTime.boxToInteger((int)pos.z)))) {
                    return this.replaceable(world, pos);
                }
                return false;
            }
            return t.canAddPart(part);
        }
        return false;
    }

    public boolean replaceable(abw world, BlockCoord pos) {
        aqz block = aqz.s[world.a(pos.x, pos.y, pos.z)];
        return block == null || block.isAirBlock(world, pos.x, pos.y, pos.z) || block.isBlockReplaceable(world, pos.x, pos.y, pos.z);
    }

    public TileMultipart addPart(abw world, BlockCoord pos, TMultiPart part) {
        Predef$.MODULE$.assert(!world.I, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Cannot add multi parts to a client tile.";
            }
        });
        return MultipartGenerator$.MODULE$.addPart(world, pos, part);
    }

    public void handleDescPacket(abw world, BlockCoord pos, PacketCustom packet) {
        TileMultipart tilemp2;
        int nparts = packet.readUByte();
        ListBuffer parts = new ListBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nparts).foreach((Function1)new Serializable(packet, parts){
            public static final long serialVersionUID = 0L;
            private final PacketCustom packet$2;
            private final ListBuffer parts$2;

            public final ListBuffer<TMultiPart> apply(int i) {
                TMultiPart part = MultiPartRegistry$.MODULE$.readPart((MCDataInput)this.packet$2);
                part.readDesc((MCDataInput)this.packet$2);
                return this.parts$2.$plus$eq((Object)part);
            }
            {
                this.packet$2 = packet$2;
                this.parts$2 = parts$2;
            }
        });
        if (parts.size() == 0) {
            return;
        }
        asp t = world.r(pos.x, pos.y, pos.z);
        TileMultipart tileMultipart = tilemp2 = MultipartGenerator$.MODULE$.generateCompositeTile(t, (Seq<TMultiPart>)parts, true);
        asp asp2 = t;
        if (tileMultipart == null ? asp2 != null : !((Object)((Object)tileMultipart)).equals(asp2)) {
            world.c(pos.x, pos.y, pos.z, MultipartProxy$.MODULE$.block().cF);
            MultipartGenerator$.MODULE$.silentAddTile(world, pos, tilemp2);
        }
        tilemp2.loadParts((ListBuffer<TMultiPart>)parts);
        tilemp2.notifyTileChange();
        tilemp2.markRender();
    }

    public void handlePacket(BlockCoord pos, abw world, int i, PacketCustom packet) {
        ObjectRef tilemp$lzy = new ObjectRef(null);
        VolatileByteRef bitmap$0 = new VolatileByteRef(0);
        int n = i;
        switch (n) {
            default: {
                ((TMultiPart)this.tilemp$1(pos, world, tilemp$lzy, bitmap$0).partList().apply(i)).read((MCDataInput)packet);
                break;
            }
            case 254: {
                this.tilemp$1(pos, world, tilemp$lzy, bitmap$0).remPart_impl((TMultiPart)this.tilemp$1(pos, world, tilemp$lzy, bitmap$0).partList().apply(packet.readUByte()));
                break;
            }
            case 253: {
                TMultiPart part = MultiPartRegistry$.MODULE$.readPart((MCDataInput)packet);
                part.readDesc((MCDataInput)packet);
                MultipartGenerator$.MODULE$.addPart(world, pos, part);
            }
        }
    }

    public TileMultipart createFromNBT(by tag) {
        cg partList = tag.m("parts");
        ListBuffer parts = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partList.c()).foreach((Function1)new Serializable(partList, parts){
            public static final long serialVersionUID = 0L;
            private final cg partList$1;
            private final ListBuffer parts$3;

            public final Object apply(int i) {
                BoxedUnit boxedUnit;
                by partTag = (by)this.partList$1.b(i);
                String partID = partTag.i("id");
                TMultiPart part = MultiPartRegistry$.MODULE$.createPart(partID, false);
                if (part == null) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    part.load(partTag);
                    boxedUnit = this.parts$3.$plus$eq((Object)part);
                }
                return boxedUnit;
            }
            {
                this.partList$1 = partList$1;
                this.parts$3 = parts$3;
            }
        });
        if (parts.size() == 0) {
            return null;
        }
        TileMultipart tmb = MultipartGenerator$.MODULE$.generateCompositeTile(null, (Seq<TMultiPart>)parts, false);
        tmb.a(tag);
        tmb.loadParts((ListBuffer<TMultiPart>)parts);
        return tmb;
    }

    public void dropItem(ye stack, abw world, Vector3 pos) {
        ss item = new ss(world, pos.x, pos.y, pos.z, stack);
        item.x = world.s.nextGaussian() * 0.05;
        item.y = world.s.nextGaussian() * 0.05 + 0.2;
        item.z = world.s.nextGaussian() * 0.05;
        item.b = 10;
        world.d((nn)item);
    }

    private final TileMultipart tilemp$lzycompute$1(BlockCoord pos$5, abw world$2, ObjectRef tilemp$lzy$1, VolatileByteRef bitmap$0$1) {
        TileMultipart$ tileMultipart$ = this;
        synchronized (tileMultipart$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                tilemp$lzy$1.elem = (TileMultipart)((Object)Option$.MODULE$.apply((Object)BlockMultipart$.MODULE$.getTile((acf)world$2, pos$5.x, pos$5.y, pos$5.z)).getOrElse((Function0)new Serializable(pos$5){
                    public static final long serialVersionUID = 0L;
                    private final BlockCoord pos$5;

                    public final TileMultipart apply() {
                        return (TileMultipart)((Object)TileMultipart$.MODULE$.codechicken$multipart$TileMultipart$$clientFlushMap().apply((Object)this.pos$5));
                    }
                    {
                        this.pos$5 = pos$5;
                    }
                }));
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (TileMultipart)((Object)tilemp$lzy$1.elem);
        }
    }

    private final TileMultipart tilemp$1(BlockCoord pos$5, abw world$2, ObjectRef tilemp$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.tilemp$lzycompute$1(pos$5, world$2, tilemp$lzy$1, bitmap$0$1) : (TileMultipart)((Object)tilemp$lzy$1.elem);
    }

    private TileMultipart$() {
        MODULE$ = this;
        this.renderID = -1;
        this.codechicken$multipart$TileMultipart$$clientFlushMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

