/*
 * Decompiled with CFR 0.152.
 */
package openmods.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openmods.Log;
import openmods.api.IActivateAwareTile;
import openmods.api.IBreakAwareTile;
import openmods.api.IHasGui;
import openmods.api.IIconProvider;
import openmods.api.INeighbourAwareTile;
import openmods.api.IPlaceAwareTile;
import openmods.api.ISpecialDrops;
import openmods.api.ISurfaceAttachment;
import openmods.block.RotationHelper;
import openmods.config.IRegisterableBlock;
import openmods.sync.SyncableDirection;
import openmods.tileentity.OpenTileEntity;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.BlockUtils;

public abstract class OpenBlock
extends Block
implements IRegisterableBlock {
    private static final String SYNCED_ROTATION_VAR = "_rotation2";
    public static final int OPEN_MODS_TE_GUI = -1;
    private String blockName;
    private String modId;
    private Class<? extends TileEntity> teClass = null;
    protected BlockRotationMode blockRotationMode;
    protected BlockPlacementMode blockPlacementMode;
    protected ForgeDirection inventoryRenderRotation = ForgeDirection.WEST;
    public Icon[] textures = new Icon[6];

    protected OpenBlock(int id, Material material) {
        super(id, material);
        this.func_71848_c(1.0f);
        this.setRotationMode(BlockRotationMode.NONE);
        this.setPlacementMode(BlockPlacementMode.ENTITY_ANGLE);
        this.field_72025_cg = false;
    }

    protected void setPlacementMode(BlockPlacementMode mode) {
        this.blockPlacementMode = mode;
    }

    protected void setRotationMode(BlockRotationMode mode) {
        this.blockRotationMode = mode;
    }

    public BlockRotationMode getRotationMode() {
        return this.blockRotationMode;
    }

    protected BlockPlacementMode getPlacementMode() {
        return this.blockPlacementMode;
    }

    protected void setInventoryRenderRotation(ForgeDirection rotation) {
        this.inventoryRenderRotation = rotation;
    }

    @SideOnly(value=Side.CLIENT)
    public ForgeDirection getInventoryRenderRotation() {
        return this.inventoryRenderRotation;
    }

    public void setBoundsBasedOnRotation(ForgeDirection direction) {
    }

    public static OpenBlock getOpenBlock(IBlockAccess world, int x, int y, int z) {
        if (world == null) {
            return null;
        }
        int id = world.func_72798_a(x, y, z);
        if (id < 0 || id >= Block.field_71973_m.length) {
            return null;
        }
        Block block = Block.field_71973_m[id];
        if (block instanceof OpenBlock) {
            return (OpenBlock)block;
        }
        return null;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        TileEntity te = this.createTileEntity();
        te.field_70324_q = this;
        if (te instanceof OpenTileEntity) {
            ((OpenTileEntity)te).setup();
        }
        return te;
    }

    public TileEntity createTileEntityForRender() {
        TileEntity te = this.createTileEntity();
        te.field_70324_q = this;
        te.field_70325_p = 0;
        return te;
    }

    protected TileEntity createTileEntity() {
        try {
            if (this.teClass != null) {
                return this.teClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (NoSuchMethodException nsm) {
            Log.warn(nsm, "Notice: Cannot create TE automatically due to constructor requirements", new Object[0]);
        }
        catch (Exception ex) {
            Log.warn(ex, "Notice: Error creating tile entity", new Object[0]);
        }
        return null;
    }

    public Class<? extends TileEntity> getTileClass() {
        return this.teClass;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister registry) {
        this.field_94336_cN = registry.func_94245_a(String.format("%s:%s", this.modId, this.blockName));
    }

    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof IBreakAwareTile) {
            ((IBreakAwareTile)te).onBlockBroken();
        }
        world.func_72932_q(x, y, z);
        super.func_71852_a(world, x, y, z, par5, par6);
    }

    private void getTileEntityDrops(TileEntity te, List<ItemStack> result) {
        if (te != null) {
            BlockUtils.getTileInventoryDrops(te, result);
            if (te instanceof ISpecialDrops) {
                ((ISpecialDrops)te).addDrops(result);
            }
            this.getCustomTileEntityDrops(te, result);
        }
    }

    protected void getCustomTileEntityDrops(TileEntity te, List<ItemStack> result) {
    }

    protected boolean hasNormalDrops() {
        return true;
    }

    protected boolean hasTileEntityDrops() {
        return true;
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (this.hasTileEntityDrops() && !player.field_71075_bZ.field_75098_d) {
            TileEntity te = world.func_72796_p(x, y, z);
            ArrayList teDrops = Lists.newArrayList();
            this.getTileEntityDrops(te, teDrops);
            for (ItemStack drop : teDrops) {
                this.func_71929_a(world, x, y, z, drop);
            }
        }
        return super.removeBlockByPlayer(world, player, x, y, z);
    }

    public ArrayList<ItemStack> getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList result = Lists.newArrayList();
        if (this.hasNormalDrops()) {
            result.addAll(super.getBlockDropped(world, x, y, z, metadata, fortune));
        }
        if (this.hasTileEntityDrops()) {
            TileEntity te = world.func_72796_p(x, y, z);
            this.getTileEntityDrops(te, result);
        }
        return result;
    }

    @Override
    public void setupBlock(String modId, String blockName, Class<? extends TileEntity> tileEntity, Class<? extends ItemBlock> itemClass) {
        this.blockName = blockName;
        this.modId = modId;
        if (tileEntity != null) {
            this.teClass = tileEntity;
            this.field_72025_cg = true;
            if (this.blockRotationMode == BlockRotationMode.TWENTYFOUR_DIRECTIONS) {
                Preconditions.checkArgument((boolean)SyncedTileEntity.class.isAssignableFrom(tileEntity), (String)"To use 24-direction rotations TE class '%s' needs to implement SyncedTileEntity", (Object[])new Object[]{tileEntity});
            }
        }
    }

    public boolean hasTileEntity(int metadata) {
        return this.teClass != null;
    }

    public static final boolean isNeighborBlockSolid(World world, int x, int y, int z, ForgeDirection side) {
        return world.isBlockSolidOnSide(x += side.offsetX, y += side.offsetY, z += side.offsetZ, side.getOpposite());
    }

    public static final boolean areNeighborBlocksSolid(World world, int x, int y, int z, ForgeDirection ... sides) {
        for (ForgeDirection side : sides) {
            if (!OpenBlock.isNeighborBlockSolid(world, x, y, z, side)) continue;
            return true;
        }
        return false;
    }

    public void func_71863_a(World world, int x, int y, int z, int blockId) {
        ForgeDirection direction;
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof INeighbourAwareTile) {
            ((INeighbourAwareTile)te).onNeighbourChanged(blockId);
        }
        if (te instanceof ISurfaceAttachment && !OpenBlock.isNeighborBlockSolid(world, x, y, z, direction = ((ISurfaceAttachment)te).getSurfaceDirection())) {
            world.func_94578_a(x, y, z, true);
        }
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof IHasGui && ((IHasGui)te).canOpenGui(player) && !player.func_70093_af()) {
            if (!world.field_72995_K) {
                this.openGui(player, world, x, y, z);
            }
            return true;
        }
        if (te instanceof IActivateAwareTile) {
            return ((IActivateAwareTile)te).onBlockActivated(player, side, hitX, hitY, hitZ);
        }
        return false;
    }

    public boolean func_71886_c() {
        return this.func_71926_d();
    }

    public boolean func_71883_b(World world, int x, int y, int z, int eventId, int eventParam) {
        super.func_71883_b(world, x, y, z, eventId, eventParam);
        TileEntity te = OpenBlock.getTileEntity((IBlockAccess)world, x, y, z, TileEntity.class);
        if (te != null) {
            return te.func_70315_b(eventId, eventParam);
        }
        return false;
    }

    protected void setupDimensionsFromCenter(float x, float y, float z, float width, float height, float depth) {
        this.setupDimensions(x - width, y, z - depth, x + width, y + height, z + depth);
    }

    protected void setupDimensions(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.field_72026_ch = minX;
        this.field_72023_ci = minY;
        this.field_72024_cj = minZ;
        this.field_72021_ck = maxX;
        this.field_72022_cl = maxY;
        this.field_72019_cm = maxZ;
    }

    public AxisAlignedBB func_71911_a_(World world, int x, int y, int z) {
        this.func_71902_a((IBlockAccess)world, x, y, z);
        return super.func_71911_a_(world, x, y, z);
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        this.func_71902_a((IBlockAccess)world, x, y, z);
        return super.func_71872_e(world, x, y, z);
    }

    public static <U> U getTileEntity(IBlockAccess world, int x, int y, int z, Class<U> T) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te != null && T.isAssignableFrom(te.getClass())) {
            return (U)te;
        }
        return null;
    }

    public void onBlockPlacedBy(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, ForgeDirection side, float hitX, float hitY, float hitZ, int meta) {
        ForgeDirection additionalRotation = null;
        if (this.getRotationMode() == BlockRotationMode.TWENTYFOUR_DIRECTIONS) {
            this.setPlacementMode(BlockPlacementMode.ENTITY_ANGLE);
        }
        block0 : switch (this.blockPlacementMode) {
            case SURFACE: {
                meta = side.getOpposite().ordinal();
                break;
            }
            default: {
                switch (this.getRotationMode()) {
                    case FOUR_DIRECTIONS: {
                        meta = BlockUtils.get2dOrientation((EntityLivingBase)player).ordinal();
                        break block0;
                    }
                    case SIX_DIRECTIONS: {
                        meta = BlockUtils.get3dOrientation((EntityLivingBase)player).ordinal();
                        break block0;
                    }
                    case TWENTYFOUR_DIRECTIONS: {
                        meta = side.getOpposite().ordinal();
                        additionalRotation = BlockUtils.get2dOrientation((EntityLivingBase)player);
                        break block0;
                    }
                }
            }
        }
        world.func_72921_c(x, y, z, meta, 3);
        TileEntity te = world.func_72796_p(x, y, z);
        if (additionalRotation != null) {
            Preconditions.checkState((boolean)(te instanceof SyncedTileEntity), (String)"For 6+ levels of rotation you need to use a SyncedTileEntity, but '%s' on block '%s' is not one", (Object[])new Object[]{te, this});
            SyncedTileEntity ste = (SyncedTileEntity)te;
            ste.addSyncedObject(SYNCED_ROTATION_VAR, new SyncableDirection(additionalRotation));
            ste.sync();
        }
        if (te instanceof IPlaceAwareTile) {
            ((IPlaceAwareTile)te).onBlockPlacedBy(player, side, stack, hitX, hitY, hitZ);
        }
    }

    public final boolean func_71850_a_(World world, int x, int y, int z, int side) {
        return this.canPlaceBlockOnSide(world, x, y, z, ForgeDirection.getOrientation((int)side).getOpposite());
    }

    public boolean canPlaceBlockOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return this.func_71930_b(world, x, y, z);
    }

    protected boolean isOnTopOfSolidBlock(World world, int x, int y, int z, ForgeDirection side) {
        return side == ForgeDirection.DOWN && OpenBlock.isNeighborBlockSolid(world, x, y, z, ForgeDirection.DOWN);
    }

    public void setTexture(ForgeDirection direction, Icon icon) {
        this.textures[direction.ordinal()] = icon;
    }

    protected final Icon getUnrotatedTexture(ForgeDirection direction) {
        int directionId;
        if (direction != ForgeDirection.UNKNOWN && this.textures[directionId = direction.ordinal()] != null) {
            return this.textures[directionId];
        }
        return this.field_94336_cN;
    }

    public Icon getUnrotatedTexture(ForgeDirection direction, IBlockAccess world, int x, int y, int z) {
        return this.getUnrotatedTexture(direction);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        ForgeDirection direction = this.rotateSideByMetadata(side, world.func_72805_g(x, y, z));
        IIconProvider provider = OpenBlock.getTileEntity(world, x, y, z, IIconProvider.class);
        Icon teIcon = null;
        if (provider != null) {
            teIcon = provider.getIcon(direction);
        }
        return teIcon != null ? teIcon : this.getUnrotatedTexture(direction, world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int metadata) {
        ForgeDirection newRotation = this.rotateSideByMetadata(side, metadata);
        return this.getUnrotatedTexture(newRotation);
    }

    public ForgeDirection rotateSideByMetadata(int side, int metadata) {
        ForgeDirection rotation = ForgeDirection.getOrientation((int)metadata);
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        switch (this.getRotationMode()) {
            case FOUR_DIRECTIONS: 
            case NONE: {
                switch (rotation) {
                    case EAST: {
                        dir = dir.getRotation(ForgeDirection.DOWN);
                        break;
                    }
                    case SOUTH: {
                        dir = dir.getRotation(ForgeDirection.UP);
                        dir = dir.getRotation(ForgeDirection.UP);
                        break;
                    }
                    case WEST: {
                        dir = dir.getRotation(ForgeDirection.UP);
                        break;
                    }
                }
                return dir;
            }
        }
        switch (rotation) {
            case DOWN: {
                dir = dir.getRotation(ForgeDirection.SOUTH);
                dir = dir.getRotation(ForgeDirection.SOUTH);
                break;
            }
            case EAST: {
                dir = dir.getRotation(ForgeDirection.NORTH);
                break;
            }
            case NORTH: {
                dir = dir.getRotation(ForgeDirection.WEST);
                break;
            }
            case SOUTH: {
                dir = dir.getRotation(ForgeDirection.EAST);
                break;
            }
            case WEST: {
                dir = dir.getRotation(ForgeDirection.SOUTH);
                break;
            }
        }
        return dir;
    }

    public void setDefaultTexture(Icon icon) {
        this.field_94336_cN = icon;
    }

    public abstract boolean shouldRenderBlock();

    protected abstract Object getModInstance();

    public void openGui(EntityPlayer player, World world, int x, int y, int z) {
        player.openGui(this.getModInstance(), -1, world, x, y, z);
    }

    public boolean useTESRForInventory() {
        return true;
    }

    public boolean canRotateWithTool() {
        return true;
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        return this.canRotateWithTool() && RotationHelper.rotateBlock(this, worldObj, x, y, z, axis);
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        if (!this.canRotateWithTool()) {
            return BlockRotationMode.NONE.rotations;
        }
        return this.blockRotationMode.rotations;
    }

    public static enum BlockPlacementMode {
        ENTITY_ANGLE,
        SURFACE;

    }

    public static enum BlockRotationMode {
        NONE(new ForgeDirection[0]),
        FOUR_DIRECTIONS(ForgeDirection.UP, ForgeDirection.DOWN),
        SIX_DIRECTIONS(ForgeDirection.VALID_DIRECTIONS),
        TWENTYFOUR_DIRECTIONS(ForgeDirection.VALID_DIRECTIONS);

        private final ForgeDirection[] rotations;

        private BlockRotationMode(ForgeDirection ... rotations) {
            this.rotations = rotations;
        }
    }
}

