/*
 * Decompiled with CFR 0.152.
 */
package openmods.network;

import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.minecraft.network.packet.Packet131MapData;
import net.minecraft.network.packet.Packet250CustomPayload;
import openmods.OpenMods;

public class PacketLogger {
    private static final String CHANNEL_PACKET_TYPE = "packet250";
    private static final String TINY_PACKET_TYPE = "packet131";
    private static Logger debugLog;

    public static void log(Packet250CustomPayload packet, boolean incoming, Collection<String> extras) {
        PacketLogger.log(CHANNEL_PACKET_TYPE, packet.field_73630_a, packet.func_73284_a(), incoming, extras);
    }

    public static void log(Packet250CustomPayload packet, boolean incoming, String ... extras) {
        PacketLogger.log(CHANNEL_PACKET_TYPE, packet.field_73630_a, packet.func_73284_a(), incoming, Arrays.asList(extras));
    }

    public static void log(Packet131MapData packet, boolean incoming, Collection<String> extras) {
        PacketLogger.log(TINY_PACKET_TYPE, packet.field_73436_b, packet.func_73284_a(), incoming, extras);
    }

    public static void log(Packet131MapData packet, boolean incoming, String ... extras) {
        PacketLogger.log(TINY_PACKET_TYPE, packet.field_73436_b, packet.func_73284_a(), incoming, Arrays.asList(extras));
    }

    public static void log(String type, Object source, int payloadLength, boolean incoming, Collection<String> extras) {
        ArrayList fields = Lists.newArrayList();
        fields.add(type.toString());
        fields.add(source.toString());
        fields.add(OpenMods.proxy.isServerThread() ? "server" : "client");
        fields.add(incoming ? "incoming" : "outgoing");
        fields.add(Integer.toString(payloadLength));
        fields.addAll(extras);
        String extra = Joiner.on((char)'\t').join((Iterable)fields);
        PacketLogger.getDebugLog().info(extra);
    }

    private static Logger getDebugLog() {
        if (debugLog == null) {
            debugLog = Logger.getLogger("packets");
            try {
                File dir = OpenMods.proxy.getMinecraftDir();
                File logPattern = new File(dir, "open-mods-packets.log");
                FileHandler handler = new FileHandler(logPattern.getCanonicalPath(), 0x100000, 5);
                handler.setFormatter(new PacketLogFormatter());
                debugLog.addHandler(handler);
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
        }
        return debugLog;
    }

    private static class PacketLogFormatter
    extends Formatter {
        private static final String LINE_SEPARATOR = System.getProperty("line.separator");
        private static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS");

        private PacketLogFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            String isoDate = df.format(new Date(record.getMillis()));
            return isoDate + "\t" + this.formatMessage(record) + LINE_SEPARATOR;
        }
    }
}

