/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet131MapData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import openmods.LibConfig;
import openmods.Log;
import openmods.OpenMods;
import openmods.network.PacketLogger;
import openmods.sync.ISyncHandler;
import openmods.sync.ISyncableObject;
import openmods.utils.ByteUtils;

public abstract class SyncMap<H extends ISyncHandler> {
    private static final int MAX_OBJECT_NUM = 16;
    protected final H handler;
    private Set<Integer> knownUsers = new HashSet<Integer>();
    protected ISyncableObject[] objects = new ISyncableObject[16];
    protected HashMap<String, Integer> nameMap = new HashMap();
    private int index = 0;
    private static final Map<Class<? extends ISyncHandler>, List<Field>> syncedFields = Maps.newIdentityHashMap();
    private static final Comparator<Field> FIELD_NAME_COMPARATOR = new Comparator<Field>(){

        @Override
        public int compare(Field o1, Field o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    protected SyncMap(H handler) {
        this.handler = handler;
    }

    public void put(String name, ISyncableObject value) {
        Preconditions.checkState((this.index < 16 ? 1 : 0) != 0, (String)"Can't add more than %s objects", (Object[])new Object[]{16});
        this.nameMap.put(name, this.index);
        this.objects[this.index++] = value;
    }

    public ISyncableObject get(String name) {
        if (this.nameMap.containsKey(name)) {
            return this.objects[this.nameMap.get(name)];
        }
        return null;
    }

    public int size() {
        return this.index;
    }

    public Set<ISyncableObject> readFromStream(DataInput dis) throws IOException {
        Set changes = Sets.newIdentityHashSet();
        int currentBit = 0;
        for (short mask = dis.readShort(); mask != 0; mask = (short)(mask >> 1)) {
            ISyncableObject object;
            if ((mask & 1) != 0 && (object = this.objects[currentBit]) != null) {
                object.readFromStream(dis);
                changes.add(object);
                object.resetChangeTimer(this.getWorld());
            }
            ++currentBit;
        }
        return changes;
    }

    public int writeToStream(DataOutput dos, boolean regardless) throws IOException {
        ISyncableObject object;
        int i;
        int count = 0;
        short mask = 0;
        for (i = 0; i < this.index; ++i) {
            object = this.objects[i];
            mask = ByteUtils.set(mask, i, object != null && (regardless || object.isDirty()));
        }
        dos.writeShort(mask);
        for (i = 0; i < this.index; ++i) {
            object = this.objects[i];
            if (object == null || !regardless && !object.isDirty()) continue;
            object.writeToStream(dos, regardless);
            object.resetChangeTimer(this.getWorld());
            ++count;
        }
        return count;
    }

    public void markAllAsClean() {
        for (int i = 0; i < this.index; ++i) {
            if (this.objects[i] == null) continue;
            this.objects[i].markClean();
        }
    }

    protected abstract HandlerType getHandlerType();

    protected abstract Set<EntityPlayer> getPlayersWatching();

    protected abstract World getWorld();

    protected abstract boolean isInvalid();

    public Set<ISyncableObject> sync() {
        boolean hasChanges;
        if (this.isInvalid()) {
            return ImmutableSet.of();
        }
        Set<EntityPlayer> players = this.getPlayersWatching();
        Set<ISyncableObject> changes = this.listChanges();
        boolean bl = hasChanges = !changes.isEmpty();
        if (!this.getWorld().field_72995_K) {
            Packet changePacket = null;
            Packet fullPacket = null;
            try {
                for (EntityPlayer player : players) {
                    if (this.knownUsers.contains(player.field_70157_k)) {
                        if (!hasChanges) continue;
                        if (changePacket == null) {
                            changePacket = this.createPacket(false, false);
                        }
                        OpenMods.proxy.sendPacketToPlayer((Player)player, changePacket);
                        continue;
                    }
                    this.knownUsers.add(player.field_70157_k);
                    if (fullPacket == null) {
                        fullPacket = this.createPacket(true, false);
                    }
                    OpenMods.proxy.sendPacketToPlayer((Player)player, fullPacket);
                }
            }
            catch (IOException e) {
                Log.warn(e, "IOError during downstream sync", new Object[0]);
            }
        } else if (hasChanges) {
            try {
                OpenMods.proxy.sendPacketToServer(this.createPacket(false, true));
            }
            catch (IOException e) {
                Log.warn(e, "IOError during upstream sync", new Object[0]);
            }
            this.knownUsers.clear();
        }
        this.markAllAsClean();
        return changes;
    }

    private Set<ISyncableObject> listChanges() {
        Set changes = Sets.newIdentityHashSet();
        for (ISyncableObject obj : this.objects) {
            if (obj == null || !obj.isDirty()) continue;
            changes.add(obj);
        }
        return changes;
    }

    public Packet createPacket(boolean fullPacket, boolean toServer) throws IOException {
        ByteArrayDataOutput bos = ByteStreams.newDataOutput();
        bos.writeBoolean(toServer);
        if (toServer) {
            int dimension = this.getWorld().field_73011_w.field_76574_g;
            bos.writeInt(dimension);
        }
        HandlerType type = this.getHandlerType();
        ByteUtils.writeVLI((DataOutput)bos, type.ordinal());
        type.writeHandlerInfo((ISyncHandler)this.handler, (DataOutput)bos);
        int count = this.writeToStream((DataOutput)bos, fullPacket);
        Packet131MapData packet = PacketDispatcher.getTinyPacket((Object)OpenMods.instance, (short)0, (byte[])bos.toByteArray());
        if (LibConfig.logPackets) {
            PacketLogger.log(packet, false, this.handler.toString(), this.handler.getClass().toString(), Integer.toString(count));
        }
        return packet;
    }

    public static ISyncHandler findSyncMap(World world, DataInput input) throws IOException {
        int handlerTypeId = ByteUtils.readVLI(input);
        Preconditions.checkPositionIndex((int)handlerTypeId, (int)HandlerType.TYPES.length, (String)"handler type");
        HandlerType handlerType = HandlerType.TYPES[handlerTypeId];
        ISyncHandler handler = handlerType.findHandler(world, input);
        return handler;
    }

    public void writeToNBT(NBTTagCompound tag) {
        for (Map.Entry<String, Integer> entry : this.nameMap.entrySet()) {
            int index = entry.getValue();
            String name = entry.getKey();
            if (this.objects[index] == null) continue;
            this.objects[index].writeToNBT(tag, name);
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        for (Map.Entry<String, Integer> entry : this.nameMap.entrySet()) {
            int index = entry.getValue();
            String name = entry.getKey();
            if (this.objects[index] == null) continue;
            this.objects[index].readFromNBT(tag, name);
        }
    }

    private static List<Field> getSyncedFields(ISyncHandler handler) {
        Class<?> handlerCls = handler.getClass();
        ImmutableList result = syncedFields.get(handlerCls);
        if (result == null) {
            TreeSet fields = Sets.newTreeSet(FIELD_NAME_COMPARATOR);
            for (Field field : handlerCls.getDeclaredFields()) {
                if (!ISyncableObject.class.isAssignableFrom(field.getType())) continue;
                fields.add(field);
                field.setAccessible(true);
            }
            result = ImmutableList.copyOf((Collection)fields);
            syncedFields.put(handlerCls, (List<Field>)result);
        }
        return result;
    }

    public void autoregister() {
        for (Field field : SyncMap.getSyncedFields(this.handler)) {
            try {
                this.put(field.getName(), (ISyncableObject)field.get(this.handler));
            }
            catch (Exception e) {
                Log.severe(e, "Exception while registering synce field '%s'", field);
            }
        }
    }

    public static enum HandlerType {
        TILE_ENTITY{

            @Override
            public ISyncHandler findHandler(World world, DataInput input) throws IOException {
                TileEntity tile;
                int x = input.readInt();
                int y = input.readInt();
                int z = input.readInt();
                if (world != null && world.func_72899_e(x, y, z) && (tile = world.func_72796_p(x, y, z)) instanceof ISyncHandler) {
                    return (ISyncHandler)tile;
                }
                Log.warn("Invalid handler info: can't find ISyncHandler TE @ (%d,%d,%d)", x, y, z);
                return null;
            }

            @Override
            public void writeHandlerInfo(ISyncHandler handler, DataOutput output) throws IOException {
                try {
                    TileEntity te = (TileEntity)handler;
                    output.writeInt(te.field_70329_l);
                    output.writeInt(te.field_70330_m);
                    output.writeInt(te.field_70327_n);
                }
                catch (ClassCastException e) {
                    throw new RuntimeException("Invalid usage of handler type", e);
                }
            }
        }
        ,
        ENTITY{

            @Override
            public ISyncHandler findHandler(World world, DataInput input) throws IOException {
                int entityId = input.readInt();
                Entity entity = world.func_73045_a(entityId);
                if (entity instanceof ISyncHandler) {
                    return (ISyncHandler)entity;
                }
                Log.warn("Invalid handler info: can't find ISyncHandler entity id %d", entityId);
                return null;
            }

            @Override
            public void writeHandlerInfo(ISyncHandler handler, DataOutput output) throws IOException {
                try {
                    Entity e = (Entity)handler;
                    output.writeInt(e.field_70157_k);
                }
                catch (ClassCastException e) {
                    throw new RuntimeException("Invalid usage of handler type", e);
                }
            }
        };

        private static final HandlerType[] TYPES;

        public abstract ISyncHandler findHandler(World var1, DataInput var2) throws IOException;

        public abstract void writeHandlerInfo(ISyncHandler var1, DataOutput var2) throws IOException;

        static {
            TYPES = HandlerType.values();
        }
    }
}

