/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import openmods.sync.SyncableObjectBase;

public class SyncableBoolean
extends SyncableObjectBase {
    private boolean value;

    public SyncableBoolean(boolean value) {
        this.value = value;
    }

    public SyncableBoolean() {
    }

    public void setValue(boolean newValue) {
        if (newValue != this.value) {
            this.value = newValue;
            this.markDirty();
        }
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    public void readFromStream(DataInput stream) throws IOException {
        this.value = stream.readBoolean();
    }

    @Override
    public void writeToStream(DataOutput stream, boolean fullData) throws IOException {
        stream.writeBoolean(this.value);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, String name) {
        tag.func_74757_a(name, this.value);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, String name) {
        this.value = tag.func_74767_n(name);
    }

    public void toggle() {
        this.value = !this.value;
        this.markDirty();
    }
}

