/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import java.io.DataInput;
import java.io.IOException;
import java.util.Set;
import net.minecraft.network.packet.Packet131MapData;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.world.World;
import openmods.LibConfig;
import openmods.OpenMods;
import openmods.network.PacketLogger;
import openmods.sync.ISyncHandler;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncMap;

public class SyncableManager {
    public void handlePacket(Packet250CustomPayload packet) throws IOException {
        ByteArrayDataInput input = ByteStreams.newDataInput((byte[])packet.field_73629_c);
        World world = SyncableManager.readWorld((DataInput)input);
        ISyncHandler handler = SyncMap.findSyncMap(world, (DataInput)input);
        if (handler != null) {
            Set<ISyncableObject> changes = handler.getSyncMap().readFromStream((DataInput)input);
            handler.onSynced(changes);
            if (LibConfig.logPackets) {
                PacketLogger.log(packet, true, handler.toString(), handler.getClass().toString(), Integer.toString(changes.size()));
            }
        }
    }

    public void handlePacket(Packet131MapData packet) throws IOException {
        ByteArrayDataInput input = ByteStreams.newDataInput((byte[])packet.field_73437_c);
        World world = SyncableManager.readWorld((DataInput)input);
        ISyncHandler handler = SyncMap.findSyncMap(world, (DataInput)input);
        if (handler != null) {
            Set<ISyncableObject> changes = handler.getSyncMap().readFromStream((DataInput)input);
            handler.onSynced(changes);
            if (LibConfig.logPackets) {
                PacketLogger.log(packet, true, handler.toString(), handler.getClass().toString(), Integer.toString(changes.size()));
            }
        }
    }

    private static World readWorld(DataInput input) throws IOException {
        boolean toServer = input.readBoolean();
        if (toServer) {
            int dimension = input.readInt();
            return OpenMods.proxy.getServerWorld(dimension);
        }
        return OpenMods.proxy.getClientWorld();
    }
}

