/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.collect.Ordering;
import java.io.File;
import java.net.URL;
import net.minecraftforge.common.ConfigCategory;
import net.minecraftforge.common.Configuration;
import openmods.Log;
import openmods.utils.MCUtils;
import openmods.utils.MiscUtils;

public class ModVersionChecker {
    private URL versionURL;
    private final String modName;
    private final String proposedVer;
    private final String currentVer;
    private String updateURL;
    private String[] loadMsg;
    private String[] inGameMsg;
    private File trackerFile;
    private File trackerDir;
    private static Configuration versionCheckTracker;
    private final String lastNewVersionFound;

    public ModVersionChecker(String modName, String oldVer, String versionURL, String updateURL, String[] loadMsg, String[] inGameMsg) {
        this(modName, oldVer, versionURL, updateURL, loadMsg, inGameMsg, 3000);
    }

    public ModVersionChecker(String modName, String currentVer, String versionURL, String updateURL, String[] loadMsg, String[] inGameMsg, int timeoutMS) {
        this.modName = modName;
        this.currentVer = currentVer;
        this.updateURL = updateURL;
        this.loadMsg = loadMsg;
        this.inGameMsg = inGameMsg;
        try {
            this.versionURL = new URL(versionURL);
            Log.info("Initializing ModVersionChecker for mod %s", modName);
        }
        catch (Throwable e) {
            Log.warn("Error initializing ModVersionChecker for mod %s: %s", modName, e.getMessage());
        }
        String[] versionLines = MiscUtils.loadTextFromURL(this.versionURL, new String[]{currentVer}, timeoutMS);
        this.proposedVer = versionLines[0].trim();
        if (this.trackerDir == null) {
            this.trackerDir = new File(MCUtils.getConfigDir() + "/OpenModsLib/");
            if (this.trackerDir.exists() || this.trackerDir.mkdirs()) {
                this.trackerFile = new File(this.trackerDir, "ModVersionCheckerTracking.txt");
            }
        }
        if (versionCheckTracker == null) {
            versionCheckTracker = new Configuration(this.trackerFile);
        }
        versionCheckTracker.load();
        ConfigCategory cc = versionCheckTracker.getCategory("version_check_tracker");
        if (!cc.containsKey(modName)) {
            versionCheckTracker.get("version_check_tracker", modName, currentVer);
        }
        this.lastNewVersionFound = ModVersionChecker.isNewerVersion(currentVer, this.proposedVer) ? this.proposedVer : cc.get(modName).getString();
        cc.get(modName).set(this.proposedVer);
        versionCheckTracker.save();
        this.setLoadMessage(loadMsg);
        this.setInGameMessage(inGameMsg);
    }

    public ModVersionChecker(String modName, String oldVer, String versionURL, String updateURL) {
        this(modName, oldVer, versionURL, updateURL, new String[]{"{modName} {oldVer} is out of date! Visit {updateURL} to download the latest release ({newVer})."}, new String[]{"\u00a7c{modName} {newVer} \u00a7ris out! Download the latest from \u00a7a{updateURL}\u00a7r"});
    }

    public void checkVersionWithLogging() {
        if (!ModVersionChecker.isNewerVersion(this.currentVer, this.proposedVer)) {
            for (String msg : this.loadMsg) {
                Log.info(msg, new Object[0]);
            }
        }
    }

    public void setLoadMessage(String[] loadMsg) {
        this.loadMsg = loadMsg;
        for (int i = 0; i < this.loadMsg.length; ++i) {
            this.loadMsg[i] = this.replaceAllTags(this.loadMsg[i]);
        }
    }

    public void setInGameMessage(String[] inGameMsg) {
        this.inGameMsg = inGameMsg;
        for (int i = 0; i < this.inGameMsg.length; ++i) {
            this.inGameMsg[i] = this.replaceAllTags(this.inGameMsg[i]);
        }
    }

    public String[] getLoadMessage() {
        return this.loadMsg;
    }

    public String[] getInGameMessage() {
        return this.inGameMsg;
    }

    public boolean isCurrentVersion() {
        return ModVersionChecker.isNewerVersion(this.lastNewVersionFound, this.proposedVer);
    }

    public static boolean isNewerVersion(String currentVer, String proposedVer) {
        return Ordering.natural().compare((Object)currentVer, (Object)proposedVer) >= 0;
    }

    private String replaceAllTags(String s) {
        return s.replace("{oldVer}", this.currentVer).replace("{newVer}", this.proposedVer).replace("{modName}", this.modName).replace("{updateURL}", this.updateURL);
    }
}

