/*
 * Decompiled with CFR 0.152.
 */
package com.advGenetics.DNA;

import com.advGenetics.API.Ability;
import com.advGenetics.API.IAddRemove;
import com.advGenetics.API.IEntityInteract;
import com.advGenetics.API.IInteractPlayer;
import com.advGenetics.API.IKeyAction;
import com.advGenetics.API.ILivingAttack;
import com.advGenetics.API.ILivingDeath;
import com.advGenetics.API.ILivingHurt;
import com.advGenetics.API.ILivingJoin;
import com.advGenetics.API.IPlayerTick;
import com.advGenetics.Lib.HashHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AbilityRegistry {
    public static Map<Integer, Ability> abilities = new HashMap<Integer, Ability>();
    public static List<Ability> abilitiesRegisted = new ArrayList<Ability>();
    public static List<Ability> ab_key = new ArrayList<Ability>();
    public static List<Ability> ab_event_damage = new ArrayList<Ability>();
    public static List<Ability> ab_event_join = new ArrayList<Ability>();
    public static List<Ability> ab_event_interact = new ArrayList<Ability>();
    public static List<Ability> ab_add_remove = new ArrayList<Ability>();
    public static List<Ability> ab_tick = new ArrayList<Ability>();
    public static Map<String, ArrayList<Class>> abilities_holder = new HashMap<String, ArrayList<Class>>();
    public static List<Class> entityBlacklist = new ArrayList<Class>();
    private static int lastID = -1;

    public static void registerAbility(Ability ability, Class entityHolderClass) {
        if (!abilities.containsValue(ability)) {
            ability.id = ++lastID;
            ability.hash = HashHelper.toMD5(ability.getUnlocalizedName());
            abilities.put(lastID, ability);
            abilitiesRegisted.add(ability);
            if (ability instanceof IAddRemove) {
                ab_add_remove.add(ability);
            }
            if (ability instanceof IEntityInteract || ability instanceof IInteractPlayer) {
                ab_event_interact.add(ability);
            }
            if (ability instanceof IKeyAction) {
                ab_key.add(ability);
            }
            if (ability instanceof ILivingAttack || ability instanceof ILivingHurt || ability instanceof ILivingDeath) {
                ab_event_damage.add(ability);
            }
            if (ability instanceof ILivingJoin) {
                ab_event_join.add(ability);
            }
            if (ability instanceof IPlayerTick) {
                ab_tick.add(ability);
            }
            AbilityRegistry.addEntityToAbility(ability.getUnlocalizedName(), entityHolderClass);
        } else {
            System.out.println("[Advanced Genetics] Skipped Ability (" + Ability.class.toString() + ")[" + (lastID + 1) + "]! This ability is already registed!");
        }
    }

    public static void addEntityToAbility(String unlocalizedName, Class entityHolderClass) {
        if (!abilities_holder.containsKey(unlocalizedName)) {
            abilities_holder.put(unlocalizedName, new ArrayList());
        }
        abilities_holder.get(unlocalizedName).add(entityHolderClass);
    }

    public static Ability getAbility(Class abilityClass) {
        for (Ability ability : abilitiesRegisted) {
            if (ability.getClass() != abilityClass) continue;
            return ability;
        }
        return null;
    }

    public static void addEntityToBlacklist(Class entityClass) {
        if (!entityBlacklist.contains(entityClass)) {
            entityBlacklist.add(entityClass);
        }
    }
}

