/*
 * Decompiled with CFR 0.152.
 */
package com.advGenetics.DNA;

import com.advGenetics.API.Ability;
import com.advGenetics.Lib.GeneHelper;
import net.minecraft.nbt.NBTTagCompound;

public class DNA {
    private NBTTagCompound tag;
    private boolean forgeTag = false;

    public DNA(NBTTagCompound tag) {
        this.tag = tag;
        if (this.tag.func_74775_l("ForgeData").func_74764_b("dna_transmutators")) {
            this.forgeTag = true;
        }
    }

    public void applyTransmutator(Ability ability) {
        String trans = this.getTransmutators();
        if (!trans.contains(ability.hash + ",")) {
            trans = trans + ability.hash + ",";
        }
        if (this.forgeTag) {
            this.tag.func_74775_l("ForgeData").func_74778_a("dna_transmutators", trans);
        } else {
            this.tag.func_74778_a("dna_transmutators", trans);
        }
    }

    public void removeTransmutator(Ability ability) {
        String trans = this.getTransmutators();
        if (trans.contains(ability.hash + ",")) {
            trans = trans.replace(ability.hash + ",", "");
        }
        if (this.forgeTag) {
            this.tag.func_74775_l("ForgeData").func_74778_a("dna_transmutators", trans);
        } else {
            this.tag.func_74778_a("dna_transmutators", trans);
        }
    }

    public void removeTransmutatorMarked(Ability ability) {
        String trans = this.getTransmutators();
        if (trans.contains(ability.hash + ",")) {
            trans = trans.replace(ability.hash + ",", "");
            trans = trans + "-" + ability.hash + ",";
        }
        if (this.forgeTag) {
            this.tag.func_74775_l("ForgeData").func_74778_a("dna_transmutators", trans);
        } else {
            this.tag.func_74778_a("dna_transmutators", trans);
        }
    }

    public String getTransmutators() {
        return this.forgeTag ? this.tag.func_74775_l("ForgeData").func_74779_i("dna_transmutators") : this.tag.func_74779_i("dna_transmutators");
    }

    public NBTTagCompound createTagCompound() {
        return this.tag;
    }

    public boolean hasGene(Ability ability) {
        return this.getTransmutators().contains(ability.hash + ",");
    }

    public boolean hasGene(String hash) {
        return this.getTransmutators().contains(hash + ",");
    }

    public void clearToMin(String externTrans) {
        String[] eta = externTrans.split(",");
        if (eta.length > 0) {
            for (String trans : eta) {
                if (trans.trim().length() <= 1) continue;
                char h = trans.charAt(0);
                if (h == '-') {
                    if (!this.hasGene(trans.substring(1))) continue;
                    this.removeTransmutator(GeneHelper.getAbility(trans.substring(1)));
                    continue;
                }
                if (this.hasGene(trans)) continue;
                this.applyTransmutator(GeneHelper.getAbility(trans));
            }
        }
    }

    public Ability[] getAbilities() {
        String[] transArray = this.getTransmutators().split(",");
        Ability[] output = new Ability[transArray.length];
        for (int i = 0; i < transArray.length; ++i) {
            if (transArray[i].trim().length() <= 1 || GeneHelper.getAbility(transArray[i]) == null) continue;
            output[i] = GeneHelper.getAbility(transArray[i]);
        }
        return output;
    }
}

