/*
 * Decompiled with CFR 0.152.
 */
package com.advGenetics.Lib;

import com.advGenetics.API.Ability;
import com.advGenetics.DNA.Abilities.AbilityBasic;
import com.advGenetics.DNA.AbilityRegistry;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;

public class GeneHelper {
    public static String[] getListString() {
        int i = 0;
        String[] output = new String[AbilityRegistry.abilities.size() - 1];
        for (Map.Entry<Integer, Ability> entry : AbilityRegistry.abilities.entrySet()) {
            if (entry.getValue().getClass() == AbilityBasic.class) continue;
            output[i] = entry.getValue().getUnlocalizedName();
            ++i;
        }
        return output;
    }

    public static int getIDOfAbility(Class ability) {
        for (Map.Entry<Integer, Ability> entry : AbilityRegistry.abilities.entrySet()) {
            if (!entry.getValue().getClass().equals(ability)) continue;
            return entry.getKey();
        }
        return -1;
    }

    public static Ability getAbility(Class ability) {
        return AbilityRegistry.abilities.get(GeneHelper.getIDOfAbility(ability));
    }

    public static Ability getAbility(String hash) {
        for (Map.Entry<Integer, Ability> entry : AbilityRegistry.abilities.entrySet()) {
            if (!entry.getValue().hash.equals(hash)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static Ability getAbility(int id) {
        for (Map.Entry<Integer, Ability> entry : AbilityRegistry.abilities.entrySet()) {
            if (entry.getValue().id != id) continue;
            return entry.getValue();
        }
        return null;
    }

    public static Ability getAbilityByName(String name) {
        for (Map.Entry<Integer, Ability> entry : AbilityRegistry.abilities.entrySet()) {
            if (!entry.getValue().getName().equals(name)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static Ability getAbilityByUnlocalizedName(String name) {
        for (Map.Entry<Integer, Ability> entry : AbilityRegistry.abilities.entrySet()) {
            if (!entry.getValue().getUnlocalizedName().equals(name)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static ArrayList<Ability> getRandomTransmutatorsByEntityClass(Entity entity, Random random) {
        ArrayList<Ability> output = new ArrayList<Ability>();
        if (entity != null) {
            for (Map.Entry<Integer, Ability> entry : AbilityRegistry.abilities.entrySet()) {
                if (entry.getValue().getClass() == AbilityBasic.class || !AbilityRegistry.abilities_holder.get(entry.getValue().getUnlocalizedName()).contains(entity.getClass()) || random.nextInt(8 + entry.getValue().getRarity()) > 12 || !entry.getValue().isAllowed()) continue;
                output.add(entry.getValue());
            }
            if (random.nextInt(50) <= 25) {
                output.add(GeneHelper.getAbility(AbilityBasic.class));
            }
            if (output.size() == 0) {
                output.add(GeneHelper.getAbility(AbilityBasic.class));
            }
        }
        return output;
    }

    public static String getHashString(ArrayList<Ability> list) {
        String output = "";
        for (Ability ability : list) {
            output = output + ability.hash + ";";
        }
        return output;
    }

    public static boolean isTransmutator(String name) {
        for (Map.Entry<Integer, Ability> entry : AbilityRegistry.abilities.entrySet()) {
            if (!entry.getValue().getUnlocalizedName().equals(name) || entry.getValue().getClass() == AbilityBasic.class) continue;
            return true;
        }
        return false;
    }
}

