/*
 * Decompiled with CFR 0.152.
 */
package com.advGenetics.TickHandler;

import com.advGenetics.DNA.DNA;
import com.advGenetics.Lib.EntityUpdater;
import com.advGenetics.Lib.PacketWrapper;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class TickHandlerDimSync
implements ITickHandler {
    private static Map<Integer, DNA> dnaMapping = new HashMap<Integer, DNA>();
    private static Map<Integer, Integer> idleMapping = new HashMap<Integer, Integer>();

    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
        World world = (World)tickData[0];
        if (world != null && !world.field_72995_K) {
            HashMap<Integer, DNA> dnaMappingCopy = new HashMap<Integer, DNA>(dnaMapping);
            for (Map.Entry entry : dnaMappingCopy.entrySet()) {
                Entity entity = world.func_73045_a(((Integer)entry.getKey()).intValue());
                if (entity == null || !(entity instanceof EntityPlayer)) continue;
                EntityPlayer player = (EntityPlayer)entity;
                if (player.field_70170_p.field_73011_w.field_76574_g == 1) continue;
                int idle = idleMapping.get(player.field_70157_k);
                if (++idle == 8) {
                    player.getEntityData().func_74778_a("dna_transmutators", ((DNA)entry.getValue()).getTransmutators());
                    PacketWrapper.sendDNASyncPacket(10, ((DNA)entry.getValue()).getTransmutators(), player.field_70157_k);
                    EntityUpdater.updatePlayerCapatilities((DNA)entry.getValue(), (Entity)player);
                    TickHandlerDimSync.removePlayer(player);
                    continue;
                }
                idleMapping.put(player.field_70157_k, idle);
            }
        }
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.WORLD);
    }

    public String getLabel() {
        return "dimsync";
    }

    public static void dispose() {
        dnaMapping.clear();
        idleMapping.clear();
    }

    public static void addPlayer(EntityPlayer player) {
        dnaMapping.put(player.field_70157_k, new DNA(player.getEntityData()));
        idleMapping.put(player.field_70157_k, 0);
    }

    public static void removePlayer(EntityPlayer player) {
        dnaMapping.remove(player.field_70157_k);
        idleMapping.remove(player.field_70157_k);
    }
}

