/*
 * Decompiled with CFR 0.152.
 */
package com.advGenetics.TileEntity;

import cofh.api.energy.IEnergyHandler;
import cofh.api.tileentity.IEnergyInfo;
import com.advGenetics.API.Power.IPowerReceiver;
import com.advGenetics.AdvGenetics;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TileEntityDNA
extends TileEntity
implements IEnergySink,
IPowerReceiver,
IEnergyHandler,
IEnergyInfo {
    private int overclocker = 0;
    private boolean hasAutoOutputUpgrade = false;
    public int idle = 0;
    public boolean canExctract = true;
    public int storedEnergy = 0;
    public final int maxStroredEnergy = 8000;
    public static int energyRequiredForWork = AdvGenetics.machineEnergyUsingForWork;
    public int energyReq = 128;
    public final int energyPerEU = 4;
    public int energyReqTick = 0;
    private boolean addOnNextTick;
    private boolean wasAddedToIC2;

    public int getOverclocker() {
        return this.overclocker;
    }

    public boolean hasAutoOutputUpgrade() {
        return this.hasAutoOutputUpgrade;
    }

    public void addOverclocker(int amount) {
        this.overclocker += amount;
    }

    public void setHasAutoOutputUpgrade(boolean par1) {
        this.hasAutoOutputUpgrade = par1;
    }

    public void func_70307_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70307_a(par1NBTTagCompound);
        this.overclocker = par1NBTTagCompound.func_74762_e("overclocker");
        this.hasAutoOutputUpgrade = par1NBTTagCompound.func_74767_n("autoOutputUpgrade");
        this.storedEnergy = par1NBTTagCompound.func_74762_e("storedEnergy");
    }

    public void func_70310_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70310_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("overclocker", this.overclocker);
        par1NBTTagCompound.func_74757_a("autoOutputUpgrade", this.hasAutoOutputUpgrade);
        par1NBTTagCompound.func_74768_a("storedEnergy", this.storedEnergy);
    }

    public void setOverclocker(int par2) {
        this.overclocker = par2;
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        if (this.addOnNextTick) {
            if (!this.field_70331_k.field_72995_K) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            }
            this.addOnNextTick = false;
            this.wasAddedToIC2 = true;
        }
        int eReq = Math.min(this.maxStroredEnergy - this.storedEnergy, energyRequiredForWork);
        this.energyReqTick = Math.max(this.energyReqTick + this.energyReqTick, this.energyReq);
    }

    public void func_70313_j() {
        super.func_70313_j();
        if (this.wasAddedToIC2) {
            if (this.field_70331_k != null && !this.field_70331_k.field_72995_K) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            }
            this.wasAddedToIC2 = false;
        }
    }

    public void func_70312_q() {
        super.func_70312_q();
        if (!this.wasAddedToIC2) {
            this.addOnNextTick = true;
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.wasAddedToIC2) {
            if (this.field_70331_k != null && !this.field_70331_k.field_72995_K) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            }
            this.addOnNextTick = false;
        }
    }

    public int getScaledEnergy(int pixel) {
        int i2 = this.storedEnergy > this.maxStroredEnergy ? this.maxStroredEnergy : this.storedEnergy;
        return i2 * pixel / this.maxStroredEnergy;
    }

    public int getMinEnergy(int maxIdle) {
        return this.maxStroredEnergy / 2;
    }

    public int getEnergyRequired() {
        return Math.min(this.maxStroredEnergy - this.storedEnergy, this.energyReqTick);
    }

    public int storeEnergy(int energy, boolean doStore) {
        int energyInjected = Math.max(Math.min(energy, this.getEnergyRequired()), 0);
        if (doStore) {
            this.storedEnergy += energyInjected;
            this.energyReqTick -= energyInjected;
        }
        return energyInjected;
    }

    public int storeEnergy(int energy) {
        return this.storeEnergy(energy, true);
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    @Override
    public double demandedEnergyUnits() {
        return Math.max(Math.ceil((double)this.getEnergyRequired() / 4.0), 0.0);
    }

    @Override
    public double injectEnergyUnits(ForgeDirection directionFrom, double amount) {
        double euLeftOver = Math.max(amount, 0.0);
        euLeftOver -= (double)this.storeEnergy((int)(euLeftOver * 4.0)) / 4.0;
        return euLeftOver;
    }

    @Override
    public int getMaxSafeInput() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getStoredEnergy() {
        return this.storedEnergy;
    }

    @Override
    public int getMaxStoredEnergy() {
        return this.maxStroredEnergy;
    }

    @Override
    public void setStoredEnergy(double par1) {
        this.storedEnergy = (int)par1;
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.func_70307_a(packet.field_73331_e);
    }

    public Packet func_70319_e() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_70310_b(nbttagcompound);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 4, nbttagcompound);
    }

    public boolean isItemValidForSlot(int par1, ItemStack par2ItemStack) {
        return false;
    }

    @Override
    public int getEnergyPerTick() {
        return Math.min(this.maxStroredEnergy - this.storedEnergy, this.energyReq);
    }

    @Override
    public int getEnergy() {
        return this.storedEnergy;
    }

    @Override
    public int getMaxEnergy() {
        return this.maxStroredEnergy;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storeEnergy(maxReceive, !simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean doExtract) {
        return 0;
    }

    @Override
    public boolean canInterface(ForgeDirection from) {
        return true;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storedEnergy;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.maxStroredEnergy;
    }

    @Override
    public int getMaxEnergyPerTick() {
        return this.energyReq;
    }
}

