/*
 * Decompiled with CFR 0.152.
 */
package tropicraft;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.Potion;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import tropicraft.Tropicraft;
import tropicraft.ai.WorldDirector;
import tropicraft.entities.placeable.EntityChair;
import tropicraft.fishing.FishingManager;
import tropicraft.questsystem.PlayerQuestManager;
import tropicraft.world.TropicraftWorldUtils;

public class TickHandlerServer
implements ITickHandler {
    public static Tropicraft mod;
    public static World lastWorld;
    public static WorldDirector wd;
    public static PlayerQuestManager playerQuestMan;

    public TickHandlerServer(Tropicraft pMod) {
        mod = pMod;
    }

    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
        if (type.equals(EnumSet.of(TickType.SERVER))) {
            this.onTickInGame();
        }
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.SERVER);
    }

    public String getLabel() {
        return null;
    }

    public void onTickInGame() {
        boolean reInitQuests = false;
        if (lastWorld != DimensionManager.getWorld((int)0)) {
            lastWorld = DimensionManager.getWorld((int)0);
            reInitQuests = true;
        }
        if (playerQuestMan == null || reInitQuests) {
            WorldServer tropics = DimensionManager.getWorld((int)-127);
            if (tropics != null) {
                playerQuestMan = new PlayerQuestManager((World)tropics);
            }
        } else {
            playerQuestMan.tick();
        }
        try {
            FishingManager.onServerTick();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (wd == null) {
            wd = new WorldDirector();
        }
        wd.onTick();
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0);
        if (world != null && world instanceof WorldServer) {
            for (int ii = 0; ii < world.field_73010_i.size(); ++ii) {
                Entity entity1 = (Entity)world.field_73010_i.get(ii);
                if (!(entity1 instanceof EntityPlayerMP) || !((EntityPlayerMP)entity1).func_70644_a(Potion.field_76431_k) || !this.isSunset((World)world) || !(entity1.field_70154_o instanceof EntityChair)) continue;
                entity1.field_70154_o = null;
                TropicraftWorldUtils.teleportPlayer((EntityPlayerMP)entity1);
            }
        }
    }

    private boolean isSunset(World world) {
        long timeDay = world.func_72820_D() % 24000L;
        return timeDay > 12200L && timeDay < 14000L;
    }

    static {
        lastWorld = null;
    }
}

