/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.ai;

import CoroUtil.OldUtil;
import CoroUtil.componentAI.ICoroAI;
import CoroUtil.pathfinding.IPFCallback;
import CoroUtil.pathfinding.PFCallbackItem;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import tropicraft.Tropicraft;
import tropicraft.ai.AreaScanner;
import tropicraft.config.TropicraftConfig;

public class WorldDirector
implements IPFCallback {
    public static HashMap<Integer, ArrayList<ChunkCoordinates>> coordSurfaceCaves = new HashMap();
    public static HashMap<Integer, ArrayList<ChunkCoordinates>> coordCaves = new HashMap();
    public static HashMap<Integer, ArrayList<ChunkCoordinates>> coordInvasionSources = new HashMap();
    public HashMap<String, ChunkCoordinates> lastCursePlayerLocations;
    public HashMap<String, ChunkCoordinates> lastScanPlayerLocations;
    public static HashMap<String, NBTTagCompound> playerNBT = new HashMap();
    public AreaScanner areaScanner;
    public boolean scanning;
    private int detectedIDTropicraft;
    public ArrayList<PFCallbackItem> queue = new ArrayList();
    public boolean waitingOnPF = false;
    public static String lastWorldFolder = "";

    public WorldDirector() {
        this.lastScanPlayerLocations = new HashMap();
    }

    public void onTick() {
        WorldServer[] worlds = DimensionManager.getWorlds();
        for (int i = 0; i < worlds.length; ++i) {
            WorldServer world = worlds[i];
            this.onTickWorld((World)world);
        }
    }

    public static void resetDimData() {
        WorldDirector.dbg("Resetting TropiWD Data");
        coordSurfaceCaves = new HashMap();
        coordCaves = new HashMap();
        coordInvasionSources = new HashMap();
    }

    public static void initDimData(World world) {
        WorldDirector.initDimData(world.field_73011_w.field_76574_g);
    }

    public static void initDimData(int dimID) {
        WorldDirector.dbg("Initializing TropiWD Data for dim: " + dimID);
        coordSurfaceCaves.put(dimID, new ArrayList());
        coordCaves.put(dimID, new ArrayList());
        coordInvasionSources.put(dimID, new ArrayList());
    }

    public static NBTTagCompound getPlayerNBT(String username) {
        if (!playerNBT.containsKey(username)) {
            WorldDirector.tryLoadPlayerNBT(username);
        }
        return playerNBT.get(username);
    }

    public static void tryLoadPlayerNBT(String username) {
        NBTTagCompound playerData = new NBTTagCompound();
        try {
            String fileURL = WorldDirector.getWorldSaveFolderPath() + WorldDirector.getWorldFolderName() + File.separator + "TCPlayerData" + File.separator + username + ".dat";
            if (new File(fileURL).exists()) {
                playerData = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(fileURL));
            }
        }
        catch (Exception ex) {
            WorldDirector.dbg("no saved data found for " + username);
        }
        playerNBT.put(username, playerData);
    }

    public static void writeAllPlayerNBT() {
        WorldDirector.dbg("writing out all player nbt");
        String fileURL = WorldDirector.getWorldSaveFolderPath() + WorldDirector.getWorldFolderName() + File.separator + "TCPlayerData";
        if (!new File(fileURL).exists()) {
            new File(fileURL).mkdir();
        }
        for (Map.Entry<String, NBTTagCompound> pairs : playerNBT.entrySet()) {
            WorldDirector.dbg(pairs.getKey() + " = " + pairs.getValue());
            WorldDirector.writePlayerNBT(pairs.getKey(), pairs.getValue());
        }
    }

    public static void writePlayerNBT(String username, NBTTagCompound parData) {
        WorldDirector.dbg("writing " + username);
        String fileURL = WorldDirector.getWorldSaveFolderPath() + WorldDirector.getWorldFolderName() + File.separator + "TCPlayerData" + File.separator + username + ".dat";
        try {
            FileOutputStream fos = new FileOutputStream(fileURL);
            CompressedStreamTools.func_74799_a((NBTTagCompound)parData, (OutputStream)fos);
            fos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            WorldDirector.dbg("Error writing TropiWD player data for " + username);
        }
    }

    public void onTickWorld(World world) {
        int dim = world.field_73011_w.field_76574_g;
        if (coordSurfaceCaves.get(dim) == null) {
            WorldDirector.initDimData(world);
        }
        if (world.field_73011_w.field_76574_g == 0) {
            this.onTickOverworld(world);
        }
        if (world.field_73011_w.func_80007_l().equalsIgnoreCase("Tropics")) {
            this.detectedIDTropicraft = world.field_73011_w.field_76574_g;
            this.onTickTropicraft(world);
        }
    }

    public static void dbg(Object obj) {
        Tropicraft.dbg(obj);
    }

    public boolean isCoordAndNearAreaNaturalBlocks(World parWorld, int x, int y, int z, int range) {
        return this.isNaturalSurfaceBlock(parWorld.func_72798_a(x, y, z)) && this.isNaturalSurfaceBlock(parWorld.func_72798_a(x + range, y, z)) && this.isNaturalSurfaceBlock(parWorld.func_72798_a(x - range, y, z)) && this.isNaturalSurfaceBlock(parWorld.func_72798_a(x, y, z + range)) && this.isNaturalSurfaceBlock(parWorld.func_72798_a(x, y, z - range));
    }

    public boolean isNaturalSurfaceBlock(int id) {
        if (id == Block.field_72037_aS.field_71990_ca || id == Block.field_71980_u.field_71990_ca || id == Block.field_71979_v.field_71990_ca || id == Block.field_71939_E.field_71990_ca || id == Block.field_71981_t.field_71990_ca || id == Block.field_71940_F.field_71990_ca || id == Block.field_71962_X.field_71990_ca) {
            return true;
        }
        return this.isLogOrLeafBlock(id);
    }

    public boolean isLogOrLeafBlock(int id) {
        Block block = Block.field_71973_m[id];
        if (block == null) {
            return false;
        }
        if (block.field_72018_cp == Material.field_76257_i) {
            return true;
        }
        if (block.field_72018_cp == Material.field_76254_j) {
            return true;
        }
        return block.field_72018_cp == Material.field_76245_d;
    }

    public boolean isCursed(EntityPlayer entP) {
        return true;
    }

    public ArrayList<ChunkCoordinates> getUnusedInvasionSourcesInRange(ArrayList<ChunkCoordinates> collection, EntityPlayer entP, float range) {
        return this.getUnusedInvasionSourcesInRange(collection, new ChunkCoordinates((int)entP.field_70165_t, (int)entP.field_70163_u, (int)entP.field_70161_v), entP.field_71093_bK, range);
    }

    public ArrayList<ChunkCoordinates> getUnusedInvasionSourcesInRange(ArrayList<ChunkCoordinates> collection, ChunkCoordinates parCoords, int dim, float range) {
        ArrayList<ChunkCoordinates> coordList = new ArrayList<ChunkCoordinates>();
        for (int i = 0; i < collection.size(); ++i) {
            ChunkCoordinates coords = collection.get(i);
            if (this.isValid(dim, coords)) {
                if (!(OldUtil.getDistanceXZ((ChunkCoordinates)parCoords, (ChunkCoordinates)coords) < (double)range)) continue;
                coordList.add(coords);
                continue;
            }
            collection.remove(coords);
        }
        return coordList;
    }

    public boolean isValid(int dim, ChunkCoordinates coords) {
        return true;
    }

    public void onTickTropicraft(World world) {
        Random rand = new Random();
        if (world.field_73010_i.size() > 0) {
            EntityPlayer entP2 = (EntityPlayer)world.field_73010_i.get(rand.nextInt(world.field_73010_i.size()));
            if (!entP2.field_70128_L && world.func_72820_D() % 3600L == 0L) {
                this.tryAreaScan(entP2);
            }
        }
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer entP = (EntityPlayer)world.field_73010_i.get(i);
            if (entP == null || entP.field_70128_L) continue;
            NBTTagCompound playerData = WorldDirector.getPlayerNBT(entP.field_71092_bJ);
            if (!TropicraftConfig.eventMiniSpawns) continue;
            int cooldown = playerData.func_74762_e("spawnEventCooldown");
            if (cooldown <= 0) {
                if (!world.func_72935_r()) {
                    if (coordSurfaceCaves.get(world.field_73011_w.field_76574_g).size() > 0) {
                        cooldown = this.triggerEvent(world, new ChunkCoordinates((int)entP.field_70165_t, (int)entP.field_70163_u, (int)entP.field_70161_v), coordSurfaceCaves.get(world.field_73011_w.field_76574_g)) ? 22000 : 200;
                    }
                }
            } else {
                --cooldown;
            }
            playerData.func_74768_a("spawnEventCooldown", cooldown);
        }
    }

    public void onTickOverworld(World world) {
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer entP = (EntityPlayer)world.field_73010_i.get(i);
            if (entP == null || entP.field_70128_L) continue;
            NBTTagCompound playerData = WorldDirector.getPlayerNBT(entP.field_71092_bJ);
        }
    }

    public float distanceTo(int x1, int y1, int z1, int x2, int y2, int z2) {
        float f = x2 - x1;
        float f1 = y2 - y1;
        float f2 = z2 - z1;
        return MathHelper.func_76129_c((float)(f * f + f1 * f1 + f2 * f2));
    }

    public boolean tryAreaScan(EntityPlayer entP) {
        if (entP.field_70170_p.func_72935_r() && !this.scanning && (!this.lastScanPlayerLocations.containsKey(entP.field_71092_bJ) || Math.sqrt(this.lastScanPlayerLocations.get(entP.field_71092_bJ).func_71569_e((int)entP.field_70165_t, (int)entP.field_70163_u, (int)entP.field_70161_v)) > 8.0)) {
            this.lastScanPlayerLocations.put(entP.field_71092_bJ, new ChunkCoordinates((int)entP.field_70165_t, (int)entP.field_70163_u, (int)entP.field_70161_v));
            WorldDirector.dbg("Starting area scan on player: " + entP.field_71092_bJ);
            this.areaScanner = new AreaScanner(this, entP.field_70170_p, entP);
            new Thread((Runnable)this.areaScanner, "TC Area Scanner").start();
            this.scanning = true;
        }
        return false;
    }

    public synchronized void areaScanCompleteCallback() {
        coordSurfaceCaves.put(this.areaScanner.world.field_73011_w.field_76574_g, this.areaScanner.tempSurfaceCaves);
        coordCaves.put(this.areaScanner.world.field_73011_w.field_76574_g, this.areaScanner.tempCaves);
        this.scanning = false;
        WorldDirector.dbg(this.areaScanner.world.field_73011_w.field_76574_g + ": Area scan complete, surface caves: " + coordSurfaceCaves.get(this.areaScanner.world.field_73011_w.field_76574_g).size() + ", caves: " + coordCaves.get(this.areaScanner.world.field_73011_w.field_76574_g).size());
    }

    public boolean triggerEvent(World world, ChunkCoordinates curseCoord, ArrayList<ChunkCoordinates> coordList) {
        int dim = world.field_73011_w.field_76574_g;
        ChunkCoordinates bestCave = null;
        float closest = 99999.0f;
        float minDist = 50.0f;
        Random rand = new Random(world.func_72820_D());
        int i = rand.nextInt(coordList.size());
        int tries = 0;
        while (closest > 160.0f && tries++ < 100) {
            float dist;
            i = rand.nextInt(coordList.size());
            if (!world.func_72863_F().func_73149_a(coordList.get((int)i).field_71574_a / 16, coordList.get((int)i).field_71573_c / 16) || !((dist = (float)Math.sqrt(coordList.get(i).func_71569_e(curseCoord.field_71574_a, curseCoord.field_71572_b, curseCoord.field_71573_c))) < closest) || !(dist > minDist)) continue;
            closest = dist;
            bestCave = coordList.get(i);
        }
        if (closest <= 160.0f && bestCave != null) {
            WorldDirector.dbg(world.field_73011_w.field_76574_g + ": Cave Spawn Event dist: " + Math.sqrt(curseCoord.func_82371_e(bestCave)) + " - " + bestCave.field_71574_a + ", " + bestCave.field_71572_b + ", " + bestCave.field_71573_c);
            return this.spawnGroup(world, curseCoord, bestCave, TropicraftConfig.eventMiniSpawnGroupCount);
        }
        WorldDirector.dbg("failed to find close cave, closest: " + closest);
        return false;
    }

    public boolean spawnGroup(World world, ChunkCoordinates attackCoord, ChunkCoordinates spawnCoord, int spawnCount) {
        int spawned = 0;
        int amountToSpawn = spawnCount;
        int tries = 0;
        String prefix = "tropicraftmod.";
        String mobToSpawnLeader = "TropiSkeleton";
        String mobToSpawn = "TropiSkeleton";
        Object leader = null;
        while (spawned < amountToSpawn && tries++ < 100) {
            Entity ent = EntityList.func_75620_a((String)(prefix + (spawned < 1 ? mobToSpawnLeader : mobToSpawn)), (World)world);
            int range = 16;
            if (ent instanceof EntityLiving) {
                EntityLiving ent2 = (EntityLiving)ent;
                double var5 = (double)spawnCoord.field_71574_a + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)range;
                double var7 = spawnCoord.field_71572_b + world.field_73012_v.nextInt(4) - 2;
                double var9 = (double)spawnCoord.field_71573_c + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)range;
                ent2.func_70012_b(var5, var7, var9, ent2.field_70170_p.field_73012_v.nextFloat() * 360.0f, 0.0f);
                if (!ent2.func_70601_bi()) continue;
                if (ent instanceof ICoroAI) {
                    ((ICoroAI)ent).getAIAgent().spawnedOrNBTReloadedInit();
                    ((ICoroAI)ent).getAIAgent().homeX = attackCoord.field_71574_a;
                    ((ICoroAI)ent).getAIAgent().homeY = attackCoord.field_71572_b;
                    ((ICoroAI)ent).getAIAgent().homeZ = attackCoord.field_71573_c;
                    ((ICoroAI)ent).getAIAgent().maxDistanceFromHome = 16.0;
                    ((ICoroAI)ent).getAIAgent().jobMan.getPrimaryJob().dontStrayFromHome = true;
                    ((EntityLiving)ent).field_70708_bq = -2000;
                }
                world.func_72838_d((Entity)ent2);
                ++spawned;
                tries = 0;
                continue;
            }
            WorldDirector.dbg("invalid entity, aborting");
            return false;
        }
        if (tries >= 100) {
            WorldDirector.dbg("hit max tries, aborted");
            if (spawned > 0) {
                WorldDirector.dbg("spawned " + spawned + " at least, returning true");
                return true;
            }
            return false;
        }
        WorldDirector.dbg("spawned: " + spawned);
        return true;
    }

    public void pfComplete(PFCallbackItem ci) {
        this.getQueue().add(ci);
    }

    public void manageCallbackQueue() {
        ArrayList<PFCallbackItem> list = this.getQueue();
        try {
            for (int i = 0; i < list.size(); ++i) {
                PFCallbackItem item = list.get(i);
                WorldDirector.dbg("processing queue");
                this.waitingOnPF = false;
                float dist = this.distanceTo(item.pe.func_75870_c().field_75839_a, item.pe.func_75870_c().field_75837_b, item.pe.func_75870_c().field_75838_c, item.pe.func_75877_a((int)0).field_75839_a, item.pe.func_75877_a((int)0).field_75837_b, item.pe.func_75877_a((int)0).field_75838_c);
                WorldDirector.dbg(Float.valueOf(dist));
                if (!(dist < 7.0f)) continue;
                WorldDirector.dbg("found a pathable spot!");
            }
        }
        catch (Exception ex) {
            WorldDirector.dbg("Crash in HW Callback PF manager");
            ex.printStackTrace();
        }
        list.clear();
    }

    public ArrayList<PFCallbackItem> getQueue() {
        return this.queue;
    }

    public static String getWorldFolderName() {
        WorldServer world = DimensionManager.getWorld((int)0);
        if (world != null) {
            lastWorldFolder = world.getChunkSaveLocation().getName();
            return lastWorldFolder + File.separator;
        }
        return lastWorldFolder + File.separator;
    }

    public static String getSaveFolderPath() {
        if (MinecraftServer.func_71276_C() == null || MinecraftServer.func_71276_C().func_71264_H()) {
            return WorldDirector.getClientSidePath() + File.separator;
        }
        return new File(".").getAbsolutePath() + File.separator;
    }

    public static String getWorldSaveFolderPath() {
        if (MinecraftServer.func_71276_C() == null || MinecraftServer.func_71276_C().func_71264_H()) {
            return WorldDirector.getClientSidePath() + File.separator + "saves" + File.separator;
        }
        return new File(".").getAbsolutePath() + File.separator;
    }

    @SideOnly(value=Side.CLIENT)
    public static String getClientSidePath() {
        return FMLClientHandler.instance().getClient().field_71412_D.getPath();
    }
}

