/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.IPlantable;
import tropicraft.blocks.BlockTropicraft;
import tropicraft.items.TropicraftItems;

public class BlockBambooChute
extends BlockTropicraft
implements IPlantable {
    private static final int NUM_TICKS_GROWTH = 6;
    private int plantHeight;

    public BlockBambooChute(int id, Material material) {
        super(id, material);
        float f = 0.375f;
        this.func_71905_a(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 1.0f, 0.5f + f);
        this.func_71907_b(true);
    }

    public void func_71847_b(World world, int x, int y, int z, Random random) {
        if (world.func_72799_c(x, y + 1, z)) {
            int plantHeight = 1;
            while (world.func_72798_a(x, y - plantHeight, z) == this.field_71990_ca) {
                ++plantHeight;
            }
            if (plantHeight < 12) {
                int meta = world.func_72805_g(x, y, z);
                if (meta == 8) {
                    world.func_94575_c(x, y + 1, z, this.field_71990_ca);
                    world.func_72921_c(x, y, z, 0, 3);
                } else {
                    world.func_72921_c(x, y, z, meta + 1, 3);
                }
            }
        }
    }

    public boolean func_71930_b(World world, int i, int j, int k) {
        int idBelow = world.func_72798_a(i, j - 1, k);
        int idAdjacentX1 = world.func_72798_a(i - 1, j - 1, k);
        int idAdjacentX2 = world.func_72798_a(i + 1, j - 1, k);
        int idAdjacentZ1 = world.func_72798_a(i, j - 1, k - 1);
        int idAdjacentZ2 = world.func_72798_a(i, j - 1, k + 1);
        if (idBelow == this.field_71990_ca) {
            return true;
        }
        if (idBelow != Block.field_71980_u.field_71990_ca && idBelow != Block.field_71979_v.field_71990_ca) {
            return false;
        }
        if (idAdjacentX1 == Block.field_71979_v.field_71990_ca || idAdjacentX1 == Block.field_71980_u.field_71990_ca) {
            return true;
        }
        if (idAdjacentX2 == Block.field_71979_v.field_71990_ca || idAdjacentX2 == Block.field_71980_u.field_71990_ca) {
            return true;
        }
        if (idAdjacentZ1 == Block.field_71979_v.field_71990_ca || idAdjacentZ1 == Block.field_71980_u.field_71990_ca) {
            return true;
        }
        return idAdjacentZ2 == Block.field_71980_u.field_71990_ca;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71922_a(World par1World, int par2, int par3, int par4) {
        return TropicraftItems.bambooChute.field_77779_bT;
    }

    public int func_71857_b() {
        return 1;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public int func_71885_a(int par1, Random par2Random, int par3) {
        return TropicraftItems.bambooChute.field_77779_bT;
    }

    public AxisAlignedBB func_71872_e(World par1World, int par2, int par3, int par4) {
        return null;
    }

    public boolean func_71854_d(World par1World, int par2, int par3, int par4) {
        return this.func_71930_b(par1World, par2, par3, par4);
    }

    public void func_71863_a(World world, int x, int y, int z, int neighborID) {
        this.checkBlockCoordValid(world, x, y, z);
    }

    protected final void checkBlockCoordValid(World world, int x, int y, int z) {
        if (!this.func_71854_d(world, x, y, z)) {
            this.func_71897_c(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_94571_i(x, y, z);
        }
    }

    public boolean canSustainPlant(World world, int x, int y, int z, ForgeDirection direction, IPlantable plant) {
        int plantID = plant.getPlantID(world, x, y + 1, z);
        EnumPlantType plantType = plant.getPlantType(world, x, y + 1, z);
        if (plantID == this.field_71990_ca) {
            return true;
        }
        switch (plantType) {
            case Desert: {
                return this.field_71990_ca == BlockBambooChute.field_71939_E.field_71990_ca;
            }
            case Nether: {
                return this.field_71990_ca == BlockBambooChute.field_72013_bc.field_71990_ca;
            }
            case Crop: {
                return this.field_71990_ca == BlockBambooChute.field_72050_aA.field_71990_ca;
            }
            case Cave: {
                return this.isBlockSolidOnSide(world, x, y, z, ForgeDirection.UP);
            }
            case Plains: {
                return this.field_71990_ca == BlockBambooChute.field_71980_u.field_71990_ca || this.field_71990_ca == BlockBambooChute.field_71979_v.field_71990_ca;
            }
            case Water: {
                return world.func_72803_f(x, y, z) == Material.field_76244_g && world.func_72805_g(x, y, z) == 0;
            }
            case Beach: {
                boolean isBeach = this.field_71990_ca == Block.field_71980_u.field_71990_ca || this.field_71990_ca == Block.field_71979_v.field_71990_ca || this.field_71990_ca == Block.field_71939_E.field_71990_ca;
                boolean hasWater = world.func_72803_f(x - 1, y, z) == Material.field_76244_g || world.func_72803_f(x + 1, y, z) == Material.field_76244_g || world.func_72803_f(x, y, z - 1) == Material.field_76244_g || world.func_72803_f(x, y, z + 1) == Material.field_76244_g;
                return isBeach && hasWater;
            }
        }
        return false;
    }

    @Override
    public String getImageName() {
        return "bambooChute";
    }

    public EnumPlantType getPlantType(World world, int x, int y, int z) {
        return EnumPlantType.Plains;
    }

    public int getPlantID(World world, int x, int y, int z) {
        return this.field_71990_ca;
    }

    public int getPlantMetadata(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }
}

