/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.drinks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import tropicraft.blocks.tileentities.TileEntityEIHMixer;
import tropicraft.drinks.Ingredient;
import tropicraft.drinks.MixerRecipe;
import tropicraft.items.ItemCocktail;
import tropicraft.items.TropicraftItems;

public class MixerRecipeRegistry {
    private static MixerRecipeRegistry instance = null;
    private List<MixerRecipe> recipes = new LinkedList<MixerRecipe>();

    private MixerRecipeRegistry() {
    }

    public static MixerRecipeRegistry getInstance() {
        if (instance == null) {
            instance = new MixerRecipeRegistry();
        }
        return instance;
    }

    public void registerRecipe(MixerRecipe recipe) {
        this.recipes.add(recipe);
    }

    public boolean isRegisteredIngredient(ItemStack item) {
        if (item.field_77993_c == TropicraftItems.cocktail.field_77779_bT) {
            return true;
        }
        for (MixerRecipe recipe : this.recipes) {
            for (Ingredient i : recipe.getIngredients()) {
                if (!ItemStack.func_77989_b((ItemStack)i.getIngredient(), (ItemStack)item)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRegisteredIngredient(int itemId) {
        return this.isRegisteredIngredient(new ItemStack(itemId, 1, 0));
    }

    public ItemStack getResult(ItemStack[] ingredients) {
        for (MixerRecipe recipe : this.recipes) {
            if (ItemStack.func_77989_b((ItemStack)recipe.getIngredients()[0].getIngredient(), (ItemStack)ingredients[0]) && ItemStack.func_77989_b((ItemStack)recipe.getIngredients()[1].getIngredient(), (ItemStack)ingredients[1])) {
                return ItemCocktail.makeCocktail(recipe);
            }
            if (!ItemStack.func_77989_b((ItemStack)recipe.getIngredients()[0].getIngredient(), (ItemStack)ingredients[1]) || !ItemStack.func_77989_b((ItemStack)recipe.getIngredients()[1].getIngredient(), (ItemStack)ingredients[0])) continue;
            return ItemCocktail.makeCocktail(recipe);
        }
        ArrayList<Ingredient> is = new ArrayList<Ingredient>();
        is.addAll(TileEntityEIHMixer.listIngredients(ingredients[0]));
        is.addAll(TileEntityEIHMixer.listIngredients(ingredients[1]));
        Collections.sort(is);
        return ItemCocktail.makeCocktail(is.toArray(new Ingredient[is.size()]));
    }

    public List<MixerRecipe> getRecipes() {
        return this.recipes;
    }
}

