/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.entities.ai.jobs.v3;

import CoroUtil.componentAI.ICoroAI;
import CoroUtil.componentAI.jobSystem.JobBase;
import CoroUtil.componentAI.jobSystem.JobManager;
import CoroUtil.entity.EnumActState;
import CoroUtil.entity.EnumJobState;
import CoroUtil.util.CoroUtilEntity;
import CoroUtil.util.CoroUtilInventory;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import tropicraft.entities.EntityTropicraftWaterMob;
import tropicraft.items.TropicraftItems;

public class JobFish
extends JobBase {
    public float maxCastStr = 1.0f;
    public int fishingTimeout;
    public int dryCastX;
    public int dryCastY;
    public int dryCastZ;
    public int pfRangeHome = 128;

    public JobFish(JobManager jm) {
        super(jm);
    }

    public boolean shouldExecute() {
        return this.ai.entityToAttack == null;
    }

    public boolean shouldContinue() {
        return this.state == EnumJobState.IDLE;
    }

    public void onIdleTick() {
        super.onIdleTick();
    }

    public void onLowHealth() {
        super.onLowHealth();
        if (this.hitAndRunDelay == 0 && this.ent.func_70032_d(this.ai.lastFleeEnt) > 3.0f) {
            this.hitAndRunDelay = this.entInt.getCooldownRanged() + 1;
            this.ai.entityToAttack = this.ai.lastFleeEnt;
            if (this.ai.entityToAttack != null) {
                this.ent.func_70625_a(this.ai.entityToAttack, 180.0f, 180.0f);
                if (this.ai.useInv) {
                    this.ai.entInv.attackRanged(this.ai.entityToAttack, this.ent.func_70032_d(this.ai.lastFleeEnt));
                } else {
                    this.entInt.attackRanged(this.ai.entityToAttack, this.ent.func_70032_d(this.ai.lastFleeEnt));
                }
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.ai.entInv.inventory == null) {
            return;
        }
        if (this.ai.entInv != null && this.ai.entInv.fishEntity != null && (this.state == EnumJobState.IDLE || this.ai.entInv.fishEntity.field_70128_L)) {
            this.ai.entInv.fishEntity.func_70106_y();
            this.ai.entInv.fishEntity.catchFish();
            this.ai.entInv.fishEntity = null;
        }
        Random rand = new Random();
        this.ai.maxDistanceFromHome = 16.0;
        if (this.state == EnumJobState.IDLE) {
            if (this.findWater()) {
                this.setJobState(EnumJobState.W1);
            } else if (rand.nextInt(150) == 0 && this.ent.func_70661_as().func_75500_f()) {
                this.ai.updateWanderPath();
            }
        } else if (this.state == EnumJobState.W1) {
            if (this.ai.targY < 0) {
                this.setJobState(EnumJobState.IDLE);
                return;
            }
            if (!this.ent.func_70090_H()) {
                if (this.walkingTimeout <= 0 || this.ent.func_70661_as().func_75500_f()) {
                    float tdist = (float)this.ent.func_70011_f((double)this.ai.targX, (double)this.ai.targY, (double)this.ai.targZ);
                    this.ai.walkTo((Entity)this.ent, this.ai.targX, this.ai.targY, this.ai.targZ, (float)this.pfRangeHome, 600);
                }
            } else if (this.findLandClose()) {
                this.setJobState(EnumJobState.W4);
            }
            double distStart = 0.5;
            double distEnd = 1.0;
            double distStep = 0.5;
            double lookStartStop = 0.0;
            double lookStep = 30.0;
            boolean test = this.isFacingWater(distStart, distEnd, distStep, lookStartStop, lookStep);
            if (this.ent.func_70011_f((double)this.ai.targX, (double)this.ai.targY, (double)this.ai.targZ) < 8.0 || this.ent.func_70090_H() || test) {
                if (CoroUtilEntity.canCoordBeSeenFromFeet((EntityLivingBase)this.ent, (int)this.ai.targX, (int)this.ai.targY, (int)this.ai.targZ) || test) {
                    this.ai.setState(EnumActState.IDLE);
                    this.setJobState(EnumJobState.W2);
                    this.ent.func_70661_as().func_75499_g();
                    this.castLine();
                } else {
                    this.setJobState(EnumJobState.IDLE);
                }
            }
        } else if (this.state == EnumJobState.W2) {
            if (!this.ent.func_70090_H()) {
                this.ent.func_70661_as().func_75499_g();
                this.ai.faceCoord(this.ai.targX, this.ai.targY, this.ai.targZ, 90.0f, 90.0f);
            } else if (this.findLandClose()) {
                if (this.ai.entInv.fishEntity != null) {
                    this.catchFish();
                }
                this.setJobState(EnumJobState.W4);
                return;
            }
            if (this.ai.entInv.fishEntity != null && this.ai.entInv.fishEntity.bobber instanceof EntityTropicraftWaterMob) {
                EntityTropicraftWaterMob fish = (EntityTropicraftWaterMob)this.ai.entInv.fishEntity.bobber;
                if (fish.outOfWaterTick > 10) {
                    this.ai.entInv.setCurrentSlot(this.ai.entInv.slot_Melee);
                    this.ai.entInv.leftClickItem((Entity)fish);
                    if (fish.func_110143_aJ() < 0.0f) {
                        this.catchFish();
                    }
                }
            }
            if (this.ai.entInv.fishEntity == null || this.fishingTimeout <= 0 || this.ai.entInv.fishEntity != null && (this.ai.entInv.fishEntity.inGround || this.ai.entInv.fishEntity.ticksCatchable > 0 && this.ai.entInv.fishEntity.ticksCatchable < 10)) {
                if (this.ai.entInv.fishEntity != null) {
                    this.catchFish();
                }
                if (this.getFishCount() > 4 || rand.nextInt(1) == 0 && this.getFishCount() >= 2) {
                    this.ai.walkTo((Entity)this.ent, this.ai.homeX, this.ai.homeY, this.ai.homeZ, (float)this.pfRangeHome, 600);
                    this.setJobState(EnumJobState.W3);
                } else if (rand.nextInt(2) == 0) {
                    this.setJobState(EnumJobState.IDLE);
                } else {
                    this.castLine();
                }
                this.ai.setState(EnumActState.IDLE);
            } else {
                --this.fishingTimeout;
            }
        } else if (this.state == EnumJobState.W3) {
            if (this.ai.entInv.fishEntity != null) {
                this.catchFish();
            }
            if (this.walkingTimeout <= 0 || this.ent.func_70661_as().func_75500_f() && this.ent.field_70170_p.func_72820_D() % 20L == 0L) {
                this.ai.walkTo((Entity)this.ent, this.ai.homeX, this.ai.homeY, this.ai.homeZ, (float)this.pfRangeHome, 600);
            }
            if (this.ent.func_70011_f((double)this.ai.homeX, (double)this.ai.homeY, (double)this.ai.homeZ) < 2.0) {
                this.ai.faceCoord((int)((float)this.ai.homeX - 0.5f), this.ai.homeY, (int)((float)this.ai.homeZ - 0.5f), 180.0f, 180.0f);
                this.transferJobItems(this.ai.homeX, this.ai.homeY, this.ai.homeZ);
                this.setJobState(EnumJobState.IDLE);
            }
        } else if (this.state == EnumJobState.W4) {
            if (this.ent.func_70011_f((double)this.dryCastX, this.ent.field_70163_u, (double)this.dryCastZ) < 5.0 || this.ent.field_70122_E) {
                this.dryCastX = (int)Math.floor(this.ent.field_70165_t + 0.5);
                this.dryCastY = (int)this.ent.field_70121_D.field_72338_b;
                this.dryCastZ = (int)Math.floor(this.ent.field_70161_v + 0.5);
                this.ai.setState(EnumActState.IDLE);
                this.ent.func_70661_as().func_75499_g();
                this.castLine();
                this.setJobState(EnumJobState.W2);
                return;
            }
            if (this.walkingTimeout <= 0 || this.ent.func_70661_as().func_75500_f() && this.ent.field_70170_p.func_72820_D() % 20L == 0L) {
                if (this.ent.func_70011_f((double)this.dryCastX, (double)this.dryCastY, (double)this.dryCastZ) < 64.0) {
                    this.ai.walkTo((Entity)this.ent, this.dryCastX, this.dryCastY, this.dryCastZ, (float)this.ai.maxPFRange, 600);
                } else {
                    this.ai.walkTo((Entity)this.ent, this.ai.targX, this.ai.targY, this.ai.targZ, (float)this.ai.maxPFRange, 600);
                }
            }
        }
    }

    public void catchFish() {
        if (this.ai.entInv.fishEntity == null) {
            return;
        }
        this.ai.entInv.fishEntity.func_70106_y();
        this.ai.entInv.fishEntity.catchFish();
        this.ai.entInv.fishEntity = null;
    }

    public boolean hookHit(DamageSource ds, int damage) {
        if (this.ai.entInv.fishEntity != null) {
            this.catchFish();
            this.ai.setState(EnumActState.IDLE);
        }
        return super.hookHit(ds, damage);
    }

    protected boolean findLandClose() {
        if (this.findLand()) {
            this.catchFish();
            this.dryCastX = this.ai.targX;
            this.dryCastY = this.ai.targY;
            this.dryCastZ = this.ai.targZ;
            return true;
        }
        return false;
    }

    protected void castLine() {
        if (!this.ent.func_70090_H()) {
            this.dryCastX = (int)Math.floor(this.ent.field_70165_t + 0.5);
            this.dryCastY = (int)this.ent.field_70121_D.field_72338_b;
            this.dryCastZ = (int)Math.floor(this.ent.field_70161_v + 0.5);
        }
        double dist = this.ent.func_70011_f((double)this.ai.targX, (double)this.ai.targY, (double)this.ai.targZ);
        this.ai.faceCoord(this.ai.targX, this.ai.targY, this.ai.targZ, 180.0f, 180.0f);
        this.ai.entInv.castingStrength = (float)dist / 17.0f;
        if ((double)this.ai.entInv.castingStrength < 0.25) {
            this.ai.entInv.castingStrength = 0.25f;
        }
        if (this.ai.entInv.castingStrength > this.maxCastStr) {
            this.ai.entInv.castingStrength = this.maxCastStr;
        }
        this.ent.field_70125_A -= 25.0f;
        this.ai.entInv.setCurrentSlot(this.ai.entInv.slot_Tool);
        this.fishingTimeout = 400;
        if (this.ai.entInv.fishEntity != null) {
            this.ai.entInv.fishEntity.catchFish();
        }
        if (this.ai.entInv.fishEntity != null) {
            this.ai.entInv.fishEntity.func_70106_y();
        }
        this.ai.entInv.fishEntity = null;
        this.ai.entInv.rightClickItem();
    }

    protected int getFishCount() {
        int count = 0;
        count += CoroUtilInventory.getItemCount((IInventory)this.ai.entInv.inventory, (int)Item.field_77754_aU.field_77779_bT);
        return count += CoroUtilInventory.getItemCount((IInventory)this.ai.entInv.inventory, (int)TropicraftItems.freshMarlin.field_77779_bT);
    }

    protected boolean isFish(int id) {
        return id == Item.field_77754_aU.field_77779_bT || id == TropicraftItems.freshMarlin.field_77779_bT;
    }

    protected void transferJobItems(int x, int y, int z) {
        if (CoroUtilInventory.isChest((int)this.ent.field_70170_p.func_72798_a(x, y - 1, z))) {
            --y;
        }
        boolean transferred = false;
        if (!CoroUtilInventory.chestTryTransfer((World)this.ent.field_70170_p, (ICoroAI)this.ai.entInt, (int)x, (int)y, (int)z)) {
            this.tossItems();
        }
    }

    public void tossItems() {
        for (int j = 0; j < this.ai.entInv.inventory.field_70462_a.length; ++j) {
            if (this.ai.entInv.inventory.field_70462_a[j] == null || !this.isFish(this.ai.entInv.inventory.field_70462_a[j].field_77993_c)) continue;
            this.ai.entInv.fakePlayer.func_71019_a(this.ai.entInv.inventory.func_70298_a(j, this.ai.entInv.inventory.field_70462_a[j].field_77994_a), false);
        }
    }
}

