/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.entities.hostile.land;

import CoroUtil.componentAI.AIAgent;
import CoroUtil.componentAI.ICoroAI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import tropicraft.blocks.TropicraftBlocks;
import tropicraft.entities.hostile.EntityLand;
import tropicraft.items.TropicraftItems;

public class Creeper
extends EntityLand
implements IMob {
    public AIAgent agent;
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int fuseTime = 30;
    private int explosionRadius = 3;

    public Creeper(World par1World) {
        super(par1World);
        this.field_70728_aV = 8;
        if (this.agent == null) {
            this.agent = new AIAgent((ICoroAI)this, false);
        }
        this.agent.moveLeadTicks = 0;
        this.agent.shouldAvoid = false;
    }

    @Override
    public boolean func_70601_bi() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        return this.field_70170_p.func_72798_a(i, (j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b)) - 1, k = MathHelper.func_76128_c((double)this.field_70161_v)) != 0 && this.field_70170_p.func_72883_k(i, j, k) > 8 && super.func_70601_bi();
    }

    @Override
    public void attackMelee(Entity ent, float dist) {
        this.setCreeperState(1);
    }

    @Override
    public boolean func_70650_aV() {
        return true;
    }

    public int func_82143_as() {
        return this.func_70638_az() == null ? 3 : 3 + ((int)this.func_110143_aJ() - 1);
    }

    protected void func_70069_a(float par1) {
        super.func_70069_a(par1);
        this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + par1 * 1.5f);
        if (this.timeSinceIgnited > this.fuseTime - 5) {
            this.timeSinceIgnited = this.fuseTime - 5;
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        if (this.field_70180_af.func_75683_a(17) == 1) {
            par1NBTTagCompound.func_74757_a("powered", true);
        }
        par1NBTTagCompound.func_74777_a("Fuse", (short)this.fuseTime);
        par1NBTTagCompound.func_74774_a("ExplosionRadius", (byte)this.explosionRadius);
    }

    @Override
    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.field_70180_af.func_75692_b(17, (Object)((byte)(par1NBTTagCompound.func_74767_n("powered") ? 1 : 0)));
        if (par1NBTTagCompound.func_74764_b("Fuse")) {
            this.fuseTime = par1NBTTagCompound.func_74765_d("Fuse");
        }
        if (par1NBTTagCompound.func_74764_b("ExplosionRadius")) {
            this.explosionRadius = par1NBTTagCompound.func_74771_c("ExplosionRadius");
        }
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            this.lastActiveTime = this.timeSinceIgnited;
            int i = this.getCreeperState();
            if (i > 0 && this.timeSinceIgnited == 0) {
                this.func_85030_a("random.fuse", 1.0f, 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                if (!this.field_70170_p.field_72995_K) {
                    boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
                    this.onDeathBySelf();
                    this.func_70106_y();
                }
            }
        }
        super.func_70071_h_();
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        super.func_70645_a(par1DamageSource);
        if (par1DamageSource.func_76346_g() instanceof EntitySkeleton) {
            this.func_70025_b(TropicraftItems.recordEasternIsles.field_77779_bT - this.field_70146_Z.nextInt(1), 1);
        } else if (par1DamageSource.func_76346_g() instanceof EntityPlayer) {
            this.func_70025_b(TropicraftItems.coconutBomb.field_77779_bT, this.field_70146_Z.nextInt(3) + 1);
            int y = this.field_70170_p.func_72976_f((int)this.field_70165_t, (int)this.field_70161_v);
            int xo = this.field_70146_Z.nextInt(3) + 4;
            int zo = xo + this.field_70146_Z.nextInt(3) - new Random().nextInt(3);
            for (int x = (int)this.field_70165_t - xo; x < (int)this.field_70165_t + xo; ++x) {
                for (int z = (int)this.field_70161_v - zo; z < (int)this.field_70161_v + zo; ++z) {
                    y = this.field_70170_p.func_72976_f(x, z);
                    if (this.field_70170_p.func_72803_f(x, y - 1, z) == Material.field_76244_g || this.field_70170_p.func_72798_a(x, y - 1, z) == 0) continue;
                    this.field_70170_p.func_72832_d(x, y, z, TropicraftBlocks.tropicsFlowers.field_71990_ca, this.field_70146_Z.nextInt(7), 3);
                }
            }
        }
    }

    public void onDeathBySelf() {
        this.func_70025_b(TropicraftItems.coconutBomb.field_77779_bT, this.field_70146_Z.nextInt(3) + 1);
        int y = (int)this.field_70163_u + 3;
        int xo = this.field_70146_Z.nextInt(3) + 2;
        int zo = this.field_70146_Z.nextInt(3) + 2;
        for (int x = (int)this.field_70165_t - xo; x < (int)this.field_70165_t + xo; ++x) {
            for (int z = (int)this.field_70161_v - zo; z < (int)this.field_70161_v + zo; ++z) {
                if (this.field_70146_Z.nextInt(3) == 0) continue;
                for (y = (int)this.field_70163_u + 3; !(y <= (int)this.field_70163_u - 3 || this.field_70170_p.func_72799_c(x, y, z) && this.field_70170_p.func_72804_r(x, y - 1, z)); --y) {
                }
                if (y == (int)this.field_70163_u - 3) continue;
                if (this.field_70146_Z.nextInt(10) < 6 && this.field_70170_p.func_72798_a(x, y, z) != TropicraftBlocks.bambooBundle.field_71990_ca && this.field_70170_p.func_72798_a(x, y, z) != TropicraftBlocks.coconut.field_71990_ca) {
                    int flowerType = this.field_70146_Z.nextInt(7);
                    if (TropicraftBlocks.tropicsFlowers.func_71930_b(this.field_70170_p, x, y, z)) {
                        this.field_70170_p.func_72832_d(x, y, z, TropicraftBlocks.tropicsFlowers.field_71990_ca, flowerType, 3);
                        continue;
                    }
                    this.func_70099_a(new ItemStack(TropicraftBlocks.tropicsFlowers.field_71990_ca, 1, flowerType), 0.5f);
                    continue;
                }
                if (this.field_70146_Z.nextInt(10) < 7 && this.field_70170_p.func_72798_a(x, y, z) != TropicraftBlocks.bambooBundle.field_71990_ca && this.field_70170_p.func_72798_a(x, y, z) != TropicraftBlocks.coconut.field_71990_ca && this.field_70170_p.func_72798_a(x, y - 1, z) == Block.field_71980_u.field_71990_ca) {
                    this.field_70170_p.func_72832_d(x, y, z, Block.field_71962_X.field_71990_ca, 1, 3);
                    continue;
                }
                if (this.field_70146_Z.nextInt(10) >= 8 || this.field_70170_p.func_72798_a(x, y - 1, z) == TropicraftBlocks.bambooBundle.field_71990_ca || this.field_70170_p.func_72798_a(x, y - 1, z) == 0) continue;
                int palmTreeType = this.field_70146_Z.nextInt(3);
                Object gen = null;
            }
        }
    }

    protected String func_70621_aR() {
        return "mob.creeper.say";
    }

    protected String func_70673_aS() {
        return "mob.creeper.death";
    }

    public boolean func_70652_k(Entity par1Entity) {
        return true;
    }

    public boolean getPowered() {
        return this.field_70180_af.func_75683_a(17) == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public float getCreeperFlashIntensity(float par1) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * par1) / (float)(this.fuseTime - 2);
    }

    protected int func_70633_aT() {
        return Item.field_77677_M.field_77779_bT;
    }

    public int getCreeperState() {
        return this.field_70180_af.func_75683_a(16);
    }

    public void setCreeperState(int par1) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)par1));
    }

    public void func_70077_a(EntityLightningBolt par1EntityLightningBolt) {
        super.func_70077_a(par1EntityLightningBolt);
        this.field_70180_af.func_75692_b(17, (Object)1);
    }

    @Override
    public void func_70619_bc() {
        super.func_70619_bc();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)-1);
        this.field_70180_af.func_75682_a(17, (Object)0);
    }
}

