/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.entities.placeable;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import tropicraft.config.TropicraftConfig;
import tropicraft.items.TropicraftItems;
import weather.system.wind.WindHandler;

public class EntityChair
extends Entity
implements WindHandler {
    private boolean field_70279_a = true;
    private double speedMultiplier = 0.07;
    private int chairPosRotationIncrements;
    private double chairX;
    private double chairY;
    private double chairZ;
    private double chairYaw;
    private double chairPitch;
    @SideOnly(value=Side.CLIENT)
    private double velocityX;
    @SideOnly(value=Side.CLIENT)
    private double velocityY;
    @SideOnly(value=Side.CLIENT)
    private double velocityZ;
    private final int COLOR = 16;

    public EntityChair(World world) {
        super(world);
        this.field_70156_m = true;
        this.func_70105_a(1.0f, 1.0f);
        this.field_70144_Y = 0.95f;
    }

    public EntityChair(World world, double d, double d1, double d2, float f1, int damagedColor, EntityPlayer player) {
        this(world);
        this.func_70107_b(d, d1, d2);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = d;
        this.field_70167_r = d1;
        this.field_70166_s = d2;
        this.field_70177_z = this.getAngleToPlayer(player);
        this.setColor(damagedColor);
    }

    public EntityChair(World par1World, double par2, double par4, double par6) {
        this(par1World);
        this.func_70107_b(par2, par4 + (double)this.field_70129_M, par6);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = par2;
        this.field_70167_r = par4;
        this.field_70166_s = par6;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(17, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(18, (Object)new Integer(1));
        this.field_70180_af.func_75682_a(19, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(16, (Object)new Integer(0));
    }

    public void setColor(int col) {
        this.field_70180_af.func_75692_b(16, (Object)col);
    }

    public int getColor() {
        return this.field_70180_af.func_75679_c(16);
    }

    public void setCurrentDamage(int dam) {
        this.field_70180_af.func_75692_b(17, (Object)dam);
    }

    public int getCurrentDamage() {
        return this.field_70180_af.func_75679_c(17);
    }

    public AxisAlignedBB func_70114_g(Entity par1Entity) {
        return par1Entity.field_70121_D;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public boolean func_70104_M() {
        return true;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O - 0.65;
    }

    private float getAngleToPlayer(EntityPlayer player) {
        double subAngle = MathHelper.func_76138_g((double)player.field_70177_z);
        double angle = subAngle + (180.0 - subAngle) * 2.0;
        return (float)subAngle;
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + (int)par2 * 10);
            this.func_70018_K();
            if (par1DamageSource.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)par1DamageSource.func_76346_g()).field_71075_bZ.field_75098_d) {
                this.setDamageTaken(100);
            }
            if (this.getDamageTaken() > 40) {
                if (this.field_70153_n != null) {
                    this.field_70153_n.func_70078_a((Entity)this);
                }
                this.func_70099_a(new ItemStack(TropicraftItems.chair, 1, this.getColor()), 0.0f);
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70057_ab() {
        this.setForwardDirection(-this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() * 11);
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double par1, double par3, double par5, float par7, float par8, int par9) {
        if (this.field_70279_a) {
            this.chairPosRotationIncrements = par9 + 5;
        } else {
            double var10 = par1 - this.field_70165_t;
            double var12 = par3 - this.field_70163_u;
            double var14 = par5 - this.field_70161_v;
            double var16 = var10 * var10 + var12 * var12 + var14 * var14;
            if (var16 <= 1.0) {
                return;
            }
            this.chairPosRotationIncrements = 3;
        }
        this.chairX = par1;
        this.chairY = par3;
        this.chairZ = par5;
        this.chairYaw = par7;
        this.chairPitch = par8;
        this.field_70159_w = this.velocityX;
        this.field_70181_x = this.velocityY;
        this.field_70179_y = this.velocityZ;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double par1, double par3, double par5) {
        this.velocityX = this.field_70159_w = par1;
        this.velocityY = this.field_70181_x = par3;
        this.velocityZ = this.field_70179_y = par5;
    }

    public void func_70071_h_() {
        double var8;
        double var6;
        super.func_70071_h_();
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0) {
            this.setDamageTaken(this.getDamageTaken() - 1);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        int var1 = 5;
        double var2 = 0.0;
        for (int var4 = 0; var4 < var1; ++var4) {
            double var5 = this.field_70121_D.field_72338_b + (this.field_70121_D.field_72337_e - this.field_70121_D.field_72338_b) * (double)(var4 + 0) / (double)var1 - 0.125;
            double var7 = this.field_70121_D.field_72338_b + (this.field_70121_D.field_72337_e - this.field_70121_D.field_72338_b) * (double)(var4 + 1) / (double)var1 - 0.125;
            AxisAlignedBB var9 = AxisAlignedBB.func_72332_a().func_72299_a(this.field_70121_D.field_72340_a, var5, this.field_70121_D.field_72339_c, this.field_70121_D.field_72336_d, var7, this.field_70121_D.field_72334_f);
            if (!this.field_70170_p.func_72830_b(var9, Material.field_76244_g)) continue;
            var2 += 1.0 / (double)var1;
        }
        double var24 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        if (var24 > 0.26249999999999996 && TropicraftConfig.comeSailAway) {
            var6 = Math.cos((double)this.field_70177_z * Math.PI / 180.0);
            var8 = Math.sin((double)this.field_70177_z * Math.PI / 180.0);
            int var10 = 0;
            while ((double)var10 < 1.0 + var24 * 60.0) {
                double var17;
                double var15;
                double var11 = this.field_70146_Z.nextFloat() * 2.0f - 1.0f;
                double var13 = (double)(this.field_70146_Z.nextInt(2) * 2 - 1) * 0.7;
                if (this.field_70146_Z.nextBoolean()) {
                    var15 = this.field_70165_t - var6 * var11 * 0.8 + var8 * var13;
                    var17 = this.field_70161_v - var8 * var11 * 0.8 - var6 * var13;
                    this.field_70170_p.func_72869_a("splash", var15, this.field_70163_u - 0.125, var17, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                } else {
                    var15 = this.field_70165_t + var6 + var8 * var11 * 0.7;
                    var17 = this.field_70161_v + var8 - var6 * var11 * 0.7;
                    this.field_70170_p.func_72869_a("splash", var15, this.field_70163_u - 0.125, var17, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
                ++var10;
            }
        }
        if (this.field_70170_p.field_72995_K && this.field_70279_a) {
            if (this.chairPosRotationIncrements > 0) {
                var6 = this.field_70165_t + (this.chairX - this.field_70165_t) / (double)this.chairPosRotationIncrements;
                var8 = this.field_70163_u + (this.chairY - this.field_70163_u) / (double)this.chairPosRotationIncrements;
                double var26 = this.field_70161_v + (this.chairZ - this.field_70161_v) / (double)this.chairPosRotationIncrements;
                double var12 = MathHelper.func_76138_g((double)(this.chairYaw - (double)this.field_70177_z));
                this.field_70177_z = (float)((double)this.field_70177_z + var12 / (double)this.chairPosRotationIncrements);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.chairPitch - (double)this.field_70125_A) / (double)this.chairPosRotationIncrements);
                --this.chairPosRotationIncrements;
                this.func_70107_b(var6, var8, var26);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            } else {
                var6 = this.field_70165_t + this.field_70159_w;
                var8 = this.field_70163_u + this.field_70181_x;
                double var26 = this.field_70161_v + this.field_70179_y;
                this.func_70107_b(var6, var8, var26);
                if (this.field_70122_E) {
                    this.field_70159_w *= 0.5;
                    this.field_70181_x *= 0.5;
                    this.field_70179_y *= 0.5;
                }
                this.field_70159_w *= (double)0.99f;
                this.field_70181_x *= (double)0.95f;
                this.field_70179_y *= (double)0.99f;
            }
        } else {
            double var14;
            if (var2 < 1.0) {
                var6 = var2 * 2.0 - 1.0;
                this.field_70181_x += (double)0.04f * var6;
            } else {
                if (this.field_70181_x < 0.0) {
                    this.field_70181_x /= 2.0;
                }
                this.field_70181_x += (double)0.007f;
            }
            if (this.field_70153_n != null && TropicraftConfig.comeSailAway) {
                this.field_70159_w += this.field_70153_n.field_70159_w * this.speedMultiplier;
                this.field_70179_y += this.field_70153_n.field_70179_y * this.speedMultiplier;
            }
            if ((var6 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) > 0.35) {
                var8 = 0.35 / var6;
                this.field_70159_w *= var8;
                this.field_70179_y *= var8;
                var6 = 0.35;
            }
            if (var6 > var24 && this.speedMultiplier < 0.35) {
                this.speedMultiplier += (0.35 - this.speedMultiplier) / 35.0;
                if (this.speedMultiplier > 0.35) {
                    this.speedMultiplier = 0.35;
                }
            } else {
                this.speedMultiplier -= (this.speedMultiplier - 0.07) / 35.0;
                if (this.speedMultiplier < 0.07) {
                    this.speedMultiplier = 0.07;
                }
            }
            if (this.field_70122_E) {
                this.field_70159_w *= 0.5;
                this.field_70181_x *= 0.5;
                this.field_70179_y *= 0.5;
            }
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            if (this.field_70123_F && var24 > 0.2) {
                if (!this.field_70170_p.field_72995_K) {
                    // empty if block
                }
            } else {
                this.field_70159_w *= (double)0.99f;
                this.field_70181_x *= (double)0.95f;
                this.field_70179_y *= (double)0.99f;
            }
            this.field_70125_A = 0.0f;
            var8 = this.field_70177_z;
            double var26 = this.field_70169_q - this.field_70165_t;
            double var12 = this.field_70166_s - this.field_70161_v;
            if (var26 * var26 + var12 * var12 > 0.001) {
                var8 = (float)(Math.atan2(var12, var26) * 180.0 / Math.PI);
            }
            if ((var14 = MathHelper.func_76138_g((double)(var8 - (double)this.field_70177_z))) > 20.0) {
                var14 = 20.0;
            }
            if (var14 < -20.0) {
                var14 = -20.0;
            }
            this.field_70177_z = (float)((double)this.field_70177_z + var14);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            if (!this.field_70170_p.field_72995_K) {
                List var16 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b((double)0.2f, 0.0, (double)0.2f));
                if (var16 != null && !var16.isEmpty()) {
                    for (int var27 = 0; var27 < var16.size(); ++var27) {
                        Entity var18 = (Entity)var16.get(var27);
                        if (var18 == this.field_70153_n || !var18.func_70104_M() || !(var18 instanceof EntityChair)) continue;
                        var18.func_70108_f((Entity)this);
                    }
                }
                for (int var27 = 0; var27 < 4; ++var27) {
                    int var28 = MathHelper.func_76128_c((double)(this.field_70165_t + ((double)(var27 % 2) - 0.5) * 0.8));
                    int var19 = MathHelper.func_76128_c((double)(this.field_70161_v + ((double)(var27 / 2) - 0.5) * 0.8));
                    for (int var20 = 0; var20 < 2; ++var20) {
                        int var21 = MathHelper.func_76128_c((double)this.field_70163_u) + var20;
                        int var22 = this.field_70170_p.func_72798_a(var28, var21, var19);
                        int var23 = this.field_70170_p.func_72805_g(var28, var21, var19);
                        if (var22 == Block.field_72037_aS.field_71990_ca) {
                            this.field_70170_p.func_94571_i(var28, var21, var19);
                            continue;
                        }
                        if (var22 != Block.field_71991_bz.field_71990_ca) continue;
                        Block.field_71991_bz.func_71914_a(this.field_70170_p, var28, var21, var19, var23, 0.3f, 0);
                        this.field_70170_p.func_94571_i(var28, var21, var19);
                    }
                }
                if (this.field_70153_n != null && this.field_70153_n.field_70128_L) {
                    this.field_70153_n = null;
                }
            }
        }
    }

    public void func_70043_V() {
        if (this.field_70153_n != null) {
            this.field_70153_n.func_70107_b(this.field_70165_t, this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W(), this.field_70161_v);
        }
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("Color", Integer.valueOf(this.getColor()).intValue());
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        this.setColor(nbttagcompound.func_74762_e("Color"));
    }

    public boolean func_130002_c(EntityPlayer par1EntityPlayer) {
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer && this.field_70153_n != par1EntityPlayer) {
            return true;
        }
        if (!this.field_70170_p.field_72995_K) {
            par1EntityPlayer.func_70078_a((Entity)this);
        }
        return true;
    }

    public void setDamageTaken(int par1) {
        this.field_70180_af.func_75692_b(19, (Object)par1);
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public int getDamageTaken() {
        return this.field_70180_af.func_75679_c(19);
    }

    public void setTimeSinceHit(int par1) {
        this.field_70180_af.func_75692_b(17, (Object)par1);
    }

    public int getTimeSinceHit() {
        return this.field_70180_af.func_75679_c(17);
    }

    public void setForwardDirection(int par1) {
        this.field_70180_af.func_75692_b(18, (Object)par1);
    }

    public int getForwardDirection() {
        return this.field_70180_af.func_75679_c(18);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70270_d(boolean par1) {
        this.field_70279_a = par1;
    }

    public float getWindWeight() {
        return 9999999.0f;
    }

    public int getParticleDecayExtra() {
        return 0;
    }
}

