/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.fishing;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import tropicraft.creative.TropiCreativeTabs;
import tropicraft.fishing.EntityHook;
import tropicraft.fishing.FishingEvent;
import tropicraft.fishing.FishingEventReelComplete;
import tropicraft.fishing.FishingManager;
import tropicraft.fishing.LinkedRods;

public class ItemRod
extends Item {
    @SideOnly(value=Side.CLIENT)
    private Icon theIcon;
    public static int TYPE_OLD = 0;
    public static int TYPE_GOOD = 1;
    public static int TYPE_SUPER = 2;
    public int rodType;
    public LinkedRods rodLink;
    public Icon oldIcon;
    public Icon goodIcon;
    public Icon superIcon;

    public ItemRod(int par1) {
        super(par1);
        this.func_77656_e(64);
        this.func_77625_d(1);
        this.func_77637_a(TropiCreativeTabs.tabTools);
    }

    public ItemRod setType(int i) {
        this.rodType = i;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77629_n_() {
        return true;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (this.rodLink == null && !par2World.field_72995_K) {
            this.rodLink = new LinkedRods();
        }
        if (!par2World.field_72995_K) {
            if (!this.rodLink.playerHasFloat(par3EntityPlayer)) {
                ArrayList<FishingEvent> evts = FishingManager.getEventsForPlayer(par3EntityPlayer);
                if (!evts.isEmpty()) {
                    for (FishingEvent evt : evts) {
                        if (!(evt instanceof FishingEventReelComplete) || evt.currentTick >= 20) continue;
                        return par1ItemStack;
                    }
                }
                par2World.func_72956_a((Entity)par3EntityPlayer, "random.bow", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                EntityHook hook = new EntityHook(par2World, par3EntityPlayer).setRodType(this.rodType);
                this.rodLink.createLink(hook, par3EntityPlayer);
                par2World.func_72838_d((Entity)hook);
            } else {
                EntityHook hook = this.rodLink.getLinkedHook(par3EntityPlayer);
                if (hook != null) {
                    if (hook.field_70128_L) {
                        this.rodLink.destroyLink(this.rodLink.getLinkedHook(par3EntityPlayer), par3EntityPlayer);
                    }
                    if (!hook.hasLanded) {
                        hook.hasLanded = true;
                        return par1ItemStack;
                    }
                    if ((double)hook.func_70032_d((Entity)par3EntityPlayer) > 3.0) {
                        float len = 0.0f;
                        if (this.rodType == TYPE_OLD) {
                            len = 0.5f;
                        }
                        if (this.rodType == TYPE_GOOD) {
                            len = 2.0f;
                        }
                        if (this.rodType == TYPE_SUPER) {
                            len = 5.0f;
                        }
                        if (par3EntityPlayer.func_70093_af()) {
                            len /= 4.0f;
                        }
                        if (hook.getWireLength() - len >= 0.0f) {
                            hook.setWireLength(hook.getWireLength() - len);
                        }
                    } else {
                        if (hook.field_70205_c != null) {
                            hook.field_70205_c.func_70107_b(hook.field_70165_t, hook.field_70163_u, hook.field_70161_v);
                        }
                        FishingManager.initEvent(new FishingEventReelComplete(hook, par3EntityPlayer));
                        hook.func_70106_y();
                        return par1ItemStack;
                    }
                }
            }
        }
        return par1ItemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister par1IconRegister) {
        this.theIcon = par1IconRegister.func_94245_a("tropicraftmod:fishingRod");
        this.oldIcon = par1IconRegister.func_94245_a("tropicraftmod:fishingRodOld");
        this.superIcon = par1IconRegister.func_94245_a("tropicraftmod:fishingRodSuper");
        this.goodIcon = par1IconRegister.func_94245_a("tropicraftmod:fishingRodGood");
    }

    public Icon getType(int i) {
        switch (i) {
            case 0: {
                return this.oldIcon;
            }
            case 1: {
                return this.goodIcon;
            }
            case 2: {
                return this.superIcon;
            }
        }
        return this.theIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_77617_a(int par1) {
        return this.getType(this.rodType);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_77618_c(int par1, int par2) {
        return this.theIcon;
    }

    public boolean playerHasLureOutHybrid(EntityPlayer p) {
        World w = p.field_70170_p;
        List ents = w.field_72996_f;
        for (Entity e : ents) {
            if (!(e instanceof EntityHook)) continue;
            EntityHook hook = (EntityHook)e;
            if (hook.field_70204_b == null || hook.field_70204_b.field_70157_k != p.field_70157_k) continue;
            return true;
        }
        return false;
    }

    public Icon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (this.playerHasLureOutHybrid(player)) {
            return this.theIcon;
        }
        return this.getType(this.rodType);
    }

    public Icon getIcon(ItemStack stack, int pass) {
        return this.theIcon;
    }
}

