/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.items;

import cpw.mods.fml.common.FMLCommonHandler;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import tropicraft.blocks.TropicraftBlocks;
import tropicraft.creative.TropiCreativeTabs;
import tropicraft.items.ItemTropicraft;
import tropicraft.world.TropicraftWorldUtils;
import tropicraft.world.teleporter.TeleporterTropics;

public class ItemPortalEnchanter
extends ItemTropicraft {
    private boolean isTestItem;

    public ItemPortalEnchanter(int id, boolean isTestItem) {
        super(id);
        this.isTestItem = isTestItem;
        this.field_77777_bU = 1;
        if (!isTestItem) {
            this.func_77656_e(3);
        }
        this.func_77637_a(TropiCreativeTabs.tabMisc);
    }

    @Override
    public String getImageName() {
        return "portalenchanter";
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (this.isTestItem) {
            int destination = entityplayer.field_71093_bK == 0 ? -127 : 0;
            TropicraftWorldUtils.teleportPlayer((EntityPlayerMP)entityplayer);
            return itemstack;
        }
        double playerX = entityplayer.field_70169_q + (entityplayer.field_70165_t - entityplayer.field_70169_q);
        double playerY = entityplayer.field_70167_r + (entityplayer.field_70163_u - entityplayer.field_70167_r) + 1.62 - (double)entityplayer.field_70129_M;
        double playerZ = entityplayer.field_70166_s + (entityplayer.field_70161_v - entityplayer.field_70166_s);
        MovingObjectPosition target = this.func_77621_a(world, entityplayer, true);
        if (target == null || world.field_72995_K) {
            return itemstack;
        }
        if (target.field_72313_a == EnumMovingObjectType.TILE) {
            int x = target.field_72311_b;
            int y = target.field_72312_c;
            int z = target.field_72309_d;
            int l = world.func_72805_g(x, y, z);
            if (!world.func_72962_a(entityplayer, x, y, z)) {
                return itemstack;
            }
            if (!entityplayer.func_82247_a(x, y, z, l, itemstack)) {
                return itemstack;
            }
            boolean found = false;
            for (int searchZ = -4; searchZ <= 4 && !found; ++searchZ) {
                for (int searchX = -4; searchX <= 4 && !found; ++searchX) {
                    if (!this.canGen(world, x + searchX, y, z + searchZ)) continue;
                    found = true;
                    entityplayer.func_71038_i();
                    new TeleporterTropics(FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(entityplayer.field_71093_bK)).buildTeleporterAt(x + searchX, y, z + searchZ, (Entity)entityplayer);
                    itemstack.func_77972_a(1, (EntityLivingBase)entityplayer);
                }
            }
        }
        return itemstack;
    }

    public boolean canGen(World world, int x, int y, int z) {
        if (y < 9) {
            return false;
        }
        for (int offsetZ = -2; offsetZ < 3; ++offsetZ) {
            for (int offsetX = -2; offsetX < 3; ++offsetX) {
                if (offsetX == -2 || offsetX == 2 || offsetZ == -2 || offsetZ == 2) {
                    int bID = world.func_72798_a(x + offsetX, y, z + offsetZ);
                    if (bID == Block.field_71957_Q.field_71990_ca || bID == TropicraftBlocks.portalWall.field_71990_ca) continue;
                    return false;
                }
                if (world.func_72803_f(x + offsetX, y, z + offsetZ) != Material.field_76244_g) {
                    return false;
                }
                if (world.func_72799_c(x + offsetX, y + 1, z + offsetZ)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean func_77662_d() {
        return true;
    }
}

