/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.questsystem;

import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.event.Event;
import tropicraft.questsystem.PlayerQuests;
import tropicraft.questsystem.quests.ActiveQuest;

public class PlayerQuestManager {
    public static PlayerQuestManager i;
    public HashMap<String, PlayerQuests> playerQuests;
    public World worldRef;

    public PlayerQuestManager(World world) {
        this.worldRef = world;
        this.playerQuests = new HashMap();
        i = this;
    }

    public void check(EntityPlayer entP) {
        if (!this.playerQuests.containsKey(entP.field_71092_bJ)) {
            this.playerQuests.put(entP.field_71092_bJ, new PlayerQuests(this, entP));
        }
    }

    public PlayerQuests getPlayerQuests(EntityPlayer entP) {
        this.check(entP);
        return this.playerQuests.get(entP.field_71092_bJ);
    }

    public void tick() {
        for (int i = 0; i < this.worldRef.field_73010_i.size(); ++i) {
            EntityPlayer entP = (EntityPlayer)this.worldRef.field_73010_i.get(i);
            this.check(entP);
            this.playerQuests.get(entP.field_71092_bJ).tick();
        }
    }

    public void giveQuest(int questID, String username, boolean giveToAllPlayers) {
        if (giveToAllPlayers) {
            for (int i = 0; i < this.worldRef.field_73010_i.size(); ++i) {
                EntityPlayer entP = (EntityPlayer)this.worldRef.field_73010_i.get(i);
                this.check(entP);
                this.playerQuests.get(entP.field_71092_bJ).giveQuest(questID);
            }
        } else {
            EntityPlayer entP = this.worldRef.func_72924_a(username);
            if (entP != null) {
                this.check(entP);
                this.playerQuests.get(entP.field_71092_bJ).giveQuest(questID);
            }
        }
        this.saveAndSync();
    }

    public void clearQuests(String username, boolean allPlayers, boolean save) {
        if (allPlayers) {
            for (int i = 0; i < this.worldRef.field_73010_i.size(); ++i) {
                EntityPlayer entP = (EntityPlayer)this.worldRef.field_73010_i.get(i);
                this.check(entP);
                this.playerQuests.get(entP.field_71092_bJ).clearQuests();
            }
        } else {
            EntityPlayer entP = this.worldRef.func_72924_a(username);
            if (entP != null) {
                this.check(entP);
                this.playerQuests.get(entP.field_71092_bJ).clearQuests();
            }
        }
        if (save) {
            this.saveAndSync();
        }
    }

    public void markQuestCompleteForAll(ActiveQuest quest) {
        for (int i = 0; i < this.worldRef.field_73010_i.size(); ++i) {
            EntityPlayer entP = (EntityPlayer)this.worldRef.field_73010_i.get(i);
            this.check(entP);
            this.playerQuests.get(entP.field_71092_bJ).removeQuest(quest);
        }
    }

    public void onEvent(Event event) {
        for (int i = 0; i < this.worldRef.field_73010_i.size(); ++i) {
            EntityPlayer entP = (EntityPlayer)this.worldRef.field_73010_i.get(i);
            this.check(entP);
            this.playerQuests.get(entP.field_71092_bJ).onEvent(event);
        }
    }

    public void saveAndSync() {
        for (int i = 0; i < this.worldRef.field_73010_i.size(); ++i) {
            EntityPlayer entP = (EntityPlayer)this.worldRef.field_73010_i.get(i);
            this.check(entP);
            this.playerQuests.get(entP.field_71092_bJ).saveAndSyncImpl();
        }
    }

    public void saveAndUnload() {
        this.saveAndSync();
        this.clearQuests("", true, false);
    }
}

