/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.questsystem;

import CoroUtil.util.CoroUtilFile;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import tropicraft.questsystem.EnumQuestState;
import tropicraft.questsystem.PlayerQuestManager;
import tropicraft.questsystem.QuestCreator;
import tropicraft.questsystem.quests.ActiveQuest;
import tropicraft.questsystem.quests.ItemQuest;
import tropicraft.questsystem.quests.KillEntityQuest;

public class PlayerQuests {
    public PlayerQuestManager playerQuestMan;
    public String playerName = "Player";
    public EntityPlayer playerInstance;
    public ArrayList<ActiveQuest> activeQuests;

    public PlayerQuests(PlayerQuestManager parMan, EntityPlayer player) {
        this.playerQuestMan = parMan;
        this.playerInstance = player;
        this.playerName = player.field_71092_bJ;
        this.activeQuests = new ArrayList();
        this.readQuestsFile();
    }

    public void tick() {
        for (int i = 0; i < this.activeQuests.size(); ++i) {
            this.activeQuests.get(i).tick();
            if (!this.activeQuests.get(i).isComplete()) continue;
            this.onComplete(i, true);
        }
    }

    public void saveAndSync() {
        boolean syncAllPlayers = true;
        if (syncAllPlayers) {
            this.playerQuestMan.saveAndSync();
        } else {
            this.saveAndSyncImpl();
        }
    }

    public void saveAndSyncImpl() {
        this.sync();
        this.writeQuestsFile();
    }

    public void sync() {
        if (MinecraftServer.func_71276_C() != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.save(nbt);
            try {
                byte[] data = CompressedStreamTools.func_74798_a((NBTTagCompound)nbt);
                ByteArrayOutputStream bos = new ByteArrayOutputStream(8 * data.length + 16);
                DataOutputStream dos = new DataOutputStream(bos);
                PlayerQuests.writeNBTTagCompound(nbt, dos, data);
                Packet250CustomPayload pkt = new Packet250CustomPayload();
                pkt.field_73630_a = "QuestData";
                pkt.field_73629_c = bos.toByteArray();
                pkt.field_73628_b = bos.size();
                MinecraftServer.func_71276_C().func_71203_ab().func_72361_f((String)this.playerName).field_71135_a.func_72567_b((Packet)pkt);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected static void writeNBTTagCompound(NBTTagCompound par0NBTTagCompound, DataOutputStream par1DataOutputStream, byte[] data) throws IOException {
        if (par0NBTTagCompound == null) {
            par1DataOutputStream.writeShort(-1);
        } else {
            par1DataOutputStream.writeShort((short)data.length);
            par1DataOutputStream.write(data);
        }
    }

    public void onComplete(int questIndex, boolean completeForAllInWorld) {
        if (completeForAllInWorld) {
            this.playerQuestMan.markQuestCompleteForAll(this.activeQuests.get(questIndex));
        } else {
            this.removeQuest(this.activeQuests.get(questIndex));
        }
        this.sync();
    }

    public void giveQuest(int questID) {
        boolean exists = false;
        for (int i = 0; i < this.activeQuests.size(); ++i) {
            if (this.activeQuests.get((int)i).questID != questID) continue;
            exists = true;
        }
        if (!exists) {
            this.activeQuests.add(QuestCreator.getNewQuestInstance(this, questID));
        }
    }

    public ActiveQuest getQuestByID(int parID) {
        for (int i = 0; i < this.activeQuests.size(); ++i) {
            if (this.activeQuests.get((int)i).questID != parID) continue;
            return this.activeQuests.get(i);
        }
        return null;
    }

    public ActiveQuest getFirstQuestByStatus(EnumQuestState questState) {
        for (int i = 0; i < this.activeQuests.size(); ++i) {
            if (this.activeQuests.get((int)i).curState != questState) continue;
            return this.activeQuests.get(i);
        }
        return null;
    }

    public void removeQuest(ActiveQuest quest) {
        for (int i = 0; i < this.activeQuests.size(); ++i) {
            if (this.activeQuests.get((int)i).questID != quest.questID) continue;
            this.activeQuests.remove(i);
        }
    }

    public void clearQuests() {
        for (int i = 0; i < this.activeQuests.size(); ++i) {
            this.activeQuests.remove(i);
        }
    }

    public void onEvent(Event event) {
        for (int i = 0; i < this.activeQuests.size(); ++i) {
            if (event instanceof LivingDeathEvent) {
                if (!(this.activeQuests.get(i) instanceof KillEntityQuest)) continue;
                ((KillEntityQuest)this.activeQuests.get(i)).deathEvent((LivingDeathEvent)event);
                continue;
            }
            if (!(event instanceof EntityItemPickupEvent) || !(this.activeQuests.get(i) instanceof ItemQuest)) continue;
            ((ItemQuest)this.activeQuests.get(i)).pickupEvent((EntityItemPickupEvent)event);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderQuestOverlay() {
        int startX = 10;
        int startY = 10;
        Minecraft mc = FMLClientHandler.instance().getClient();
        mc.field_71466_p.func_78261_a("Quests:", startX, startY, 0xFFFFFF);
        startY += 10;
        for (int i = 0; i < this.activeQuests.size(); ++i) {
            String qStr = "";
            String qStr2 = "";
            if (this.activeQuests.get(i) instanceof KillEntityQuest) {
                qStr = "Kill some " + EntityList.field_75626_c.get(((KillEntityQuest)this.activeQuests.get((int)i)).neededMob);
                qStr2 = "Killed: " + ((KillEntityQuest)this.activeQuests.get((int)i)).curKillCount + " / " + ((KillEntityQuest)this.activeQuests.get((int)i)).neededKillCount;
            }
            mc.field_71466_p.func_78261_a(qStr, startX, startY + (i + 10), 0xFFFFFF);
            mc.field_71466_p.func_78261_a(qStr2, startX, startY + 10 + (i + 10), 0xFFFFFF);
        }
    }

    public void syncFromServer(NBTTagCompound parNBT) {
        this.activeQuests.clear();
        this.load(parNBT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readQuestsFile() {
        FileInputStream fis = null;
        try {
            String URL2 = CoroUtilFile.getWorldFolderName() + "TCQuests" + File.separator;
            File file = new File(URL2 + this.playerName + ".dat");
            if (file.exists()) {
                fis = new FileInputStream(file);
                NBTTagCompound nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)fis);
                this.load(nbttagcompound);
                if (fis != null) {
                    fis.close();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void writeQuestsFile() {
        try {
            NBTTagCompound nbt = new NBTTagCompound();
            this.save(nbt);
            String URL2 = CoroUtilFile.getWorldFolderName() + "TCQuests" + File.separator;
            File fl = new File(URL2);
            if (!fl.exists()) {
                fl.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(URL2 + this.playerName + ".dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)fos);
            fos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void load(NBTTagCompound parNBT) {
        for (int i = 0; i < QuestCreator.maxQuestCount; ++i) {
            NBTTagCompound questNBT = parNBT.func_74775_l("q" + i);
            if (questNBT.func_82582_d()) continue;
            ActiveQuest quest = this.getQuestByID(i);
            if (quest == null) {
                quest = QuestCreator.getNewQuestInstance(this, i);
                this.activeQuests.add(quest);
            }
            quest.load(questNBT);
        }
    }

    public void save(NBTTagCompound parNBT) {
        for (int i = 0; i < this.activeQuests.size(); ++i) {
            NBTTagCompound questNBT = new NBTTagCompound();
            this.activeQuests.get(i).save(questNBT);
            parNBT.func_74782_a("q" + this.activeQuests.get((int)i).questID, (NBTBase)questNBT);
        }
    }
}

