/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.questsystem.quests;

import CoroUtil.componentAI.ICoroAI;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import tropicraft.ai.WorldDirector;
import tropicraft.packets.TropicraftPacketHandler;
import tropicraft.questsystem.EnumQuestState;
import tropicraft.questsystem.PlayerQuests;

public class ActiveQuest {
    public int questID;
    public EnumQuestState curState = EnumQuestState.ASSIGNED;
    public PlayerQuests playerQuests;
    public boolean givesPage = false;

    public ActiveQuest(PlayerQuests parPlQuests, int parID) {
        this.playerQuests = parPlQuests;
        this.questID = parID;
    }

    public void tick() {
    }

    public void saveAndSync() {
        this.playerQuests.saveAndSync();
    }

    public void load(NBTTagCompound parNBT) {
        this.curState = EnumQuestState.get(parNBT.func_74762_e("curState"));
    }

    public void save(NBTTagCompound parNBT) {
        parNBT.func_74768_a("curState", this.curState.ordinal());
    }

    public void setState(EnumQuestState state) {
        this.curState = state;
        this.saveAndSync();
    }

    public boolean isComplete() {
        return this.curState == EnumQuestState.COMPLETE;
    }

    public void eventComplete(ICoroAI ent) {
        this.setState(EnumQuestState.COMPLETE);
        this.givePage(this.playerQuests.playerInstance, true);
    }

    public void givePage(EntityPlayer par1EntityPlayer, boolean itemForm) {
        int maxPages = 16;
        NBTTagCompound pNBT = WorldDirector.getPlayerNBT(par1EntityPlayer.field_71092_bJ);
        NBTTagCompound nbt = pNBT.func_74775_l("pagesData");
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        for (int i = 0; i < maxPages; ++i) {
            if (nbt.func_74764_b("p" + i)) continue;
            if (itemForm) break;
            nbt.func_74757_a("p" + i, true);
            pNBT.func_74766_a("pagesData", nbt);
            TropicraftPacketHandler.syncPagesData(par1EntityPlayer.field_71092_bJ);
            break;
        }
    }
}

