/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.questsystem.quests;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import tropicraft.questsystem.EnumQuestState;
import tropicraft.questsystem.PlayerQuests;
import tropicraft.questsystem.quests.ActiveQuest;

public class KillEntityQuest
extends ActiveQuest {
    public Class neededMob;
    public int neededKillCount;
    public boolean returnToQuestGiver;
    public int curKillCount;

    public KillEntityQuest(PlayerQuests parPlQuests, int parID, Class mob, int count, boolean parReturnToQuestGiver) {
        super(parPlQuests, parID);
        this.neededMob = mob;
        this.neededKillCount = count;
        this.returnToQuestGiver = parReturnToQuestGiver;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.curState == EnumQuestState.ASSIGNED) {
            if (this.curKillCount >= this.neededKillCount) {
                if (this.returnToQuestGiver) {
                    this.setState(EnumQuestState.CONCLUDING);
                } else {
                    this.setState(EnumQuestState.COMPLETE);
                    System.out.println("quest kill complete");
                }
            }
        } else if (this.curState == EnumQuestState.CONCLUDING) {
            // empty if block
        }
    }

    public void deathEvent(LivingDeathEvent event) {
        Entity source = event.source.func_76346_g();
        if (source != null && source.equals((Object)this.playerQuests.playerInstance) && event.entityLiving.getClass().equals(this.neededMob)) {
            ++this.curKillCount;
            this.saveAndSync();
            System.out.println("quest kill inc");
        }
    }

    @Override
    public void load(NBTTagCompound parNBT) {
        super.load(parNBT);
        this.curKillCount = parNBT.func_74762_e("curKillCount");
    }

    @Override
    public void save(NBTTagCompound parNBT) {
        super.save(parNBT);
        parNBT.func_74768_a("curKillCount", this.curKillCount);
    }
}

