/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.volleyball;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import tropicraft.blocks.TropicraftBlocks;
import tropicraft.volleyball.Court;
import tropicraft.volleyball.Volleyball;

public class CourtHelper {
    private static final int MAX_SEARCH_DIST = 29;
    private static final int MIN_COURT_LONG_LENGTH = 9;
    private static final int MIN_COURT_SHORT_LENGTH = 5;
    private static final double COURT_LENGTH_RATIO = 2.0;
    private static final int TOLERANCE = 10;

    public static Court buildCourt(World world, ChunkCoordinates[] postCoords) {
        Court court = new Court();
        court.minX = postCoords[0].field_71574_a < postCoords[1].field_71574_a ? (double)postCoords[0].field_71574_a : (double)postCoords[1].field_71574_a;
        court.minZ = postCoords[1].field_71573_c < postCoords[2].field_71573_c ? (double)postCoords[1].field_71573_c : (double)postCoords[2].field_71573_c;
        court.maxX = postCoords[0].field_71574_a > postCoords[1].field_71574_a ? (double)postCoords[0].field_71574_a : (double)postCoords[1].field_71574_a;
        court.maxZ = postCoords[1].field_71573_c > postCoords[2].field_71573_c ? (double)postCoords[1].field_71573_c : (double)postCoords[2].field_71573_c;
        court.zLength = court.maxZ - court.minZ + 1.0;
        court.xLength = court.maxX - court.minX + 1.0;
        court.y = postCoords[0].field_71572_b;
        int posY = postCoords[0].field_71572_b;
        int id = TropicraftBlocks.bambooBundle.field_71990_ca;
        int id2 = TropicraftBlocks.purifiedSand.field_71990_ca;
        int i = (int)court.minX;
        while ((double)i < court.maxX) {
            world.func_94575_c(i, posY - 1, (int)court.minZ, id);
            world.func_94575_c(i, posY - 1, (int)court.maxZ, id);
            ++i;
        }
        i = (int)court.minZ;
        while ((double)i < court.maxZ) {
            world.func_94575_c((int)court.minX, posY - 1, i, id);
            world.func_94575_c((int)court.maxX, posY - 1, i, id);
            ++i;
        }
        if (court.xLength > court.zLength) {
            world.func_72832_d((int)(court.minX + (double)MathHelper.func_76128_c((double)(court.xLength / 2.0))), (int)court.y, (int)court.minZ, Volleyball.post.field_71990_ca, 1, 3);
            world.func_72832_d((int)(court.minX + (double)MathHelper.func_76128_c((double)(court.xLength / 2.0))), (int)court.y + 1, (int)court.minZ, Volleyball.post.field_71990_ca, 1, 3);
            world.func_72832_d((int)(court.minX + (double)MathHelper.func_76128_c((double)(court.xLength / 2.0))), (int)court.y, (int)court.maxZ, Volleyball.post.field_71990_ca, 1, 3);
            world.func_72832_d((int)(court.minX + (double)MathHelper.func_76128_c((double)(court.xLength / 2.0))), (int)court.y + 1, (int)court.maxZ, Volleyball.post.field_71990_ca, 1, 3);
        } else {
            world.func_72832_d((int)court.minX, (int)court.y, (int)(court.minZ + (double)MathHelper.func_76128_c((double)(court.zLength / 2.0))), Volleyball.post.field_71990_ca, 1, 3);
            world.func_72832_d((int)court.minX, (int)court.y + 1, (int)(court.minZ + (double)MathHelper.func_76128_c((double)(court.zLength / 2.0))), Volleyball.post.field_71990_ca, 1, 3);
            world.func_72832_d((int)court.maxX, (int)court.y, (int)(court.minZ + (double)MathHelper.func_76128_c((double)(court.zLength / 2.0))), Volleyball.post.field_71990_ca, 1, 3);
            world.func_72832_d((int)court.maxX, (int)court.y + 1, (int)(court.minZ + (double)MathHelper.func_76128_c((double)(court.zLength / 2.0))), Volleyball.post.field_71990_ca, 1, 3);
        }
        return court;
    }

    public static ChunkCoordinates[] checkCourtForValidity(World world, int x, int y, int z) {
        int posXDist = CourtHelper.findPost(world, x, y, z, ForgeDirection.EAST, 0);
        int negXDist = CourtHelper.findPost(world, x, y, z, ForgeDirection.WEST, 0);
        int posZDist = CourtHelper.findPost(world, x, y, z, ForgeDirection.SOUTH, 0);
        int negZDist = CourtHelper.findPost(world, x, y, z, ForgeDirection.NORTH, 0);
        int closestCount = 0;
        while (!(posXDist == -1 && negXDist == -1 || posZDist == -1 && negZDist == -1)) {
            posXDist = CourtHelper.findPost(world, x, y, z, ForgeDirection.EAST, closestCount);
            negXDist = CourtHelper.findPost(world, x, y, z, ForgeDirection.WEST, closestCount);
            posZDist = CourtHelper.findPost(world, x, y, z, ForgeDirection.SOUTH, closestCount);
            negZDist = CourtHelper.findPost(world, x, y, z, ForgeDirection.NORTH, closestCount);
            ForgeDirection closerX = CourtHelper.closerDir(ForgeDirection.EAST, posXDist, ForgeDirection.WEST, negXDist);
            ForgeDirection closerZ = CourtHelper.closerDir(ForgeDirection.SOUTH, posZDist, ForgeDirection.NORTH, negZDist);
            if (closerX == null || closerZ == null) {
                ++closestCount;
                continue;
            }
            List<ChunkCoordinates> numCorrect = CourtHelper.simulateCourt(world, x, y, z, closerX, closerX == ForgeDirection.EAST ? posXDist : negXDist, closerZ, closerZ == ForgeDirection.SOUTH ? posZDist : negZDist);
            if (numCorrect.size() == 4) {
                ChunkCoordinates[] coordsArray = numCorrect.toArray(new ChunkCoordinates[numCorrect.size()]);
                return CourtHelper.checkBoundsForValidity(coordsArray) ? coordsArray : null;
            }
            ++closestCount;
        }
        return null;
    }

    private static boolean checkBoundsForValidity(ChunkCoordinates[] posts) {
        int shortLength;
        int DEFAULT_LONG_LENGTH = 19;
        int DEFAULT_SHORT_LENGTH = 9;
        int minX = posts[0].field_71574_a < posts[1].field_71574_a ? posts[0].field_71574_a : posts[1].field_71574_a;
        int minZ = posts[1].field_71573_c < posts[2].field_71573_c ? posts[1].field_71573_c : posts[2].field_71573_c;
        int maxX = posts[0].field_71574_a > posts[1].field_71574_a ? posts[0].field_71574_a : posts[1].field_71574_a;
        int maxZ = posts[1].field_71573_c > posts[2].field_71573_c ? posts[1].field_71573_c : posts[2].field_71573_c;
        int longLength = maxX - minX > maxZ - minZ ? maxX - minX + 1 : maxZ - minZ + 1;
        int n = shortLength = maxX - minX < maxZ - minZ ? maxX - minX + 1 : maxZ - minZ + 1;
        if (longLength % 2 != 0) {
            return shortLength >= 5 && longLength >= 9 && CourtHelper.isValidRatio(longLength, shortLength);
        }
        return false;
    }

    private static boolean isValidRatio(int longLength, int shortLength) {
        return 2.0 <= (double)(longLength / shortLength) && (double)(longLength / shortLength) <= 2.0;
    }

    private static List<ChunkCoordinates> simulateCourt(World world, int x, int y, int z, ForgeDirection xDir, int xDist, ForgeDirection zDir, int zDist) {
        int zDiff;
        ArrayList<ChunkCoordinates> validPosts = new ArrayList<ChunkCoordinates>();
        validPosts.add(new ChunkCoordinates(x, y, z));
        int xDiff = xDir == ForgeDirection.EAST ? x + xDist : x - xDist;
        int n = zDiff = zDir == ForgeDirection.SOUTH ? z + zDist : z - zDist;
        if (CourtHelper.isPost(world, xDiff, y, z)) {
            validPosts.add(new ChunkCoordinates(xDiff, y, z));
        }
        if (CourtHelper.isPost(world, x, y, zDiff)) {
            validPosts.add(new ChunkCoordinates(x, y, zDiff));
        }
        if (CourtHelper.isPost(world, xDiff, y, zDiff)) {
            validPosts.add(new ChunkCoordinates(xDiff, y, zDiff));
        }
        return validPosts;
    }

    private static int findPost(World world, int x, int y, int z, ForgeDirection dir, int which) {
        int whichCounter = -1;
        int distance = 0;
        int i = x;
        int j = y;
        int k = z;
        while (whichCounter < which && distance++ <= 29) {
            switch (dir) {
                case EAST: {
                    if (!CourtHelper.isPost(world, ++i, j, k) || ++whichCounter < which) break;
                    return i - x;
                }
                case WEST: {
                    if (!CourtHelper.isPost(world, --i, j, k) || ++whichCounter < which) break;
                    return x - i;
                }
                case NORTH: {
                    if (!CourtHelper.isPost(world, i, j, --k) || ++whichCounter < which) break;
                    return z - k;
                }
                case SOUTH: {
                    if (!CourtHelper.isPost(world, i, j, ++k)) break;
                    return k - z;
                }
            }
        }
        return -1;
    }

    private static boolean isPost(World world, int i, int j, int k) {
        return world.func_72798_a(i, j, k) == Volleyball.post.field_71990_ca && world.func_72805_g(i, j, k) == 0;
    }

    private static ForgeDirection closerDir(ForgeDirection dir1, int dist1, ForgeDirection dir2, int dist2) {
        if (dist1 <= dist2 && dist1 != -1) {
            return dir1;
        }
        if (dist1 <= dist2 && dist2 != -1) {
            return dir2;
        }
        if (dist2 <= dist1 && dist2 != -1) {
            return dir2;
        }
        if (dist2 <= dist1 && dist1 != -1) {
            return dir1;
        }
        return null;
    }
}

