/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.world.mapgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import tropicraft.blocks.TropicraftBlocks;
import tropicraft.world.perlin.generator.RidgedMulti;

public class MapGenUndergroundGrove {
    private World worldObj;
    public boolean isActive = false;
    public int centerX = 0;
    public int centerZ = 0;
    public double length;
    public double width;
    public double height;
    public int y;

    public MapGenUndergroundGrove(World worldObj) {
        this.worldObj = worldObj;
    }

    public short[] generate(int x, int z, short[] blocks, byte[] metas) {
        ChunkCoordinates groveCoords = this.getGroveNear(this.worldObj, x, z);
        if (groveCoords == null) {
            return blocks;
        }
        this.centerX = groveCoords.field_71574_a;
        this.y = groveCoords.field_71572_b;
        this.centerZ = groveCoords.field_71573_c;
        System.out.println((x *= 16) + ", " + (z *= 16));
        this.isActive = true;
        Random rand = new Random(this.worldObj.func_72905_C() * (long)this.centerX + (long)this.centerZ * 57647382913L);
        RidgedMulti ridged = new RidgedMulti(rand.nextLong(), 1);
        ridged.frequency = 0.0325;
        this.length = rand.nextInt(20) + 30;
        this.width = rand.nextInt(20) + 30;
        this.height = rand.nextInt(3) + 5;
        this.length *= this.length;
        this.width *= this.width;
        this.height *= this.height;
        for (int i = 0; i < 16; ++i) {
            for (int k = 0; k < 16; ++k) {
                int j;
                int relativeX = x + i - this.centerX;
                int relativeZ = z + k - this.centerZ;
                relativeX *= relativeX;
                relativeZ *= relativeZ;
                for (double j2 = -this.height; j2 < this.height; j2 += 1.0) {
                    if (!((double)relativeX / this.length + j2 * j2 / this.height + (double)relativeZ / this.width <= 1.0)) continue;
                    this.placeBlock(i, this.y + (int)j2, k, 0, blocks);
                }
                double noise1 = ridged.getNoise(x + i, z + k);
                double noise2 = ridged.getNoise(x + i + 15432, z + k + 42314);
                if (noise1 > 0.845 || noise2 > 0.855) {
                    j = (int)Math.sqrt(this.height - this.height * (double)relativeX / this.length - this.height * (double)relativeZ / this.width);
                    this.placeBlock(i, this.y - j - 1, k, Block.field_71979_v.field_71990_ca, blocks);
                    double tunnelHeight = (5.0 - ((double)relativeX / 2500.0 + (double)relativeZ / 2500.0) * 2.0) / 3.0;
                    int j2 = 0;
                    while ((double)j2 < tunnelHeight) {
                        this.placeBlock(i, this.y - j + j2, k, 0, blocks);
                        ++j2;
                    }
                }
                if ((i + x) % 16 != 0 || (k + z) % 16 != 0) continue;
                j = (int)Math.sqrt(this.height - this.height * (double)relativeX / this.length - this.height * (double)relativeZ / this.width);
                rand.setSeed((long)(i * k * 54325432) * this.worldObj.func_72905_C() * (long)relativeX * (long)this.centerX);
                if (this.getBlock(i, this.y - j, k, blocks) != 0 || this.getBlock(i, this.y - j + 1, k, blocks) != 0 || this.getBlock(i, this.y - j + 2, k, blocks) != 0 || rand.nextInt(3) == 0) continue;
                this.placeBlockAndMeta(i, this.y - j, k, TropicraftBlocks.tikiTorch.field_71990_ca, 1, blocks, metas);
                this.placeBlockAndMeta(i, this.y - j + 1, k, TropicraftBlocks.tikiTorch.field_71990_ca, 1, blocks, metas);
                this.placeBlockAndMeta(i, this.y - j + 2, k, TropicraftBlocks.tikiTorch.field_71990_ca, 0, blocks, metas);
            }
        }
        return blocks;
    }

    public int getHeightAt(int x, int z) {
        int relativeX = x - this.centerX;
        int relativeZ = z - this.centerZ;
        relativeX *= relativeX;
        relativeZ *= relativeZ;
        return this.y - (int)Math.sqrt(this.height - this.height * (double)relativeX / this.length - this.height * (double)relativeZ / this.width);
    }

    protected boolean canGenGroveAtCoords(World worldObj, int i, int j) {
        int numChunks = 32;
        int offsetChunks = 8;
        int oldi = i;
        int oldj = j;
        if (i < 0) {
            i -= numChunks - 1;
        }
        if (j < 0) {
            j -= numChunks - 1;
        }
        int randX = i / numChunks;
        int randZ = j / numChunks;
        long seed = (long)randX * 341832132712L + (long)randZ * 422843987541L + worldObj.func_72912_H().func_76063_b() + 42231726L;
        Random rand = new Random(seed);
        randX *= numChunks;
        randZ *= numChunks;
        return oldi == (randX += rand.nextInt(numChunks - offsetChunks)) && oldj == (randZ += rand.nextInt(numChunks - offsetChunks));
    }

    public ChunkCoordinates getGroveNear(World worldObj, int i, int j) {
        int range = 4;
        for (int x = i - range; x <= i + range; ++x) {
            for (int z = j - range; z <= j + range; ++z) {
                Random rand = new Random(worldObj.func_72905_C() * (long)x + (long)z * 57647382913L);
                if (!this.canGenGroveAtCoords(worldObj, x, z)) continue;
                return new ChunkCoordinates(x * 16 + 8, rand.nextInt(5) + 20, z * 16 + 8);
            }
        }
        return null;
    }

    private void placeBlock(int x, int y, int z, int blockID, short[] blocks) {
        blocks[y << 8 | z << 4 | x] = (short)(blockID & 0xFFFF);
    }

    private void placeBlockAndMeta(int x, int y, int z, int blockID, int meta, short[] blocks, byte[] metas) {
        blocks[y << 8 | z << 4 | x] = (short)(blockID & 0xFFFF);
        metas[y << 8 | z << 4 | x] = (byte)(meta & 0xF);
    }

    private int getBlock(int x, int y, int z, short[] blocks) {
        return blocks[y << 8 | z << 4 | x];
    }
}

