/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.world.mapgen;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import tropicraft.blocks.TropicraftBlocks;
import tropicraft.world.biomes.BiomeGenTropicraft;
import tropicraft.world.perlin.NoiseModule;
import tropicraft.world.perlin.generator.Billowed;
import tropicraft.world.perlin.generator.Gradient;

public class MapGenVolcano {
    protected HashMap coordMap = new HashMap();
    public static List<BiomeGenBase> volcanoSpawnBiomesLand = Arrays.asList(new BiomeGenBase[]{BiomeGenTropicraft.tropics});
    public static List<BiomeGenBase> volcanoSpawnBiomesOcean = Arrays.asList(new BiomeGenBase[]{BiomeGenTropicraft.tropicsOcean});
    private World worldObj;
    private boolean useArrays;
    private final int CHUNK_SIZE_X = 16;
    private final int CHUNK_SIZE_Z = 16;
    private final int CHUNK_SIZE_Y = 127;
    private final int MAX_RADIUS = 65;
    private final int MIN_RADIUS = 45;
    private final int LAND_STEEPNESS_MOD = 4;
    private final int OCEAN_STEEPNESS_MOD = 8;
    private final int CALDERA_CUTOFF = 110;
    private final int VOLCANO_TOP = 103;
    private final int VOLCANO_CRUST = 100;
    private final int LAVA_LEVEL = 95;
    private final int CRUST_HOLE_CHANCE = 15;

    public MapGenVolcano(World worldObj, boolean useArrays) {
        this.worldObj = worldObj;
        this.useArrays = useArrays;
    }

    public short[] generate(int i, int k, short[] blocks, byte[] metas) {
        ChunkCoordinates volcanoCoords = this.getVolcanoNear(this.worldObj, i, k);
        if (volcanoCoords == null) {
            return blocks;
        }
        int[] heightmap = new int[256];
        for (int x = 0; x < 16; ++x) {
            block1: for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 127; ++y) {
                    int blockID = this.getBlock(x, y, z, blocks);
                    if (blockID == 0 || blockID == TropicraftBlocks.tropicsWaterStationary.field_71990_ca) {
                        heightmap[x * 16 + z] = y;
                        continue block1;
                    }
                    if (y <= 75) continue;
                    heightmap[x * 16 + z] = y;
                    continue block1;
                }
            }
        }
        System.out.println((i *= 16) + ", " + (k *= 16) + "v");
        int volcCenterX = volcanoCoords.field_71574_a;
        int volcCenterZ = volcanoCoords.field_71573_c;
        int steepnessMod = volcanoCoords.field_71572_b == 1 ? 4 : 8;
        long seed = (long)volcCenterX * 341873128712L + (long)volcCenterZ * 132897987541L + this.worldObj.func_72912_H().func_76063_b() + 4291726L;
        Random rand = new Random(seed);
        int radiusX = rand.nextInt(20) + 45;
        int radiusZ = rand.nextInt(20) + 45;
        Billowed volcNoise = new Billowed(seed, 1, 1.0);
        volcNoise.amplitude = 0.45;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                float relativeX = x + i - volcCenterX;
                float relativeZ = z + k - volcCenterZ;
                float distanceSquared = relativeX / (float)radiusX * (relativeX / (float)radiusX) + relativeZ / (float)radiusZ * (relativeZ / (float)radiusZ);
                float perlin = (float)((NoiseModule)volcNoise).getNoise((double)relativeX * 0.05 + 1.0E-4, (double)relativeZ * 0.05 + 1.0E-4) + 1.0f;
                double volcanoHeight = (float)steepnessMod / distanceSquared * perlin - (float)steepnessMod - 2.0f;
                int groundHeight = heightmap[x * 16 + z];
                if (!(distanceSquared < 1.0f)) continue;
                for (int y = 127; y > 0; --y) {
                    if (volcanoHeight + (double)groundHeight < 110.0) {
                        if (volcanoHeight + (double)groundHeight <= 103.0) {
                            if (!((double)y <= volcanoHeight + (double)groundHeight) || y < groundHeight) continue;
                            this.placeBlock(x, y, z, TropicraftBlocks.chunkOHead.field_71990_ca, blocks);
                            continue;
                        }
                        if (y > 103) continue;
                        this.placeBlock(x, y, z, TropicraftBlocks.chunkOHead.field_71990_ca, blocks);
                        continue;
                    }
                    if (y == 100 && rand.nextInt(15) != 0) {
                        this.placeBlock(x, y, z, TropicraftBlocks.chunkOHead.field_71990_ca, blocks);
                    }
                    if (y > 95) continue;
                    this.placeBlock(x, y, z, Block.field_71938_D.field_71990_ca, blocks);
                }
            }
        }
        return blocks;
    }

    public void generate(int i, int k) {
        int volcCenterX = i;
        int volcCenterZ = k;
        int steepnessMod = this.worldObj.func_72807_a(i, k) == BiomeGenTropicraft.tropics ? 4 : 8;
        long seed = (long)volcCenterX * 341873128712L + (long)volcCenterZ * 132897987541L + this.worldObj.func_72912_H().func_76063_b() + 4291726L;
        Random rand = new Random(seed);
        int radiusX = rand.nextInt(20) + 45;
        int radiusZ = rand.nextInt(20) + 45;
        int[] heightmap = new int[radiusX * 2 * (radiusZ * 2)];
        for (int x = -radiusX; x < radiusX; ++x) {
            block1: for (int z = -radiusZ; z < radiusZ; ++z) {
                for (int y = 127; y > 0; --y) {
                    int blockID = this.getBlock(x + i, y, z + k, null);
                    if (blockID == Block.field_71939_E.field_71990_ca || blockID == Block.field_71979_v.field_71990_ca || blockID == Block.field_71980_u.field_71990_ca) {
                        heightmap[(x + radiusX) * (radiusZ * 2) + (z + radiusZ)] = y;
                        continue block1;
                    }
                    if (y >= 30) continue;
                    heightmap[(x + radiusX) * (radiusZ * 2) + (z + radiusZ)] = y;
                    continue block1;
                }
            }
        }
        Gradient volcNoise = new Gradient(seed, 1, 1.0);
        volcNoise.amplitude = 0.6;
        for (int x = -radiusX; x < radiusX; ++x) {
            for (int z = -radiusZ; z < radiusZ; ++z) {
                float relativeX = x + i - volcCenterX;
                float relativeZ = z + k - volcCenterZ;
                float distanceSquared = relativeX / (float)radiusX * (relativeX / (float)radiusX) + relativeZ / (float)radiusZ * (relativeZ / (float)radiusZ);
                float perlin = (float)((NoiseModule)volcNoise).getNoise((double)relativeX * 0.05 + 1.0E-4, (double)relativeZ * 0.05 + 1.0E-4) + 1.0f;
                double volcanoHeight = (float)steepnessMod / distanceSquared * perlin - (float)steepnessMod - 1.0f;
                int groundHeight = heightmap[(x + radiusX) * (radiusZ * 2) + (z + radiusZ)];
                if (!(distanceSquared < 1.0f)) continue;
                for (int y = 127; y > 0; --y) {
                    if (volcanoHeight + (double)groundHeight < 110.0) {
                        if (volcanoHeight + (double)groundHeight <= 103.0) {
                            if (!((double)y <= volcanoHeight + (double)groundHeight) || y < groundHeight) continue;
                            this.placeBlock(x + i, y, z + k, TropicraftBlocks.chunkOHead.field_71990_ca, null);
                            continue;
                        }
                        if (y > 103) continue;
                        this.placeBlock(x + i, y, z + k, TropicraftBlocks.chunkOHead.field_71990_ca, null);
                        continue;
                    }
                    if (y == 100 && rand.nextInt(15) != 0) {
                        this.placeBlock(x + i, y, z + k, TropicraftBlocks.chunkOHead.field_71990_ca, null);
                    }
                    if (y > 95) continue;
                    this.placeBlock(x + i, y, z + k, Block.field_71938_D.field_71990_ca, null);
                }
            }
        }
        System.out.println("Done");
    }

    public void placeBlock(int x, int y, int z, int blockID, short[] blocks) {
        if (this.useArrays) {
            blocks[y << 8 | z << 4 | x] = (short)(blockID & 0xFFFF);
        } else {
            this.worldObj.func_94575_c(x, y, z, blockID);
        }
    }

    public int getBlock(int x, int y, int z, short[] blocks) {
        if (this.useArrays) {
            return blocks[y << 8 | z << 4 | x];
        }
        return this.worldObj.func_72798_a(x, y, z);
    }

    protected int canGenVolcanoAtCoords(World worldObj, int i, int j) {
        int numChunks = 32;
        int offsetChunks = 8;
        int oldi = i;
        int oldj = j;
        if (i < 0) {
            i -= numChunks - 1;
        }
        if (j < 0) {
            j -= numChunks - 1;
        }
        int randX = i / numChunks;
        int randZ = j / numChunks;
        long seed = (long)randX * 341873128712L + (long)randZ * 132897987541L + worldObj.func_72912_H().func_76063_b() + 4291726L;
        Random rand = new Random(seed);
        randX *= numChunks;
        randZ *= numChunks;
        if (oldi == (randX += rand.nextInt(numChunks - offsetChunks)) && oldj == (randZ += rand.nextInt(numChunks - offsetChunks))) {
            if (worldObj.func_72959_q().func_76940_a(oldi * 16 + 8, oldj * 16 + 8, 0, volcanoSpawnBiomesLand)) {
                return 1;
            }
            if (worldObj.func_72959_q().func_76940_a(oldi * 16 + 8, oldj * 16 + 8, 0, volcanoSpawnBiomesOcean)) {
                return 2;
            }
        }
        return 0;
    }

    public ChunkCoordinates getVolcanoNear(World worldObj, int i, int j) {
        int range = 4;
        for (int x = i - range; x <= i + range; ++x) {
            for (int z = j - range; z <= j + range; ++z) {
                int biome = this.canGenVolcanoAtCoords(worldObj, x, z);
                if (biome == 0) continue;
                return new ChunkCoordinates(x * 16 + 8, biome, z * 16 + 8);
            }
        }
        return null;
    }
}

