/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.world.structures;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import tropicraft.blocks.TropicraftBlocks;
import tropicraft.world.structures.KoaBridgePiece;
import tropicraft.world.structures.KoaVillage;
import tropicraft.world.structures.KoaVillageComponent;
import tropicraft.world.structures.KoaVillageHut;
import tropicraft.world.structures.KoaVillageManager;
import tropicraft.world.structures.KoaVillageShop;
import tropicraft.world.structures.KoaVillageWell;

public class KoaVillageGenerator {
    private static final List<Integer> waterBlockIDs = Arrays.asList(Block.field_71942_A.field_71990_ca, Block.field_71943_B.field_71990_ca, TropicraftBlocks.tropicsWaterFlowing.field_71990_ca, TropicraftBlocks.tropicsWaterStationary.field_71990_ca);
    private static final List<Integer> sandBlockIDs = Arrays.asList(Block.field_71939_E.field_71990_ca, TropicraftBlocks.purifiedSand.field_71990_ca);
    public static LinkedList<KoaBridgePiece> bridgePieceList;
    public KoaVillage village;

    public KoaVillageGenerator(World world) {
        this.village = new KoaVillage(world);
        bridgePieceList = new LinkedList();
    }

    private void generateSexy(World world, Random random, int i, int j, int k, int dir) {
        int x = i;
        int y = j - 1;
        int z = k;
        Block thatchStair = TropicraftBlocks.thatchStairs;
        for (int a = 0; a < 6; ++a) {
            int yLoc;
            int xOffset = random.nextInt(8) - random.nextInt(8);
            int zOffset = random.nextInt(8) - random.nextInt(8);
            for (yLoc = y + 6; yLoc > y - 4 && world.func_72798_a(x + xOffset, yLoc, z + zOffset) == 0; --yLoc) {
            }
            if (!sandBlockIDs.contains(world.func_72798_a(x + xOffset, yLoc, z + zOffset)) || world.func_72798_a(x + xOffset, yLoc + 1, z + zOffset) != 0 || world.func_72798_a(x + xOffset, yLoc + 2, z + zOffset) != 0 || world.func_72798_a(x + xOffset, yLoc + 3, z + zOffset) != 0) continue;
            this.placeWithMetadata(world, x + xOffset, yLoc + 1, z + zOffset, TropicraftBlocks.tikiTorch, 1, false);
            this.placeWithMetadata(world, x + xOffset, yLoc + 2, z + zOffset, TropicraftBlocks.tikiTorch, 1, false);
            this.placeWithMetadata(world, x + xOffset, yLoc + 3, z + zOffset, TropicraftBlocks.tikiTorch, 0, false);
        }
        switch (dir) {
            case 0: {
                this.placeWithMetadata(world, i - 1, j, k, thatchStair, 0);
                this.placeWithMetadata(world, i - 1, j, k + 1, thatchStair, 0);
                this.placeWithMetadata(world, i - 1, j, k - 1, thatchStair, 0);
                if (world.func_72798_a(i - 2, j - 1, k) != 0 && world.func_72798_a(i - 2, j - 1, k - 1) != 0 && world.func_72798_a(i - 2, j - 1, k + 1) != 0) break;
                this.placeWithMetadata(world, i - 2, j - 1, k, thatchStair, 0);
                this.placeWithMetadata(world, i - 2, j - 1, k + 1, thatchStair, 0);
                this.placeWithMetadata(world, i - 2, j - 1, k - 1, thatchStair, 0);
                break;
            }
            case 1: {
                this.placeWithMetadata(world, i + 1, j, k, thatchStair, 1);
                this.placeWithMetadata(world, i + 1, j, k + 1, thatchStair, 1);
                this.placeWithMetadata(world, i + 1, j, k - 1, thatchStair, 1);
                if (world.func_72798_a(i + 2, j - 1, k) != 0 && world.func_72798_a(i + 2, j - 1, k - 1) != 0 && world.func_72798_a(i + 2, j - 1, k + 1) != 0) break;
                this.placeWithMetadata(world, i + 2, j - 1, k, thatchStair, 1);
                this.placeWithMetadata(world, i + 2, j - 1, k + 1, thatchStair, 1);
                this.placeWithMetadata(world, i + 2, j - 1, k - 1, thatchStair, 1);
                break;
            }
            case 2: {
                this.placeWithMetadata(world, i, j, k - 1, thatchStair, 2);
                this.placeWithMetadata(world, i + 1, j, k - 1, thatchStair, 2);
                this.placeWithMetadata(world, i - 1, j, k - 1, thatchStair, 2);
                if (world.func_72798_a(i, j - 1, k - 2) != 0 && world.func_72798_a(i - 1, j - 1, k - 2) != 0 && world.func_72798_a(i + 1, j - 1, k - 2) != 0) break;
                this.placeWithMetadata(world, i, j - 1, k - 2, thatchStair, 2);
                this.placeWithMetadata(world, i - 1, j - 1, k - 2, thatchStair, 2);
                this.placeWithMetadata(world, i + 1, j - 1, k - 2, thatchStair, 2);
                break;
            }
            case 3: {
                this.placeWithMetadata(world, i, j, k + 1, thatchStair, 3);
                this.placeWithMetadata(world, i + 1, j, k + 1, thatchStair, 3);
                this.placeWithMetadata(world, i - 1, j, k + 1, thatchStair, 3);
                if (world.func_72798_a(i, j - 1, k - 2) != 0 && world.func_72798_a(i - 1, j - 1, k - 2) != 0 && world.func_72798_a(i + 1, j - 1, k - 2) != 0) break;
                this.placeWithMetadata(world, i, j - 1, k + 2, thatchStair, 3);
                this.placeWithMetadata(world, i - 1, j - 1, k + 2, thatchStair, 3);
                this.placeWithMetadata(world, i + 1, j - 1, k + 2, thatchStair, 3);
                break;
            }
        }
    }

    protected void placeWithMetadata(World world, int i, int j, int k, Block block, int meta) {
        this.placeWithMetadata(world, i, j, k, block, meta, true);
    }

    protected void placeWithMetadata(World world, int i, int j, int k, Block block, int meta, boolean notify) {
        if (notify) {
            world.func_72832_d(i, j, k, block.field_71990_ca, meta, 3);
        } else {
            world.func_72832_d(i, j, k, block.field_71990_ca, meta, 3);
        }
    }

    private boolean generateBridges(World world, Random random, int x, int y, int z, int dir, int length) {
        if (this.canSimulateBridge(world, x, y, z, dir, length)) {
            if (length > 50) {
                length = 43;
            }
            if (length > 40) {
                length -= 3;
            }
            if (length > 25) {
                length -= 4;
            }
            if (length < 25) {
                return false;
            }
            KoaVillageManager.villageMap.put(this.village.id, this.village);
            this.generateSexy(world, random, x, y, z, dir);
            this.generateBridge(world, random, x, y, z, dir, length -= 5);
            this.generateHuts(world, random);
            int maxAdditionalBridges = random.nextInt(2) + 2;
            if (dir == 0) {
                x += length + 1;
            } else if (dir == 1) {
                x -= length + 1;
            } else {
                z = dir == 2 ? (z += length + 1) : (z -= length + 1);
            }
            for (int segment = 0; segment < maxAdditionalBridges; ++segment) {
                int[] pdirs = new int[]{0, 0};
                if (dir == 0 || dir == 1) {
                    pdirs[0] = 2;
                    pdirs[1] = 3;
                } else if (dir == 2 || dir == 3) {
                    pdirs[0] = 0;
                    pdirs[1] = 1;
                }
                int maxLength = -1;
                int newDir = -1;
                if (this.getMaxDistance(world, x, y, z, pdirs[0]) > maxLength) {
                    maxLength = this.getMaxDistance(world, x, y, z, pdirs[0]);
                    newDir = pdirs[0];
                }
                if (this.getMaxDistance(world, x, y, z, pdirs[1]) > maxLength) {
                    maxLength = this.getMaxDistance(world, x, y, z, pdirs[1]);
                    newDir = pdirs[1];
                }
                if (newDir == 0) {
                    --x;
                } else if (newDir == 1) {
                    ++x;
                } else {
                    z = newDir == 2 ? --z : ++z;
                }
                length = maxLength;
                if (length > 50) {
                    length = 43;
                }
                if (length > 30) {
                    length -= 8;
                }
                if (length > 15) {
                    length -= 4;
                }
                if (length < 10 || !this.canSimulateBridge(world, x, y, z, newDir, length -= 3)) continue;
                this.generateBridge(world, random, x, y, z, newDir, length);
                this.generateHuts(world, random);
                dir = newDir;
                if (dir == 0) {
                    x += length + 1;
                    continue;
                }
                if (dir == 1) {
                    x -= length + 1;
                    continue;
                }
                if (dir == 2) {
                    z += length + 1;
                    continue;
                }
                z -= length + 1;
            }
            return true;
        }
        return false;
    }

    private void generateHuts(World world, Random random) {
        for (KoaBridgePiece kbp : bridgePieceList) {
            KoaVillageComponent component;
            if (!kbp.canBuildHere) continue;
            kbp.canBuildHere = false;
            if (random.nextFloat() < 0.4f) {
                component = new KoaVillageWell(this.village, this.coordsOfAdjacentAir(world, kbp.x, kbp.y, kbp.z)[0], this.coordsOfAdjacentAir(world, kbp.x, kbp.y, kbp.z)[1], this.coordsOfAdjacentAir(world, kbp.x, kbp.y, kbp.z)[2]);
                if (!((KoaVillageWell)component).canFitInWorld(world)) continue;
                ((KoaVillageWell)component).generate(world);
                continue;
            }
            if (random.nextBoolean() && !this.village.hasPlacedTrader) {
                component = new KoaVillageShop(this.village, this.coordsOfAdjacentAir(world, kbp.x, kbp.y, kbp.z)[0], this.coordsOfAdjacentAir(world, kbp.x, kbp.y, kbp.z)[1], this.coordsOfAdjacentAir(world, kbp.x, kbp.y, kbp.z)[2]);
                if (!((KoaVillageShop)component).canFitInWorld(world)) continue;
                this.village.hasPlacedTrader = true;
                ((KoaVillageShop)component).generateSchematic(world);
                continue;
            }
            component = new KoaVillageHut(this.village, this.coordsOfAdjacentAir(world, kbp.x, kbp.y, kbp.z)[0], this.coordsOfAdjacentAir(world, kbp.x, kbp.y, kbp.z)[1], this.coordsOfAdjacentAir(world, kbp.x, kbp.y, kbp.z)[2]);
            if (!((KoaVillageHut)component).canFitInWorld(world)) continue;
            ((KoaVillageHut)component).generate(world);
        }
        for (ChunkCoordinates ksp : this.village.spawnPoints) {
            this.place(world, ksp.field_71574_a, ksp.field_71572_b, ksp.field_71573_c, TropicraftBlocks.koaChest);
        }
    }

    private int[] coordsOfAdjacentAir(World world, int i, int j, int k) {
        int[] asdf = new int[4];
        if (world.func_72798_a(i + 1, j, k) == 0) {
            asdf[0] = i + 1;
            asdf[1] = j;
            asdf[2] = k;
            asdf[3] = i + 1;
        } else if (world.func_72798_a(i - 1, j, k) == 0) {
            asdf[0] = i - 1;
            asdf[1] = j;
            asdf[2] = k;
            asdf[3] = i - 1;
        } else if (world.func_72798_a(i + 1, j, k + 1) == 0) {
            asdf[0] = i + 1;
            asdf[1] = j;
            asdf[2] = k + 1;
            asdf[3] = 0;
        } else if (world.func_72798_a(i - 1, j, k - 1) == 0) {
            asdf[0] = i - 1;
            asdf[1] = j;
            asdf[2] = k - 1;
            asdf[3] = 0;
        } else if (world.func_72798_a(i, j, k + 1) == 0) {
            asdf[0] = i;
            asdf[1] = j;
            asdf[2] = k + 1;
            asdf[3] = k + 1;
        } else if (world.func_72798_a(i, j, k - 1) == 0) {
            asdf[0] = i;
            asdf[1] = j;
            asdf[2] = k - 1;
            asdf[3] = k - 1;
        } else if (world.func_72798_a(i - 1, j, k + 1) == 0) {
            asdf[0] = i - 1;
            asdf[1] = j;
            asdf[2] = k + 1;
            asdf[3] = 0;
        } else if (world.func_72798_a(i + 1, j, k - 1) == 0) {
            asdf[0] = i + 1;
            asdf[1] = j;
            asdf[2] = k - 1;
            asdf[3] = 0;
        }
        return asdf;
    }

    private void generateBridge(World world, Random random, int i, int j, int k, int dir, int length) {
        Block bridgebl = TropicraftBlocks.tropicsBuildingBlock;
        switch (dir) {
            case 0: {
                for (int a = 0; a < length; ++a) {
                    this.genBridgePiece(world, i + a, j, k, bridgebl);
                    this.genBridgePiece(world, i + a, j, k + 1, bridgebl, a, 0, length);
                    this.genBridgePiece(world, i + a, j, k - 1, bridgebl, a, 1, length);
                }
                break;
            }
            case 1: {
                for (int a = 0; a < length; ++a) {
                    this.genBridgePiece(world, i - a, j, k, bridgebl);
                    this.genBridgePiece(world, i - a, j, k + 1, bridgebl, a, 0, length);
                    this.genBridgePiece(world, i - a, j, k - 1, bridgebl, a, 1, length);
                }
                break;
            }
            case 2: {
                for (int a = 0; a < length; ++a) {
                    this.genBridgePiece(world, i, j, k + a, bridgebl);
                    this.genBridgePiece(world, i + 1, j, k + a, bridgebl, a, 0, length);
                    this.genBridgePiece(world, i - 1, j, k + a, bridgebl, a, 1, length);
                }
                break;
            }
            case 3: {
                for (int a = 0; a < length; ++a) {
                    this.genBridgePiece(world, i, j, k - a, bridgebl);
                    this.genBridgePiece(world, i + 1, j, k - a, bridgebl, a, 0, length);
                    this.genBridgePiece(world, i - 1, j, k - a, bridgebl, a, 1, length);
                }
                break;
            }
        }
        this.generateHuts(world, random);
    }

    private void genBridgePiece(World world, int i, int j, int k, Block block, int count, int decide, int totalLength) {
        if (decide == 0) {
            this.place(world, i, j, k, block);
            int r = world.field_73012_v.nextInt(1) + 14;
            bridgePieceList.add(new KoaBridgePiece(i, j, k, count % r == 0 && this.hasAdjacentAir(world, i, j, k) && count > 2 && count < totalLength - 4));
        } else {
            this.place(world, i, j, k, block);
            int r = world.field_73012_v.nextInt(1) + 11;
            bridgePieceList.add(new KoaBridgePiece(i, j, k, count % r == 0 && this.hasAdjacentAir(world, i, j, k) && count > 2 && count < totalLength - 4));
        }
    }

    private boolean hasAdjacentAir(World world, int i, int j, int k) {
        return world.func_72798_a(i + 1, j, k) == 0 || world.func_72798_a(i - 1, j, k) == 0 || world.func_72798_a(i, j, k - 1) == 0 || world.func_72798_a(i, j, k + 1) == 0 || world.func_72798_a(i + 1, j, k + 1) == 0 || world.func_72798_a(i + 1, j, k - 1) == 0 || world.func_72798_a(i - 1, j, k - 1) == 0 || world.func_72798_a(i - 1, j, k + 1) == 0;
    }

    private void genBridgePiece(World world, int i, int j, int k, Block block) {
        this.place(world, i, j, k, block);
        bridgePieceList.add(new KoaBridgePiece(i, j, k, false));
    }

    private boolean canSimulateBridge(World world, int i, int j, int k, int dir, int length) {
        switch (dir) {
            case 0: {
                for (int a = 0; a < length; ++a) {
                    if (world.func_72798_a(i + a, j, k) == 0 && world.func_72798_a(i + a, j, k + 1) == 0 && world.func_72798_a(i + a, j, k - 1) == 0) continue;
                    return false;
                }
                break;
            }
            case 1: {
                for (int a = 0; a < length; ++a) {
                    if (world.func_72798_a(i - a, j, k) == 0 && world.func_72798_a(i - a, j, k + 1) == 0 && world.func_72798_a(i - a, j, k - 1) == 0) continue;
                    return false;
                }
                break;
            }
            case 2: {
                for (int a = 0; a < length; ++a) {
                    if (world.func_72798_a(i, j, k + a) == 0 && world.func_72798_a(i + 1, j, k + a) == 0 && world.func_72798_a(i - 1, j, k + a) == 0) continue;
                    return false;
                }
                break;
            }
            case 3: {
                for (int a = 0; a < length; ++a) {
                    if (world.func_72798_a(i, j, k - a) == 0 && world.func_72798_a(i + 1, j, k - a) == 0 && world.func_72798_a(i - 1, j, k - a) == 0) continue;
                    return false;
                }
                break;
            }
        }
        return true;
    }

    private void place(World world, int i, int j, int k, Block block) {
        this.place(world, i, j, k, block, true);
    }

    private void place(World world, int i, int j, int k, Block block, boolean notify) {
        if (notify) {
            world.func_94575_c(i, j, k, block.field_71990_ca);
        } else {
            world.func_94575_c(i, j, k, block.field_71990_ca);
        }
    }

    public boolean generate(World world, Random random, int i, int j, int k) {
        int genDirection = this.canGenerateStart(world, random, i, j - 1, k);
        return this.generate(world, random, i, j, k, genDirection);
    }

    public boolean generate(World world, Random random, int i, int j, int k, int direction) {
        if (direction != -1 && sandBlockIDs.contains(world.func_72798_a(i, j - 1, k))) {
            int idir = direction;
            int dist = this.getMaxDistance(world, i, j + 1, k, idir);
            boolean generated = this.generateBridges(world, random, i, j + 1, k, idir, dist);
            if (generated) {
                this.village.spawnEntities(world);
            }
            return generated;
        }
        return false;
    }

    private int canGenerateStart(World world, Random random, int i, int j, int k) {
        int dir = -1;
        boolean[] adjacentWater = new boolean[]{waterBlockIDs.contains(world.func_72798_a(i + 1, j, k)), waterBlockIDs.contains(world.func_72798_a(i - 1, j, k)), waterBlockIDs.contains(world.func_72798_a(i, j, k + 1)), waterBlockIDs.contains(world.func_72798_a(i, j, k - 1))};
        int numTrue = 0;
        for (int b = 0; b < 4; ++b) {
            if (!adjacentWater[b]) continue;
            ++numTrue;
            dir = b;
        }
        if (numTrue > 1) {
            return -1;
        }
        if (numTrue == 0) {
            return -1;
        }
        return dir;
    }

    private int getMaxDistance(World world, int i, int j, int k, int direction) {
        int max = 0;
        int id = TropicraftBlocks.tropicsBuildingBlock.field_71990_ca;
        switch (direction) {
            case 0: {
                for (int a = 1; a < 80; ++a) {
                    if (!(waterBlockIDs.contains(world.func_72798_a(i + a, j - 2, k)) || world.func_72798_a(i + a, j, k) != 0 && world.func_72798_a(i + a, j, k) != id)) {
                        return a;
                    }
                    ++max;
                }
                break;
            }
            case 1: {
                for (int a = 1; a < 80; ++a) {
                    if (!(waterBlockIDs.contains(world.func_72798_a(i - a, j - 2, k)) || world.func_72798_a(i - a, j, k) != 0 && world.func_72798_a(i - a, j, k) != id)) {
                        return a;
                    }
                    ++max;
                }
                break;
            }
            case 2: {
                for (int a = 1; a < 80; ++a) {
                    if (!(waterBlockIDs.contains(world.func_72798_a(i, j - 2, k + a)) || world.func_72798_a(i, j, k + a) != 0 && world.func_72798_a(i, j, k + a) != id)) {
                        return a;
                    }
                    ++max;
                }
                break;
            }
            case 3: {
                for (int a = 1; a < 80; ++a) {
                    if (!(waterBlockIDs.contains(world.func_72798_a(i, j - 2, k - a)) || world.func_72798_a(i, j, k - a) != 0 && world.func_72798_a(i, j, k - a) != id)) {
                        return a;
                    }
                    ++max;
                }
                break;
            }
        }
        if (max >= 79) {
            return 50;
        }
        return -1;
    }
}

