/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.world.structures;

import build.BuildServerTicks;
import build.world.BuildJob;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import tropicraft.ai.WorldDirector;
import tropicraft.blocks.TropicraftBlocks;
import tropicraft.world.schematic.CustomGenKoaHut;
import tropicraft.world.structures.KoaVillage;
import tropicraft.world.structures.KoaVillageComponent;

public class KoaVillageShop
extends KoaVillageComponent {
    private static final int bridgeBlockID = TropicraftBlocks.tropicsBuildingBlock.field_71990_ca;
    private Block thatchBlock = TropicraftBlocks.tropicsBuildingBlock;
    private Block bambooFence = TropicraftBlocks.tropicsFence;
    private Block palmWood = TropicraftBlocks.treeWood;
    private Block bambooBlock = TropicraftBlocks.bambooBundle;
    private Block thatchSlab = TropicraftBlocks.tropicsSingleSlab;
    private Block thatchStair = TropicraftBlocks.thatchStairs;
    private Block tikiTorch = TropicraftBlocks.tikiTorch;

    public KoaVillageShop(KoaVillage village, int x, int y, int z) {
        this.village = village;
        this.homeX = x;
        this.homeY = y;
        this.homeZ = z;
    }

    @Override
    public boolean canFitInWorld(World world) {
        if (world.func_72798_a(this.homeX + 1, this.homeY, this.homeZ) == bridgeBlockID) {
            for (int x = -7; x < 1; ++x) {
                for (int z = -4; z < 6; ++z) {
                    if (world.func_72798_a(this.homeX + x, this.homeY, this.homeZ + z) == 0) continue;
                    return false;
                }
            }
            this.genX = this.homeX;
            this.genY = this.homeY;
            this.genZ = this.homeZ;
            this.genDirection = 2;
        } else if (world.func_72798_a(this.homeX - 1, this.homeY, this.homeZ) == bridgeBlockID) {
            for (int x = 0; x < 8; ++x) {
                for (int z = -4; z < 6; ++z) {
                    if (world.func_72798_a(this.homeX + x, this.homeY, this.homeZ + z) == 0) continue;
                    return false;
                }
            }
            this.genX = this.homeX;
            this.genY = this.homeY;
            this.genZ = this.homeZ;
            this.genDirection = 1;
        } else if (world.func_72798_a(this.homeX, this.homeY, this.homeZ + 1) == bridgeBlockID) {
            for (int x = -5; x < 4; ++x) {
                for (int z = -6; z < 1; ++z) {
                    if (world.func_72798_a(this.homeX + x, this.homeY, this.homeZ + z) == 0) continue;
                    return false;
                }
            }
            this.genX = this.homeX;
            this.genY = this.homeY;
            this.genZ = this.homeZ;
            this.genDirection = 3;
        } else if (world.func_72798_a(this.homeX, this.homeY, this.homeZ - 1) == bridgeBlockID) {
            for (int x = -5; x < 4; ++x) {
                for (int z = 0; z < 6; ++z) {
                    if (world.func_72798_a(this.homeX + x, this.homeY, this.homeZ + z) == 0) continue;
                    return false;
                }
            }
            this.genX = this.homeX;
            this.genY = this.homeY;
            this.genZ = this.homeZ;
            this.genDirection = 4;
        }
        return true;
    }

    public void generateSchematic(World world) {
        if (world.field_72995_K) {
            return;
        }
        int x = this.homeX;
        int y = this.homeY;
        int z = this.homeZ;
        this.village.tradePoints.add(new ChunkCoordinates(x, y, z));
        --this.genDirection;
        System.out.println("genDirection: " + this.genDirection + ", " + x + ", " + y + ", " + z);
        if (this.genDirection == 0) {
            this.genDirection = 2;
        } else if (this.genDirection == 2) {
            this.genDirection = 3;
        } else if (this.genDirection == 3) {
            this.genDirection = 1;
        } else if (this.genDirection == 1) {
            this.genDirection = 0;
        }
        System.out.println("fixed? genDirection: " + this.genDirection + ", " + x + ", " + y + ", " + z);
        int buildID = BuildServerTicks.buildMan.activeBuilds.size();
        String str = "TradeHut";
        BuildJob bj = new BuildJob(buildID, this.homeX, this.homeY, this.homeZ, WorldDirector.getSaveFolderPath() + "assets" + File.separator + "tropicraftmod" + File.separator + "schematics" + File.separator + str);
        bj.build.dim = world.field_73011_w.field_76574_g;
        bj.useFirstPass = false;
        bj.neverPlaceAir = true;
        bj.useRotationBuild = true;
        bj.build.newFormat = true;
        bj.build.backwardsCompatibleOldRotate = true;
        bj.customGenCallback = new CustomGenKoaHut();
        boolean offset = false;
        bj.setDirection(this.genDirection);
        BuildServerTicks.buildMan.addBuild(bj);
    }

    @Override
    public void generate(World world) {
        int b;
        int a;
        if (world.field_72995_K) {
            return;
        }
        int x = this.homeX;
        int y = this.homeY;
        int z = this.homeZ;
        for (a = 0; a < 2; ++a) {
            for (b = 0; b < 2; ++b) {
                this.place(world, x + a, y, z + b, this.thatchBlock);
            }
        }
        for (a = 0; a < 5; ++a) {
            for (b = 0; b < 8; ++b) {
                if (a != 2 || b == 2) {
                    // empty if block
                }
                this.place(world, x + a + 2, y, z + b - 3, this.thatchBlock);
                if (a != 0 && a != 4 || b != 0 && b != 7) continue;
                this.placeDownTilGround(world, x + a + 2, y - 1, z + b - 3, this.bambooFence);
            }
        }
        for (a = 0; a < 3; ++a) {
            this.place(world, x + 3 + a, y + 1, z - 3, this.bambooBlock);
            this.place(world, x + 3 + a, y + 1, z + 4, this.bambooBlock);
            this.place(world, x + 3 + a, y + 3, z - 3, this.bambooBlock);
            this.place(world, x + 3 + a, y + 3, z + 4, this.bambooBlock);
            this.place(world, x + 3 + a, y + 4, z - 3, this.palmWood);
            this.place(world, x + 3 + a, y + 4, z + 4, this.palmWood);
            this.place(world, x + 3 + a, y + 5, z - 3, this.thatchBlock);
            this.place(world, x + 3 + a, y + 5, z + 4, this.thatchBlock);
            this.place(world, x + 3 + a, y + 5, z - 4, this.thatchSlab, 1);
            this.place(world, x + 3 + a, y + 5, z + 5, this.thatchSlab, 1);
            this.place(world, x + 3 + a, y + 6, z - 2, this.thatchSlab, 1);
            this.place(world, x + 3 + a, y + 6, z + 3, this.thatchSlab, 1);
        }
        this.placeWithMetadata(world, x + 4, y + 6, z - 2, this.thatchStair, 2);
        this.placeWithMetadata(world, x + 4, y + 6, z + 3, this.thatchStair, 3);
        for (a = 0; a < 4; ++a) {
            this.placeWithMetadata(world, x + 5, y + 6, z - 2 + a + 1, this.thatchStair, 1);
            this.placeWithMetadata(world, x + 3, y + 6, z - 2 + a + 1, this.thatchStair, 0);
        }
        this.place(world, x + 4, y + 7, z + 2, this.thatchSlab, 1);
        this.place(world, x + 4, y + 7, z - 1, this.thatchSlab, 1);
        this.place(world, x + 4, y + 7, z + 1, this.thatchSlab, 1);
        this.place(world, x + 4, y + 7, z, this.thatchSlab, 1);
        for (a = 0; a < 7; ++a) {
            this.place(world, x + 6, y + 1, z - 3 + a, this.bambooBlock);
            this.place(world, x + 6, y + 2, z - 3 + a, this.bambooBlock);
            this.place(world, x + 6, y + 3, z - 3 + a, this.bambooBlock);
            this.place(world, x + 2, y + 3, z - 3 + a, this.bambooBlock);
            this.place(world, x + 6, y + 4, z - 3 + a, this.palmWood);
            this.place(world, x + 2, y + 4, z - 3 + a, this.palmWood);
            this.place(world, x + 6, y + 5, z - 3 + a, this.thatchBlock);
            this.place(world, x + 2, y + 5, z - 3 + a, this.thatchBlock);
            if (a == 3 || a == 4) continue;
            this.place(world, x + 2, y + 1, z - 3 + a, this.bambooBlock);
        }
        for (a = 2; a < 6; ++a) {
            this.place(world, x + 4, y + 1, z - 3 + a, this.bambooBlock);
            if (a == 4) {
                this.place(world, x + 4, y + 2, z - 3 + a, Block.field_72044_aK);
            }
            this.placeShopFrame(world, x + 6, y + 2, z - 3 + a);
        }
        this.place(world, x - 1, y + 1, z - 1, this.bambooFence);
        this.place(world, x - 1, y + 1, z + 2, this.bambooFence);
        this.place(world, x - 1, y + 2, z - 1, this.tikiTorch, 0);
        this.place(world, x - 1, y + 2, z + 2, this.tikiTorch, 0);
        this.place(world, x + 2, y + 2, z - 1, this.palmWood);
        this.place(world, x + 2, y + 2, z + 2, this.palmWood);
        for (a = 0; a < 4; ++a) {
            this.place(world, x + 2, y + 1 + a, z - 3, this.palmWood);
            this.place(world, x + 2, y + 1 + a, z + 4, this.palmWood);
            this.place(world, x + 6, y + 1 + a, z - 3, this.palmWood);
            this.place(world, x + 6, y + 1 + a, z + 4, this.palmWood);
            if (a != 3) continue;
            this.place(world, x + 2, y + 2 + a, z - 3, this.thatchBlock);
            this.place(world, x + 2, y + 2 + a, z + 4, this.thatchBlock);
            this.place(world, x + 6, y + 2 + a, z - 3, this.thatchBlock);
            this.place(world, x + 6, y + 2 + a, z + 4, this.thatchBlock);
            this.place(world, x + 2, y + 2 + a, z - 4, this.thatchSlab, 1);
            this.place(world, x + 2, y + 2 + a, z + 5, this.thatchSlab, 1);
            this.place(world, x + 6, y + 2 + a, z - 4, this.thatchSlab, 1);
            this.place(world, x + 6, y + 2 + a, z + 5, this.thatchSlab, 1);
        }
        for (a = 0; a < 10; ++a) {
            this.place(world, x + 1, y + 5, z - 4 + a, this.thatchSlab, 1);
            this.place(world, x + 7, y + 5, z - 4 + a, this.thatchSlab, 1);
        }
    }

    private void placeShopFrame(World world, int i, int j, int k) {
    }

    @Override
    public void spawn(World world) {
    }
}

