/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.world.structures;

import net.minecraft.block.Block;
import net.minecraft.world.World;
import tropicraft.blocks.TropicraftBlocks;
import tropicraft.world.structures.KoaVillage;
import tropicraft.world.structures.KoaVillageComponent;

public class KoaVillageWell
extends KoaVillageComponent {
    private static final int bridgeBlockID = TropicraftBlocks.tropicsBuildingBlock.field_71990_ca;
    private Block thatchBlock = TropicraftBlocks.tropicsBuildingBlock;
    private Block bambooFence = TropicraftBlocks.tropicsFence;
    private Block palmWood = TropicraftBlocks.treeWood;
    private Block bambooBlock = TropicraftBlocks.bambooBundle;
    private Block thatchSlab = TropicraftBlocks.tropicsSingleSlab;
    private Block thatchStair = TropicraftBlocks.thatchStairs;
    private Block tikiTorch = TropicraftBlocks.tikiTorch;

    public KoaVillageWell(KoaVillage village, int x, int y, int z) {
        this.village = village;
        this.homeX = x;
        this.homeY = y;
        this.homeZ = z;
    }

    @Override
    public boolean canFitInWorld(World world) {
        if (world.func_72798_a(this.homeX + 1, this.homeY, this.homeZ) == bridgeBlockID || world.func_72798_a(this.homeX - 1, this.homeY, this.homeZ) == bridgeBlockID) {
            if (world.func_72798_a(this.homeX + 1, this.homeY, this.homeZ) == bridgeBlockID) {
                for (int x1 = -4; x1 < 1; ++x1) {
                    for (int z1 = -1; z1 < 4; ++z1) {
                        if (world.func_72798_a(this.homeX + x1, this.homeY, this.homeZ + z1) == 0) continue;
                        return false;
                    }
                }
                this.genX = this.homeX;
                this.genY = this.homeY;
                this.genZ = this.homeZ;
                this.genDirection = 2;
                return true;
            }
            if (world.func_72798_a(this.homeX - 1, this.homeY, this.homeZ) == bridgeBlockID) {
                for (int x1 = -1; x1 < 4; ++x1) {
                    for (int z1 = -1; z1 < 4; ++z1) {
                        if (world.func_72798_a(this.homeX + x1, this.homeY, this.homeZ + z1) == 0) continue;
                        return false;
                    }
                }
                this.genX = this.homeX;
                this.genY = this.homeY;
                this.genZ = this.homeZ;
                this.genDirection = 1;
                return true;
            }
        } else if (world.func_72798_a(this.homeX, this.homeY, this.homeZ + 1) == bridgeBlockID || world.func_72798_a(this.homeX, this.homeY, this.homeZ - 1) == bridgeBlockID) {
            if (world.func_72798_a(this.homeX, this.homeY, this.homeZ + 1) == bridgeBlockID) {
                for (int x1 = -5; x1 < 0; ++x1) {
                    for (int z1 = -4; z1 < -1; ++z1) {
                        if (world.func_72798_a(this.homeX + x1, this.homeY, this.homeZ + z1) == 0) continue;
                        return false;
                    }
                }
                this.genX = this.homeX;
                this.genY = this.homeY;
                this.genZ = this.homeZ;
                this.genDirection = 3;
                return true;
            }
            if (world.func_72798_a(this.homeX, this.homeY, this.homeZ - 1) == bridgeBlockID) {
                for (int x1 = -5; x1 < 0; ++x1) {
                    for (int z1 = -1; z1 < 4; ++z1) {
                        if (world.func_72798_a(this.homeX + x1, this.homeY, this.homeZ + z1) == 0) continue;
                        return false;
                    }
                }
                this.genX = this.homeX;
                this.genY = this.homeY;
                this.genZ = this.homeZ;
                this.genDirection = 4;
                return true;
            }
        }
        return false;
    }

    @Override
    public void spawn(World world) {
    }

    @Override
    public void generate(World world) {
        if (this.genDirection == 1) {
            this.genWellOne(world, this.genX, this.genY, this.genZ);
        } else if (this.genDirection == 2) {
            this.genWellTwo(world, this.genX, this.genY, this.genZ);
        } else if (this.genDirection == 3) {
            this.genWellThree(world, this.genX, this.genY, this.genZ);
        } else if (this.genDirection == 4) {
            this.genWellFour(world, this.genX, this.genY, this.genZ);
        }
    }

    private void genWellOne(World world, int x, int y, int z) {
        int a;
        for (int b = 0; b < 3; ++b) {
            this.place(world, x, y, z + b, this.thatchBlock);
        }
        for (a = 0; a < 4; ++a) {
            for (int b = 0; b < 5; ++b) {
                this.place(world, x + a + 1, y, z + b - 1, this.thatchBlock);
                if (a != 0 && a != 3 || b != 0 && b != 4) continue;
                this.placeDownTilGround(world, x + a + 1, y - 1, z + b - 1, this.bambooFence);
            }
        }
        this.place(world, x - 1, y + 1, z - 1, this.bambooFence);
        this.place(world, x - 1, y + 1, z + 3, this.bambooFence);
        this.place(world, x - 1, y + 2, z - 1, this.tikiTorch, 0);
        this.place(world, x - 1, y + 2, z + 3, this.tikiTorch, 0);
        for (a = 0; a < 3; ++a) {
            this.place(world, x + 1, y + 1 + a, z - 1, this.bambooFence);
            this.place(world, x + 1, y + 1 + a, z + 3, this.bambooFence);
            this.place(world, x + 4, y + 1 + a, z - 1, this.bambooFence);
            this.place(world, x + 4, y + 1 + a, z + 3, this.bambooFence);
            if (a != 2) continue;
            this.place(world, x + 1, y + 1 + a, z - 1, this.thatchSlab, 1);
            this.place(world, x + 1, y + 1 + a, z + 3, this.thatchSlab, 1);
            this.place(world, x + 4, y + 1 + a, z - 1, this.thatchSlab, 1);
            this.place(world, x + 4, y + 1 + a, z + 3, this.thatchSlab, 1);
        }
        int j3 = y + 3;
        int k1 = z - 1;
        int k2 = z + 3;
        this.placeWithMetadata(world, x + 2, j3, k1, this.thatchStair, 2);
        this.placeWithMetadata(world, x + 3, j3, k1, this.thatchStair, 2);
        this.placeWithMetadata(world, x + 2, j3, k2, this.thatchStair, 3);
        this.placeWithMetadata(world, x + 3, j3, k2, this.thatchStair, 3);
        for (int d = 0; d < 3; ++d) {
            this.placeWithMetadata(world, x + 4, j3, z + d, this.thatchStair, 1);
            this.place(world, x + 2, j3, z + d, this.thatchBlock);
            this.place(world, x + 3, j3, z + d, this.thatchBlock);
            this.place(world, x + 1, j3, z + d, this.thatchBlock);
        }
        this.placeWithMetadata(world, x + 1, j3, z, this.thatchStair, 0);
        this.placeWithMetadata(world, x + 1, j3, z + 1, this.thatchStair, 0);
        this.placeWithMetadata(world, x + 1, j3, z + 2, this.thatchStair, 0);
        this.place(world, x + 2, j3 + 1, z + 1, this.thatchSlab, 1);
        this.place(world, x + 4, y, z + 1, 0);
        this.place(world, x + 3, y, z + 1, 0);
        this.place(world, x + 2, y, z + 1, 0);
        this.place(world, x + 1, y, z + 1, 0);
        this.placeWithMetadata(world, x + 1, y, z + 1, Block.field_72055_aF, 5);
        this.place(world, x, y - 1, z + 1, this.thatchBlock);
        this.placeWithMetadata(world, x + 1, y - 1, z + 1, Block.field_72055_aF, 5);
    }

    private void genWellTwo(World world, int x, int y, int z) {
        int a;
        for (int b = 0; b < 3; ++b) {
            this.place(world, x, y, z + b, this.thatchBlock);
        }
        for (a = 0; a < 4; ++a) {
            for (int b = 0; b < 5; ++b) {
                this.place(world, x - a - 1, y, z + b - 1, this.thatchBlock);
                if (a != 0 && a != 3 || b != 0 && b != 4) continue;
                this.placeDownTilGround(world, x - a - 1, y - 1, z + b - 1, this.bambooFence);
            }
        }
        this.place(world, x + 1, y + 1, z - 1, this.bambooFence);
        this.place(world, x + 1, y + 1, z + 3, this.bambooFence);
        this.place(world, x + 1, y + 2, z - 1, this.tikiTorch, 0);
        this.place(world, x + 1, y + 2, z + 3, this.tikiTorch, 0);
        for (a = 0; a < 3; ++a) {
            this.place(world, x - 1, y + 1 + a, z - 1, this.bambooFence);
            this.place(world, x - 1, y + 1 + a, z + 3, this.bambooFence);
            this.place(world, x - 4, y + 1 + a, z - 1, this.bambooFence);
            this.place(world, x - 4, y + 1 + a, z + 3, this.bambooFence);
            if (a != 2) continue;
            this.place(world, x - 1, y + 1 + a, z - 1, this.thatchSlab, 1);
            this.place(world, x - 1, y + 1 + a, z + 3, this.thatchSlab, 1);
            this.place(world, x - 4, y + 1 + a, z - 1, this.thatchSlab, 1);
            this.place(world, x - 4, y + 1 + a, z + 3, this.thatchSlab, 1);
        }
        int j3 = y + 3;
        int k1 = z - 1;
        int k2 = z + 3;
        this.placeWithMetadata(world, x - 2, j3, k1, this.thatchStair, 2);
        this.placeWithMetadata(world, x - 3, j3, k1, this.thatchStair, 2);
        this.placeWithMetadata(world, x - 2, j3, k2, this.thatchStair, 3);
        this.placeWithMetadata(world, x - 3, j3, k2, this.thatchStair, 3);
        for (int d = 0; d < 3; ++d) {
            this.placeWithMetadata(world, x - 4, j3, z + d, this.thatchStair, 0);
            this.place(world, x - 2, j3, z + d, this.thatchBlock);
            this.place(world, x - 3, j3, z + d, this.thatchBlock);
            this.place(world, x - 1, j3, z + d, this.thatchBlock);
        }
        this.placeWithMetadata(world, x - 1, j3, z, this.thatchStair, 1);
        this.placeWithMetadata(world, x - 1, j3, z + 1, this.thatchStair, 1);
        this.placeWithMetadata(world, x - 1, j3, z + 2, this.thatchStair, 1);
        this.place(world, x - 2, j3 + 1, z + 1, this.thatchSlab, 1);
        this.place(world, x - 4, y, z + 1, 0);
        this.place(world, x - 3, y, z + 1, 0);
        this.place(world, x - 2, y, z + 1, 0);
        this.place(world, x - 1, y, z + 1, 0);
        this.placeWithMetadata(world, x - 1, y, z + 1, Block.field_72055_aF, 4);
        this.place(world, x, y - 1, z + 1, this.thatchBlock);
        this.placeWithMetadata(world, x - 1, y - 1, z + 1, Block.field_72055_aF, 4);
    }

    private void genWellThree(World world, int x, int y, int z) {
        int a;
        for (int b = 0; b < 3; ++b) {
            this.place(world, x - b - 2, y, z, this.thatchBlock);
        }
        for (a = 0; a < 5; ++a) {
            for (int b = 0; b < 4; ++b) {
                this.place(world, x - a - 1, y, z - b - 1, this.thatchBlock);
                if (a != 0 && a != 4 || b != 0 && b != 3) continue;
                this.placeDownTilGround(world, x - a - 1, y - 1, z - b - 1, this.bambooFence);
            }
        }
        this.place(world, x - 1, y + 1, z + 1, this.bambooFence);
        this.place(world, x - 5, y + 1, z + 1, this.bambooFence);
        this.place(world, x - 1, y + 2, z + 1, this.tikiTorch, 0);
        this.place(world, x - 5, y + 2, z + 1, this.tikiTorch, 0);
        for (a = 0; a < 3; ++a) {
            this.place(world, x - 1, y + 1 + a, z - 1, this.bambooFence);
            this.place(world, x - 5, y + 1 + a, z - 4, this.bambooFence);
            this.place(world, x - 5, y + 1 + a, z - 1, this.bambooFence);
            this.place(world, x - 1, y + 1 + a, z - 4, this.bambooFence);
            if (a != 2) continue;
            this.place(world, x - 1, y + 1 + a, z - 1, this.thatchSlab, 1);
            this.place(world, x - 5, y + 1 + a, z - 1, this.thatchSlab, 1);
            this.place(world, x - 1, y + 1 + a, z - 4, this.thatchSlab, 1);
            this.place(world, x - 5, y + 1 + a, z - 4, this.thatchSlab, 1);
        }
        int j3 = y + 3;
        int k1 = z - 2;
        int k2 = z - 3;
        this.placeWithMetadata(world, x - 1, j3, k1, this.thatchStair, 1);
        this.placeWithMetadata(world, x - 5, j3, k1, this.thatchStair, 0);
        this.placeWithMetadata(world, x - 1, j3, k2, this.thatchStair, 1);
        this.placeWithMetadata(world, x - 5, j3, k2, this.thatchStair, 0);
        for (int d = 0; d < 3; ++d) {
            this.placeWithMetadata(world, x - 2 - d, j3, z - 4, this.thatchStair, 2);
            this.place(world, x - 2, j3, z - 3 + d, this.thatchBlock);
            this.place(world, x - 3, j3, z - 3 + d, this.thatchBlock);
            this.place(world, x - 4, j3, z - 3 + d, this.thatchBlock);
        }
        this.placeWithMetadata(world, x - 2, j3, z - 3 + 2, this.thatchStair, 3);
        this.placeWithMetadata(world, x - 3, j3, z - 3 + 2, this.thatchStair, 3);
        this.placeWithMetadata(world, x - 4, j3, z - 3 + 2, this.thatchStair, 3);
        this.place(world, x - 3, j3 + 1, z - 2, this.thatchSlab, 1);
        this.place(world, x - 3, y, z - 4, 0);
        this.place(world, x - 3, y, z - 3, 0);
        this.place(world, x - 3, y, z - 2, 0);
        this.place(world, x - 3, y, z - 1, 0);
        this.placeWithMetadata(world, x - 3, y, z - 1, Block.field_72055_aF, 2);
        this.place(world, x - 3, y - 1, z, this.thatchBlock);
        this.placeWithMetadata(world, x - 3, y - 1, z - 1, Block.field_72055_aF, 2);
    }

    private void genWellFour(World world, int x, int y, int z) {
        int a;
        for (int b = 0; b < 3; ++b) {
            this.place(world, x - b - 2, y, z, this.thatchBlock);
        }
        for (a = 0; a < 5; ++a) {
            for (int b = 0; b < 4; ++b) {
                this.place(world, x - a - 1, y, z + b + 1, this.thatchBlock);
                if (a != 0 && a != 4 || b != 0 && b != 3) continue;
                this.placeDownTilGround(world, x - a - 1, y - 1, z + b + 1, this.bambooFence);
            }
        }
        this.place(world, x - 1, y + 1, z - 1, this.bambooFence);
        this.place(world, x - 5, y + 1, z - 1, this.bambooFence);
        this.place(world, x - 1, y + 2, z - 1, this.tikiTorch, 0);
        this.place(world, x - 5, y + 2, z - 1, this.tikiTorch, 0);
        for (a = 0; a < 3; ++a) {
            this.place(world, x - 1, y + 1 + a, z + 1, this.bambooFence);
            this.place(world, x - 5, y + 1 + a, z + 4, this.bambooFence);
            this.place(world, x - 5, y + 1 + a, z + 1, this.bambooFence);
            this.place(world, x - 1, y + 1 + a, z + 4, this.bambooFence);
            if (a != 2) continue;
            this.place(world, x - 1, y + 1 + a, z + 1, this.thatchSlab, 1);
            this.place(world, x - 5, y + 1 + a, z + 1, this.thatchSlab, 1);
            this.place(world, x - 1, y + 1 + a, z + 4, this.thatchSlab, 1);
            this.place(world, x - 5, y + 1 + a, z + 4, this.thatchSlab, 1);
        }
        int j3 = y + 3;
        int k1 = z + 2;
        int k2 = z + 3;
        this.placeWithMetadata(world, x - 1, j3, k1, this.thatchStair, 1);
        this.placeWithMetadata(world, x - 5, j3, k1, this.thatchStair, 0);
        this.placeWithMetadata(world, x - 1, j3, k2, this.thatchStair, 1);
        this.placeWithMetadata(world, x - 5, j3, k2, this.thatchStair, 0);
        for (int d = 0; d < 3; ++d) {
            this.placeWithMetadata(world, x - 2 - d, j3, z + 4, this.thatchStair, 3);
            this.place(world, x - 2, j3, z + 3 - d, this.thatchBlock);
            this.place(world, x - 3, j3, z + 3 - d, this.thatchBlock);
            this.place(world, x - 4, j3, z + 3 - d, this.thatchBlock);
        }
        this.placeWithMetadata(world, x - 2, j3, z + 3 - 2, this.thatchStair, 2);
        this.placeWithMetadata(world, x - 3, j3, z + 3 - 2, this.thatchStair, 2);
        this.placeWithMetadata(world, x - 4, j3, z + 3 - 2, this.thatchStair, 2);
        this.place(world, x - 3, j3 + 1, z + 2, this.thatchSlab, 1);
        this.place(world, x - 3, y, z + 4, 0);
        this.place(world, x - 3, y, z + 3, 0);
        this.place(world, x - 3, y, z + 2, 0);
        this.place(world, x - 3, y, z + 1, 0);
        this.placeWithMetadata(world, x - 3, y, z + 1, Block.field_72055_aF, 3);
        this.place(world, x - 3, y - 1, z, this.thatchBlock);
        this.placeWithMetadata(world, x - 3, y - 1, z + 1, Block.field_72055_aF, 3);
    }
}

