/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.world.worldgen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import tropicraft.blocks.TropicraftBlocks;

public abstract class TCGenBase
extends WorldGenerator {
    World worldObj;
    Random rand;
    static final byte[] otherCoordPairs = new byte[]{2, 0, 0, 1, 2, 1};
    boolean isRainforestOnly;
    List<Integer> standardAllowedBlocks;

    public TCGenBase(World world, Random random, boolean isRainforestOnly) {
        this.standardAllowedBlocks = Arrays.asList(0, Block.field_71952_K.field_71990_ca, Block.field_71962_X.field_71990_ca, Block.field_72037_aS.field_71990_ca);
        this.worldObj = world;
        this.rand = random;
        this.isRainforestOnly = isRainforestOnly;
    }

    public TCGenBase(World world, Random random) {
        this.standardAllowedBlocks = Arrays.asList(0, Block.field_71952_K.field_71990_ca, Block.field_71962_X.field_71990_ca, Block.field_72037_aS.field_71990_ca);
        this.worldObj = world;
        this.rand = random;
        this.isRainforestOnly = true;
    }

    public boolean isLeafId(int id) {
        return id == Block.field_71952_K.field_71990_ca || id == TropicraftBlocks.tropicsLeaves.field_71990_ca || id == TropicraftBlocks.fruitLeaves.field_71990_ca;
    }

    public abstract boolean generate(int var1, int var2, int var3);

    public boolean func_76484_a(World world, Random rand, int i, int j, int k) {
        this.worldObj = world;
        this.rand = rand;
        return this.generate(i, j, k);
    }

    public boolean genCircle(int x, int y, int z, double outerRadius, double innerRadius, int id, int meta, boolean solid) {
        boolean hasGenned = false;
        for (int i = (int)(-outerRadius - 1.0) + x; i <= (int)(outerRadius + 1.0) + x; ++i) {
            for (int k = (int)(-outerRadius - 1.0) + z; k <= (int)(outerRadius + 1.0) + z; ++k) {
                double d = (i - x) * (i - x) + (k - z) * (k - z);
                if (!(d <= outerRadius * outerRadius) || !(d >= innerRadius * innerRadius) || !this.worldObj.func_72799_c(i, y, k) && !solid || !this.worldObj.func_72832_d(i, y, k, id, meta, 3)) continue;
                hasGenned = true;
            }
        }
        return hasGenned;
    }

    public boolean checkCircle(int i, int j, int k, double outerRadius, double innerRadius, List allowedBlockList) {
        for (int x = (int)(-outerRadius - 2.0) + i; x < (int)(outerRadius + 2.0) + i; ++x) {
            for (int z = (int)(-outerRadius - 2.0) + k; z < (int)(outerRadius + 2.0) + k; ++z) {
                double d = (i - x) * (i - x) + (k - z) * (k - z);
                if (!(d <= outerRadius * outerRadius) || !(d >= innerRadius * innerRadius)) continue;
                int bId = this.worldObj.func_72798_a(x, j, z);
                if (!allowedBlockList.contains(bId)) {
                    // empty if block
                }
                return false;
            }
        }
        return true;
    }

    public boolean checkBlockLine(int[] ai, int[] ai1, List allowedBlockList) {
        int[] ai2 = new int[]{0, 0, 0};
        int j = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[j])) continue;
            j = byte0;
        }
        if (ai2[j] == 0) {
            return false;
        }
        byte byte1 = otherCoordPairs[j];
        byte byte2 = otherCoordPairs[j + 3];
        int byte3 = ai2[j] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[j];
        double d1 = (double)ai2[byte2] / (double)ai2[j];
        int[] ai3 = new int[]{0, 0, 0};
        int l = ai2[j] + byte3;
        for (int k = 0; k != l; k += byte3) {
            ai3[j] = MathHelper.func_76128_c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = MathHelper.func_76128_c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = MathHelper.func_76128_c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            int bId = this.worldObj.func_72798_a(ai3[0], ai3[1], ai3[2]);
            List<Integer> standardAllowedBlocks = Arrays.asList(0, Block.field_71952_K.field_71990_ca, Block.field_71962_X.field_71990_ca, Block.field_72037_aS.field_71990_ca);
            if (allowedBlockList.contains(bId)) continue;
            return false;
        }
        return true;
    }

    public ArrayList<int[]> placeBlockLine(int[] ai, int[] ai1, int i, int meta) {
        ArrayList<int[]> places = new ArrayList<int[]>();
        int[] ai2 = new int[]{0, 0, 0};
        int j = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[j])) continue;
            j = byte0;
        }
        if (ai2[j] == 0) {
            return null;
        }
        byte byte1 = otherCoordPairs[j];
        byte byte2 = otherCoordPairs[j + 3];
        int byte3 = ai2[j] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[j];
        double d1 = (double)ai2[byte2] / (double)ai2[j];
        int[] ai3 = new int[]{0, 0, 0};
        int l = ai2[j] + byte3;
        for (int k = 0; k != l; k += byte3) {
            ai3[j] = MathHelper.func_76128_c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = MathHelper.func_76128_c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = MathHelper.func_76128_c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            this.worldObj.func_72832_d(ai3[0], ai3[1], ai3[2], i, meta, 3);
            places.add(new int[]{ai3[0], ai3[1], ai3[2]});
        }
        return places;
    }

    public boolean checkBlockCircleLine(int[] ai, int[] ai1, double outerRadius, double innerRadius, List allowedBlockList) {
        ArrayList places = new ArrayList();
        int[] ai2 = new int[]{0, 0, 0};
        int j = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[j])) continue;
            j = byte0;
        }
        if (ai2[j] == 0) {
            return false;
        }
        byte byte1 = otherCoordPairs[j];
        byte byte2 = otherCoordPairs[j + 3];
        int byte3 = ai2[j] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[j];
        double d1 = (double)ai2[byte2] / (double)ai2[j];
        int[] ai3 = new int[]{0, 0, 0};
        int l = ai2[j] + byte3;
        for (int k = 0; k != l; k += byte3) {
            ai3[j] = MathHelper.func_76128_c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = MathHelper.func_76128_c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = MathHelper.func_76128_c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            if (this.checkCircle(ai3[0], ai3[1], ai3[2], outerRadius, innerRadius, allowedBlockList)) continue;
            return false;
        }
        return true;
    }

    public ArrayList<int[]> checkAndPlaceBlockCircleLine(int[] ai, int[] ai1, double outerRadius, double innerRadius, int i, int meta, List allowedBlockList) {
        int k;
        ArrayList<int[]> places = new ArrayList<int[]>();
        int[] ai2 = new int[]{0, 0, 0};
        int j = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[j])) continue;
            j = byte0;
        }
        if (ai2[j] == 0) {
            return null;
        }
        byte byte1 = otherCoordPairs[j];
        byte byte2 = otherCoordPairs[j + 3];
        int byte3 = ai2[j] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[j];
        double d1 = (double)ai2[byte2] / (double)ai2[j];
        int[] ai3 = new int[]{0, 0, 0};
        int l = ai2[j] + byte3;
        for (k = 0; k != l; k += byte3) {
            ai3[j] = MathHelper.func_76128_c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = MathHelper.func_76128_c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = MathHelper.func_76128_c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            if (this.checkCircle(ai3[0], ai3[1], ai3[2], outerRadius, innerRadius, allowedBlockList)) continue;
            return null;
        }
        l = ai2[j] + byte3;
        while (k != l) {
            ai3[j] = MathHelper.func_76128_c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = MathHelper.func_76128_c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = MathHelper.func_76128_c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            this.genCircle(ai3[0], ai3[1], ai3[2], outerRadius, innerRadius, i, meta, true);
            places.add(new int[]{ai3[0], ai3[1], ai3[2]});
            k += byte3;
        }
        return places;
    }

    public ArrayList<int[]> checkAndPlaceBlockLine(int[] ai, int[] ai1, int i, int meta, List allowedBlockList) {
        int k;
        ArrayList<int[]> places = new ArrayList<int[]>();
        int[] ai2 = new int[]{0, 0, 0};
        int j = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[j])) continue;
            j = byte0;
        }
        if (ai2[j] == 0) {
            return null;
        }
        byte byte1 = otherCoordPairs[j];
        byte byte2 = otherCoordPairs[j + 3];
        int byte3 = ai2[j] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[j];
        double d1 = (double)ai2[byte2] / (double)ai2[j];
        int[] ai3 = new int[]{0, 0, 0};
        int l = ai2[j] + byte3;
        for (k = 0; k != l; k += byte3) {
            ai3[j] = MathHelper.func_76128_c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = MathHelper.func_76128_c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = MathHelper.func_76128_c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            int bId = this.worldObj.func_72798_a(ai3[0], ai3[1], ai3[2]);
            if (allowedBlockList.contains(bId)) continue;
            return null;
        }
        l = ai2[j] + byte3;
        while (k != l) {
            ai3[j] = MathHelper.func_76128_c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = MathHelper.func_76128_c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = MathHelper.func_76128_c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            this.worldObj.func_72832_d(ai3[0], ai3[1], ai3[2], i, meta, 3);
            places.add(new int[]{ai3[0], ai3[1], ai3[2]});
            k += byte3;
        }
        return places;
    }

    public ArrayList<int[]> placeBlockCircleLine(int[] ai, int[] ai1, double distance, double distance2, int i, int meta) {
        ArrayList<int[]> places = new ArrayList<int[]>();
        int[] ai2 = new int[]{0, 0, 0};
        int j = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[j])) continue;
            j = byte0;
        }
        if (ai2[j] == 0) {
            return null;
        }
        byte byte1 = otherCoordPairs[j];
        byte byte2 = otherCoordPairs[j + 3];
        int byte3 = ai2[j] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[j];
        double d1 = (double)ai2[byte2] / (double)ai2[j];
        int[] ai3 = new int[]{0, 0, 0};
        int l = ai2[j] + byte3;
        for (int k = 0; k != l; k += byte3) {
            ai3[j] = MathHelper.func_76128_c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = MathHelper.func_76128_c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = MathHelper.func_76128_c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            this.genCircle(ai3[0], ai3[1], ai3[2], distance, distance2, i, meta, true);
            places.add(new int[]{ai3[0], ai3[1], ai3[2]});
        }
        return places;
    }

    public void genSphere(int x, int y, int z, int outerRadius, int id, int meta) {
        for (int i = x - outerRadius; i < x + outerRadius; ++i) {
            for (int j = y - outerRadius; j < y + outerRadius; ++j) {
                for (int k = z - outerRadius; k < z + outerRadius; ++k) {
                    int distance1;
                    if (!this.worldObj.func_72799_c(i, j, k) || (distance1 = (i - x) * (i - x) + (j - y) * (j - y) + (k - z) * (k - z)) > outerRadius) continue;
                    this.worldObj.func_72832_d(i, j, k, id, meta, 3);
                }
            }
        }
    }

    public int getTerrainHeightAt(int x, int z) {
        for (int y = 256; y > 0; --y) {
            int id = this.worldObj.func_72798_a(x, y, z);
            if (id != Block.field_71979_v.field_71990_ca && id != Block.field_71980_u.field_71990_ca && id != Block.field_71939_E.field_71990_ca && id != Block.field_71981_t.field_71990_ca) continue;
            return y + 1;
        }
        return 0;
    }

    public double randAngle() {
        return this.rand.nextDouble() * Math.PI * 2.0;
    }
}

