/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.world.worldgen;

import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import tropicraft.blocks.TropicraftBlocks;
import tropicraft.blocks.tileentities.TileEntityBambooChest;
import tropicraft.items.TropicraftItems;
import tropicraft.world.worldgen.TCGenBase;

public class WorldGenSunkenShip
extends TCGenBase {
    private int x;
    private int z;
    private final int DIR;

    public WorldGenSunkenShip(World world, Random random) {
        super(world, random, true);
        this.DIR = this.rand.nextInt(4);
    }

    @Override
    public boolean generate(int i, int j, int k) {
        this.x = i;
        this.z = k;
        j = this.getTerrainHeightAt(i, k);
        if (this.worldObj.func_72798_a(i, j + 4, k) != TropicraftBlocks.tropicsWaterStationary.field_71990_ca) {
            return false;
        }
        int length = this.rand.nextInt(25) + 25;
        int y = ++j;
        while (true) {
            boolean hasGenned = false;
            int fib = 2;
            int lastFib = 1;
            int width = y - j;
            for (int x = 0; x < length; ++x) {
                if (x == fib && (double)x <= (double)length / 3.0) {
                    ++width;
                    lastFib = (fib += lastFib) - lastFib;
                }
                if (x > length - 3) {
                    --width;
                }
                if (width < 0) continue;
                for (int z = -width; z <= width; ++z) {
                    if (this.rand.nextInt(5) >= 3) continue;
                    if (y == j || x == length - 1) {
                        this.placeBlockWithDir(x, y, z, TropicraftBlocks.tropicsBuildingBlock.field_71990_ca, 1);
                        if (z == -width || z == width || x == length - 1) {
                            this.placeBlockWithDir(x, y + 1, z, TropicraftBlocks.tropicsBuildingBlock.field_71990_ca, 1);
                        }
                        if (x != length / 2 || z != 0) continue;
                        this.placeBlockWithDir(x, y + 1, z, TropicraftBlocks.tropicsBuildingBlock.field_71990_ca, 1);
                        this.placeBlockWithDir(x, y + 2, z, TropicraftBlocks.tropicsBuildingBlock.field_71990_ca, 1);
                        this.placeBlockWithDir(x, y + 3, z, TropicraftBlocks.tropicsBuildingBlock.field_71990_ca, 1);
                        continue;
                    }
                    if (x == length / 2 && z == 0 && y == j - 2) {
                        this.placeBlockWithDir(x, y, z, TropicraftBlocks.bambooChest.field_71990_ca, 0);
                        TileEntityBambooChest chest = (TileEntityBambooChest)this.getTEWithDir(x, y, z);
                        if (chest == null) continue;
                        chest.func_70299_a(0, this.randLoot());
                        continue;
                    }
                    if (z == -width || z == width) {
                        this.placeBlockWithDir(x, y, z, TropicraftBlocks.tropicsBuildingBlock.field_71990_ca, 1);
                        continue;
                    }
                    this.placeBlockWithDir(x, y, z, 0, 0);
                }
                hasGenned = true;
            }
            if (!hasGenned) break;
            --y;
        }
        return false;
    }

    private void placeBlockWithDir(int i, int j, int k, int blockID, int meta) {
        switch (this.DIR) {
            case 2: {
                this.worldObj.func_72832_d(this.x + i, j, this.z + k, blockID, meta, 3);
                return;
            }
            case 0: {
                this.worldObj.func_72832_d(this.x + k, j, this.z + i, blockID, meta, 3);
                return;
            }
            case 3: {
                this.worldObj.func_72832_d(this.x - i, j, this.z - k, blockID, meta, 3);
                return;
            }
            case 1: {
                this.worldObj.func_72832_d(this.x - k, j, this.z - i, blockID, meta, 3);
                return;
            }
        }
    }

    private TileEntity getTEWithDir(int i, int j, int k) {
        switch (this.DIR) {
            case 2: {
                return this.worldObj.func_72796_p(this.x + i, j, this.z + k);
            }
            case 0: {
                return this.worldObj.func_72796_p(this.x + k, j, this.z + i);
            }
            case 3: {
                return this.worldObj.func_72796_p(this.x - i, j, this.z - k);
            }
            case 1: {
                return this.worldObj.func_72796_p(this.x - k, j, this.z - i);
            }
        }
        return null;
    }

    public ItemStack randLoot() {
        int picker = this.rand.nextInt(18);
        if (picker < 6) {
            return new ItemStack(TropicraftItems.bambooChute, this.rand.nextInt(20) + 1);
        }
        if (picker < 8) {
            return new ItemStack(TropicraftItems.coconutBomb, this.rand.nextInt(3) + 1);
        }
        if (picker < 10) {
            return new ItemStack(TropicraftItems.scale, this.rand.nextInt(3) + 1);
        }
        if (picker < 12) {
            return new ItemStack(TropicraftBlocks.tropicsBuildingBlock, this.rand.nextInt(20) + 1);
        }
        if (picker < 15) {
            return new ItemStack(TropicraftItems.cookedFrogLeg, this.rand.nextInt(4) + 1);
        }
        if (picker == 14) {
            return new ItemStack(TropicraftItems.ashenMasks, 1, this.rand.nextInt(7));
        }
        if (picker == 15) {
            return new ItemStack(TropicraftItems.recordTradeWinds, 1);
        }
        if (picker == 16) {
            return new ItemStack(TropicraftItems.recordEasternIsles, 1);
        }
        return new ItemStack(TropicraftItems.blowGun, 1);
    }
}

