/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.world.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import tropicraft.blocks.TropicraftBlocks;
import tropicraft.world.biomes.BiomeGenTropicraft;
import tropicraft.world.worldgen.TCGenBase;

public class WorldGenTualang
extends TCGenBase {
    private int woodBlockId;
    private int leafBlockID;
    private int leafMeta;
    private int maxHeight;
    private int baseHeight;

    public WorldGenTualang(World world, Random random, int mH, int bH) {
        super(world, random, true);
        this.woodBlockId = TropicraftBlocks.treeWood.field_71990_ca;
        this.leafBlockID = TropicraftBlocks.tropicsLeaves.field_71990_ca;
        this.leafMeta = 3;
        this.maxHeight = mH;
        this.baseHeight = bH;
    }

    public WorldGenTualang(World world, Random random, int mH, int bH, boolean rainforestOnly) {
        super(world, random, rainforestOnly);
        this.woodBlockId = TropicraftBlocks.treeWood.field_71990_ca;
        this.leafBlockID = TropicraftBlocks.tropicsLeaves.field_71990_ca;
        this.leafMeta = 3;
        this.maxHeight = mH;
        this.baseHeight = bH;
    }

    @Override
    public boolean generate(int i, int j, int k) {
        int bId;
        int y;
        int z;
        int x;
        if (this.isRainforestOnly && !BiomeGenTropicraft.rainforestBiomes.contains(this.worldObj.func_72807_a(i, k))) {
            return false;
        }
        int height = this.rand.nextInt(this.maxHeight - this.baseHeight) + this.baseHeight + j;
        int branches = this.rand.nextInt(6) + 4;
        if (height + 6 > 127) {
            return false;
        }
        if (this.worldObj.func_72798_a(i, j - 1, k) != Block.field_71979_v.field_71990_ca && this.worldObj.func_72798_a(i, j - 1, k) != Block.field_71980_u.field_71990_ca) {
            return false;
        }
        for (x = i - 1; x <= i + 1; ++x) {
            for (z = k - 1; z <= k + 1; ++z) {
                for (y = j; y < j + height; ++y) {
                    bId = this.worldObj.func_72798_a(x, y, z);
                    if (bId == 0 || this.isLeafId(bId) || bId == Block.field_71962_X.field_71990_ca || bId == Block.field_72037_aS.field_71990_ca) continue;
                    return false;
                }
            }
        }
        for (x = i - 9; x >= i + 9; ++x) {
            for (z = k - 9; z >= k + 9; ++z) {
                for (y = height; y < height + 6; ++y) {
                    bId = this.worldObj.func_72798_a(x, y, z);
                    if (bId == 0 || this.isLeafId(bId) || bId == Block.field_71962_X.field_71990_ca || bId == Block.field_72037_aS.field_71990_ca) continue;
                    return false;
                }
            }
        }
        this.genCircle(i, j - 1, k, 1.0, 0.0, Block.field_71979_v.field_71990_ca, 0, true);
        this.placeBlockCircleLine(new int[]{i, j, k}, new int[]{i, height, k}, 1.0, 0.0, this.woodBlockId, 1);
        for (int lVar = 0; lVar < branches; ++lVar) {
            double randAngle = this.randAngle();
            int branchHeight = this.rand.nextInt(4) + 2 + height;
            int branchLength = this.rand.nextInt(5) + 4;
            int ax = (int)Math.round((double)branchLength * Math.sin(randAngle) + (double)i);
            int az = (int)Math.round((double)branchLength * Math.cos(randAngle) + (double)k);
            int tax = (int)Math.round(Math.sin(randAngle) + (double)i);
            int taz = (int)Math.round(Math.cos(randAngle) + (double)k);
            this.placeBlockLine(new int[]{tax, height, taz}, new int[]{ax, branchHeight, az}, this.woodBlockId, 1);
            this.genCircle(ax, branchHeight, az, 2.0, 1.0, this.leafBlockID, this.leafMeta, false);
            this.genCircle(ax, branchHeight + 1, az, 3.0, 2.0, this.leafBlockID, this.leafMeta, false);
        }
        return true;
    }
}

