/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen;

import biomesoplenty.api.Blocks;
import biomesoplenty.api.Fluids;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenHive
extends WorldGenerator {
    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int baseWidth = 4 + rand.nextInt(2);
        int baseHeight = 8 + rand.nextInt(2);
        for (int air = 0; air < 26; ++air) {
            if (world.func_72798_a(x, y + 3, z) == Block.field_72012_bb.field_71990_ca && world.func_72799_c(x, y + 2 - air, z)) continue;
            return false;
        }
        for (int cubeno = 0; cubeno < 4; ++cubeno) {
            float chance = 0.0f;
            int meta = 0;
            switch (cubeno) {
                case 0: {
                    chance = 0.25f;
                    meta = 0;
                    break;
                }
                case 1: {
                    chance = 1.0f;
                    meta = 0;
                    break;
                }
                case 2: {
                    chance = 1.0f;
                    meta = 1;
                    break;
                }
                case 3: {
                    chance = 0.5f;
                    meta = 1;
                }
            }
            int honeychance = rand.nextInt(2);
            this.generateHiveCubeSmall(world, x, y + cubeno, z, baseHeight - 11 + cubeno * 2, baseWidth - 1 + cubeno, cubeno, chance, meta);
            this.generateHiveCube(world, x, y - 2 + cubeno, z, baseHeight + cubeno * 2, baseWidth + cubeno, cubeno, chance, honeychance, meta);
            this.generateHiveCubeSmall(world, x, y - (baseHeight + 6) + cubeno, z, baseHeight - 10 + cubeno * 2, baseWidth - 1 + cubeno, cubeno, chance, meta);
            this.generateHiveCubeSmall(world, x, y - (baseHeight + 7) + cubeno, z, baseHeight - 9 + cubeno * 2, baseWidth - 2 + cubeno, cubeno, chance, meta);
            this.generateHiveCubeSmall(world, x, y - (baseHeight + 9) + cubeno, z, baseHeight - 9 + cubeno * 2, baseWidth - 4 + cubeno, cubeno, chance, meta);
            this.spawnWasps(world, rand, x, y, z);
            this.spawnEmptyHoneycombs(world, rand, x, y, z);
            this.spawnFilledHoneycombs(world, rand, x, y, z);
        }
        return true;
    }

    public void generateHiveCube(World world, int origx, int origy, int origz, int height, int width, int cubeno, float chance, int honeychance, int meta) {
        for (int hLayer = 0; hLayer < height; ++hLayer) {
            for (int i = -width; i < width; ++i) {
                for (int j = -width; j < width; ++j) {
                    if ((hLayer == 0 || hLayer == height - 1) && world.field_73012_v.nextFloat() <= chance) {
                        world.func_72832_d(origx + i, origy - hLayer, origz + j, ((Block)Blocks.hive.get()).field_71990_ca, meta, 2);
                    } else if ((i == -width || i == width - 1 || j == -width || j == width - 1) && world.field_73012_v.nextFloat() <= chance) {
                        world.func_72832_d(origx + i, origy - hLayer, origz + j, ((Block)Blocks.hive.get()).field_71990_ca, meta, 2);
                    }
                    if (hLayer > height / 2) {
                        if (honeychance == 0) {
                            if (cubeno < 2 && world.func_72798_a(origx + i, origy - hLayer, origz + j) != ((Block)Blocks.hive.get()).field_71990_ca) {
                                world.func_72832_d(origx + i, origy - hLayer, origz + j, ((Block)Fluids.honey.get()).field_71990_ca, 7, 2);
                            }
                            if (cubeno >= 2 || world.func_72798_a(origx + i, origy - hLayer, origz + j) != ((Block)Blocks.hive.get()).field_71990_ca || world.func_72805_g(origx + i, origy - hLayer, origz + j) == 0) continue;
                            world.func_72832_d(origx + i, origy - hLayer, origz + j, ((Block)Fluids.honey.get()).field_71990_ca, 7, 2);
                            continue;
                        }
                        if (cubeno < 2 && world.func_72798_a(origx + i, origy - hLayer, origz + j) != ((Block)Blocks.hive.get()).field_71990_ca) {
                            world.func_94571_i(origx + i, origy - hLayer, origz + j);
                        }
                        if (cubeno >= 2 || world.func_72798_a(origx + i, origy - hLayer, origz + j) != ((Block)Blocks.hive.get()).field_71990_ca || world.func_72805_g(origx + i, origy - hLayer, origz + j) == 0) continue;
                        world.func_94571_i(origx + i, origy - hLayer, origz + j);
                        continue;
                    }
                    if (honeychance == 0) {
                        if (hLayer == height / 2) {
                            if (cubeno < 2 && world.func_72798_a(origx + i, origy - hLayer, origz + j) != ((Block)Blocks.hive.get()).field_71990_ca) {
                                world.func_72832_d(origx + i, origy - hLayer, origz + j, ((Block)Blocks.honeyBlock.get()).field_71990_ca, 0, 2);
                            }
                            if (cubeno >= 2 || world.func_72798_a(origx + i, origy - hLayer, origz + j) != ((Block)Blocks.hive.get()).field_71990_ca || world.func_72805_g(origx + i, origy - hLayer, origz + j) == 0) continue;
                            world.func_72832_d(origx + i, origy - hLayer, origz + j, ((Block)Blocks.honeyBlock.get()).field_71990_ca, 0, 2);
                            continue;
                        }
                        if (cubeno < 2 && world.func_72798_a(origx + i, origy - hLayer, origz + j) != ((Block)Blocks.hive.get()).field_71990_ca) {
                            world.func_94571_i(origx + i, origy - hLayer, origz + j);
                        }
                        if (cubeno >= 2 || world.func_72798_a(origx + i, origy - hLayer, origz + j) != ((Block)Blocks.hive.get()).field_71990_ca || world.func_72805_g(origx + i, origy - hLayer, origz + j) == 0) continue;
                        world.func_94571_i(origx + i, origy - hLayer, origz + j);
                        continue;
                    }
                    if (cubeno < 2 && world.func_72798_a(origx + i, origy - hLayer, origz + j) != ((Block)Blocks.hive.get()).field_71990_ca) {
                        world.func_94571_i(origx + i, origy - hLayer, origz + j);
                    }
                    if (cubeno >= 2 || world.func_72798_a(origx + i, origy - hLayer, origz + j) != ((Block)Blocks.hive.get()).field_71990_ca || world.func_72805_g(origx + i, origy - hLayer, origz + j) == 0) continue;
                    world.func_94571_i(origx + i, origy - hLayer, origz + j);
                }
            }
        }
    }

    public void generateHiveCubeSmall(World world, int origx, int origy, int origz, int height, int width, int cubeno, float chance, int meta) {
        for (int hLayer = 0; hLayer < height; ++hLayer) {
            for (int i = -width; i < width; ++i) {
                for (int j = -width; j < width; ++j) {
                    if ((hLayer == 0 || hLayer == height - 1) && world.field_73012_v.nextFloat() <= chance) {
                        world.func_72832_d(origx + i, origy - hLayer, origz + j, ((Block)Blocks.hive.get()).field_71990_ca, 1, 2);
                        continue;
                    }
                    if (i != -width && i != width - 1 && j != -width && j != width - 1 || !(world.field_73012_v.nextFloat() <= chance)) continue;
                    world.func_72832_d(origx + i, origy - hLayer, origz + j, ((Block)Blocks.hive.get()).field_71990_ca, 1, 2);
                }
            }
        }
    }

    public void spawnWasps(World world, Random rand, int x, int y, int z) {
        for (int spawn = 0; spawn < 50; ++spawn) {
            int spawnz;
            int spawny;
            int spawnx = x - 12 + rand.nextInt(24);
            if (world.func_72798_a(spawnx, spawny = y - rand.nextInt(24), spawnz = z - 12 + rand.nextInt(24)) != ((Block)Blocks.hive.get()).field_71990_ca || world.func_72805_g(spawnx, spawny, spawnz) != 1 || world.func_72798_a(spawnx - 1, spawny, spawnz) != ((Block)Blocks.hive.get()).field_71990_ca || world.func_72798_a(spawnx + 1, spawny, spawnz) != ((Block)Blocks.hive.get()).field_71990_ca || world.func_72798_a(spawnx, spawny, spawnz - 1) != ((Block)Blocks.hive.get()).field_71990_ca || world.func_72798_a(spawnx, spawny, spawnz + 1) != ((Block)Blocks.hive.get()).field_71990_ca || world.func_72798_a(spawnx, spawny - 1, spawnz) != ((Block)Blocks.hive.get()).field_71990_ca || world.func_72798_a(spawnx, spawny + 1, spawnz) != ((Block)Blocks.hive.get()).field_71990_ca || world.func_72805_g(spawnx - 1, spawny, spawnz) != 1 || world.func_72805_g(spawnx + 1, spawny, spawnz) != 1 || world.func_72805_g(spawnx, spawny, spawnz - 1) != 1 || world.func_72805_g(spawnx, spawny, spawnz + 1) != 1 || world.func_72805_g(spawnx, spawny - 1, spawnz) != 1 || world.func_72805_g(spawnx, spawny + 1, spawnz) != 1) continue;
            world.func_94575_c(spawnx, spawny, spawnz, Block.field_72065_as.field_71990_ca);
            TileEntityMobSpawner tileentitymobspawner = (TileEntityMobSpawner)world.func_72796_p(spawnx, spawny, spawnz);
            if (tileentitymobspawner == null) continue;
            tileentitymobspawner.func_98049_a().func_98272_a("BiomesOPlenty.Wasp");
        }
    }

    public void spawnEmptyHoneycombs(World world, Random rand, int x, int y, int z) {
        for (int spawn = 0; spawn < 50; ++spawn) {
            int spawnz;
            int spawny;
            int spawnx = x - 8 + rand.nextInt(16);
            if (world.func_72798_a(spawnx, spawny = y - rand.nextInt(12), spawnz = z - 8 + rand.nextInt(16)) != ((Block)Blocks.hive.get()).field_71990_ca || world.func_72805_g(spawnx, spawny, spawnz) != 0) continue;
            world.func_72832_d(spawnx, spawny, spawnz, ((Block)Blocks.hive.get()).field_71990_ca, 2, 2);
        }
    }

    public void spawnFilledHoneycombs(World world, Random rand, int x, int y, int z) {
        for (int spawn = 0; spawn < 20; ++spawn) {
            int spawnz;
            int spawny;
            int spawnx = x - 8 + rand.nextInt(16);
            if (world.func_72798_a(spawnx, spawny = y - rand.nextInt(12), spawnz = z - 8 + rand.nextInt(16)) != ((Block)Blocks.hive.get()).field_71990_ca || world.func_72805_g(spawnx, spawny, spawnz) != 0) continue;
            world.func_72832_d(spawnx, spawny, spawnz, ((Block)Blocks.hive.get()).field_71990_ca, 3, 2);
        }
    }
}

