/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.prefab.entity;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.network.PacketDispatcher;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import micdoodle8.mods.galacticraft.api.entity.ICargoEntity;
import micdoodle8.mods.galacticraft.api.entity.IDockable;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.api.tile.ILandingPadAttachable;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlockLandingPadFull;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.core.entities.player.GCCorePlayerMP;
import micdoodle8.mods.galacticraft.core.event.GCCoreLandingPadRemovalEvent;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketManager;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityFuelLoader;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityLandingPad;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public abstract class EntityAutoRocket
extends EntitySpaceshipBase
implements IDockable,
IInventory {
    public FluidTank fuelTank = new FluidTank(this.getFuelTankCapacity());
    public int destinationFrequency = -1;
    public Vector3 targetVec;
    public int targetDimension;
    protected ItemStack[] cargoItems;
    private IFuelDock landingPad;
    public boolean landing;
    public EnumAutoLaunch autoLaunchSetting;
    private static boolean marsLoaded = Loader.isModLoaded((String)"GalacticraftMars");
    public int autoLaunchCountdown;
    public String statusMessage;
    public int statusMessageCooldown;
    public int lastStatusMessageCooldown;
    public boolean statusValid;
    protected double lastMotionY;
    protected double lastLastMotionY;
    private boolean waitForPlayer;

    public EntityAutoRocket(World world) {
        super(world);
        this.field_70129_M = 0.0f;
    }

    public EntityAutoRocket(World world, double posX, double posY, double posZ) {
        this(world);
        this.func_70105_a(0.98f, 2.0f);
        this.field_70129_M = this.field_70131_O / 2.0f;
        this.func_70107_b(posX, posY, posZ);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = posX;
        this.field_70167_r = posY;
        this.field_70166_s = posZ;
    }

    public abstract int getFuelTankCapacity();

    public boolean checkLaunchValidity() {
        this.statusMessageCooldown = 40;
        if (this.hasValidFuel()) {
            if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.UNIGNITED.getPhase() && !this.field_70170_p.field_72995_K) {
                if (!this.setFrequency()) {
                    this.destinationFrequency = -1;
                    this.statusMessage = "\u00a7cFrequency#\u00a7cNot Set";
                    return false;
                }
                this.statusMessage = "\u00a7aSuccess";
                return true;
            }
        } else {
            this.destinationFrequency = -1;
            this.statusMessage = "\u00a7cNot Enough#\u00a7cFuel";
            return false;
        }
        this.destinationFrequency = -1;
        return false;
    }

    public boolean setFrequency() {
        if (!marsLoaded) {
            return false;
        }
        for (int x = MathHelper.func_76128_c((double)this.field_70165_t) - 1; x <= MathHelper.func_76128_c((double)this.field_70165_t) + 1; ++x) {
            for (int y = MathHelper.func_76128_c((double)this.field_70163_u) - 3; y <= MathHelper.func_76128_c((double)this.field_70163_u) + 1; ++y) {
                for (int z = MathHelper.func_76128_c((double)this.field_70161_v) - 1; z <= MathHelper.func_76128_c((double)this.field_70161_v) + 1; ++z) {
                    TileEntity tile = this.field_70170_p.func_72796_p(x, y, z);
                    if (!(tile instanceof IFuelDock)) continue;
                    IFuelDock dock = (IFuelDock)tile;
                    try {
                        int controllerFrequency;
                        boolean foundPad;
                        Boolean b;
                        TileEntity launchController = null;
                        Class<?> controllerClass = Class.forName("micdoodle8.mods.galacticraft.mars.tile.GCMarsTileEntityLaunchController");
                        for (ILandingPadAttachable connectedTile : dock.getConnectedTiles()) {
                            try {
                                controllerClass.cast(connectedTile);
                            }
                            catch (ClassCastException e) {
                                continue;
                            }
                            launchController = (TileEntity)connectedTile;
                            if (launchController != null) {
                                TileEntity tile2 = launchController.field_70331_k.func_72796_p(launchController.field_70329_l, launchController.field_70330_m, launchController.field_70327_n);
                                try {
                                    controllerClass.cast(tile2);
                                }
                                catch (ClassCastException e) {
                                    launchController = null;
                                    continue;
                                }
                                launchController = tile2;
                            }
                            if (launchController == null) continue;
                            break;
                        }
                        if (launchController == null || (b = (Boolean)controllerClass.getMethod("validFrequency", new Class[0]).invoke(launchController, new Object[0])) == null || !b.booleanValue() || !(foundPad = this.setTarget(false, controllerFrequency = controllerClass.getField("destFrequency").getInt(launchController)))) continue;
                        this.destinationFrequency = controllerFrequency;
                        return true;
                    }
                    catch (ClassCastException e) {
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.destinationFrequency = -1;
        return false;
    }

    protected boolean setTarget(boolean doSet, int destFreq) {
        if (!marsLoaded || FMLCommonHandler.instance().getMinecraftServerInstance() == null || FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c == null) {
            return false;
        }
        for (int i = 0; i < FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c.length; ++i) {
            WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c[i];
            for (int j = 0; j < world.field_73009_h.size(); ++j) {
                TileEntity tile = (TileEntity)world.field_73009_h.get(j);
                if (tile == null) continue;
                tile = world.func_72796_p(tile.field_70329_l, tile.field_70330_m, tile.field_70327_n);
                try {
                    Class<?> controllerClass = Class.forName("micdoodle8.mods.galacticraft.mars.tile.GCMarsTileEntityLaunchController");
                    try {
                        controllerClass.cast(tile);
                    }
                    catch (ClassCastException e) {
                        continue;
                    }
                    TileEntity launchController = tile;
                    int controllerFrequency = controllerClass.getField("frequency").getInt(tile);
                    if (destFreq != controllerFrequency) continue;
                    boolean targetSet = false;
                    block6: for (int x = -2; x <= 2; ++x) {
                        for (int z = -2; z <= 2; ++z) {
                            int blockID = world.func_72798_a(launchController.field_70329_l + x, launchController.field_70330_m, launchController.field_70327_n + z);
                            if (blockID <= 0 || !(Block.field_71973_m[blockID] instanceof GCCoreBlockLandingPadFull)) continue;
                            if (doSet) {
                                this.targetVec = new Vector3(launchController.field_70329_l + x, launchController.field_70330_m, launchController.field_70327_n + z);
                            }
                            targetSet = true;
                            break block6;
                        }
                    }
                    if (doSet) {
                        this.targetDimension = launchController.field_70331_k.field_73011_w.field_76574_g;
                    }
                    if (!targetSet) {
                        if (doSet) {
                            this.targetVec = null;
                        }
                        return false;
                    }
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    @Override
    public int getScaledFuelLevel(int scale) {
        if (this.getFuelTankCapacity() <= 0) {
            return 0;
        }
        return this.fuelTank.getFluidAmount() * scale / this.getFuelTankCapacity();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.statusMessageCooldown > 0) {
                --this.statusMessageCooldown;
            }
            if (this.statusMessageCooldown == 0 && this.lastStatusMessageCooldown > 0 && this.statusValid) {
                this.autoLaunch();
            }
            if (this.autoLaunchCountdown > 0) {
                --this.autoLaunchCountdown;
                if (this.autoLaunchCountdown <= 0) {
                    this.autoLaunch();
                }
            }
            if (this.autoLaunchSetting == EnumAutoLaunch.ROCKET_IS_FUELED && this.fuelTank.getFluidAmount() == this.fuelTank.getCapacity()) {
                this.autoLaunch();
            }
            if (marsLoaded && this.autoLaunchSetting == EnumAutoLaunch.REDSTONE_SIGNAL && this.ticks % 5L == 0L && this.getLandingPad() != null && this.getLandingPad().getConnectedTiles() != null) {
                for (ILandingPadAttachable tile : this.getLandingPad().getConnectedTiles()) {
                    if (this.field_70170_p.func_72796_p(((TileEntity)tile).field_70329_l, ((TileEntity)tile).field_70330_m, ((TileEntity)tile).field_70327_n) == null) continue;
                    try {
                        Class<?> controllerClass = Class.forName("micdoodle8.mods.galacticraft.mars.tile.GCMarsTileEntityLaunchController");
                        try {
                            controllerClass.cast(this.field_70170_p.func_72796_p(((TileEntity)tile).field_70329_l, ((TileEntity)tile).field_70330_m, ((TileEntity)tile).field_70327_n));
                        }
                        catch (ClassCastException e) {
                            continue;
                        }
                        if (!this.field_70170_p.func_72864_z(((TileEntity)tile).field_70329_l, ((TileEntity)tile).field_70330_m, ((TileEntity)tile).field_70327_n)) continue;
                        this.autoLaunch();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.getPhase() && this.hasValidFuel() && this.landing && this.targetVec != null && this.field_70170_p.func_72796_p(this.targetVec.intX(), this.targetVec.intY(), this.targetVec.intZ()) instanceof IFuelDock && this.field_70163_u - this.targetVec.y < 5.0) {
                for (int x = MathHelper.func_76128_c((double)this.field_70165_t) - 1; x <= MathHelper.func_76128_c((double)this.field_70165_t) + 1; ++x) {
                    for (int y = MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)); y <= MathHelper.func_76128_c((double)this.field_70163_u) + 1; ++y) {
                        for (int z = MathHelper.func_76128_c((double)this.field_70161_v) - 1; z <= MathHelper.func_76128_c((double)this.field_70161_v) + 1; ++z) {
                            TileEntity tile = this.field_70170_p.func_72796_p(x, y, z);
                            if (!(tile instanceof IFuelDock)) continue;
                            this.failRocket();
                        }
                    }
                }
            }
            if (this.getLandingPad() != null && this.getLandingPad().getConnectedTiles() != null) {
                for (ILandingPadAttachable tile : this.getLandingPad().getConnectedTiles()) {
                    if (this.field_70170_p.func_72796_p(((TileEntity)tile).field_70329_l, ((TileEntity)tile).field_70330_m, ((TileEntity)tile).field_70327_n) == null || !(this.field_70170_p.func_72796_p(((TileEntity)tile).field_70329_l, ((TileEntity)tile).field_70330_m, ((TileEntity)tile).field_70327_n) instanceof GCCoreTileEntityFuelLoader) || !(tile instanceof GCCoreTileEntityFuelLoader) || !(((GCCoreTileEntityFuelLoader)tile).getEnergyStored() > 0.0f) || this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.getPhase()) continue;
                    this.setPad(null);
                }
            }
            PacketDispatcher.sendPacketToAllAround((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)60.0, (int)this.field_70170_p.field_73011_w.field_76574_g, (Packet)GCCorePacketManager.getPacket("GCCoreEntities", (Entity)this, this.getNetworkedData(new ArrayList<Object>())));
            this.lastStatusMessageCooldown = this.statusMessageCooldown;
        }
    }

    @Override
    protected boolean shouldMoveClientSide() {
        return false;
    }

    private void autoLaunch() {
        this.ignite();
        this.autoLaunchSetting = null;
    }

    public boolean igniteWithResult() {
        if (this.setFrequency()) {
            super.ignite();
            return true;
        }
        if (this.isPlayerRocket()) {
            super.ignite();
        }
        return false;
    }

    @Override
    public void ignite() {
        this.igniteWithResult();
    }

    public abstract boolean isPlayerRocket();

    protected void landRocket(int x, int y, int z) {
        IFuelDock dock;
        TileEntity tile = this.field_70170_p.func_72796_p(x, y, z);
        if (tile instanceof IFuelDock && this.isDockValid(dock = (IFuelDock)tile)) {
            this.onRocketLand(x, y, z);
            return;
        }
    }

    private void updateControllerSettings(IFuelDock dock) {
        HashSet<ILandingPadAttachable> connectedTiles = dock.getConnectedTiles();
        try {
            Class<?> controllerClass = Class.forName("micdoodle8.mods.galacticraft.mars.tile.GCMarsTileEntityLaunchController");
            for (ILandingPadAttachable connectedTile : connectedTiles) {
                if (connectedTile == null) continue;
                TileEntity updatedTile = this.field_70170_p.func_72796_p(((TileEntity)connectedTile).field_70329_l, ((TileEntity)connectedTile).field_70330_m, ((TileEntity)connectedTile).field_70327_n);
                try {
                    controllerClass.cast(updatedTile);
                }
                catch (ClassCastException e) {
                    continue;
                }
                Boolean autoLaunchEnabled = controllerClass.getField("launchSchedulingEnabled").getBoolean(updatedTile);
                this.autoLaunchSetting = autoLaunchEnabled != false ? EnumAutoLaunch.values()[controllerClass.getField("launchDropdownSelection").getInt(updatedTile)] : null;
                if (this.autoLaunchSetting != null) {
                    switch (this.autoLaunchSetting) {
                        case INSTANT: {
                            this.autoLaunch();
                            break;
                        }
                        case TIME_10_SECONDS: {
                            this.autoLaunchCountdown = 200;
                            break;
                        }
                        case TIME_30_SECONDS: {
                            this.autoLaunchCountdown = 600;
                            break;
                        }
                        case TIME_1_MINUTE: {
                            this.autoLaunchCountdown = 1200;
                            break;
                        }
                        default: {
                            break;
                        }
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onRocketLand(int x, int y, int z) {
        this.func_70080_a((double)x + 0.5, (double)y + 0.3, (double)z + 0.5, this.field_70177_z, 0.0f);
    }

    @Override
    public void readNetworkedData(ByteArrayDataInput dataStream) {
        super.readNetworkedData(dataStream);
        this.fuelTank.setFluid(new FluidStack(GalacticraftCore.fluidFuel, dataStream.readInt()));
        this.landing = dataStream.readBoolean();
        this.destinationFrequency = dataStream.readInt();
        if (dataStream.readBoolean()) {
            this.targetVec = new Vector3(dataStream.readDouble(), dataStream.readDouble(), dataStream.readDouble());
        }
        this.field_70159_w = dataStream.readDouble() / 8000.0;
        this.field_70181_x = dataStream.readDouble() / 8000.0;
        this.field_70179_y = dataStream.readDouble() / 8000.0;
        this.lastMotionY = dataStream.readDouble() / 8000.0;
        this.lastLastMotionY = dataStream.readDouble() / 8000.0;
        if (this.cargoItems == null) {
            this.cargoItems = new ItemStack[this.func_70302_i_()];
        }
        this.setWaitForPlayer(dataStream.readBoolean());
        this.statusMessage = dataStream.readUTF();
        this.statusMessage = this.statusMessage.equals("") ? null : this.statusMessage;
        this.statusMessageCooldown = dataStream.readInt();
        this.lastStatusMessageCooldown = dataStream.readInt();
        this.statusValid = dataStream.readBoolean();
    }

    @Override
    public ArrayList<Object> getNetworkedData(ArrayList<Object> list) {
        super.getNetworkedData(list);
        list.add(this.fuelTank.getFluidAmount());
        list.add(this.landing);
        list.add(this.destinationFrequency);
        list.add(this.targetVec != null);
        if (this.targetVec != null) {
            list.add(this.targetVec.x);
            list.add(this.targetVec.y);
            list.add(this.targetVec.z);
        }
        list.add(this.field_70159_w * 8000.0);
        list.add(this.field_70181_x * 8000.0);
        list.add(this.field_70179_y * 8000.0);
        list.add(this.lastMotionY * 8000.0);
        list.add(this.lastLastMotionY * 8000.0);
        list.add(this.getWaitForPlayer());
        list.add(this.statusMessage != null ? this.statusMessage : "");
        list.add(this.statusMessageCooldown);
        list.add(this.lastStatusMessageCooldown);
        list.add(this.statusValid);
        return list;
    }

    @Override
    protected void failRocket() {
        if (this.shouldCancelExplosion()) {
            for (int i = -3; i <= 3; ++i) {
                if (!this.landing || this.targetVec == null || !(this.field_70170_p.func_72796_p((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u + (double)i), (int)Math.floor(this.field_70161_v)) instanceof IFuelDock) || !(this.field_70163_u - this.targetVec.y < 5.0)) continue;
                for (int x = MathHelper.func_76128_c((double)this.field_70165_t) - 1; x <= MathHelper.func_76128_c((double)this.field_70165_t) + 1; ++x) {
                    for (int y = MathHelper.func_76128_c((double)(this.field_70163_u - 3.0)); y <= MathHelper.func_76128_c((double)this.field_70163_u) + 1; ++y) {
                        for (int z = MathHelper.func_76128_c((double)this.field_70161_v) - 1; z <= MathHelper.func_76128_c((double)this.field_70161_v) + 1; ++z) {
                            TileEntity tile = this.field_70170_p.func_72796_p(x, y, z);
                            if (!(tile instanceof IFuelDock)) continue;
                            this.landRocket(x, y, z);
                            return;
                        }
                    }
                }
            }
        }
        if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.getPhase()) {
            super.failRocket();
        }
    }

    protected boolean shouldCancelExplosion() {
        return this.hasValidFuel();
    }

    public boolean hasValidFuel() {
        return this.fuelTank.getFluidAmount() > 0;
    }

    @Override
    public void onLaunch() {
        super.onLaunch();
        if (!this.field_70170_p.field_72995_K) {
            if (!(this.field_70170_p.field_73011_w instanceof IOrbitDimension) && this.field_70153_n != null && this.field_70153_n instanceof GCCorePlayerMP) {
                ((GCCorePlayerMP)this.field_70153_n).setCoordsTeleportedFromX(this.field_70153_n.field_70165_t);
                ((GCCorePlayerMP)this.field_70153_n).setCoordsTeleportedFromZ(this.field_70153_n.field_70161_v);
            }
            int amountRemoved = 0;
            block0: for (int x = MathHelper.func_76128_c((double)this.field_70165_t) - 1; x <= MathHelper.func_76128_c((double)this.field_70165_t) + 1; ++x) {
                for (int y = MathHelper.func_76128_c((double)this.field_70163_u) - 3; y <= MathHelper.func_76128_c((double)this.field_70163_u) + 1; ++y) {
                    for (int z = MathHelper.func_76128_c((double)this.field_70161_v) - 1; z <= MathHelper.func_76128_c((double)this.field_70161_v) + 1; ++z) {
                        int id = this.field_70170_p.func_72798_a(x, y, z);
                        Block block = Block.field_71973_m[id];
                        if (block == null || !(block instanceof GCCoreBlockLandingPadFull) || amountRemoved >= 9) continue;
                        GCCoreLandingPadRemovalEvent event = new GCCoreLandingPadRemovalEvent(this.field_70170_p, x, y, z);
                        MinecraftForge.EVENT_BUS.post((Event)event);
                        if (!event.allow) break block0;
                        this.field_70170_p.func_94571_i(x, y, z);
                        amountRemoved = 9;
                        break block0;
                    }
                }
            }
            if (this.field_70153_n != null && this.field_70153_n instanceof GCCorePlayerMP) {
                ((GCCorePlayerMP)this.field_70153_n).setLaunchpadStack(amountRemoved == 9 ? new ItemStack(GCCoreBlocks.landingPad, 9, 0) : null);
            }
            this.func_85030_a("random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.fuelTank.getFluid() != null) {
            nbt.func_74782_a("fuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        }
        if (this.func_70302_i_() > 0) {
            NBTTagList var2 = new NBTTagList();
            for (int var3 = 0; var3 < this.cargoItems.length; ++var3) {
                if (this.cargoItems[var3] == null) continue;
                NBTTagCompound var4 = new NBTTagCompound();
                var4.func_74774_a("Slot", (byte)var3);
                this.cargoItems[var3].func_77955_b(var4);
                var2.func_74742_a((NBTBase)var4);
            }
            nbt.func_74782_a("Items", (NBTBase)var2);
        }
        nbt.func_74757_a("TargetValid", this.targetVec != null);
        if (this.targetVec != null) {
            nbt.func_74780_a("targetTileX", this.targetVec.x);
            nbt.func_74780_a("targetTileY", this.targetVec.y);
            nbt.func_74780_a("targetTileZ", this.targetVec.z);
        }
        nbt.func_74757_a("WaitingForPlayer", this.getWaitForPlayer());
        nbt.func_74757_a("Landing", this.landing);
        nbt.func_74768_a("AutoLaunchSetting", this.autoLaunchSetting != null ? this.autoLaunchSetting.getIndex() : -1);
        nbt.func_74768_a("TimeUntilAutoLaunch", this.autoLaunchCountdown);
        nbt.func_74768_a("DestinationFrequency", this.destinationFrequency);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("fuelTank")) {
            this.fuelTank.readFromNBT(nbt.func_74775_l("fuelTank"));
        }
        if (this.func_70302_i_() > 0) {
            NBTTagList var2 = nbt.func_74761_m("Items");
            this.cargoItems = new ItemStack[this.func_70302_i_()];
            for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
                NBTTagCompound var4 = (NBTTagCompound)var2.func_74743_b(var3);
                int var5 = var4.func_74771_c("Slot") & 0xFF;
                if (var5 < 0 || var5 >= this.cargoItems.length) continue;
                this.cargoItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
            }
        }
        if (nbt.func_74767_n("TargetValid") && nbt.func_74764_b("targetTileX")) {
            this.targetVec = new Vector3(nbt.func_74769_h("targetTileX"), nbt.func_74769_h("targetTileY"), nbt.func_74769_h("targetTileZ"));
        }
        this.setWaitForPlayer(nbt.func_74767_n("WaitingForPlayer"));
        this.landing = nbt.func_74767_n("Landing");
        int autoLaunchValue = nbt.func_74762_e("AutoLaunchSetting");
        this.autoLaunchSetting = autoLaunchValue == -1 ? null : EnumAutoLaunch.values()[autoLaunchValue];
        this.autoLaunchCountdown = nbt.func_74762_e("TimeUntilAutoLaunch");
        this.destinationFrequency = nbt.func_74762_e("DestinationFrequency");
    }

    @Override
    public int addFuel(FluidStack liquid, boolean doFill) {
        if (liquid != null && FluidRegistry.getFluidName((FluidStack)liquid).equalsIgnoreCase("fuel")) {
            return this.fuelTank.fill(liquid, doFill);
        }
        return 0;
    }

    @Override
    public FluidStack removeFuel(int amount) {
        return this.fuelTank.drain(amount, true);
    }

    @Override
    public void setPad(IFuelDock pad) {
        this.landingPad = pad;
    }

    @Override
    public IFuelDock getLandingPad() {
        return this.landingPad;
    }

    @Override
    public int getMaxFuel() {
        return this.fuelTank.getCapacity();
    }

    @Override
    public boolean isDockValid(IFuelDock dock) {
        if (dock instanceof GCCoreTileEntityLandingPad) {
            if (!this.field_70170_p.field_72995_K) {
                this.launchPhase = EntitySpaceshipBase.EnumLaunchPhase.UNIGNITED.getPhase();
                this.landing = false;
                this.targetVec = null;
                this.setPad(dock);
                if (marsLoaded) {
                    this.updateControllerSettings(dock);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public ICargoEntity.EnumCargoLoadingState addCargo(ItemStack stack, boolean doAdd) {
        ItemStack stackAt;
        if (this.func_70302_i_() <= 3) {
            if (this.autoLaunchSetting == EnumAutoLaunch.CARGO_IS_FULL) {
                this.autoLaunch();
            }
            return ICargoEntity.EnumCargoLoadingState.NOINVENTORY;
        }
        int count = 0;
        for (count = 0; count < this.cargoItems.length - 2; ++count) {
            stackAt = this.cargoItems[count];
            if (stackAt == null || stackAt.field_77993_c != stack.field_77993_c || stackAt.func_77960_j() != stack.func_77960_j() || stackAt.field_77994_a >= stackAt.func_77976_d()) continue;
            if (doAdd) {
                this.cargoItems[count].field_77994_a += stack.field_77994_a;
            }
            return ICargoEntity.EnumCargoLoadingState.SUCCESS;
        }
        for (count = 0; count < this.cargoItems.length - 2; ++count) {
            stackAt = this.cargoItems[count];
            if (stackAt != null) continue;
            if (doAdd) {
                this.cargoItems[count] = stack;
            }
            return ICargoEntity.EnumCargoLoadingState.SUCCESS;
        }
        if (this.autoLaunchSetting == EnumAutoLaunch.CARGO_IS_FULL) {
            this.autoLaunch();
        }
        return ICargoEntity.EnumCargoLoadingState.FULL;
    }

    @Override
    public ICargoEntity.RemovalResult removeCargo(boolean doRemove) {
        for (int i = 0; i < this.cargoItems.length - 2; ++i) {
            ItemStack stackAt = this.cargoItems[i];
            if (stackAt == null) continue;
            if (doRemove && --this.cargoItems[i].field_77994_a <= 0) {
                this.cargoItems[i] = null;
            }
            return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.SUCCESS, new ItemStack(stackAt.field_77993_c, 1, stackAt.func_77960_j()));
        }
        if (this.autoLaunchSetting == EnumAutoLaunch.CARGO_IS_UNLOADED) {
            this.autoLaunch();
        }
        return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.EMPTY, null);
    }

    public ItemStack func_70301_a(int par1) {
        return this.cargoItems[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.cargoItems[par1] != null) {
            if (this.cargoItems[par1].field_77994_a <= par2) {
                ItemStack var3 = this.cargoItems[par1];
                this.cargoItems[par1] = null;
                return var3;
            }
            ItemStack var3 = this.cargoItems[par1].func_77979_a(par2);
            if (this.cargoItems[par1].field_77994_a == 0) {
                this.cargoItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.cargoItems[par1] != null) {
            ItemStack var2 = this.cargoItems[par1];
            this.cargoItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.cargoItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70303_b() {
        return StatCollector.func_74838_a((String)"container.spaceship.name");
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94042_c() {
        return true;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_70128_L ? false : entityplayer.func_70068_e((Entity)this) <= 64.0;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    @Override
    public void onPadDestroyed() {
        if (!this.field_70128_L && this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.getPhase()) {
            this.dropShipAsItem();
            this.func_70106_y();
        }
    }

    @Override
    public List<ItemStack> getItemsDropped(List<ItemStack> droppedItemList) {
        if (this.cargoItems != null) {
            for (ItemStack item : this.cargoItems) {
                if (item == null) continue;
                droppedItemList.add(item);
            }
        }
        return droppedItemList;
    }

    public boolean getWaitForPlayer() {
        return this.waitForPlayer;
    }

    public void setWaitForPlayer(boolean waitForPlayer) {
        this.waitForPlayer = waitForPlayer;
    }

    public static enum EnumAutoLaunch {
        CARGO_IS_UNLOADED(0, "Cargo is Unloaded"),
        CARGO_IS_FULL(1, "Cargo is Full"),
        ROCKET_IS_FUELED(2, "Fully Fueled"),
        INSTANT(3, "Instantly"),
        TIME_10_SECONDS(4, "10 Seconds"),
        TIME_30_SECONDS(5, "30 Seconds"),
        TIME_1_MINUTE(6, "1 Minute"),
        REDSTONE_SIGNAL(7, "Redstone Signal");

        private final int index;
        private String title;

        private EnumAutoLaunch(int index, String title) {
            this.index = index;
            this.title = title;
        }

        public int getIndex() {
            return this.index;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

