/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.prefab.world.gen;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.GCBiomeDecoratorBase;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.GCCoreMapGenBaseMeta;
import micdoodle8.mods.galacticraft.core.perlin.generator.Gradient;
import micdoodle8.mods.galacticraft.core.world.gen.GCCoreCraterSize;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.SpawnListEntry;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderGenerate;

public abstract class GCChunkProvider
extends ChunkProviderGenerate {
    private final Random field_73220_k;
    private final Gradient field_73217_l;
    private final Gradient field_73218_m;
    private final Gradient field_73215_n;
    private final Gradient field_73216_o;
    private final Gradient field_73214_a;
    private final Gradient field_73212_b;
    private final Gradient noiseGen7;
    public GCBiomeDecoratorBase biomeDecoratorPlanet = this.getBiomeGenerator();
    private final World field_73230_p;
    private BiomeGenBase[] field_73231_z = this.getBiomesForGeneration();
    double[] field_73211_e;
    double[] field_73208_f;
    double[] field_73210_d;
    double[] noise4;
    double[] field_73209_g;
    double[] field_73221_h;
    float[] field_35388_l;
    int[][] field_914_i = new int[32][32];
    private final double TERRAIN_HEIGHT_MOD = this.getHeightModifier();
    private final double SMALL_FEATURE_HEIGHT_MOD = this.getSmallFeatureHeightModifier();
    private final double MOUNTAIN_HEIGHT_MOD = this.getMountainHeightModifier();
    private final double VALLEY_HEIGHT_MOD = this.getValleyHeightModifier();
    private final int CRATER_PROB = this.getCraterProbability();
    private final int MID_HEIGHT = this.getSeaLevel();
    private static final int CHUNK_SIZE_X = 16;
    private static final int CHUNK_SIZE_Y = 256;
    private static final int CHUNK_SIZE_Z = 16;
    private static final double MAIN_FEATURE_FILTER_MOD = 4.0;
    private static final double LARGE_FEATURE_FILTER_MOD = 8.0;
    private static final double SMALL_FEATURE_FILTER_MOD = 8.0;
    private List<GCCoreMapGenBaseMeta> worldGenerators;

    public GCChunkProvider(World par1World, long seed, boolean mapFeaturesEnabled) {
        super(par1World, seed, mapFeaturesEnabled);
        this.field_73230_p = par1World;
        this.field_73220_k = new Random(seed);
        this.field_73217_l = new Gradient(this.field_73220_k.nextLong(), 4, 0.25);
        this.field_73218_m = new Gradient(this.field_73220_k.nextLong(), 4, 0.25);
        this.field_73215_n = new Gradient(this.field_73220_k.nextLong(), 4, 0.25);
        this.field_73216_o = new Gradient(this.field_73220_k.nextLong(), 2, 0.25);
        this.field_73214_a = new Gradient(this.field_73220_k.nextLong(), 1, 0.25);
        this.field_73212_b = new Gradient(this.field_73220_k.nextLong(), 1, 0.25);
        this.noiseGen7 = new Gradient(this.field_73220_k.nextLong(), 1, 0.25);
    }

    public void generateTerrain(int chunkX, int chunkZ, short[] idArray, byte[] metaArray) {
        this.field_73217_l.frequency = 0.015;
        this.field_73218_m.frequency = 0.01;
        this.field_73215_n.frequency = 0.01;
        this.field_73216_o.frequency = 0.01;
        this.field_73214_a.frequency = 0.01;
        this.field_73212_b.frequency = 0.001;
        this.noiseGen7.frequency = 0.005;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                double baseHeight = this.field_73217_l.getNoise(chunkX * 16 + x, chunkZ * 16 + z) * this.TERRAIN_HEIGHT_MOD;
                double smallHillHeight = this.field_73218_m.getNoise(chunkX * 16 + x, chunkZ * 16 + z) * this.SMALL_FEATURE_HEIGHT_MOD;
                double mountainHeight = Math.abs(this.field_73215_n.getNoise(chunkX * 16 + x, chunkZ * 16 + z));
                double valleyHeight = Math.abs(this.field_73216_o.getNoise(chunkX * 16 + x, chunkZ * 16 + z));
                double featureFilter = this.field_73214_a.getNoise(chunkX * 16 + x, chunkZ * 16 + z) * 4.0;
                double largeFilter = this.field_73212_b.getNoise(chunkX * 16 + x, chunkZ * 16 + z) * 8.0;
                double smallFilter = this.noiseGen7.getNoise(chunkX * 16 + x, chunkZ * 16 + z) * 8.0 - 0.5;
                mountainHeight = this.lerp(smallHillHeight, mountainHeight * this.MOUNTAIN_HEIGHT_MOD, this.fade(this.clamp(mountainHeight * 2.0, 0.0, 1.0)));
                valleyHeight = this.lerp(smallHillHeight, valleyHeight * this.VALLEY_HEIGHT_MOD - this.VALLEY_HEIGHT_MOD + 9.0, this.fade(this.clamp((valleyHeight + 2.0) * 4.0, 0.0, 1.0)));
                double yDev = this.lerp(valleyHeight, mountainHeight, this.fade(largeFilter));
                yDev = this.lerp(smallHillHeight, yDev, smallFilter);
                yDev = this.lerp(baseHeight, yDev, featureFilter);
                for (int y = 0; y < 256; ++y) {
                    if (!((double)y < (double)this.MID_HEIGHT + yDev)) continue;
                    idArray[this.getIndex((int)x, (int)y, (int)z)] = this.getStoneBlock().getBlockID();
                    metaArray[this.getIndex((int)x, (int)y, (int)z)] = this.getStoneBlock().getMetadata();
                }
            }
        }
    }

    private double lerp(double d1, double d2, double t) {
        if (t < 0.0) {
            return d1;
        }
        if (t > 1.0) {
            return d2;
        }
        return d1 + (d2 - d1) * t;
    }

    private double fade(double n) {
        return n * n * n * (n * (n * 6.0 - 15.0) + 10.0);
    }

    private double clamp(double x, double min, double max) {
        if (x < min) {
            return min;
        }
        if (x > max) {
            return max;
        }
        return x;
    }

    public void replaceBlocksForBiome(int par1, int par2, short[] arrayOfIDs, byte[] arrayOfMeta, BiomeGenBase[] par4ArrayOfBiomeGenBase) {
        int var5 = 20;
        double var6 = 0.03125;
        this.field_73216_o.frequency = 0.0625;
        for (int var8 = 0; var8 < 16; ++var8) {
            for (int var9 = 0; var9 < 16; ++var9) {
                int var12 = (int)(this.field_73216_o.getNoise(par1 * 16 + var8, par2 * 16 + var9) / 3.0 + 3.0 + this.field_73220_k.nextDouble() * 0.25);
                int var13 = -1;
                short var14 = this.getGrassBlock().getBlockID();
                byte var14m = this.getGrassBlock().getMetadata();
                short var15 = this.getDirtBlock().getBlockID();
                byte var15m = this.getDirtBlock().getMetadata();
                for (int var16 = 255; var16 >= 0; --var16) {
                    int index = this.getIndex(var8, var16, var9);
                    if (var16 <= 0 + this.field_73220_k.nextInt(5)) {
                        arrayOfIDs[index] = (short)Block.field_71986_z.field_71990_ca;
                        continue;
                    }
                    short var18 = arrayOfIDs[index];
                    if (var18 == 0) {
                        var13 = -1;
                        continue;
                    }
                    if (var18 != this.getStoneBlock().getBlockID()) continue;
                    arrayOfMeta[index] = this.getStoneBlock().getMetadata();
                    if (var13 == -1) {
                        if (var12 <= 0) {
                            var14 = 0;
                            var14m = 0;
                            var15 = this.getStoneBlock().getBlockID();
                            var15m = this.getStoneBlock().getMetadata();
                        } else if (var16 >= 36 && var16 <= 21) {
                            var14 = this.getGrassBlock().getBlockID();
                            var14m = this.getGrassBlock().getMetadata();
                            var14 = this.getDirtBlock().getBlockID();
                            var14m = this.getDirtBlock().getMetadata();
                        }
                        if (var16 < 20 && var14 == 0) {
                            var14 = 0;
                        }
                        var13 = var12;
                        if (var16 >= 19) {
                            arrayOfIDs[index] = var14;
                            arrayOfMeta[index] = var14m;
                            continue;
                        }
                        arrayOfIDs[index] = var15;
                        arrayOfMeta[index] = var15m;
                        continue;
                    }
                    if (var13 <= 0) continue;
                    --var13;
                    arrayOfIDs[index] = var15;
                    arrayOfMeta[index] = var15m;
                }
            }
        }
    }

    public Chunk func_73154_d(int par1, int par2) {
        this.field_73220_k.setSeed((long)par1 * 341873128712L + (long)par2 * 132897987541L);
        short[] ids = new short[65536];
        byte[] meta = new byte[65536];
        this.generateTerrain(par1, par2, ids, meta);
        this.createCraters(par1, par2, ids, meta);
        this.field_73231_z = this.field_73230_p.func_72959_q().func_76933_b(this.field_73231_z, par1 * 16, par2 * 16, 16, 16);
        this.replaceBlocksForBiome(par1, par2, ids, meta, this.field_73231_z);
        if (this.worldGenerators == null) {
            this.worldGenerators = this.getWorldGenerators();
        }
        for (GCCoreMapGenBaseMeta generator : this.worldGenerators) {
            generator.generate((IChunkProvider)this, this.field_73230_p, par1, par2, ids, meta);
        }
        Chunk var4 = new Chunk(this.field_73230_p, ids, meta, par1, par2);
        byte[] var5 = var4.func_76605_m();
        for (int var6 = 0; var6 < var5.length; ++var6) {
            var5[var6] = (byte)this.field_73231_z[var6].field_76756_M;
        }
        var4.func_76603_b();
        return var4;
    }

    public void createCraters(int chunkX, int chunkZ, short[] chunkArray, byte[] metaArray) {
        this.field_73214_a.frequency = 0.015;
        for (int cx = chunkX - 2; cx <= chunkX + 2; ++cx) {
            for (int cz = chunkZ - 2; cz <= chunkZ + 2; ++cz) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        if (!(Math.abs(this.randFromPoint(cx * 16 + x, (cz * 16 + z) * 1000)) < this.field_73214_a.getNoise(cx * 16 + x, cz * 16 + z) / (double)this.CRATER_PROB)) continue;
                        Random random = new Random(cx * 16 + x + (cz * 16 + z) * 5000);
                        GCCoreCraterSize cSize = GCCoreCraterSize.sizeArray[random.nextInt(GCCoreCraterSize.sizeArray.length)];
                        int size = random.nextInt(cSize.MAX_SIZE - cSize.MIN_SIZE) + cSize.MIN_SIZE + 15;
                        this.makeCrater(cx * 16 + x, cz * 16 + z, chunkX * 16, chunkZ * 16, size, chunkArray, metaArray);
                    }
                }
            }
        }
    }

    public void makeCrater(int craterX, int craterZ, int chunkX, int chunkZ, int size, short[] chunkArray, byte[] metaArray) {
        for (int x = 0; x < 16; ++x) {
            block1: for (int z = 0; z < 16; ++z) {
                double xDev = craterX - (chunkX + x);
                double zDev = craterZ - (chunkZ + z);
                if (!(xDev * xDev + zDev * zDev < (double)(size * size))) continue;
                double sqrtY = (xDev /= (double)size) * xDev + (zDev /= (double)size) * zDev;
                double yDev = sqrtY * sqrtY * 6.0;
                yDev = 5.0 - yDev;
                int helper = 0;
                for (int y = 127; y > 0; --y) {
                    if (chunkArray[this.getIndex(x, y, z)] != 0 && (double)helper <= yDev) {
                        chunkArray[this.getIndex((int)x, (int)y, (int)z)] = 0;
                        metaArray[this.getIndex((int)x, (int)y, (int)z)] = 0;
                        ++helper;
                    }
                    if ((double)helper > yDev) continue block1;
                }
            }
        }
    }

    private int getIndex(int x, int y, int z) {
        return y << 8 | z << 4 | x;
    }

    private double randFromPoint(int x, int z) {
        int n = x + z * 57;
        n = n << 13 ^ n;
        return 1.0 - (double)(n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE) / 1.073741824E9;
    }

    public boolean func_73149_a(int par1, int par2) {
        return true;
    }

    public void decoratePlanet(World par1World, Random par2Random, int par3, int par4) {
        this.biomeDecoratorPlanet.decorate(par1World, par2Random, par3, par4);
    }

    public void func_73153_a(IChunkProvider par1IChunkProvider, int par2, int par3) {
        BlockSand.field_72192_a = true;
        int var4 = par2 * 16;
        int var5 = par3 * 16;
        this.field_73230_p.func_72807_a(var4 + 16, var5 + 16);
        this.field_73220_k.setSeed(this.field_73230_p.func_72905_C());
        long var7 = this.field_73220_k.nextLong() / 2L * 2L + 1L;
        long var9 = this.field_73220_k.nextLong() / 2L * 2L + 1L;
        this.field_73220_k.setSeed((long)par2 * var7 + (long)par3 * var9 ^ this.field_73230_p.func_72905_C());
        this.decoratePlanet(this.field_73230_p, this.field_73220_k, var4, var5);
        var4 += 8;
        var5 += 8;
        BlockSand.field_72192_a = false;
    }

    public boolean func_73151_a(boolean par1, IProgressUpdate par2IProgressUpdate) {
        return true;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "RandomLevelSource";
    }

    public List func_73155_a(EnumCreatureType par1EnumCreatureType, int i, int j, int k) {
        if (par1EnumCreatureType == EnumCreatureType.monster) {
            ArrayList<SpawnListEntry> monsters = new ArrayList<SpawnListEntry>();
            for (SpawnListEntry monster : this.getMonsters()) {
                monsters.add(monster);
            }
            return monsters;
        }
        if (par1EnumCreatureType == EnumCreatureType.creature) {
            ArrayList<SpawnListEntry> creatures = new ArrayList<SpawnListEntry>();
            for (SpawnListEntry creature : this.getCreatures()) {
                creatures.add(creature);
            }
            return creatures;
        }
        return null;
    }

    protected abstract GCBiomeDecoratorBase getBiomeGenerator();

    protected abstract BiomeGenBase[] getBiomesForGeneration();

    protected abstract int getSeaLevel();

    protected abstract List<GCCoreMapGenBaseMeta> getWorldGenerators();

    protected abstract SpawnListEntry[] getMonsters();

    protected abstract SpawnListEntry[] getCreatures();

    protected abstract BlockMetaPair getGrassBlock();

    protected abstract BlockMetaPair getDirtBlock();

    protected abstract BlockMetaPair getStoneBlock();

    public abstract double getHeightModifier();

    public abstract double getSmallFeatureHeightModifier();

    public abstract double getMountainHeightModifier();

    public abstract double getValleyHeightModifier();

    public abstract int getCraterProbability();
}

