/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.recipe;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.api.recipe.ISchematicPage;
import micdoodle8.mods.galacticraft.api.recipe.SchematicEvent;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class SchematicRegistry {
    public static ArrayList<ISchematicPage> schematicRecipes = new ArrayList();

    public static void registerSchematicRecipe(ISchematicPage page) {
        if (!schematicRecipes.contains(page)) {
            schematicRecipes.add(page);
        }
    }

    public static ISchematicPage getMatchingRecipeForItemStack(ItemStack stack) {
        for (ISchematicPage schematic : schematicRecipes) {
            ItemStack requiredItem = schematic.getRequiredItem();
            if (requiredItem == null || stack == null || !requiredItem.func_77969_a(stack)) continue;
            return schematic;
        }
        return null;
    }

    public static ISchematicPage getMatchingRecipeForID(int id) {
        for (ISchematicPage schematic : schematicRecipes) {
            if (schematic.getPageID() != id) continue;
            return schematic;
        }
        return null;
    }

    public static void addUnlockedPage(EntityPlayerMP player, ISchematicPage page) {
        MinecraftForge.EVENT_BUS.post((Event)new SchematicEvent.Unlock(player, page));
    }

    public static ISchematicPage unlockNewPage(EntityPlayerMP player, ItemStack stack) {
        ISchematicPage schematic;
        if (stack != null && (schematic = SchematicRegistry.getMatchingRecipeForItemStack(stack)) != null) {
            SchematicRegistry.addUnlockedPage(player, schematic);
            return schematic;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static void flipToNextPage(int currentIndex) {
        FMLClientHandler.instance().getClient().field_71462_r = null;
        MinecraftForge.EVENT_BUS.post((Event)new SchematicEvent.FlipPage(null, currentIndex, 1));
    }

    @SideOnly(value=Side.CLIENT)
    public static void flipToLastPage(int currentIndex) {
        FMLClientHandler.instance().getClient().field_71462_r = null;
        MinecraftForge.EVENT_BUS.post((Event)new SchematicEvent.FlipPage(null, currentIndex, -1));
    }
}

