/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.transmission.core.path;

import java.util.HashSet;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.transmission.core.path.IPathCallBack;
import micdoodle8.mods.galacticraft.api.vector.Vector3;

public class Pathfinder {
    public IPathCallBack callBackCheck;
    public Set<Vector3> closedSet;
    public Set<Vector3> results;

    public Pathfinder(IPathCallBack callBack) {
        this.callBackCheck = callBack;
        this.reset();
    }

    public boolean findNodes(Vector3 currentNode) {
        this.closedSet.add(currentNode);
        if (this.callBackCheck.onSearch(this, currentNode)) {
            return false;
        }
        for (Vector3 node : this.callBackCheck.getConnectedNodes(this, currentNode)) {
            if (this.closedSet.contains(node) || !this.findNodes(node)) continue;
            return true;
        }
        return false;
    }

    public Pathfinder init(Vector3 startNode) {
        this.findNodes(startNode);
        return this;
    }

    public Pathfinder reset() {
        this.closedSet = new HashSet<Vector3>();
        this.results = new HashSet<Vector3>();
        return this;
    }
}

