/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.vector;

import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ReportedException;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeDirection;

public class BlockVec3
implements Cloneable {
    public int x;
    public int y;
    public int z;
    public boolean[] sideDone = new boolean[]{false, false, false, false, false, false};
    private static Chunk chunkCached;
    public static int chunkCacheDim;
    private static int chunkCacheX;
    private static int chunkCacheZ;

    public BlockVec3() {
        this(0, 0, 0);
    }

    public BlockVec3(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BlockVec3(Entity par1) {
        this.x = (int)Math.floor(par1.field_70165_t);
        this.y = (int)Math.floor(par1.field_70163_u);
        this.z = (int)Math.floor(par1.field_70161_v);
    }

    public BlockVec3(TileEntity par1) {
        this.x = par1.field_70329_l;
        this.y = par1.field_70330_m;
        this.z = par1.field_70327_n;
    }

    public BlockVec3 clone() {
        return new BlockVec3(this.x, this.y, this.z);
    }

    public int getBlockID(World world) {
        if (this.y < 0 || this.y >= 256 || this.x < -30000000 || this.z < -30000000 || this.x >= 30000000 || this.z >= 30000000) {
            return -1;
        }
        int chunkx = this.x >> 4;
        int chunkz = this.z >> 4;
        try {
            if (world.func_72863_F().func_73149_a(chunkx, chunkz)) {
                if (chunkCacheX == chunkx && chunkCacheZ == chunkz && chunkCacheDim == world.field_73011_w.field_76574_g && BlockVec3.chunkCached.field_76636_d) {
                    return chunkCached.func_76610_a(this.x & 0xF, this.y, this.z & 0xF);
                }
                Chunk chunk = null;
                chunkCached = chunk = world.func_72964_e(chunkx, chunkz);
                chunkCacheDim = world.field_73011_w.field_76574_g;
                chunkCacheX = chunkx;
                chunkCacheZ = chunkz;
                return chunk.func_76610_a(this.x & 0xF, this.y, this.z & 0xF);
            }
            return -2;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Oxygen Sealer thread: Exception getting block type in world");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Requested block coordinates");
            crashreportcategory.func_71507_a("Location", (Object)CrashReportCategory.func_85071_a((int)this.x, (int)this.y, (int)this.z));
            throw new ReportedException(crashreport);
        }
    }

    public int getBlockIDsafe(World world) {
        if (this.y < 0 || this.y >= 256) {
            return -1;
        }
        int chunkx = this.x >> 4;
        int chunkz = this.z >> 4;
        try {
            if (world.func_72863_F().func_73149_a(chunkx, chunkz)) {
                if (chunkCacheX == chunkx && chunkCacheZ == chunkz && chunkCacheDim == world.field_73011_w.field_76574_g && BlockVec3.chunkCached.field_76636_d) {
                    return chunkCached.func_76610_a(this.x & 0xF, this.y, this.z & 0xF);
                }
                Chunk chunk = null;
                chunkCached = chunk = world.func_72964_e(chunkx, chunkz);
                chunkCacheDim = world.field_73011_w.field_76574_g;
                chunkCacheX = chunkx;
                chunkCacheZ = chunkz;
                return chunk.func_76610_a(this.x & 0xF, this.y, this.z & 0xF);
            }
            return -2;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Oxygen Sealer thread: Exception getting block type in world");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Requested block coordinates");
            crashreportcategory.func_71507_a("Location", (Object)CrashReportCategory.func_85071_a((int)this.x, (int)this.y, (int)this.z));
            throw new ReportedException(crashreport);
        }
    }

    public BlockVec3 add(BlockVec3 par1) {
        this.x += par1.x;
        this.y += par1.y;
        this.z += par1.z;
        return this;
    }

    public BlockVec3 translate(BlockVec3 par1) {
        this.x += par1.x;
        this.y += par1.y;
        this.z += par1.z;
        return this;
    }

    public BlockVec3 translate(int par1x, int par1y, int par1z) {
        this.x += par1x;
        this.y += par1y;
        this.z += par1z;
        return this;
    }

    public static BlockVec3 add(BlockVec3 par1, BlockVec3 a) {
        return new BlockVec3(par1.x + a.x, par1.y + a.y, par1.z + a.z);
    }

    public BlockVec3 subtract(BlockVec3 par1) {
        this.x = this.x -= par1.x;
        this.y = this.y -= par1.y;
        this.z = this.z -= par1.z;
        return this;
    }

    public BlockVec3 modifyPositionFromSide(ForgeDirection side, int amount) {
        switch (side.ordinal()) {
            case 0: {
                this.y -= amount;
                break;
            }
            case 1: {
                this.y += amount;
                break;
            }
            case 2: {
                this.z -= amount;
                break;
            }
            case 3: {
                this.z += amount;
                break;
            }
            case 4: {
                this.x -= amount;
                break;
            }
            case 5: {
                this.x += amount;
            }
        }
        return this;
    }

    public BlockVec3 newVecSide(int side) {
        BlockVec3 vec = new BlockVec3(this.x, this.y, this.z);
        vec.sideDone[side ^ 1] = true;
        switch (side) {
            case 0: {
                --vec.y;
                return vec;
            }
            case 1: {
                ++vec.y;
                return vec;
            }
            case 2: {
                --vec.z;
                return vec;
            }
            case 3: {
                ++vec.z;
                return vec;
            }
            case 4: {
                --vec.x;
                return vec;
            }
            case 5: {
                ++vec.x;
                return vec;
            }
        }
        return vec;
    }

    public BlockVec3 modifyPositionFromSide(ForgeDirection side) {
        return this.modifyPositionFromSide(side, 1);
    }

    public int hashCode() {
        return ((this.y * 379 + this.x) * 373 + this.z) * 7;
    }

    public boolean equals(Object o) {
        if (o instanceof BlockVec3) {
            BlockVec3 vector = (BlockVec3)o;
            return this.x == vector.x && this.y == vector.y && this.z == vector.z;
        }
        return false;
    }

    public String toString() {
        return "BlockVec3 [" + this.x + "," + this.y + "," + this.z + "]";
    }

    public TileEntity getTileEntity(IBlockAccess world) {
        return world.func_72796_p(this.x, this.y, this.z);
    }

    public TileEntity getTileEntityOnSide(World world, ForgeDirection side) {
        int x = this.x;
        int y = this.y;
        int z = this.z;
        switch (side.ordinal()) {
            case 0: {
                --y;
                break;
            }
            case 1: {
                ++y;
                break;
            }
            case 2: {
                --z;
                break;
            }
            case 3: {
                ++z;
                break;
            }
            case 4: {
                --x;
                break;
            }
            case 5: {
                ++x;
            }
        }
        if (world.func_72899_e(x, y, z)) {
            return world.func_72796_p(x, y, z);
        }
        return null;
    }

    public int getBlockMetadata(IBlockAccess world) {
        return world.func_72805_g(this.x, this.y, this.z);
    }

    public static BlockVec3 readFromNBT(NBTTagCompound nbtCompound) {
        BlockVec3 tempVector = new BlockVec3();
        tempVector.x = (int)Math.floor(nbtCompound.func_74769_h("x"));
        tempVector.y = (int)Math.floor(nbtCompound.func_74769_h("y"));
        tempVector.z = (int)Math.floor(nbtCompound.func_74769_h("z"));
        return tempVector;
    }

    public int distanceTo(BlockVec3 vector) {
        int var2 = vector.x - this.x;
        int var4 = vector.y - this.y;
        int var6 = vector.z - this.z;
        return (int)Math.floor(Math.sqrt(var2 * var2 + var4 * var4 + var6 * var6));
    }

    public NBTTagCompound writeToNBT(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.func_74780_a("x", (double)this.x);
        par1NBTTagCompound.func_74780_a("y", (double)this.y);
        par1NBTTagCompound.func_74780_a("z", (double)this.z);
        return par1NBTTagCompound;
    }

    public double getMagnitude() {
        return Math.sqrt(this.getMagnitudeSquared());
    }

    public int getMagnitudeSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public void setBlock(World worldObj, int blockID) {
        worldObj.func_72832_d(this.x, this.y, this.z, blockID, 0, 3);
    }

    public int intX() {
        return this.x;
    }

    public int intY() {
        return this.x;
    }

    public int intZ() {
        return this.x;
    }

    public void setSideDone(int side) {
        this.sideDone[side] = true;
    }

    static {
        chunkCacheDim = Integer.MAX_VALUE;
        chunkCacheX = 1876000;
        chunkCacheZ = 1876000;
    }
}

