/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.vector;

import micdoodle8.mods.galacticraft.api.vector.Vector3;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.ForgeDirection;

public class VectorD3 {
    public Vector3 position;
    public int dimensionID;

    public VectorD3(double x, double y, double z, int dimID) {
        this.position = new Vector3(x, y, z);
        this.dimensionID = dimID;
    }

    public VectorD3() {
        this(0.0, 0.0, 0.0, 0);
    }

    public VectorD3(VectorD3 vector) {
        this(vector.position.x, vector.position.y, vector.position.z, vector.dimensionID);
    }

    public VectorD3(Vector3 vector, int dimID) {
        this(vector.x, vector.y, vector.z, dimID);
    }

    public VectorD3(double amount) {
        this(amount, amount, amount, 0);
    }

    public VectorD3(Entity par1) {
        this(par1.field_70165_t, par1.field_70163_u, par1.field_70161_v, 0);
    }

    public VectorD3(TileEntity par1) {
        this(par1.field_70329_l, par1.field_70330_m, par1.field_70327_n, 0);
    }

    public VectorD3(Vec3 par1) {
        this(par1.field_72450_a, par1.field_72448_b, par1.field_72449_c, 0);
    }

    public VectorD3(MovingObjectPosition par1) {
        this(par1.field_72311_b, par1.field_72312_c, par1.field_72309_d, 0);
    }

    public VectorD3(ChunkCoordinates par1) {
        this(par1.field_71574_a, par1.field_71572_b, par1.field_71573_c, 0);
    }

    public VectorD3(ForgeDirection direction) {
        this(direction.offsetX, direction.offsetY, direction.offsetZ, 0);
    }

    public VectorD3(NBTTagCompound nbt) {
        this(nbt.func_74769_h("x"), nbt.func_74769_h("y"), nbt.func_74769_h("z"), nbt.func_74762_e("dimID"));
    }

    public VectorD3(float rotationYaw, float rotationPitch) {
        this(Math.cos(Math.toRadians(rotationYaw + 90.0f)), Math.sin(Math.toRadians(-rotationPitch)), Math.sin(Math.toRadians(rotationYaw + 90.0f)), 0);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        this.position.writeToNBT(nbt);
        nbt.func_74768_a("dimID", this.dimensionID);
        return nbt;
    }

    public VectorD3 clone() {
        return new VectorD3(this);
    }
}

