/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.recipe.CircuitFabricatorRecipes;
import micdoodle8.mods.galacticraft.api.recipe.CompressorRecipes;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.api.transmission.compatibility.NetworkConfigHandler;
import micdoodle8.mods.galacticraft.api.transmission.core.grid.ChunkPowerHandler;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.world.ICelestialBody;
import micdoodle8.mods.galacticraft.api.world.IGalaxy;
import micdoodle8.mods.galacticraft.api.world.IMoon;
import micdoodle8.mods.galacticraft.api.world.IPlanet;
import micdoodle8.mods.galacticraft.core.CommonProxyCore;
import micdoodle8.mods.galacticraft.core.GCCoreCompatibilityManager;
import micdoodle8.mods.galacticraft.core.GCCoreConfigManager;
import micdoodle8.mods.galacticraft.core.GCCoreCreativeTab;
import micdoodle8.mods.galacticraft.core.GCCoreGalaxyBlockyWay;
import micdoodle8.mods.galacticraft.core.GCCorePlanetOverworld;
import micdoodle8.mods.galacticraft.core.GCCorePlanetSun;
import micdoodle8.mods.galacticraft.core.GCCoreThreadRequirementMissing;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlockFluid;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.core.client.gui.GCCoreGuiHandler;
import micdoodle8.mods.galacticraft.core.command.GCCoreCommandGCInv;
import micdoodle8.mods.galacticraft.core.command.GCCoreCommandKeepDim;
import micdoodle8.mods.galacticraft.core.command.GCCoreCommandPlanetTeleport;
import micdoodle8.mods.galacticraft.core.command.GCCoreCommandSpaceStationAddOwner;
import micdoodle8.mods.galacticraft.core.command.GCCoreCommandSpaceStationRemoveOwner;
import micdoodle8.mods.galacticraft.core.dimension.GCCoreOrbitTeleportType;
import micdoodle8.mods.galacticraft.core.dimension.GCCoreOverworldTeleportType;
import micdoodle8.mods.galacticraft.core.dimension.GCCoreWorldProviderSpaceStation;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityAlienVillager;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityArrow;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityBuggy;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityCreeper;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityFlag;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityLander;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityMeteor;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityMeteorChunk;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityOxygenBubble;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityParaChest;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityRocketT1;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntitySkeleton;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntitySkeletonBoss;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntitySpider;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityZombie;
import micdoodle8.mods.galacticraft.core.entities.player.GCCorePlayerMP;
import micdoodle8.mods.galacticraft.core.entities.player.GCCorePlayerSP;
import micdoodle8.mods.galacticraft.core.entities.player.PlayerTracker;
import micdoodle8.mods.galacticraft.core.event.GCCoreEvents;
import micdoodle8.mods.galacticraft.core.items.GCCoreItemBasic;
import micdoodle8.mods.galacticraft.core.items.GCCoreItemBlock;
import micdoodle8.mods.galacticraft.core.items.GCCoreItems;
import micdoodle8.mods.galacticraft.core.network.GCCoreConnectionHandler;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketHandlerServer;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketManager;
import micdoodle8.mods.galacticraft.core.recipe.GCCoreRecipeManager;
import micdoodle8.mods.galacticraft.core.schematic.GCCoreSchematicAdd;
import micdoodle8.mods.galacticraft.core.schematic.GCCoreSchematicMoonBuggy;
import micdoodle8.mods.galacticraft.core.schematic.GCCoreSchematicRocketT1;
import micdoodle8.mods.galacticraft.core.tick.GCCoreTickHandlerServer;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityAdvancedCraftingTable;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityAirLock;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityAirLockController;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityAluminumWire;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityBuggyFueler;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityBuggyFuelerSingle;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityCargoLoader;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityCargoUnloader;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityCircuitFabricator;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityCoalGenerator;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityDungeonSpawner;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityElectricFurnace;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityElectricIngotCompressor;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityEnergyStorageModule;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityFallenMeteor;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityFuelLoader;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityIngotCompressor;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityLandingPad;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityLandingPadSingle;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityOxygenCollector;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityOxygenCompressor;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityOxygenDecompressor;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityOxygenDetector;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityOxygenDistributor;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityOxygenPipe;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityOxygenSealer;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityOxygenStorageModule;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityParachest;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityRefinery;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntitySolar;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntitySpaceStationBase;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityTreasureChest;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.core.world.ChunkLoadingCallback;
import micdoodle8.mods.galacticraft.core.world.gen.GCCoreOverworldGenerator;
import micdoodle8.mods.galacticraft.moon.GalacticraftMoon;
import micdoodle8.mods.galacticraft.moon.dimension.GCMoonWorldProvider;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldProviderSurface;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

@Mod(name="Galacticraft Core", version="2.0.13", useMetadata=true, modid="GalacticraftCore", dependencies="required-after:Forge@[9.10.0.837,); after:ICBM|Explosion; after:IC2; after:BuildCraft|Core; after:BuildCraft|Energy; after:IC2")
@NetworkMod(channels={"GalacticraftCore"}, clientSideRequired=true, serverSideRequired=false, connectionHandler=GCCoreConnectionHandler.class, packetHandler=GCCorePacketManager.class)
public class GalacticraftCore {
    public static final String NAME = "Galacticraft Core";
    public static final String MODID = "GalacticraftCore";
    public static final String CHANNEL = "GalacticraftCore";
    public static final String CHANNELENTITIES = "GCCoreEntities";
    public static final int LOCALMAJVERSION = 2;
    public static final int LOCALMINVERSION = 0;
    public static final int LOCALBUILDVERSION = 13;
    public static int remoteMajVer;
    public static int remoteMinVer;
    public static int remoteBuildVer;
    @SidedProxy(clientSide="micdoodle8.mods.galacticraft.core.client.ClientProxyCore", serverSide="micdoodle8.mods.galacticraft.core.CommonProxyCore")
    public static CommonProxyCore proxy;
    @Mod.Instance(value="GalacticraftCore")
    public static GalacticraftCore instance;
    private static GCCoreThreadRequirementMissing missingRequirementThread;
    public static Map<String, GCCorePlayerSP> playersClient;
    public static Map<String, GCCorePlayerMP> playersServer;
    public static List<IPlanet> mapPlanets;
    public static HashMap<IPlanet, ArrayList<IMoon>> mapMoons;
    public static CreativeTabs galacticraftTab;
    public static final IGalaxy galaxyMilkyWay;
    public static final String FILE_PATH = "/micdoodle8/mods/galacticraft/core/";
    public static final String CLIENT_PATH = "client/";
    public static final String LANGUAGE_PATH = "/assets/galacticraftcore/lang/";
    public static final String BLOCK_TEXTURE_FILE = "/micdoodle8/mods/galacticraft/core/client/blocks/core.png";
    public static final String ITEM_TEXTURE_FILE = "/micdoodle8/mods/galacticraft/core/client/items/core.png";
    public static final String CONFIG_FILE = "Galacticraft/core.conf";
    public static final String POWER_CONFIG_FILE = "Galacticraft/power.conf";
    public static final String CHUNKLOADER_CONFIG_FILE = "Galacticraft/chunkloading.conf";
    public static String ASSET_DOMAIN;
    public static String ASSET_PREFIX;
    public static boolean setSpaceStationRecipe;
    public static GCCorePlanetOverworld overworld;
    public static GCCorePlanetSun sun;
    public static Fluid gcFluidOil;
    public static Fluid gcFluidFuel;
    public static Fluid fluidOil;
    public static Fluid fluidFuel;
    public static HashMap<String, ItemStack> itemList;
    public static HashMap<String, ItemStack> blocksList;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        GalacticraftMoon.preLoad(event);
        MinecraftForge.EVENT_BUS.register((Object)new GCCoreEvents());
        proxy.preInit(event);
        GCCoreConfigManager.setDefaultValues(new File(event.getModConfigurationDirectory(), CONFIG_FILE));
        NetworkConfigHandler.setDefaultValues(new File(event.getModConfigurationDirectory(), POWER_CONFIG_FILE));
        ChunkLoadingCallback.loadConfig(new File(event.getModConfigurationDirectory(), CHUNKLOADER_CONFIG_FILE));
        gcFluidOil = new Fluid("oil").setDensity(800).setViscosity(1500);
        gcFluidFuel = new Fluid("fuel").setDensity(200).setViscosity(900);
        FluidRegistry.registerFluid((Fluid)gcFluidOil);
        FluidRegistry.registerFluid((Fluid)gcFluidFuel);
        fluidOil = FluidRegistry.getFluid((String)"oil");
        fluidFuel = FluidRegistry.getFluid((String)"fuel");
        if (fluidOil.getBlockID() == -1) {
            GCCoreBlocks.crudeOilStill = new GCCoreBlockFluid(GCCoreConfigManager.idBlockCrudeOilStill, fluidOil, "oil");
            ((GCCoreBlockFluid)GCCoreBlocks.crudeOilStill).setQuantaPerBlock(3);
            GCCoreBlocks.crudeOilStill.func_71864_b("crudeOilStill");
            GameRegistry.registerBlock((Block)GCCoreBlocks.crudeOilStill, GCCoreItemBlock.class, (String)GCCoreBlocks.crudeOilStill.func_71917_a(), (String)"GalacticraftCore");
            fluidOil.setBlockID(GCCoreBlocks.crudeOilStill);
        } else {
            GCCoreBlocks.crudeOilStill = Block.field_71973_m[fluidOil.getBlockID()];
        }
        if (fluidFuel.getBlockID() == -1) {
            GCCoreBlocks.fuelStill = new GCCoreBlockFluid(GCCoreConfigManager.idBlockFuel, fluidFuel, "fuel");
            ((GCCoreBlockFluid)GCCoreBlocks.fuelStill).setQuantaPerBlock(6);
            GCCoreBlocks.fuelStill.func_71864_b("fuel");
            GameRegistry.registerBlock((Block)GCCoreBlocks.fuelStill, GCCoreItemBlock.class, (String)GCCoreBlocks.fuelStill.func_71917_a(), (String)"GalacticraftCore");
            fluidFuel.setBlockID(GCCoreBlocks.fuelStill);
        } else {
            GCCoreBlocks.fuelStill = Block.field_71973_m[fluidFuel.getBlockID()];
        }
        GCCoreBlocks.initBlocks();
        GCCoreItems.initItems();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        int i;
        galacticraftTab = new GCCoreCreativeTab(CreativeTabs.getNextID(), "GalacticraftCore", GCCoreItems.rocketTier1.field_77779_bT, 0);
        overworld = new GCCorePlanetOverworld();
        GalacticraftRegistry.registerCelestialBody(overworld);
        sun = new GCCorePlanetSun();
        GalacticraftRegistry.registerCelestialBody(sun);
        GalacticraftRegistry.registerGalaxy(galaxyMilkyWay);
        DimensionManager.registerProviderType((int)GCCoreConfigManager.idDimensionOverworldOrbit, GCCoreWorldProviderSpaceStation.class, (boolean)false);
        DimensionManager.registerProviderType((int)GCCoreConfigManager.idDimensionOverworldOrbitStatic, GCCoreWorldProviderSpaceStation.class, (boolean)true);
        proxy.init(event);
        GalacticraftRegistry.registerTeleportType(WorldProviderSurface.class, new GCCoreOverworldTeleportType());
        GalacticraftRegistry.registerTeleportType(GCCoreWorldProviderSpaceStation.class, new GCCoreOrbitTeleportType());
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)instance, (ForgeChunkManager.LoadingCallback)new ChunkLoadingCallback());
        GameRegistry.registerPlayerTracker((IPlayerTracker)new PlayerTracker());
        GalacticraftMoon.load(event);
        for (i = GCCoreItems.fuelCanister.func_77612_l() - 1; i > 0; --i) {
            FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)new FluidContainerRegistry.FluidContainerData(new FluidStack(fluidFuel, GCCoreItems.fuelCanister.func_77612_l() - i), new ItemStack(GCCoreItems.fuelCanister, 1, i), new ItemStack(GCCoreItems.oilCanister, 1, GCCoreItems.fuelCanister.func_77612_l())));
        }
        for (i = GCCoreItems.oilCanister.func_77612_l() - 1; i > 0; --i) {
            FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)new FluidContainerRegistry.FluidContainerData(new FluidStack(fluidOil, GCCoreItems.oilCanister.func_77612_l() - i), new ItemStack(GCCoreItems.oilCanister, 1, i), new ItemStack(GCCoreItems.oilCanister, 1, GCCoreItems.fuelCanister.func_77612_l())));
        }
        SchematicRegistry.registerSchematicRecipe(new GCCoreSchematicRocketT1());
        SchematicRegistry.registerSchematicRecipe(new GCCoreSchematicMoonBuggy());
        SchematicRegistry.registerSchematicRecipe(new GCCoreSchematicAdd());
        ChunkPowerHandler.initiate();
        NetworkConfigHandler.initGas();
        this.registerCreatures();
        this.registerOtherEntities();
        NetworkRegistry.instance().registerChannel((IPacketHandler)new GCCorePacketManager(), CHANNELENTITIES, Side.CLIENT);
        NetworkRegistry.instance().registerChannel((IPacketHandler)new GCCorePacketManager(), CHANNELENTITIES, Side.SERVER);
        GalacticraftRegistry.registerRocketGui(GCCoreWorldProviderSpaceStation.class, new ResourceLocation(ASSET_DOMAIN, "textures/gui/overworldRocketGui.png"));
        GalacticraftRegistry.registerRocketGui(WorldProviderSurface.class, new ResourceLocation(ASSET_DOMAIN, "textures/gui/overworldRocketGui.png"));
        GalacticraftRegistry.registerRocketGui(GCMoonWorldProvider.class, new ResourceLocation(ASSET_DOMAIN, "textures/gui/moonRocketGui.png"));
        GalacticraftRegistry.addDungeonLoot(1, new ItemStack(GCCoreItems.schematic, 1, 0));
        GalacticraftRegistry.addDungeonLoot(1, new ItemStack(GCCoreItems.schematic, 1, 1));
        if (GCCoreConfigManager.enableCopperOreGen) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new GCCoreOverworldGenerator(GCCoreBlocks.basicBlock, 5, 24, 0, 75, 7));
        }
        if (GCCoreConfigManager.enableTinOreGen) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new GCCoreOverworldGenerator(GCCoreBlocks.basicBlock, 6, 22, 0, 60, 7));
        }
        if (GCCoreConfigManager.enableAluminumOreGen) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new GCCoreOverworldGenerator(GCCoreBlocks.basicBlock, 7, 18, 0, 45, 7));
        }
        if (GCCoreConfigManager.enableSiliconOreGen) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new GCCoreOverworldGenerator(GCCoreBlocks.basicBlock, 8, 3, 0, 25, 7));
        }
        FMLInterModComms.sendMessage((String)"OpenBlocks", (String)"donateUrl", (String)"http://www.patreon.com/micdoodle8");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        for (ICelestialBody celestialBody : GalacticraftRegistry.getCelestialBodies()) {
            if (!celestialBody.autoRegister()) continue;
            int id = Arrays.binarySearch(GCCoreConfigManager.staticLoadDimensions, celestialBody.getDimensionID());
            DimensionManager.registerProviderType((int)celestialBody.getDimensionID(), celestialBody.getWorldProvider(), (celestialBody.forceStaticLoad() || id < 0 ? 1 : 0) != 0);
        }
        GCCoreCompatibilityManager.checkForCompatibleMods();
        this.registerTileEntities();
        GCCoreRecipeManager.loadRecipes();
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)new GCCoreGuiHandler());
        proxy.postInit(event);
        proxy.registerRenderInformation();
        for (int i = 3; i < 8; ++i) {
            if (!GCCoreItemBasic.names[i].contains("ingot")) continue;
            for (ItemStack stack : OreDictionary.getOres((String)GCCoreItemBasic.names[i])) {
                CompressorRecipes.addShapelessRecipe(new ItemStack(GCCoreItems.basicItem, 1, i + 3), stack, stack);
            }
        }
        if (OreDictionary.getOres((String)"ingotAluminium").size() > 0 || OreDictionary.getOres((String)"ingotNaturalAluminum").size() > 0) {
            ArrayList aluminumIngotList = new ArrayList();
            aluminumIngotList.addAll(OreDictionary.getOres((String)"ingotAluminium"));
            aluminumIngotList.addAll(OreDictionary.getOres((String)"ingotNaturalAluminum"));
            if (OreDictionary.getOres((String)"ingotAluminium").size() > 0) {
                OreDictionary.registerOre((String)"ingotAluminium", (ItemStack)new ItemStack(GCCoreItems.basicItem, 1, 8));
            }
            if (OreDictionary.getOres((String)"ingotNaturalAluminum").size() > 0) {
                OreDictionary.registerOre((String)"ingotNaturalAluminum", (ItemStack)new ItemStack(GCCoreItems.basicItem, 1, 8));
            }
            for (ItemStack stack : aluminumIngotList) {
                CompressorRecipes.addShapelessRecipe(new ItemStack(GCCoreItems.basicItem, 1, 8), stack, stack);
            }
        }
        if (OreDictionary.getOres((String)"ingotBronze").size() > 0) {
            for (ItemStack stack : OreDictionary.getOres((String)"ingotBronze")) {
                CompressorRecipes.addShapelessRecipe(new ItemStack(GCCoreItems.basicItem, 1, 10), stack, stack);
            }
            OreDictionary.registerOre((String)"ingotBronze", (ItemStack)new ItemStack(GCCoreItems.basicItem, 1, 10));
        }
        if (OreDictionary.getOres((String)"ingotSteel").size() > 0) {
            for (ItemStack stack : OreDictionary.getOres((String)"ingotSteel")) {
                CompressorRecipes.addShapelessRecipe(new ItemStack(GCCoreItems.basicItem, 1, 9), stack, stack);
            }
            OreDictionary.registerOre((String)"ingotSteel", (ItemStack)new ItemStack(GCCoreItems.basicItem, 1, 9));
        }
        CompressorRecipes.addShapelessRecipe(new ItemStack(GCCoreItems.basicItem, 1, 9), Item.field_77705_m, new ItemStack(GCCoreItems.basicItem, 1, 11), Item.field_77705_m);
        CompressorRecipes.addShapelessRecipe(new ItemStack(GCCoreItems.basicItem, 1, 10), new ItemStack(GCCoreItems.basicItem, 1, 6), new ItemStack(GCCoreItems.basicItem, 1, 7));
        CompressorRecipes.addShapelessRecipe(new ItemStack(GCCoreItems.basicItem, 1, 11), Item.field_77703_o, Item.field_77703_o);
        CompressorRecipes.addShapelessRecipe(new ItemStack(GCCoreItems.meteoricIronIngot, 1, 1), new ItemStack(GCCoreItems.meteoricIronIngot, 1, 0));
        CompressorRecipes.addRecipe(new ItemStack(GCCoreItems.heavyPlatingTier1, 1, 0), "XYZ", "XYZ", Character.valueOf('X'), new ItemStack(GCCoreItems.basicItem, 1, 9), Character.valueOf('Y'), new ItemStack(GCCoreItems.basicItem, 1, 8), Character.valueOf('Z'), new ItemStack(GCCoreItems.basicItem, 1, 10));
        CircuitFabricatorRecipes.addRecipe(new ItemStack(GCCoreItems.basicItem, 9, 12), new ItemStack[]{new ItemStack(Item.field_77702_n), new ItemStack(GCCoreItems.basicItem, 1, 2), new ItemStack(GCCoreItems.basicItem, 1, 2), new ItemStack(Item.field_77767_aC), new ItemStack(Item.field_77756_aW, 1, 4)});
        CircuitFabricatorRecipes.addRecipe(new ItemStack(GCCoreItems.basicItem, 3, 13), new ItemStack[]{new ItemStack(Item.field_77702_n), new ItemStack(GCCoreItems.basicItem, 1, 2), new ItemStack(GCCoreItems.basicItem, 1, 2), new ItemStack(Item.field_77767_aC), new ItemStack(Block.field_72035_aQ)});
        CircuitFabricatorRecipes.addRecipe(new ItemStack(GCCoreItems.basicItem, 1, 14), new ItemStack[]{new ItemStack(Item.field_77702_n), new ItemStack(GCCoreItems.basicItem, 1, 2), new ItemStack(GCCoreItems.basicItem, 1, 2), new ItemStack(Item.field_77767_aC), new ItemStack(Item.field_77742_bb)});
        TickRegistry.registerTickHandler((ITickHandler)new GCCoreTickHandlerServer(), (Side)Side.SERVER);
        NetworkRegistry.instance().registerChannel((IPacketHandler)new GCCorePacketHandlerServer(), "GalacticraftCore", Side.SERVER);
    }

    @Mod.EventHandler
    public void serverInit(FMLServerStartedEvent event) {
        if (missingRequirementThread == null) {
            missingRequirementThread = new GCCoreThreadRequirementMissing(FMLCommonHandler.instance().getEffectiveSide());
            missingRequirementThread.start();
        }
        GCCoreUtil.checkVersion(Side.SERVER);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new GCCoreCommandSpaceStationAddOwner());
        event.registerServerCommand((ICommand)new GCCoreCommandSpaceStationRemoveOwner());
        event.registerServerCommand((ICommand)new GCCoreCommandPlanetTeleport());
        event.registerServerCommand((ICommand)new GCCoreCommandKeepDim());
        event.registerServerCommand((ICommand)new GCCoreCommandGCInv());
        WorldUtil.registerSpaceStations(event.getServer().func_71218_a(0).func_72860_G().func_75758_b("dummy").getParentFile());
        for (ICelestialBody celestialBody : GalacticraftRegistry.getCelestialBodies()) {
            if (!celestialBody.autoRegister()) continue;
            int id = Arrays.binarySearch(GCCoreConfigManager.staticLoadDimensions, celestialBody.getDimensionID());
            WorldUtil.registerPlanet(celestialBody.getDimensionID(), true);
            if (id < 0) continue;
            FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(celestialBody.getDimensionID());
        }
        BlockVec3.chunkCacheDim = Integer.MAX_VALUE;
    }

    @Mod.EventHandler
    public void unregisterDims(FMLServerStoppedEvent var1) {
        WorldUtil.unregisterPlanets();
        WorldUtil.unregisterSpaceStations();
    }

    public void registerTileEntities() {
        GameRegistry.registerTileEntity(GCCoreTileEntityTreasureChest.class, (String)(GCCoreCompatibilityManager.isAIILoaded() ? "Space Treasure Chest" : "Treasure Chest"));
        GameRegistry.registerTileEntity(GCCoreTileEntityOxygenDistributor.class, (String)"Air Distributor");
        GameRegistry.registerTileEntity(GCCoreTileEntityOxygenCollector.class, (String)"Air Collector");
        GameRegistry.registerTileEntity(GCCoreTileEntityOxygenPipe.class, (String)"Oxygen Pipe");
        GameRegistry.registerTileEntity(GCCoreTileEntityAirLock.class, (String)"Air Lock Frame");
        GameRegistry.registerTileEntity(GCCoreTileEntityRefinery.class, (String)"Refinery");
        GameRegistry.registerTileEntity(GCCoreTileEntityAdvancedCraftingTable.class, (String)"NASA Workbench");
        GameRegistry.registerTileEntity(GCCoreTileEntityOxygenCompressor.class, (String)"Air Compressor");
        GameRegistry.registerTileEntity(GCCoreTileEntityFuelLoader.class, (String)"Fuel Loader");
        GameRegistry.registerTileEntity(GCCoreTileEntityLandingPadSingle.class, (String)"Landing Pad");
        GameRegistry.registerTileEntity(GCCoreTileEntityLandingPad.class, (String)"Landing Pad Full");
        GameRegistry.registerTileEntity(GCCoreTileEntitySpaceStationBase.class, (String)"Space Station");
        GameRegistry.registerTileEntity(TileEntityMulti.class, (String)"Dummy Block");
        GameRegistry.registerTileEntity(GCCoreTileEntityOxygenSealer.class, (String)"Air Sealer");
        GameRegistry.registerTileEntity(GCCoreTileEntityDungeonSpawner.class, (String)"Dungeon Boss Spawner");
        GameRegistry.registerTileEntity(GCCoreTileEntityOxygenDetector.class, (String)"Oxygen Detector");
        GameRegistry.registerTileEntity(GCCoreTileEntityBuggyFueler.class, (String)"Buggy Fueler");
        GameRegistry.registerTileEntity(GCCoreTileEntityBuggyFuelerSingle.class, (String)"Buggy Fueler Single");
        GameRegistry.registerTileEntity(GCCoreTileEntityCargoLoader.class, (String)"Cargo Loader");
        GameRegistry.registerTileEntity(GCCoreTileEntityCargoUnloader.class, (String)"Cargo Unloader");
        GameRegistry.registerTileEntity(GCCoreTileEntityParachest.class, (String)"Parachest Tile");
        GameRegistry.registerTileEntity(GCCoreTileEntitySolar.class, (String)"Galacticraft Solar Panel");
        GameRegistry.registerTileEntity(GCCoreTileEntityEnergyStorageModule.class, (String)"Energy Storage Module");
        GameRegistry.registerTileEntity(GCCoreTileEntityCoalGenerator.class, (String)"Galacticraft Coal Generator");
        GameRegistry.registerTileEntity(GCCoreTileEntityElectricFurnace.class, (String)"Galacticraft Electric Furnace");
        GameRegistry.registerTileEntity(GCCoreTileEntityAluminumWire.class, (String)"Galacticraft Aluminum Wire");
        GameRegistry.registerTileEntity(GCCoreTileEntityFallenMeteor.class, (String)"Fallen Meteor");
        GameRegistry.registerTileEntity(GCCoreTileEntityIngotCompressor.class, (String)"Ingot Compressor");
        GameRegistry.registerTileEntity(GCCoreTileEntityElectricIngotCompressor.class, (String)"Electric Ingot Compressor");
        GameRegistry.registerTileEntity(GCCoreTileEntityCircuitFabricator.class, (String)"Circuit Fabricator");
        GameRegistry.registerTileEntity(GCCoreTileEntityAirLockController.class, (String)"Air Lock Controller");
        GameRegistry.registerTileEntity(GCCoreTileEntityOxygenStorageModule.class, (String)"Oxygen Storage Module");
        GameRegistry.registerTileEntity(GCCoreTileEntityOxygenDecompressor.class, (String)"Oxygen Decompressor");
    }

    public void registerCreatures() {
        GCCoreUtil.registerGalacticraftCreature(GCCoreEntitySpider.class, "EvolvedSpider", GCCoreConfigManager.idEntityEvolvedSpider, 3419431, 11013646);
        GCCoreUtil.registerGalacticraftCreature(GCCoreEntityZombie.class, "EvolvedZombie", GCCoreConfigManager.idEntityEvolvedZombie, 44975, 7969893);
        GCCoreUtil.registerGalacticraftCreature(GCCoreEntityCreeper.class, "EvolvedCreeper", GCCoreConfigManager.idEntityEvolvedCreeper, 894731, 0);
        GCCoreUtil.registerGalacticraftCreature(GCCoreEntitySkeleton.class, "EvolvedSkeleton", GCCoreConfigManager.idEntityEvolvedSkeleton, 0xC1C1C1, 0x494949);
        GCCoreUtil.registerGalacticraftCreature(GCCoreEntitySkeletonBoss.class, "EvolvedSkeletonBoss", GCCoreConfigManager.idEntityEvolvedSkeletonBoss, 0xC1C1C1, 0x494949);
        GCCoreUtil.registerGalacticraftCreature(GCCoreEntityAlienVillager.class, "AlienVillager", GCCoreConfigManager.idEntityAlienVillager, GCCoreUtil.convertTo32BitColor(255, 103, 181, 145), 12422002);
    }

    public void registerOtherEntities() {
        GCCoreUtil.registerGalacticraftNonMobEntity(GCCoreEntityRocketT1.class, "Spaceship", GCCoreConfigManager.idEntitySpaceship, 150, 1, false);
        GCCoreUtil.registerGalacticraftNonMobEntity(GCCoreEntityArrow.class, "GravityArrow", GCCoreConfigManager.idEntityAntiGravityArrow, 150, 5, true);
        GCCoreUtil.registerGalacticraftNonMobEntity(GCCoreEntityMeteor.class, "Meteor", GCCoreConfigManager.idEntityMeteor, 150, 5, true);
        GCCoreUtil.registerGalacticraftNonMobEntity(GCCoreEntityBuggy.class, "Buggy", GCCoreConfigManager.idEntityBuggy, 150, 5, true);
        GCCoreUtil.registerGalacticraftNonMobEntity(GCCoreEntityFlag.class, "GCFlag", GCCoreConfigManager.idEntityFlag, 150, 5, true);
        GCCoreUtil.registerGalacticraftNonMobEntity(GCCoreEntityParaChest.class, "ParaChest", GCCoreConfigManager.idEntityParaChest, 150, 5, true);
        GCCoreUtil.registerGalacticraftNonMobEntity(GCCoreEntityOxygenBubble.class, "OxygenBubble", GCCoreConfigManager.idEntityOxygenBubble, 150, 20, false);
        GCCoreUtil.registerGalacticraftNonMobEntity(GCCoreEntityLander.class, "Lander", GCCoreConfigManager.idEntityLander, 150, 5, false);
        GCCoreUtil.registerGalacticraftNonMobEntity(GCCoreEntityMeteorChunk.class, "MeteorChunk", GCCoreConfigManager.idEntityMeteorChunk, 150, 5, true);
    }

    static {
        playersClient = new HashMap<String, GCCorePlayerSP>();
        playersServer = new HashMap<String, GCCorePlayerMP>();
        mapPlanets = new ArrayList<IPlanet>();
        mapMoons = new HashMap();
        galaxyMilkyWay = new GCCoreGalaxyBlockyWay();
        ASSET_DOMAIN = "galacticraftcore";
        ASSET_PREFIX = ASSET_DOMAIN + ":";
        setSpaceStationRecipe = false;
        itemList = new HashMap();
        blocksList = new HashMap();
    }

    public static class OrientCameraEvent
    extends Event {
    }

    public static class SleepCancelledEvent
    extends Event {
    }
}

