/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlockAdvancedTile;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityOxygenCompressor;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityOxygenDecompressor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class GCCoreBlockOxygenCompressor
extends GCCoreBlockAdvancedTile {
    public static final int OXYGEN_COMPRESSOR_METADATA = 0;
    public static final int OXYGEN_DECOMPRESSOR_METADATA = 4;
    private Icon iconMachineSide;
    private Icon iconCompressor1;
    private Icon iconCompressor2;
    private Icon iconDecompressor;
    private Icon iconOxygenInput;
    private Icon iconOxygenOutput;
    private Icon iconInput;

    public GCCoreBlockOxygenCompressor(int id, boolean isActive, String assetName) {
        super(id, Material.field_76246_e);
        this.func_71848_c(1.0f);
        this.func_71884_a(Block.field_71976_h);
        this.func_111022_d(GalacticraftCore.ASSET_PREFIX + assetName);
        this.func_71864_b(assetName);
    }

    public int func_71857_b() {
        return GalacticraftCore.proxy.getBlockRenderID(this.field_71990_ca);
    }

    public CreativeTabs func_71882_w() {
        return GalacticraftCore.galacticraftTab;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister par1IconRegister) {
        this.iconMachineSide = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "machine_blank");
        this.iconCompressor1 = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "machine_compressor_1");
        this.iconCompressor2 = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "machine_compressor_2");
        this.iconDecompressor = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "machine_decompressor_1");
        this.iconOxygenInput = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "machine_oxygen_input");
        this.iconOxygenOutput = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "machine_oxygen_output");
        this.iconInput = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "machine_input");
    }

    @Override
    public boolean onUseWrench(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        int metadata;
        int original = metadata = par1World.func_72805_g(x, y, z);
        if (metadata >= 4) {
            original -= 4;
        } else if (metadata >= 0) {
            original += 0;
        }
        int meta = 0;
        switch (original) {
            case 0: {
                meta = 3;
                break;
            }
            case 3: {
                meta = 1;
                break;
            }
            case 1: {
                meta = 2;
                break;
            }
            case 2: {
                meta = 0;
            }
        }
        if (metadata >= 4) {
            meta += 4;
        } else if (metadata >= 0) {
            meta += 0;
        }
        par1World.func_72921_c(x, y, z, meta, 3);
        return true;
    }

    @Override
    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        entityPlayer.openGui((Object)GalacticraftCore.instance, -1, world, x, y, z);
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata >= 4) {
            return new GCCoreTileEntityOxygenDecompressor();
        }
        if (metadata >= 0) {
            return new GCCoreTileEntityOxygenCompressor();
        }
        return null;
    }

    public Icon func_71858_a(int side, int metadata) {
        if (side == 0 || side == 1) {
            return this.iconMachineSide;
        }
        if (metadata >= 4) {
            if (side == (metadata -= 4) + 2) {
                return this.iconInput;
            }
            if (side == ForgeDirection.getOrientation((int)(metadata + 2)).getOpposite().ordinal()) {
                return this.iconOxygenOutput;
            }
            if (metadata == 0 && side == 5 || metadata == 3 && side == 3 || metadata == 1 && side == 4 || metadata == 2 && side == 2) {
                return this.iconCompressor2;
            }
            return this.iconDecompressor;
        }
        if (metadata >= 0) {
            if (side == (metadata += 0) + 2) {
                return this.iconInput;
            }
            if (side == ForgeDirection.getOrientation((int)(metadata + 2)).getOpposite().ordinal()) {
                return this.iconOxygenInput;
            }
            if (metadata == 0 && side == 5 || metadata == 3 && side == 3 || metadata == 1 && side == 4 || metadata == 2 && side == 2) {
                return this.iconCompressor2;
            }
            return this.iconCompressor1;
        }
        return this.iconMachineSide;
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        int angle = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = 0;
        switch (angle) {
            case 0: {
                change = 3;
                break;
            }
            case 1: {
                change = 1;
                break;
            }
            case 2: {
                change = 2;
                break;
            }
            case 3: {
                change = 0;
            }
        }
        if (itemStack.func_77960_j() >= 4) {
            change += 4;
        } else if (itemStack.func_77960_j() >= 0) {
            change += 0;
        }
        world.func_72921_c(x, y, z, change, 3);
    }

    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(this.field_71990_ca, 1, 0));
        par3List.add(new ItemStack(this.field_71990_ca, 1, 4));
    }

    public int func_71899_b(int metadata) {
        if (metadata >= 4) {
            return 4;
        }
        if (metadata >= 0) {
            return 0;
        }
        return 0;
    }

    @Override
    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        Item item = Item.field_77698_e[this.field_71990_ca];
        if (item == null) {
            return null;
        }
        int metadata = this.func_71873_h(world, x, y, z);
        return new ItemStack(this.field_71990_ca, 1, metadata);
    }
}

