/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.gui;

import cpw.mods.fml.client.FMLClientHandler;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatAllowedCharacters;
import org.lwjgl.input.Keyboard;

public class GCCoreGuiTextBox
extends GuiButton {
    public String text;
    public boolean numericOnly;
    private int maxLength;
    public long timeBackspacePressed;
    public int cursorPulse;
    public int backspacePressed;
    public boolean isTextFocused = false;
    public int incorrectUseTimer;
    private ITextBoxCallback parentGui;
    private Minecraft mc = FMLClientHandler.instance().getClient();

    public GCCoreGuiTextBox(int id, ITextBoxCallback parentGui, int x, int y, int width, int height, String initialText, boolean numericOnly, int maxLength) {
        super(id, x, y, width, height, initialText);
        this.parentGui = parentGui;
        this.numericOnly = numericOnly;
        this.maxLength = maxLength;
    }

    public boolean keyTyped(char keyChar, int keyID) {
        if (this.isTextFocused) {
            if (keyID == 14) {
                if (this.text.length() > 0) {
                    if (this.parentGui.canPlayerEdit(this, (EntityPlayer)this.mc.field_71439_g)) {
                        String toBeParsed = this.text.substring(0, this.text.length() - 1);
                        if (this.isValid(toBeParsed)) {
                            this.text = toBeParsed;
                            this.timeBackspacePressed = System.currentTimeMillis();
                        } else {
                            this.text = "";
                        }
                    } else {
                        this.incorrectUseTimer = 10;
                        this.parentGui.onIntruderInteraction();
                    }
                }
            } else if (keyChar == '\u0016') {
                String pastestring = GuiScreen.func_73870_l();
                if (pastestring == null) {
                    pastestring = "";
                }
                if (this.isValid(this.text + pastestring)) {
                    if (this.parentGui.canPlayerEdit(this, (EntityPlayer)this.mc.field_71439_g)) {
                        this.text = this.text + pastestring;
                        this.text = this.text.substring(0, Math.min(String.valueOf(this.text).length(), this.maxLength));
                    } else {
                        this.incorrectUseTimer = 10;
                        this.parentGui.onIntruderInteraction();
                    }
                }
            } else if (this.isValid(this.text + keyChar)) {
                if (this.parentGui.canPlayerEdit(this, (EntityPlayer)this.mc.field_71439_g)) {
                    this.text = this.text + keyChar;
                    this.text = this.text.substring(0, Math.min(this.text.length(), this.maxLength));
                } else {
                    this.incorrectUseTimer = 10;
                    this.parentGui.onIntruderInteraction();
                }
            }
            this.parentGui.onTextChanged(this, this.text);
            return true;
        }
        return false;
    }

    public void func_73737_a(Minecraft par1Minecraft, int par2, int par3) {
        if (this.text == null) {
            this.text = this.parentGui.getInitialText(this);
            this.parentGui.onTextChanged(this, this.text);
        }
        if (this.field_73748_h) {
            Gui.func_73734_a((int)this.field_73746_c, (int)this.field_73743_d, (int)(this.field_73746_c + this.field_73747_a), (int)(this.field_73743_d + this.field_73745_b), (int)GCCoreUtil.convertTo32BitColor(140, 140, 140, 140));
            Gui.func_73734_a((int)(this.field_73746_c + 1), (int)(this.field_73743_d + 1), (int)(this.field_73746_c + this.field_73747_a - 1), (int)(this.field_73743_d + this.field_73745_b - 1), (int)GCCoreUtil.convertTo32BitColor(255, 0, 0, 0));
            ++this.cursorPulse;
            if (this.timeBackspacePressed > 0L) {
                if (Keyboard.isKeyDown((int)14) && this.text.length() > 0) {
                    if ((float)(System.currentTimeMillis() - this.timeBackspacePressed) > 200.0f / (1.0f + (float)this.backspacePressed * 0.3f) && this.parentGui.canPlayerEdit(this, (EntityPlayer)this.mc.field_71439_g)) {
                        String toBeParsed = this.text.substring(0, this.text.length() - 1);
                        if (this.isValid(toBeParsed)) {
                            this.text = toBeParsed;
                            this.parentGui.onTextChanged(this, this.text);
                        } else {
                            this.text = "";
                        }
                        this.timeBackspacePressed = System.currentTimeMillis();
                        ++this.backspacePressed;
                    } else if (!this.parentGui.canPlayerEdit(this, (EntityPlayer)this.mc.field_71439_g)) {
                        this.incorrectUseTimer = 10;
                        this.parentGui.onIntruderInteraction();
                    }
                } else {
                    this.timeBackspacePressed = 0L;
                    this.backspacePressed = 0;
                }
            }
            if (this.incorrectUseTimer > 0) {
                --this.incorrectUseTimer;
            }
            this.func_73731_b(this.mc.field_71466_p, this.text + (this.cursorPulse / 24 % 2 == 0 && this.isTextFocused ? "_" : ""), this.field_73746_c + 4, this.field_73743_d + this.field_73745_b / 2 - 4, this.incorrectUseTimer > 0 ? GCCoreUtil.convertTo32BitColor(255, 255, 20, 20) : this.parentGui.getTextColor(this));
        }
    }

    public int getIntegerValue() {
        try {
            return Integer.parseInt(this.text.equals("") ? "0" : this.text);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public boolean isValid(String string) {
        if (this.numericOnly) {
            if (string.length() > 0 && ChatAllowedCharacters.field_71568_a.indexOf(string.charAt(string.length() - 1)) >= 0) {
                try {
                    Integer.parseInt(string);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            return false;
        }
        if (string.length() <= 0) {
            return false;
        }
        return ChatAllowedCharacters.field_71568_a.indexOf(string.charAt(string.length() - 1)) >= 0;
    }

    public boolean func_73736_c(Minecraft par1Minecraft, int par2, int par3) {
        if (super.func_73736_c(par1Minecraft, par2, par3)) {
            Gui.func_73734_a((int)this.field_73746_c, (int)this.field_73743_d, (int)(this.field_73746_c + this.field_73747_a), (int)(this.field_73743_d + this.field_73745_b), (int)-6250336);
            this.isTextFocused = true;
            return true;
        }
        this.isTextFocused = false;
        return false;
    }

    public static interface ITextBoxCallback {
        public boolean canPlayerEdit(GCCoreGuiTextBox var1, EntityPlayer var2);

        public void onTextChanged(GCCoreGuiTextBox var1, String var2);

        public String getInitialText(GCCoreGuiTextBox var1);

        public int getTextColor(GCCoreGuiTextBox var1);

        public void onIntruderInteraction();
    }
}

