/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.fx.GCCoreEntityLanderFlameFX;
import micdoodle8.mods.galacticraft.core.entities.IControllableEntity;
import micdoodle8.mods.galacticraft.core.entities.IScaleableFuelLevel;
import micdoodle8.mods.galacticraft.core.entities.InventoryEntity;
import micdoodle8.mods.galacticraft.core.entities.player.GCCorePlayerMP;
import micdoodle8.mods.galacticraft.core.inventory.IInventorySettable;
import micdoodle8.mods.galacticraft.core.items.GCCoreItems;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketHandlerClient;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketHandlerServer;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketManager;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.PacketUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class GCCoreEntityLander
extends InventoryEntity
implements IInventorySettable,
IScaleableFuelLevel,
IControllableEntity {
    private final int tankCapacity = 5000;
    public FluidTank fuelTank = new FluidTank(this.tankCapacity);
    private boolean waitForPlayer;
    private boolean lastWaitForPlayer;
    public float currentDamage;
    public int timeSinceHit;
    public int rockDirection = 1;
    public boolean lastOnGround;
    private double lastMotionY;

    public GCCoreEntityLander(World par1World) {
        super(par1World);
        this.func_70105_a(3.5f, 4.8f);
        this.field_70158_ak = true;
        this.field_70178_ae = true;
    }

    public GCCoreEntityLander(GCCorePlayerMP player) {
        this(player.field_70170_p);
        this.containedItems = new ItemStack[player.getRocketStacks().length + 1];
        this.fuelTank.setFluid(new FluidStack(GalacticraftCore.fluidFuel, player.getFuelLevel()));
        for (int i = 0; i < player.getRocketStacks().length; ++i) {
            this.containedItems[i] = player.getRocketStacks()[i];
        }
    }

    protected void func_70088_a() {
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        NBTTagList itemList = nbt.func_74761_m("Items");
        this.containedItems = new ItemStack[nbt.func_74762_e("rocketStacksLength")];
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            NBTTagCompound itemTag = (NBTTagCompound)itemList.func_74743_b(i);
            int slotID = itemTag.func_74771_c("Slot") & 0xFF;
            if (slotID < 0 || slotID >= this.containedItems.length) continue;
            this.containedItems[slotID] = ItemStack.func_77949_a((NBTTagCompound)itemTag);
        }
        if (nbt.func_74764_b("fuelTank")) {
            this.fuelTank.readFromNBT(nbt.func_74775_l("fuelTank"));
        }
        this.setWaitForPlayer(nbt.func_74767_n("WaitingForPlayer"));
        this.lastOnGround = this.field_70122_E;
        this.lastMotionY = this.field_70181_x;
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        NBTTagList itemList = new NBTTagList();
        nbt.func_74768_a("rocketStacksLength", this.containedItems.length);
        for (int i = 0; i < this.containedItems.length; ++i) {
            if (this.containedItems[i] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)i);
            this.containedItems[i].func_77955_b(itemTag);
            itemList.func_74742_a((NBTBase)itemTag);
        }
        nbt.func_74782_a("Items", (NBTBase)itemList);
        if (this.fuelTank.getFluid() != null) {
            nbt.func_74782_a("fuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74757_a("WaitingForPlayer", this.getWaitForPlayer());
    }

    @Override
    public void func_70071_h_() {
        FluidStack liquid;
        AxisAlignedBB box;
        List var15;
        if (this.timeSinceHit > 0) {
            --this.timeSinceHit;
        }
        if (this.currentDamage > 0.0f) {
            this.currentDamage -= 1.0f;
        }
        if (this.getWaitForPlayer()) {
            if (this.field_70153_n != null) {
                if (this.field_70173_aa >= 40) {
                    if (!this.field_70170_p.field_72995_K) {
                        Entity e = this.field_70153_n;
                        this.field_70153_n.field_70154_o = null;
                        this.field_70153_n = null;
                        e.func_70078_a((Entity)this);
                    }
                    this.setWaitForPlayer(false);
                } else {
                    this.field_70179_y = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70159_w = 0.0;
                    this.field_70153_n.field_70179_y = 0.0;
                    this.field_70153_n.field_70181_x = 0.0;
                    this.field_70153_n.field_70159_w = 0.0;
                }
            } else {
                this.field_70179_y = 0.0;
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
            }
        }
        if (!this.waitForPlayer && this.lastWaitForPlayer) {
            this.field_70181_x = -3.5;
        }
        super.func_70071_h_();
        if (!this.field_70122_E && Math.abs(this.field_70181_x) > 0.01 && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.spawnParticles();
        }
        if ((var15 = this.field_70170_p.func_72839_b((Entity)this, box = this.field_70121_D.func_72314_b(0.2, 0.4, 0.2))) != null && !var15.isEmpty()) {
            for (int var52 = 0; var52 < var15.size(); ++var52) {
                Entity var17 = (Entity)var15.get(var52);
                if (var17 == this.field_70153_n) continue;
                this.pushEntityAway(var17);
            }
        }
        if (!this.field_70170_p.field_72995_K && (liquid = this.fuelTank.getFluid()) != null && this.fuelTank.getFluid() != null && this.fuelTank.getFluid().getFluid().getName().equalsIgnoreCase("Fuel") && FluidContainerRegistry.isEmptyContainer((ItemStack)this.containedItems[this.containedItems.length - 1])) {
            boolean isCanister = this.containedItems[this.containedItems.length - 1].func_77969_a(new ItemStack(GCCoreItems.oilCanister, 1, GCCoreItems.oilCanister.func_77612_l()));
            int amountToFill = Math.min(liquid.amount, isCanister ? GCCoreItems.fuelCanister.func_77612_l() - 1 : 1000);
            this.containedItems[this.containedItems.length - 1] = isCanister ? new ItemStack(GCCoreItems.fuelCanister, 1, GCCoreItems.fuelCanister.func_77612_l() - amountToFill) : FluidContainerRegistry.fillFluidContainer((FluidStack)liquid, (ItemStack)this.containedItems[this.containedItems.length - 1]);
            this.fuelTank.drain(amountToFill, true);
        }
        this.field_70181_x -= 0.008;
        if (this.field_70170_p.field_72995_K && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.sendPacketToServer();
        }
        if (this.field_70122_E) {
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
        } else {
            if (this.field_70170_p.field_72995_K) {
                this.field_70159_w = -50.0 * Math.cos(Math.toRadians(this.field_70177_z)) * Math.sin(Math.toRadians((double)this.field_70125_A * 0.01));
                this.field_70179_y = -50.0 * Math.sin(Math.toRadians(this.field_70177_z)) * Math.sin(Math.toRadians((double)this.field_70125_A * 0.01));
            }
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70122_E && !this.lastOnGround && Math.abs(this.lastMotionY) > 2.0) {
            if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayerMP) {
                Object[] toSend2 = new Object[]{0};
                ((EntityPlayerMP)this.field_70153_n).field_71135_a.func_72567_b((Packet)PacketUtil.createPacket("GalacticraftCore", GCCorePacketHandlerClient.EnumPacketClient.ZOOM_CAMERA, toSend2));
                this.field_70153_n.func_70078_a((Entity)this);
            }
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 12.0f, true);
            this.func_70106_y();
        }
        if (this.field_70122_E) {
            this.field_70125_A = 0.0f;
        }
        this.lastWaitForPlayer = this.waitForPlayer;
        this.lastOnGround = this.field_70122_E;
        this.lastMotionY = this.field_70181_x;
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles() {
        double x1 = 2.0 * Math.cos((double)this.field_70177_z * Math.PI / 180.0) * Math.sin((double)this.field_70125_A * Math.PI / 180.0);
        double z1 = 2.0 * Math.sin((double)this.field_70177_z * Math.PI / 180.0) * Math.sin((double)this.field_70125_A * Math.PI / 180.0);
        double y1 = -5.0;
        float angle1 = (float)((double)(this.field_70177_z - 40.0f) * Math.PI / 180.0);
        float angle2 = (float)((double)(this.field_70177_z + 40.0f) * Math.PI / 180.0);
        float angle3 = (float)((double)(this.field_70177_z + 180.0f - 40.0f) * Math.PI / 180.0);
        float angle4 = (float)((double)(this.field_70177_z + 180.0f + 40.0f) * Math.PI / 180.0);
        float pitch = (float)Math.sin((double)this.field_70125_A * Math.PI / 180.0);
        Vector3 vec1 = new Vector3(this).translate(new Vector3(0.4 * Math.cos(angle1) * Math.cos(pitch), 0.5, 0.4 * Math.sin(angle1) * Math.cos(pitch)));
        Vector3 vec2 = new Vector3(this).translate(new Vector3(0.4 * Math.cos(angle2) * Math.cos(pitch), 0.5, 0.4 * Math.sin(angle2) * Math.cos(pitch)));
        Vector3 vec3 = new Vector3(this).translate(new Vector3(0.4 * Math.cos(angle3) * Math.cos(pitch), 0.5, 0.4 * Math.sin(angle3) * Math.cos(pitch)));
        Vector3 vec4 = new Vector3(this).translate(new Vector3(0.4 * Math.cos(angle4) * Math.cos(pitch), 0.5, 0.4 * Math.sin(angle4) * Math.cos(pitch)));
        this.spawnParticle(new GCCoreEntityLanderFlameFX(this.field_70170_p, vec1.x, vec1.y, vec1.z, x1, -5.0, z1));
        this.spawnParticle(new GCCoreEntityLanderFlameFX(this.field_70170_p, vec2.x, vec2.y, vec2.z, x1, -5.0, z1));
        this.spawnParticle(new GCCoreEntityLanderFlameFX(this.field_70170_p, vec3.x, vec3.y, vec3.z, x1, -5.0, z1));
        this.spawnParticle(new GCCoreEntityLanderFlameFX(this.field_70170_p, vec4.x, vec4.y, vec4.z, x1, -5.0, z1));
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticle(EntityFX fx) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc != null && mc.field_71451_h != null && mc.field_71452_i != null && fx != null) {
            mc.field_71452_i.func_78873_a(fx);
        }
    }

    private void sendPacketToServer() {
        if (this.field_70153_n == FMLClientHandler.instance().getClient().field_71439_g) {
            PacketDispatcher.sendPacketToServer((Packet)GCCorePacketManager.getPacket("GCCoreEntities", (Entity)this, this.getNetworkedData(new ArrayList<Object>())));
        }
    }

    public void pushEntityAway(Entity par1Entity) {
        double d1;
        double d0;
        double d2;
        if (this.field_70153_n != par1Entity && this.field_70154_o != par1Entity && (d2 = MathHelper.func_76132_a((double)(d0 = this.field_70165_t - par1Entity.field_70165_t), (double)(d1 = this.field_70161_v - par1Entity.field_70161_v))) >= (double)0.01f) {
            d2 = MathHelper.func_76133_a((double)d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            par1Entity.func_70024_g(-(d0 *= (double)(1.0f - par1Entity.field_70144_Y)), 0.0, -(d1 *= (double)(1.0f - par1Entity.field_70144_Y)));
        }
    }

    @Override
    public boolean pressKey(int key) {
        if (this.field_70122_E) {
            return false;
        }
        float turnFactor = 2.0f;
        switch (key) {
            case 0: {
                if (!this.field_70122_E) {
                    this.field_70125_A = Math.min(Math.max(this.field_70125_A - 0.5f * turnFactor, -35.0f), 35.0f);
                }
                return true;
            }
            case 1: {
                if (!this.field_70122_E) {
                    this.field_70125_A = Math.min(Math.max(this.field_70125_A + 0.5f * turnFactor, -35.0f), 35.0f);
                }
                return true;
            }
            case 2: {
                if (!this.field_70122_E) {
                    this.field_70177_z -= 0.5f * turnFactor;
                }
                return true;
            }
            case 3: {
                if (!this.field_70122_E) {
                    this.field_70177_z += 0.5f * turnFactor;
                }
                return true;
            }
            case 4: {
                this.field_70181_x = Math.min(this.field_70181_x + (double)0.03f, -1.0);
                return true;
            }
            case 5: {
                this.field_70181_x = Math.min(this.field_70181_x - (double)0.022f, -1.0);
                return true;
            }
        }
        return false;
    }

    public double func_70042_X() {
        return 1.0;
    }

    public int func_70302_i_() {
        return this.containedItems.length;
    }

    public String func_70303_b() {
        return "Lander";
    }

    public boolean func_94042_c() {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    @Override
    public int getScaledFuelLevel(int scale) {
        return (int)((double)this.fuelTank.getFluidAmount() / (double)this.tankCapacity * (double)scale);
    }

    @Override
    public void setSizeInventory(int size) {
        this.containedItems = new ItemStack[size];
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public AxisAlignedBB func_70114_g(Entity par1Entity) {
        return null;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public boolean func_70097_a(DamageSource var1, float var2) {
        if (this.field_70128_L || var1.equals(DamageSource.field_76367_g) || this.field_70153_n != null) {
            return true;
        }
        this.rockDirection = -this.rockDirection;
        this.timeSinceHit = 10;
        this.currentDamage += var2 * 10.0f;
        this.func_70018_K();
        if (var1.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)var1.func_76346_g()).field_71075_bZ.field_75098_d) {
            this.currentDamage = 100.0f;
        }
        if (this.currentDamage > 70.0f) {
            if (this.field_70153_n != null) {
                if (this.field_70153_n instanceof EntityPlayerMP) {
                    Object[] toSend2 = new Object[]{0};
                    ((EntityPlayerMP)this.field_70153_n).field_71135_a.func_72567_b((Packet)PacketUtil.createPacket("GalacticraftCore", GCCorePacketHandlerClient.EnumPacketClient.ZOOM_CAMERA, toSend2));
                }
                this.field_70153_n.func_70078_a((Entity)this);
                return false;
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70153_n != null) {
                    this.field_70153_n.func_70078_a((Entity)this);
                }
                this.dropItems();
                this.func_70106_y();
            }
        }
        return true;
    }

    public boolean func_130002_c(EntityPlayer var1) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.field_70153_n == null && var1 instanceof EntityPlayerMP) {
            GCCoreUtil.openParachestInv((EntityPlayerMP)var1, this);
            return true;
        }
        if (var1 instanceof EntityPlayerMP) {
            ((EntityPlayerMP)var1).field_71135_a.func_72567_b((Packet)PacketUtil.createPacket("GalacticraftCore", GCCorePacketHandlerClient.EnumPacketClient.ZOOM_CAMERA, new Object[]{0}));
            var1.func_70078_a(null);
            return true;
        }
        return true;
    }

    @Override
    public void readNetworkedData(ByteArrayDataInput dataStream) {
        if (this.field_70170_p.field_72995_K) {
            int cargoLength = dataStream.readInt();
            if (this.containedItems == null || this.containedItems.length == 0) {
                this.containedItems = new ItemStack[cargoLength];
                PacketDispatcher.sendPacketToServer((Packet)PacketUtil.createPacket("GalacticraftCore", GCCorePacketHandlerServer.EnumPacketServer.UPDATE_DYNAMIC_ENTITY_INV, new Object[]{this.field_70157_k}));
            }
            this.fuelTank.setFluid(new FluidStack(GalacticraftCore.fluidFuel, dataStream.readInt()));
            this.setWaitForPlayer(dataStream.readBoolean());
            this.field_70122_E = dataStream.readBoolean();
        } else {
            this.field_70159_w = dataStream.readDouble() / 8000.0;
            this.field_70181_x = dataStream.readDouble() / 8000.0;
            this.field_70179_y = dataStream.readDouble() / 8000.0;
            this.field_70125_A = dataStream.readFloat();
            this.field_70177_z = dataStream.readFloat();
        }
    }

    @Override
    public ArrayList<Object> getNetworkedData(ArrayList<Object> list) {
        if (!this.field_70170_p.field_72995_K) {
            list.add(this.containedItems != null ? this.containedItems.length : 0);
            list.add(this.fuelTank.getFluidAmount());
            list.add(this.getWaitForPlayer());
            list.add(this.field_70122_E);
            return list;
        }
        list.add(this.field_70159_w * 8000.0);
        list.add(this.field_70181_x * 8000.0);
        list.add(this.field_70179_y * 8000.0);
        list.add(Float.valueOf(this.field_70125_A));
        list.add(Float.valueOf(this.field_70177_z));
        return list;
    }

    @Override
    public double getPacketRange() {
        return 100.0;
    }

    public boolean getWaitForPlayer() {
        return this.waitForPlayer;
    }

    public void setWaitForPlayer(boolean waitForPlayer) {
        this.waitForPlayer = waitForPlayer;
    }

    public void dropItems() {
        for (ItemStack item : this.getItemsDropped()) {
            if (item == null) continue;
            this.func_70099_a(item, 0.0f);
        }
    }

    public List<ItemStack> getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack stack : this.containedItems) {
            if (stack == null) continue;
            items.add(stack);
        }
        return items;
    }
}

