/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.api.IHighlightHandler;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.recipe.CompressorRecipes;
import micdoodle8.mods.galacticraft.core.GCCoreConfigManager;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.core.items.GCCoreItems;
import micdoodle8.mods.galacticraft.core.nei.BuggyRecipeHandler;
import micdoodle8.mods.galacticraft.core.nei.CircuitFabricatorRecipeHandler;
import micdoodle8.mods.galacticraft.core.nei.ElectricIngotCompressorRecipeHandler;
import micdoodle8.mods.galacticraft.core.nei.GCNEIHighlightHandler;
import micdoodle8.mods.galacticraft.core.nei.IngotCompressorRecipeHandler;
import micdoodle8.mods.galacticraft.core.nei.RefineryRecipeHandler;
import micdoodle8.mods.galacticraft.core.nei.RocketT1RecipeHandler;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;

public class NEIGalacticraftConfig
implements IConfigureNEI {
    private static HashMap<HashMap<Integer, PositionedStack>, PositionedStack> rocketBenchRecipes = new HashMap();
    private static HashMap<HashMap<Integer, PositionedStack>, PositionedStack> buggyBenchRecipes = new HashMap();
    private static HashMap<PositionedStack, PositionedStack> refineryRecipes = new HashMap();
    private static HashMap<HashMap<Integer, PositionedStack>, PositionedStack> circuitFabricatorRecipes = new HashMap();
    private static HashMap<HashMap<Integer, PositionedStack>, PositionedStack> ingotCompressorRecipes = new HashMap();

    public void loadConfig() {
        this.registerRecipes();
        API.hideItems(GCCoreItems.hiddenItems);
        API.hideItems(GCCoreBlocks.hiddenBlocks);
        API.registerRecipeHandler((ICraftingHandler)new RocketT1RecipeHandler());
        API.registerUsageHandler((IUsageHandler)new RocketT1RecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new BuggyRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new BuggyRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new RefineryRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new RefineryRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new CircuitFabricatorRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new CircuitFabricatorRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new IngotCompressorRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new IngotCompressorRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new ElectricIngotCompressorRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new ElectricIngotCompressorRecipeHandler());
        API.registerHighlightIdentifier((int)GCCoreConfigManager.idBlockDecorationBlock, (IHighlightHandler)new GCNEIHighlightHandler());
    }

    public String getName() {
        return "Galacticraft NEI Plugin";
    }

    public String getVersion() {
        return "2.0.13";
    }

    public void registerIngotCompressorRecipe(HashMap<Integer, PositionedStack> input, PositionedStack output) {
        ingotCompressorRecipes.put(input, output);
    }

    public void registerCircuitFabricatorRecipe(HashMap<Integer, PositionedStack> input, PositionedStack output) {
        circuitFabricatorRecipes.put(input, output);
    }

    public void registerRocketBenchRecipe(HashMap<Integer, PositionedStack> input, PositionedStack output) {
        rocketBenchRecipes.put(input, output);
    }

    public void registerBuggyBenchRecipe(HashMap<Integer, PositionedStack> input, PositionedStack output) {
        buggyBenchRecipes.put(input, output);
    }

    public void registerRefineryRecipe(PositionedStack input, PositionedStack output) {
        refineryRecipes.put(input, output);
    }

    public static Set<Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack>> getIngotCompressorRecipes() {
        return ingotCompressorRecipes.entrySet();
    }

    public static Set<Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack>> getCircuitFabricatorRecipes() {
        return circuitFabricatorRecipes.entrySet();
    }

    public static Set<Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack>> getRocketBenchRecipes() {
        return rocketBenchRecipes.entrySet();
    }

    public static Set<Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack>> getBuggyBenchRecipes() {
        return buggyBenchRecipes.entrySet();
    }

    public static Set<Map.Entry<PositionedStack, PositionedStack>> getRefineryRecipes() {
        return refineryRecipes.entrySet();
    }

    public void registerRecipes() {
        this.registerRefineryRecipe(new PositionedStack((Object)new ItemStack(GCCoreItems.oilCanister, 1, 1), 2, 3), new PositionedStack((Object)new ItemStack(GCCoreItems.fuelCanister, 1, 1), 148, 3));
        this.addRocketRecipes();
        this.addBuggyRecipes();
        this.addCircuitFabricatorRecipes();
        this.addIngotCompressorRecipes();
    }

    private void addBuggyRecipes() {
        HashMap<Integer, PositionedStack> input1 = new HashMap<Integer, PositionedStack>();
        input1 = new HashMap();
        input1.put(0, new PositionedStack((Object)new ItemStack(GCCoreItems.partBuggy, 1, 0), 18, 37));
        input1.put(1, new PositionedStack((Object)new ItemStack(GCCoreItems.partBuggy, 1, 0), 18, 91));
        input1.put(2, new PositionedStack((Object)new ItemStack(GCCoreItems.partBuggy, 1, 0), 90, 37));
        input1.put(3, new PositionedStack((Object)new ItemStack(GCCoreItems.partBuggy, 1, 0), 90, 91));
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 4; ++y) {
                if (x == 1 && y == 1) {
                    input1.put(y * 3 + x + 4, new PositionedStack((Object)new ItemStack(GCCoreItems.partBuggy, 1, 1), 36 + x * 18, 37 + y * 18));
                    continue;
                }
                input1.put(y * 3 + x + 4, new PositionedStack((Object)new ItemStack(GCCoreItems.heavyPlatingTier1), 36 + x * 18, 37 + y * 18));
            }
        }
        this.registerBuggyBenchRecipe(input1, new PositionedStack((Object)new ItemStack(GCCoreItems.buggy, 1, 0), 139, 101));
        HashMap<Integer, PositionedStack> input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(16, new PositionedStack((Object)new ItemStack(GCCoreItems.partBuggy, 1, 2), 90, 8));
        this.registerBuggyBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCCoreItems.buggy, 1, 1), 139, 101));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(17, new PositionedStack((Object)new ItemStack(GCCoreItems.partBuggy, 1, 2), 116, 8));
        this.registerBuggyBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCCoreItems.buggy, 1, 1), 139, 101));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(18, new PositionedStack((Object)new ItemStack(GCCoreItems.partBuggy, 1, 2), 142, 8));
        this.registerBuggyBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCCoreItems.buggy, 1, 1), 139, 101));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(16, new PositionedStack((Object)new ItemStack(GCCoreItems.partBuggy, 1, 2), 90, 8));
        input2.put(17, new PositionedStack((Object)new ItemStack(GCCoreItems.partBuggy, 1, 2), 116, 8));
        this.registerBuggyBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCCoreItems.buggy, 1, 2), 139, 101));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(17, new PositionedStack((Object)new ItemStack(GCCoreItems.partBuggy, 1, 2), 116, 8));
        input2.put(18, new PositionedStack((Object)new ItemStack(GCCoreItems.partBuggy, 1, 2), 142, 8));
        this.registerBuggyBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCCoreItems.buggy, 1, 2), 139, 101));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(16, new PositionedStack((Object)new ItemStack(GCCoreItems.partBuggy, 1, 2), 90, 8));
        input2.put(18, new PositionedStack((Object)new ItemStack(GCCoreItems.partBuggy, 1, 2), 142, 8));
        this.registerBuggyBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCCoreItems.buggy, 1, 2), 139, 101));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(16, new PositionedStack((Object)new ItemStack(GCCoreItems.partBuggy, 1, 2), 90, 8));
        input2.put(17, new PositionedStack((Object)new ItemStack(GCCoreItems.partBuggy, 1, 2), 116, 8));
        input2.put(18, new PositionedStack((Object)new ItemStack(GCCoreItems.partBuggy, 1, 2), 142, 8));
        this.registerBuggyBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCCoreItems.buggy, 1, 3), 139, 101));
    }

    private void addRocketRecipes() {
        HashMap<Integer, PositionedStack> input1 = new HashMap<Integer, PositionedStack>();
        input1.put(0, new PositionedStack((Object)new ItemStack(GCCoreItems.partNoseCone), 45, 15));
        input1.put(1, new PositionedStack((Object)new ItemStack(GCCoreItems.heavyPlatingTier1), 36, 33));
        input1.put(2, new PositionedStack((Object)new ItemStack(GCCoreItems.heavyPlatingTier1), 36, 51));
        input1.put(3, new PositionedStack((Object)new ItemStack(GCCoreItems.heavyPlatingTier1), 36, 69));
        input1.put(4, new PositionedStack((Object)new ItemStack(GCCoreItems.heavyPlatingTier1), 36, 87));
        input1.put(5, new PositionedStack((Object)new ItemStack(GCCoreItems.heavyPlatingTier1), 54, 33));
        input1.put(6, new PositionedStack((Object)new ItemStack(GCCoreItems.heavyPlatingTier1), 54, 51));
        input1.put(7, new PositionedStack((Object)new ItemStack(GCCoreItems.heavyPlatingTier1), 54, 69));
        input1.put(8, new PositionedStack((Object)new ItemStack(GCCoreItems.heavyPlatingTier1), 54, 87));
        input1.put(9, new PositionedStack((Object)new ItemStack(GCCoreItems.rocketEngine), 45, 105));
        input1.put(10, new PositionedStack((Object)new ItemStack(GCCoreItems.partFins), 18, 87));
        input1.put(11, new PositionedStack((Object)new ItemStack(GCCoreItems.partFins), 18, 105));
        input1.put(12, new PositionedStack((Object)new ItemStack(GCCoreItems.partFins), 72, 87));
        input1.put(13, new PositionedStack((Object)new ItemStack(GCCoreItems.partFins), 72, 105));
        this.registerRocketBenchRecipe(input1, new PositionedStack((Object)new ItemStack(GCCoreItems.rocketTier1, 1, 0), 139, 92));
        HashMap<Integer, PositionedStack> input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(14, new PositionedStack((Object)new ItemStack((Block)Block.field_72077_au), 90, 8));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCCoreItems.rocketTier1, 1, 1), 139, 92));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(15, new PositionedStack((Object)new ItemStack((Block)Block.field_72077_au), 116, 8));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCCoreItems.rocketTier1, 1, 1), 139, 92));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(16, new PositionedStack((Object)new ItemStack((Block)Block.field_72077_au), 142, 8));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCCoreItems.rocketTier1, 1, 1), 139, 92));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(14, new PositionedStack((Object)new ItemStack((Block)Block.field_72077_au), 90, 8));
        input2.put(15, new PositionedStack((Object)new ItemStack((Block)Block.field_72077_au), 116, 8));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCCoreItems.rocketTier1, 1, 2), 139, 92));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(15, new PositionedStack((Object)new ItemStack((Block)Block.field_72077_au), 116, 8));
        input2.put(16, new PositionedStack((Object)new ItemStack((Block)Block.field_72077_au), 142, 8));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCCoreItems.rocketTier1, 1, 2), 139, 92));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(14, new PositionedStack((Object)new ItemStack((Block)Block.field_72077_au), 90, 8));
        input2.put(16, new PositionedStack((Object)new ItemStack((Block)Block.field_72077_au), 142, 8));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCCoreItems.rocketTier1, 1, 2), 139, 92));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(14, new PositionedStack((Object)new ItemStack((Block)Block.field_72077_au), 90, 8));
        input2.put(15, new PositionedStack((Object)new ItemStack((Block)Block.field_72077_au), 116, 8));
        input2.put(16, new PositionedStack((Object)new ItemStack((Block)Block.field_72077_au), 142, 8));
        this.registerRocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCCoreItems.rocketTier1, 1, 3), 139, 92));
    }

    private void addCircuitFabricatorRecipes() {
        HashMap<Integer, PositionedStack> input1 = new HashMap<Integer, PositionedStack>();
        input1.put(0, new PositionedStack((Object)new ItemStack(Item.field_77702_n), 10, 22));
        input1.put(1, new PositionedStack((Object)new ItemStack(GCCoreItems.basicItem, 1, 2), 69, 51));
        input1.put(2, new PositionedStack((Object)new ItemStack(GCCoreItems.basicItem, 1, 2), 69, 69));
        input1.put(3, new PositionedStack((Object)new ItemStack(Item.field_77767_aC), 117, 51));
        input1.put(4, new PositionedStack((Object)new ItemStack(Block.field_72035_aQ), 140, 25));
        this.registerCircuitFabricatorRecipe(input1, new PositionedStack((Object)new ItemStack(GCCoreItems.basicItem, 3, 13), 147, 91));
        HashMap<Integer, PositionedStack> input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(4, new PositionedStack((Object)new ItemStack(Item.field_77756_aW, 1, 4), 140, 25));
        this.registerCircuitFabricatorRecipe(input2, new PositionedStack((Object)new ItemStack(GCCoreItems.basicItem, 9, 12), 147, 91));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(4, new PositionedStack((Object)new ItemStack(Item.field_77742_bb), 140, 25));
        this.registerCircuitFabricatorRecipe(input2, new PositionedStack((Object)new ItemStack(GCCoreItems.basicItem, 1, 14), 147, 91));
    }

    private void addIngotCompressorRecipes() {
        for (int i = 0; i < CompressorRecipes.getRecipeList().size(); ++i) {
            ItemStack stack;
            int j;
            ShapedRecipes recipe;
            HashMap<Integer, PositionedStack> input1 = new HashMap<Integer, PositionedStack>();
            IRecipe rec = CompressorRecipes.getRecipeList().get(i);
            if (rec instanceof ShapedRecipes) {
                recipe = (ShapedRecipes)rec;
                for (j = 0; j < recipe.field_77574_d.length; ++j) {
                    stack = recipe.field_77574_d[j];
                    input1.put(j, new PositionedStack((Object)stack, 21 + j % 3 * 18, 26 + j / 3 * 18));
                }
            } else if (rec instanceof ShapelessRecipes) {
                recipe = (ShapelessRecipes)rec;
                for (j = 0; j < recipe.field_77579_b.size(); ++j) {
                    stack = (ItemStack)recipe.field_77579_b.get(j);
                    input1.put(j, new PositionedStack((Object)stack, 21 + j % 3 * 18, 26 + j / 3 * 18));
                }
            }
            this.registerIngotCompressorRecipe(input1, new PositionedStack((Object)rec.func_77571_b(), 140, 46));
        }
    }
}

