/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.network;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class GCCorePacketManager
implements IPacketHandler,
IPacketReceiver {
    public static Packet getPacket(String channelName, Entity sender, ArrayList<Object> objs) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeInt(2);
            data.writeInt(sender.field_70157_k);
            data = GCCorePacketManager.encodeDataStream(data, objs);
            Packet250CustomPayload packet = new Packet250CustomPayload();
            packet.field_73630_a = channelName;
            packet.field_73629_c = bytes.toByteArray();
            packet.field_73628_b = packet.field_73629_c.length;
            data.close();
            return packet;
        }
        catch (IOException e) {
            System.out.println("Failed to create packet.");
            e.printStackTrace();
            return null;
        }
    }

    public static DataOutputStream encodeDataStream(DataOutputStream data, ArrayList<Object> sendData) {
        try {
            for (Object dataValue : sendData) {
                if (dataValue instanceof Integer) {
                    data.writeInt((Integer)dataValue);
                    continue;
                }
                if (dataValue instanceof Float) {
                    data.writeFloat(((Float)dataValue).floatValue());
                    continue;
                }
                if (dataValue instanceof Double) {
                    data.writeDouble((Double)dataValue);
                    continue;
                }
                if (dataValue instanceof Byte) {
                    data.writeByte(((Byte)dataValue).byteValue());
                    continue;
                }
                if (dataValue instanceof Boolean) {
                    data.writeBoolean((Boolean)dataValue);
                    continue;
                }
                if (dataValue instanceof String) {
                    data.writeUTF((String)dataValue);
                    continue;
                }
                if (dataValue instanceof Short) {
                    data.writeShort(((Short)dataValue).shortValue());
                    continue;
                }
                if (dataValue instanceof Long) {
                    data.writeLong((Long)dataValue);
                    continue;
                }
                if (!(dataValue instanceof NBTTagCompound)) continue;
                GCCorePacketManager.writeNBTTagCompound((NBTTagCompound)dataValue, data);
            }
            return data;
        }
        catch (IOException e) {
            System.out.println("Packet data encoding failed.");
            e.printStackTrace();
            return data;
        }
    }

    public static Packet getPacket(String channelName, Entity sender, Object ... sendData) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeInt(2);
            data.writeInt(sender.field_70157_k);
            data = GCCorePacketManager.encodeDataStream(data, sendData);
            Packet250CustomPayload packet = new Packet250CustomPayload();
            packet.field_73630_a = channelName;
            packet.field_73629_c = bytes.toByteArray();
            packet.field_73628_b = packet.field_73629_c.length;
            data.close();
            return packet;
        }
        catch (IOException e) {
            System.out.println("Failed to create packet.");
            e.printStackTrace();
            return null;
        }
    }

    public static Packet getPacket(String channelName, TileEntity sender, Object ... sendData) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeInt(GCCorePacketType.TILEENTITY.ordinal());
            data.writeInt(sender.field_70329_l);
            data.writeInt(sender.field_70330_m);
            data.writeInt(sender.field_70327_n);
            data = GCCorePacketManager.encodeDataStream(data, sendData);
            Packet250CustomPayload packet = new Packet250CustomPayload();
            packet.field_73630_a = channelName;
            packet.field_73629_c = bytes.toByteArray();
            packet.field_73628_b = packet.field_73629_c.length;
            return packet;
        }
        catch (IOException e) {
            System.out.println("Failed to create packet.");
            e.printStackTrace();
            return null;
        }
    }

    public static DataOutputStream encodeDataStream(DataOutputStream data, Object ... sendData) {
        try {
            for (Object dataValue : sendData) {
                if (dataValue instanceof Integer) {
                    data.writeInt((Integer)dataValue);
                    continue;
                }
                if (dataValue instanceof Float) {
                    data.writeFloat(((Float)dataValue).floatValue());
                    continue;
                }
                if (dataValue instanceof Double) {
                    data.writeDouble((Double)dataValue);
                    continue;
                }
                if (dataValue instanceof Byte) {
                    data.writeByte(((Byte)dataValue).byteValue());
                    continue;
                }
                if (dataValue instanceof Boolean) {
                    data.writeBoolean((Boolean)dataValue);
                    continue;
                }
                if (dataValue instanceof String) {
                    data.writeUTF((String)dataValue);
                    continue;
                }
                if (dataValue instanceof Short) {
                    data.writeShort(((Short)dataValue).shortValue());
                    continue;
                }
                if (dataValue instanceof Long) {
                    data.writeLong((Long)dataValue);
                    continue;
                }
                if (dataValue instanceof NBTTagCompound) {
                    GCCorePacketManager.writeNBTTagCompound((NBTTagCompound)dataValue, data);
                    continue;
                }
                if (dataValue instanceof FluidTank) {
                    GCCorePacketManager.writeFluidTank((FluidTank)dataValue, data);
                    continue;
                }
                if (dataValue instanceof Entity) {
                    data.writeInt(((Entity)dataValue).field_70157_k);
                    continue;
                }
                if (dataValue instanceof Vector3) {
                    data.writeDouble(((Vector3)dataValue).x);
                    data.writeDouble(((Vector3)dataValue).y);
                    data.writeDouble(((Vector3)dataValue).z);
                    continue;
                }
                if (!(dataValue instanceof Collection)) continue;
                for (Object subDataValue : (Collection)dataValue) {
                    if (subDataValue instanceof Integer) {
                        data.writeInt((Integer)subDataValue);
                        continue;
                    }
                    if (subDataValue instanceof Float) {
                        data.writeFloat(((Float)subDataValue).floatValue());
                        continue;
                    }
                    if (subDataValue instanceof Double) {
                        data.writeDouble((Double)subDataValue);
                        continue;
                    }
                    if (subDataValue instanceof Byte) {
                        data.writeByte(((Byte)subDataValue).byteValue());
                        continue;
                    }
                    if (subDataValue instanceof Boolean) {
                        data.writeBoolean((Boolean)subDataValue);
                        continue;
                    }
                    if (subDataValue instanceof String) {
                        data.writeUTF((String)subDataValue);
                        continue;
                    }
                    if (subDataValue instanceof Short) {
                        data.writeShort(((Short)subDataValue).shortValue());
                        continue;
                    }
                    if (subDataValue instanceof Long) {
                        data.writeLong((Long)subDataValue);
                        continue;
                    }
                    if (subDataValue instanceof NBTTagCompound) {
                        GCCorePacketManager.writeNBTTagCompound((NBTTagCompound)subDataValue, data);
                        continue;
                    }
                    if (subDataValue instanceof FluidTank) {
                        GCCorePacketManager.writeFluidTank((FluidTank)subDataValue, data);
                        continue;
                    }
                    if (subDataValue instanceof Entity) {
                        data.writeInt(((Entity)subDataValue).field_70157_k);
                        continue;
                    }
                    if (!(subDataValue instanceof Vector3)) continue;
                    data.writeDouble(((Vector3)subDataValue).x);
                    data.writeDouble(((Vector3)subDataValue).y);
                    data.writeDouble(((Vector3)subDataValue).z);
                }
            }
            return data;
        }
        catch (IOException e) {
            System.out.println("Packet data encoding failed.");
            e.printStackTrace();
            return data;
        }
    }

    public void onPacketData(INetworkManager network, Packet250CustomPayload packet, Player player) {
        if (packet == null) {
            FMLLog.severe((String)"Packet received as null!", (Object[])new Object[0]);
            return;
        }
        if (packet.field_73629_c == null) {
            FMLLog.severe((String)("Packet data received as null! ID " + packet.func_73281_k()), (Object[])new Object[0]);
            return;
        }
        try {
            ByteArrayDataInput data = ByteStreams.newDataInput((byte[])packet.field_73629_c);
            int packetTypeID = data.readInt();
            if (packetTypeID == GCCorePacketType.ENTITY.ordinal()) {
                double id = data.readInt();
                World world = ((EntityPlayer)player).field_70170_p;
                if (world != null) {
                    for (Object o : world.field_72996_f) {
                        if (!(o instanceof Entity)) continue;
                        Entity e = (Entity)o;
                        if (id != (double)e.field_70157_k || !(e instanceof IPacketReceiver)) continue;
                        ((IPacketReceiver)e).handlePacketData(network, packetTypeID, packet, (EntityPlayer)player, data);
                    }
                }
            } else if (packetTypeID == GCCorePacketType.TILEENTITY.ordinal()) {
                TileEntity tileEntity;
                int x = data.readInt();
                int y = data.readInt();
                int z = data.readInt();
                World world = ((EntityPlayer)player).field_70170_p;
                if (world != null && (tileEntity = world.func_72796_p(x, y, z)) != null && tileEntity instanceof IPacketReceiver) {
                    ((IPacketReceiver)tileEntity).handlePacketData(network, packetTypeID, packet, (EntityPlayer)player, data);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void handlePacketData(INetworkManager network, int packetType, Packet250CustomPayload packet, EntityPlayer player, ByteArrayDataInput dataStream) {
    }

    public static void writeFluidTank(FluidTank fluidTank, DataOutputStream dataStream) throws IOException {
        if (fluidTank == null) {
            dataStream.writeInt(0);
            dataStream.writeInt(-1);
            dataStream.writeInt(0);
        } else {
            dataStream.writeInt(fluidTank.getCapacity());
            dataStream.writeInt(fluidTank.getFluid() == null ? -1 : fluidTank.getFluid().fluidID);
            dataStream.writeInt(fluidTank.getFluidAmount());
        }
    }

    public static FluidTank readFluidTank(ByteArrayDataInput dataStream) throws IOException {
        int capacity = dataStream.readInt();
        int fluidID = dataStream.readInt();
        FluidTank fluidTank = new FluidTank(capacity);
        int amount = dataStream.readInt();
        if (fluidID == -1) {
            fluidTank.setFluid(null);
        } else {
            Fluid fluid = FluidRegistry.getFluid((int)fluidID);
            fluidTank.setFluid(new FluidStack(fluid, amount));
        }
        return fluidTank;
    }

    public static void writeNBTTagCompound(NBTTagCompound tag, DataOutputStream dataStream) throws IOException {
        if (tag == null) {
            dataStream.writeShort(-1);
        } else {
            byte[] var2 = CompressedStreamTools.func_74798_a((NBTTagCompound)tag);
            dataStream.writeShort((short)var2.length);
            dataStream.write(var2);
        }
    }

    public static void writeNBTTagCompound(NBTTagCompound tag, ByteArrayDataOutput dataStream) throws IOException {
        if (tag == null) {
            dataStream.writeShort(-1);
        } else {
            byte[] var2 = CompressedStreamTools.func_74798_a((NBTTagCompound)tag);
            dataStream.writeShort((int)((short)var2.length));
            dataStream.write(var2);
        }
    }

    public static NBTTagCompound readNBTTagCompound(DataInputStream dataStream) throws IOException {
        short var1 = dataStream.readShort();
        if (var1 < 0) {
            return null;
        }
        byte[] var2 = new byte[var1];
        dataStream.readFully(var2);
        return CompressedStreamTools.func_74792_a((byte[])var2);
    }

    public static NBTTagCompound readNBTTagCompound(ByteArrayDataInput dataStream) throws IOException {
        short var1 = dataStream.readShort();
        if (var1 < 0) {
            return null;
        }
        byte[] var2 = new byte[var1];
        dataStream.readFully(var2);
        return CompressedStreamTools.func_74792_a((byte[])var2);
    }

    public static void sendPacketToClients(Packet packet, World worldObj) {
        try {
            PacketDispatcher.sendPacketToAllInDimension((Packet)packet, (int)worldObj.field_73011_w.field_76574_g);
        }
        catch (Exception e) {
            System.out.println("Sending packet to client failed.");
            e.printStackTrace();
        }
    }

    public static void sendPacketToClients(Packet packet, World worldObj, Vector3 position, double range) {
        try {
            PacketDispatcher.sendPacketToAllAround((double)position.x, (double)position.y, (double)position.z, (double)range, (int)worldObj.field_73011_w.field_76574_g, (Packet)packet);
        }
        catch (Exception e) {
            System.out.println("Sending packet to client failed.");
            e.printStackTrace();
        }
    }

    public static void sendPacketToClients(Packet packet) {
        try {
            PacketDispatcher.sendPacketToAllPlayers((Packet)packet);
        }
        catch (Exception e) {
            System.out.println("Sending packet to client failed.");
            e.printStackTrace();
        }
    }

    public static Object getFieldValueFromStream(Field field, ByteArrayDataInput stream, World world) throws IOException {
        Class<?> dataValue = field.getType();
        if (dataValue.equals(Integer.TYPE)) {
            return stream.readInt();
        }
        if (dataValue.equals(Float.TYPE)) {
            return Float.valueOf(stream.readFloat());
        }
        if (dataValue.equals(Double.TYPE)) {
            return stream.readDouble();
        }
        if (dataValue.equals(Byte.TYPE)) {
            return stream.readByte();
        }
        if (dataValue.equals(Boolean.TYPE)) {
            return stream.readBoolean();
        }
        if (dataValue.equals(String.class)) {
            return stream.readUTF();
        }
        if (dataValue.equals(Short.TYPE)) {
            return stream.readShort();
        }
        if (dataValue.equals(Long.class)) {
            return stream.readLong();
        }
        if (dataValue.equals(NBTTagCompound.class)) {
            return GCCorePacketManager.readNBTTagCompound(stream);
        }
        if (dataValue.equals(FluidTank.class)) {
            return GCCorePacketManager.readFluidTank(stream);
        }
        if (dataValue.equals(Vector3.class)) {
            return new Vector3(stream.readDouble(), stream.readDouble(), stream.readDouble());
        }
        for (Class<?> c = dataValue; c != null; c = c.getSuperclass()) {
            if (!c.equals(Entity.class)) continue;
            return world.func_73045_a(stream.readInt());
        }
        throw new NullPointerException("Field type not found: " + field.getType().getSimpleName());
    }

    public static enum GCCorePacketType {
        UNSPECIFIED,
        TILEENTITY,
        ENTITY;


        public static GCCorePacketType get(int id) {
            if (id >= 0 && id < GCCorePacketType.values().length) {
                return GCCorePacketType.values()[id];
            }
            return UNSPECIFIED;
        }
    }
}

