/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.oxygen;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GCCoreConfigManager;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlockUnlitTorch;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.core.oxygen.OxygenPressureProtocol;
import micdoodle8.mods.galacticraft.core.tick.GCCoreTickHandlerServer;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityOxygenSealer;
import micdoodle8.mods.galacticraft.core.wrappers.ScheduledBlockChange;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEnchantmentTable;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockFluid;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockHalfSlab;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockSponge;
import net.minecraft.block.material.Material;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class ThreadFindSeal {
    public AtomicBoolean sealedFinal = new AtomicBoolean();
    public static AtomicBoolean anylooping = new AtomicBoolean();
    public AtomicBoolean looping = new AtomicBoolean();
    private World world;
    private BlockVec3 head;
    private boolean sealed;
    private List<GCCoreTileEntityOxygenSealer> sealers;
    public HashSet<BlockVec3> checked;
    private int checkCount;
    private HashMap<BlockVec3, GCCoreTileEntityOxygenSealer> sealersAround;
    private List<BlockVec3> currentLayer;
    private List<BlockVec3> airToReplace;
    private List<BlockVec3> breatheableToReplace;
    private List<GCCoreTileEntityOxygenSealer> otherSealers;
    private List<BlockVec3> torchesToUpdate;

    public ThreadFindSeal(GCCoreTileEntityOxygenSealer sealer) {
        this(sealer.field_70331_k, new BlockVec3(sealer).translate(0, 1, 0), sealer.getFindSealChecks(), new ArrayList<GCCoreTileEntityOxygenSealer>(Arrays.asList(sealer)));
    }

    public ThreadFindSeal(World world, BlockVec3 head, int checkCount, List<GCCoreTileEntityOxygenSealer> sealers) {
        this.world = world;
        this.head = head;
        this.checkCount = checkCount;
        this.sealers = sealers;
        this.checked = new HashSet();
        this.sealersAround = new HashMap();
        for (TileEntity tile : new ArrayList(world.field_73009_h)) {
            if (!(tile instanceof GCCoreTileEntityOxygenSealer) || !(tile.func_70318_a((double)head.x, (double)head.y, (double)head.z) < 1048576.0)) continue;
            this.sealersAround.put(new BlockVec3(tile.field_70329_l, tile.field_70330_m, tile.field_70327_n), (GCCoreTileEntityOxygenSealer)tile);
        }
        if (!sealers.isEmpty()) {
            int id;
            if (checkCount > 0 && (id = head.getBlockID(this.world)) > 0 && id != GCCoreBlocks.breatheableAir.field_71990_ca) {
                this.canBlockPassAirCheck(id, this.head, 1);
                this.checkCount = checkCount;
            }
            this.looping.set(true);
            if (GCCoreConfigManager.enableSealerMultithreading) {
                new ThreadedFindSeal();
            } else {
                this.check();
            }
        } else {
            this.check();
        }
    }

    public void check() {
        GCCoreTileEntityOxygenSealer headSealer;
        long time1 = System.nanoTime();
        this.sealed = true;
        this.checked.add(this.head.clone());
        this.currentLayer = new LinkedList<BlockVec3>();
        this.airToReplace = new LinkedList<BlockVec3>();
        this.torchesToUpdate = new LinkedList<BlockVec3>();
        if (this.checkCount > 0) {
            this.currentLayer.add(this.head);
            if (this.head.x < -29990000 || this.head.z < -29990000 || this.head.x >= 29990000 || this.head.z >= 29990000) {
                if (this.head.getBlockID(this.world) == 0) {
                    this.airToReplace.add(this.head.clone());
                }
                this.doLayerNearMapEdge();
            } else {
                if (this.head.getBlockIDsafe(this.world) == 0) {
                    this.airToReplace.add(this.head.clone());
                }
                this.doLayer();
            }
        } else {
            this.sealed = false;
        }
        long time2 = System.nanoTime();
        if (this.sealers.isEmpty()) {
            this.sealed = false;
        }
        if (this.sealed) {
            if (!this.airToReplace.isEmpty()) {
                LinkedList<ScheduledBlockChange> changeList = new LinkedList<ScheduledBlockChange>();
                int breatheableAirID = GCCoreBlocks.breatheableAir.field_71990_ca;
                for (BlockVec3 checkedVec : this.airToReplace) {
                    changeList.add(new ScheduledBlockChange(checkedVec.clone(), breatheableAirID, 0));
                }
                GCCoreTickHandlerServer.scheduleNewBlockChange(this.world.field_73011_w.field_76574_g, changeList);
                if (!this.torchesToUpdate.isEmpty()) {
                    GCCoreTickHandlerServer.scheduleNewTorchUpdate(this.world.field_73011_w.field_76574_g, this.torchesToUpdate);
                }
            }
        } else {
            HashSet<BlockVec3> checkedSave = this.checked;
            this.checked = new HashSet();
            this.breatheableToReplace = new LinkedList<BlockVec3>();
            this.otherSealers = new LinkedList<GCCoreTileEntityOxygenSealer>();
            this.currentLayer.clear();
            this.currentLayer.add(this.head);
            this.torchesToUpdate.clear();
            if (this.head.x < -29990000 || this.head.z < -29990000 || this.head.x >= 29990000 || this.head.z >= 29990000) {
                this.loopThroughDNearMapEdge();
            } else {
                this.loopThroughD();
            }
            if (!this.otherSealers.isEmpty()) {
                List<GCCoreTileEntityOxygenSealer> sealersSave = this.sealers;
                List<BlockVec3> torchesSave = this.torchesToUpdate;
                ArrayList<GCCoreTileEntityOxygenSealer> sealersDone = new ArrayList<GCCoreTileEntityOxygenSealer>();
                sealersDone.addAll(this.sealers);
                for (GCCoreTileEntityOxygenSealer otherSealer : this.otherSealers) {
                    if (sealersDone.contains(otherSealer) || otherSealer.getFindSealChecks() <= 0) continue;
                    BlockVec3 newhead = new BlockVec3(otherSealer).translate(0, 1, 0);
                    this.sealed = true;
                    this.checkCount = otherSealer.getFindSealChecks();
                    this.sealers = new LinkedList<GCCoreTileEntityOxygenSealer>();
                    this.sealers.add(otherSealer);
                    this.checked = new HashSet();
                    this.checked.add(newhead);
                    this.currentLayer.clear();
                    this.airToReplace.clear();
                    this.torchesToUpdate = new LinkedList<BlockVec3>();
                    this.currentLayer.add(newhead.clone());
                    if (newhead.x < -29990000 || newhead.z < -29990000 || newhead.x >= 29990000 || newhead.z >= 29990000) {
                        this.doLayerNearMapEdge();
                    } else {
                        this.doLayer();
                    }
                    if (this.sealed) {
                        GCCoreTileEntityOxygenSealer oldHead;
                        if (GCCoreConfigManager.enableDebug) {
                            FMLLog.info((String)("Oxygen Sealer replacing head at x" + this.head.x + " y" + (this.head.y - 1) + " z" + this.head.z), (Object[])new Object[0]);
                        }
                        if (!sealersSave.isEmpty() && !this.sealers.contains(oldHead = sealersSave.get(0))) {
                            this.sealers.add(oldHead);
                        }
                        this.head = newhead.clone();
                        otherSealer.threadSeal = this;
                        otherSealer.stopSealThreadCooldown = 75 + GCCoreTileEntityOxygenSealer.countEntities;
                        checkedSave.addAll(this.checked);
                        break;
                    }
                    sealersDone.addAll(this.sealers);
                    checkedSave.addAll(this.checked);
                }
                if (!this.sealed) {
                    this.sealers = sealersSave;
                    this.torchesToUpdate = torchesSave;
                } else if (!this.airToReplace.isEmpty()) {
                    LinkedList<ScheduledBlockChange> changeList = new LinkedList<ScheduledBlockChange>();
                    int breatheableAirID = GCCoreBlocks.breatheableAir.field_71990_ca;
                    for (BlockVec3 airVec : this.airToReplace) {
                        changeList.add(new ScheduledBlockChange(airVec.clone(), breatheableAirID, 0));
                    }
                    GCCoreTickHandlerServer.scheduleNewBlockChange(this.world.field_73011_w.field_76574_g, changeList);
                    if (!this.torchesToUpdate.isEmpty()) {
                        GCCoreTickHandlerServer.scheduleNewTorchUpdate(this.world.field_73011_w.field_76574_g, this.torchesToUpdate);
                    }
                }
            }
            this.checked = checkedSave;
            if (!this.sealed) {
                if (this.head.getBlockID(this.world) == GCCoreBlocks.breatheableAir.field_71990_ca) {
                    this.breatheableToReplace.add(this.head);
                }
                if (!this.breatheableToReplace.isEmpty()) {
                    LinkedList<ScheduledBlockChange> changeList = new LinkedList<ScheduledBlockChange>();
                    for (BlockVec3 checkedVec : this.breatheableToReplace) {
                        changeList.add(new ScheduledBlockChange(checkedVec.clone(), 0, 0));
                    }
                    GCCoreTickHandlerServer.scheduleNewBlockChange(this.world.field_73011_w.field_76574_g, changeList);
                    if (!this.torchesToUpdate.isEmpty()) {
                        GCCoreTickHandlerServer.scheduleNewTorchUpdate(this.world.field_73011_w.field_76574_g, this.torchesToUpdate);
                    }
                }
            }
        }
        if ((headSealer = this.sealersAround.get(this.head.clone().translate(0, -1, 0))) != null) {
            headSealer.stopSealThreadCooldown += 75;
        }
        for (GCCoreTileEntityOxygenSealer sealer : this.sealers) {
            if (sealer == headSealer || headSealer == null) continue;
            sealer.threadSeal = this;
            sealer.stopSealThreadCooldown = headSealer.stopSealThreadCooldown + 51;
        }
        this.looping.set(false);
        if (GCCoreConfigManager.enableDebug) {
            long time3 = System.nanoTime();
            FMLLog.info((String)("Oxygen Sealer Check Completed at x" + this.head.x + " y" + this.head.y + " z" + this.head.z), (Object[])new Object[0]);
            FMLLog.info((String)("   Sealed: " + this.sealed), (Object[])new Object[0]);
            FMLLog.info((String)("   Loop Time taken: " + (double)(time2 - time1) / 1000000.0 + "ms"), (Object[])new Object[0]);
            FMLLog.info((String)("   Place Time taken: " + (double)(time3 - time2) / 1000000.0 + "ms"), (Object[])new Object[0]);
            FMLLog.info((String)("   Total Time taken: " + (double)(time3 - time1) / 1000000.0 + "ms"), (Object[])new Object[0]);
            FMLLog.info((String)("   Found: " + this.sealers.size() + " sealers"), (Object[])new Object[0]);
            FMLLog.info((String)("   Looped through: " + this.checked.size() + " blocks"), (Object[])new Object[0]);
        }
        this.sealedFinal.set(this.sealed);
    }

    private void loopThroughD() {
        int breatheableAirID = GCCoreBlocks.breatheableAir.field_71990_ca;
        int oxygenSealerID = GCCoreBlocks.oxygenSealer.field_71990_ca;
        HashSet<BlockVec3> checkedLocal = this.checked;
        LinkedList<BlockVec3> nextLayer = new LinkedList<BlockVec3>();
        while (this.currentLayer.size() > 0) {
            for (BlockVec3 vec : this.currentLayer) {
                int side = 0;
                do {
                    BlockVec3 sideVec;
                    if (vec.sideDone[side] || checkedLocal.contains(sideVec = vec.newVecSide(side))) continue;
                    int id = sideVec.getBlockIDsafe(this.world);
                    if (id == breatheableAirID) {
                        this.breatheableToReplace.add(sideVec);
                        nextLayer.add(sideVec);
                        checkedLocal.add(sideVec);
                        continue;
                    }
                    if (id == oxygenSealerID) {
                        GCCoreTileEntityOxygenSealer sealer = this.sealersAround.get(sideVec);
                        if (sealer != null && !this.sealers.contains(sealer)) {
                            if (side != 0) continue;
                            this.otherSealers.add(sealer);
                            checkedLocal.add(sideVec);
                            continue;
                        }
                        checkedLocal.add(sideVec);
                        continue;
                    }
                    checkedLocal.add(sideVec);
                    if (id <= 0 || !this.canBlockPassAirCheck(id, sideVec, side)) continue;
                    nextLayer.add(sideVec);
                } while (++side < 6);
            }
            this.currentLayer = nextLayer;
            nextLayer = new LinkedList();
        }
    }

    private void loopThroughDNearMapEdge() {
        int breatheableAirID = GCCoreBlocks.breatheableAir.field_71990_ca;
        int oxygenSealerID = GCCoreBlocks.oxygenSealer.field_71990_ca;
        HashSet<BlockVec3> checkedLocal = this.checked;
        LinkedList<BlockVec3> nextLayer = new LinkedList<BlockVec3>();
        while (this.currentLayer.size() > 0) {
            for (BlockVec3 vec : this.currentLayer) {
                for (int side = 0; side < 6; ++side) {
                    BlockVec3 sideVec;
                    if (vec.sideDone[side] || checkedLocal.contains(sideVec = vec.newVecSide(side))) continue;
                    int id = sideVec.getBlockID(this.world);
                    if (id == breatheableAirID) {
                        this.breatheableToReplace.add(sideVec);
                        nextLayer.add(sideVec);
                        checkedLocal.add(sideVec);
                        continue;
                    }
                    if (id == oxygenSealerID) {
                        GCCoreTileEntityOxygenSealer sealer = this.sealersAround.get(sideVec);
                        if (sealer != null && !this.sealers.contains(sealer)) {
                            if (side != 0) continue;
                            this.otherSealers.add(sealer);
                            checkedLocal.add(sideVec);
                            continue;
                        }
                        checkedLocal.add(sideVec);
                        continue;
                    }
                    checkedLocal.add(sideVec);
                    if (id <= 0 || !this.canBlockPassAirCheck(id, sideVec, side)) continue;
                    nextLayer.add(sideVec);
                }
            }
            this.currentLayer = nextLayer;
            nextLayer = new LinkedList();
        }
    }

    private void doLayer() {
        int breatheableAirID = GCCoreBlocks.breatheableAir.field_71990_ca;
        int oxygenSealerID = GCCoreBlocks.oxygenSealer.field_71990_ca;
        HashSet<BlockVec3> checkedLocal = this.checked;
        LinkedList<BlockVec3> nextLayer = new LinkedList<BlockVec3>();
        while (this.sealed && this.currentLayer.size() > 0) {
            for (BlockVec3 vec : this.currentLayer) {
                int side = 0;
                do {
                    int id;
                    BlockVec3 sideVec;
                    if (vec.sideDone[side] || checkedLocal.contains(sideVec = vec.newVecSide(side))) continue;
                    if (this.checkCount > 0) {
                        GCCoreTileEntityOxygenSealer sealer;
                        --this.checkCount;
                        checkedLocal.add(sideVec);
                        id = sideVec.getBlockIDsafe(this.world);
                        if (id == breatheableAirID) {
                            nextLayer.add(sideVec);
                            continue;
                        }
                        if (id <= 0) {
                            if (id == -1) {
                                this.checkCount = 0;
                                this.sealed = false;
                                return;
                            }
                            if (id != 0) continue;
                            nextLayer.add(sideVec);
                            this.airToReplace.add(sideVec);
                            continue;
                        }
                        if (this.canBlockPassAirCheck(id, sideVec, side)) {
                            nextLayer.add(sideVec);
                            continue;
                        }
                        if (id != oxygenSealerID || (sealer = this.sealersAround.get(sideVec)) == null || this.sealers.contains(sealer)) continue;
                        if (side == 0) {
                            this.sealers.add(sealer);
                            this.checkCount += sealer.getFindSealChecks();
                            continue;
                        }
                        checkedLocal.remove(sideVec);
                        continue;
                    }
                    id = sideVec.getBlockIDsafe(this.world);
                    if (id <= 0) {
                        if (id < -1) continue;
                        this.sealed = false;
                        return;
                    }
                    if (id != breatheableAirID && !this.canBlockPassAirCheck(id, sideVec, side)) continue;
                    this.sealed = false;
                    return;
                } while (++side < 6);
            }
            this.currentLayer = nextLayer;
            nextLayer = new LinkedList();
        }
    }

    private void doLayerNearMapEdge() {
        int breatheableAirID = GCCoreBlocks.breatheableAir.field_71990_ca;
        int oxygenSealerID = GCCoreBlocks.oxygenSealer.field_71990_ca;
        HashSet<BlockVec3> checkedLocal = this.checked;
        LinkedList<BlockVec3> nextLayer = new LinkedList<BlockVec3>();
        while (this.sealed && this.currentLayer.size() > 0) {
            for (BlockVec3 vec : this.currentLayer) {
                for (int side = 0; side < 6; ++side) {
                    int id;
                    BlockVec3 sideVec;
                    if (vec.sideDone[side] || checkedLocal.contains(sideVec = vec.newVecSide(side))) continue;
                    if (this.checkCount > 0) {
                        GCCoreTileEntityOxygenSealer sealer;
                        --this.checkCount;
                        checkedLocal.add(sideVec);
                        id = sideVec.getBlockID(this.world);
                        if (id == breatheableAirID) {
                            nextLayer.add(sideVec);
                            continue;
                        }
                        if (id <= 0) {
                            if (id == -1) {
                                this.checkCount = 0;
                                this.sealed = false;
                                return;
                            }
                            if (id != 0) continue;
                            nextLayer.add(sideVec);
                            this.airToReplace.add(sideVec);
                            continue;
                        }
                        if (id == breatheableAirID || this.canBlockPassAirCheck(id, sideVec, side)) {
                            nextLayer.add(sideVec);
                            continue;
                        }
                        if (id != oxygenSealerID || (sealer = this.sealersAround.get(sideVec)) == null || this.sealers.contains(sealer)) continue;
                        if (side == 0) {
                            this.sealers.add(sealer);
                            this.checkCount += sealer.getFindSealChecks();
                            continue;
                        }
                        checkedLocal.remove(sideVec);
                        continue;
                    }
                    if (!this.sealed) continue;
                    id = sideVec.getBlockID(this.world);
                    if (id <= 0) {
                        if (id < -1) continue;
                        this.sealed = false;
                        return;
                    }
                    if (id != breatheableAirID && !this.canBlockPassAirCheck(id, sideVec, side)) continue;
                    this.sealed = false;
                    return;
                }
            }
            this.currentLayer = nextLayer;
            nextLayer = new LinkedList();
        }
    }

    private boolean canBlockPassAirCheck(int id, BlockVec3 vec, int side) {
        Block block = Block.field_71973_m[id];
        if (block == null) {
            FMLLog.info((String)("**** Please report to mod author: BlockPassAirCheck block ID " + id + " was null ****"), (Object[])new Object[0]);
            return true;
        }
        if (block instanceof BlockLeavesBase) {
            return true;
        }
        if (block.func_71926_d()) {
            return block instanceof BlockGravel || block.field_72018_cp == Material.field_76253_m || block instanceof BlockSponge;
        }
        if (block instanceof BlockGlass) {
            return false;
        }
        if (OxygenPressureProtocol.nonPermeableBlocks.containsKey(id) && OxygenPressureProtocol.nonPermeableBlocks.get(id).contains(vec.getBlockMetadata((IBlockAccess)this.world))) {
            return false;
        }
        if (block instanceof IPartialSealableBlock) {
            IPartialSealableBlock blockPartial = (IPartialSealableBlock)block;
            if (blockPartial.isSealed(this.world, vec.x, vec.y, vec.z, ForgeDirection.getOrientation((int)side))) {
                this.checked.remove(vec);
                --this.checkCount;
                return false;
            }
            for (int i = 0; i < 6; ++i) {
                if (i == side || !blockPartial.isSealed(this.world, vec.x, vec.y, vec.z, ForgeDirection.getOrientation((int)i))) continue;
                vec.setSideDone(i ^ 1);
            }
            return true;
        }
        if (block instanceof GCCoreBlockUnlitTorch) {
            this.torchesToUpdate.add(vec);
            return true;
        }
        if (block instanceof BlockHalfSlab) {
            boolean isTopSlab;
            boolean bl = isTopSlab = (vec.getBlockMetadata((IBlockAccess)this.world) & 8) == 8;
            if (side == 0 && isTopSlab || side == 1 && !isTopSlab) {
                this.checked.remove(vec);
                --this.checkCount;
                return false;
            }
            vec.setSideDone(isTopSlab ? 1 : 0);
            return true;
        }
        if (block instanceof BlockFarmland || block instanceof BlockEnchantmentTable || block instanceof BlockFluid) {
            if (side == 1) {
                this.checked.remove(vec);
                --this.checkCount;
                return false;
            }
            vec.setSideDone(0);
            return true;
        }
        if (block instanceof BlockPistonBase) {
            BlockPistonBase piston = (BlockPistonBase)block;
            int meta = vec.getBlockMetadata((IBlockAccess)this.world);
            if (BlockPistonBase.func_72114_f((int)meta)) {
                int facing = BlockPistonBase.func_72117_e((int)meta);
                if (side == facing) {
                    this.checked.remove(vec);
                    --this.checkCount;
                    return false;
                }
                vec.setSideDone(facing ^ 1);
                return true;
            }
            return false;
        }
        if (block.isBlockSolidOnSide(this.world, vec.x, vec.y, vec.z, ForgeDirection.getOrientation((int)(side ^ 1)))) {
            if (block.isBlockNormalCube(this.world, vec.x, vec.y, vec.z)) {
                return false;
            }
            this.checked.remove(vec);
            --this.checkCount;
            return false;
        }
        if (block.isAirBlock(this.world, vec.x, vec.y, vec.z)) {
            return true;
        }
        for (int i = 0; i < 6; ++i) {
            if (i == (side ^ 1) || !block.isBlockSolidOnSide(this.world, vec.x, vec.y, vec.z, ForgeDirection.getOrientation((int)i))) continue;
            vec.setSideDone(i);
        }
        return true;
    }

    public class ThreadedFindSeal
    extends Thread {
        public ThreadedFindSeal() {
            super("GC Sealer Roomfinder Thread");
            anylooping.set(true);
            if (this.isAlive()) {
                this.interrupt();
            }
            this.start();
        }

        @Override
        public void run() {
            ThreadFindSeal.this.check();
            anylooping.set(false);
        }
    }
}

