/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tick;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import micdoodle8.mods.galacticraft.api.transmission.compatibility.UniversalNetwork;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.core.oxygen.ThreadFindSeal;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityOxygenSealer;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.core.wrappers.ScheduledBlockChange;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class GCCoreTickHandlerServer
implements ITickHandler {
    private static Map<Integer, CopyOnWriteArrayList<ScheduledBlockChange>> scheduledBlockChanges = new ConcurrentHashMap<Integer, CopyOnWriteArrayList<ScheduledBlockChange>>();
    private static Map<Integer, CopyOnWriteArrayList<BlockVec3>> scheduledTorchUpdates = new ConcurrentHashMap<Integer, CopyOnWriteArrayList<BlockVec3>>();
    private static Map<Integer, List<BlockVec3>> edgeChecks = new HashMap<Integer, List<BlockVec3>>();
    private static LinkedList<UniversalNetwork> networkTicks = new LinkedList();

    public static void scheduleNewBlockChange(int dimID, ScheduledBlockChange change) {
        CopyOnWriteArrayList<ScheduledBlockChange> changeList = scheduledBlockChanges.get(dimID);
        if (changeList == null) {
            changeList = new CopyOnWriteArrayList();
        }
        changeList.add(change);
        scheduledBlockChanges.put(dimID, changeList);
    }

    public static void scheduleNewBlockChange(int dimID, List<ScheduledBlockChange> changeAdd) {
        CopyOnWriteArrayList<ScheduledBlockChange> changeList = scheduledBlockChanges.get(dimID);
        if (changeList == null) {
            changeList = new CopyOnWriteArrayList();
        }
        changeList.addAll(changeAdd);
        scheduledBlockChanges.put(dimID, changeList);
    }

    public static void scheduleNewTorchUpdate(int dimID, List<BlockVec3> torches) {
        CopyOnWriteArrayList<BlockVec3> updateList = scheduledTorchUpdates.get(dimID);
        if (updateList == null) {
            updateList = new CopyOnWriteArrayList();
        }
        updateList.addAll(torches);
        scheduledTorchUpdates.put(dimID, updateList);
    }

    public static void scheduleNewEdgeCheck(int dimID, BlockVec3 edgeBlock) {
        List<BlockVec3> updateList = edgeChecks.get(dimID);
        if (updateList == null) {
            updateList = new ArrayList<BlockVec3>();
        }
        updateList.add(edgeBlock);
        edgeChecks.put(dimID, updateList);
    }

    public static boolean scheduledForChange(int dimID, BlockVec3 test) {
        CopyOnWriteArrayList<ScheduledBlockChange> changeList = scheduledBlockChanges.get(dimID);
        if (changeList != null) {
            for (ScheduledBlockChange change : changeList) {
                if (!test.equals(change.getChangePosition())) continue;
                return true;
            }
        }
        return false;
    }

    public static void scheduleNetworkTick(UniversalNetwork grid) {
        networkTicks.add(grid);
    }

    public static void removeNetworkTick(UniversalNetwork grid) {
        networkTicks.remove(grid);
    }

    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
        ++UniversalNetwork.tickCount;
        if (type.equals(EnumSet.of(TickType.WORLD))) {
            CopyOnWriteArrayList<BlockVec3> torchList;
            WorldServer world = (WorldServer)tickData[0];
            CopyOnWriteArrayList<ScheduledBlockChange> changeList = scheduledBlockChanges.get(world.field_73011_w.field_76574_g);
            if (changeList != null && !changeList.isEmpty()) {
                for (ScheduledBlockChange change : changeList) {
                    BlockVec3 changePosition;
                    if (change == null || (changePosition = change.getChangePosition()) == null) continue;
                    world.func_72832_d(changePosition.x, changePosition.y, changePosition.z, change.getChangeID(), change.getChangeMeta(), 2);
                }
                changeList.clear();
                scheduledBlockChanges.remove(world.field_73011_w.field_76574_g);
            }
            if ((torchList = scheduledTorchUpdates.get(world.field_73011_w.field_76574_g)) != null && !torchList.isEmpty()) {
                for (BlockVec3 torch : torchList) {
                    if (torch == null) continue;
                    if (world.func_72798_a(torch.x, torch.y, torch.z) == GCCoreBlocks.unlitTorch.field_71990_ca) {
                        world.func_82740_a(torch.x, torch.y, torch.z, GCCoreBlocks.unlitTorch.field_71990_ca, 2 + world.field_73012_v.nextInt(30), 0);
                        continue;
                    }
                    if (world.func_72798_a(torch.x, torch.y, torch.z) != GCCoreBlocks.unlitTorchLit.field_71990_ca) continue;
                    world.func_82740_a(torch.x, torch.y, torch.z, GCCoreBlocks.unlitTorchLit.field_71990_ca, 2 + world.field_73012_v.nextInt(30), 0);
                }
                torchList.clear();
                scheduledTorchUpdates.remove(world.field_73011_w.field_76574_g);
            }
            if (world.field_73011_w instanceof IOrbitDimension) {
                Object[] entityList;
                for (Object o : entityList = world.field_72996_f.toArray()) {
                    IOrbitDimension dimension;
                    if (!(o instanceof Entity)) continue;
                    Entity e = (Entity)o;
                    if (!(e.field_70170_p.field_73011_w instanceof IOrbitDimension) || !(e.field_70163_u <= (double)(dimension = (IOrbitDimension)e.field_70170_p.field_73011_w).getYCoordToTeleportToPlanet())) continue;
                    Integer dim = WorldUtil.getProviderForName((String)dimension.getPlanetToOrbit()).field_76574_g;
                    WorldUtil.transferEntityToDimension(e, dim, world, false, null);
                }
            }
        }
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
        int maxPasses = 10;
        while (!networkTicks.isEmpty()) {
            LinkedList<UniversalNetwork> pass = new LinkedList<UniversalNetwork>();
            pass.addAll(networkTicks);
            networkTicks.clear();
            for (UniversalNetwork grid : pass) {
                grid.tickEnd();
            }
            if (--maxPasses > 0) continue;
            break;
        }
        if (type.equals(EnumSet.of(TickType.WORLD))) {
            WorldServer world = (WorldServer)tickData[0];
            List<BlockVec3> edgesList = edgeChecks.get(world.field_73011_w.field_76574_g);
            HashSet<BlockVec3> checkedThisTick = new HashSet<BlockVec3>();
            if (edgesList != null && !edgesList.isEmpty()) {
                for (BlockVec3 edgeBlock : edgesList) {
                    if (edgeBlock == null || checkedThisTick.contains(edgeBlock) || GCCoreTickHandlerServer.scheduledForChange(world.field_73011_w.field_76574_g, edgeBlock)) continue;
                    ThreadFindSeal done = new ThreadFindSeal((World)world, edgeBlock, 2000, new ArrayList<GCCoreTileEntityOxygenSealer>());
                    checkedThisTick.addAll(done.checked);
                }
                edgesList.clear();
                edgeChecks.remove(world.field_73011_w.field_76574_g);
            }
        }
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.WORLD);
    }

    public String getLabel() {
        return "Galacticraft Core Common";
    }
}

